/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.mcontrol.mobtable.tablecolumn;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.mcontrol.mobtable.tablecolumn.IMobTableColumn;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobTableColumn
extends Control
implements IMobTableColumn {
    private static final String VISIBLE_DEFAULT_VALUE = "init,new,edit,view,submit,audit";
    private static final String DEFAULT = "default";
    private static final String LOOKUP = "lookup";
    private static final String INIT = "init";
    private static Map<String, Integer> mapVis = new HashMap<String, Integer>(11);
    private String fieldKey;
    private LocaleString caption;
    private LocaleString width;
    private String visible;
    private String mobTableField;
    private String textAlign;
    private String foreColor;
    private int fontsize;
    private boolean hyperlink;
    private Map<String, Object> columnMeta = new LinkedHashMap<String, Object>();
    private Map<String, Object> customEditor = new LinkedHashMap<String, Object>();
    private boolean forceUseCustomEditor = false;

    @Override
    @SimplePropertyAttribute
    public String getFieldKey() {
        return this.fieldKey;
    }

    @Override
    public void setFieldKey(String key) {
        this.fieldKey = key;
    }

    @Override
    @SimplePropertyAttribute
    public LocaleString getCaption() {
        return this.caption;
    }

    @Override
    public void setCaption(LocaleString caption) {
        this.caption = caption;
    }

    @Override
    @SimplePropertyAttribute
    public LocaleString getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(LocaleString width) {
        this.width = width;
    }

    @Override
    @SimplePropertyAttribute
    public String getMobTableField() {
        return this.mobTableField;
    }

    public void setMobTableField(String mobTableField) {
        this.mobTableField = mobTableField;
    }

    @Override
    @SimplePropertyAttribute
    public String getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(String visible) {
        this.visible = visible == null ? VISIBLE_DEFAULT_VALUE : visible;
    }

    @SimplePropertyAttribute
    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    @SimplePropertyAttribute
    public String getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(String foreColor) {
        this.foreColor = foreColor;
    }

    @SimplePropertyAttribute
    public int getFontSize() {
        return this.fontsize;
    }

    public void setFontSize(int fontSize) {
        this.fontsize = fontSize;
    }

    @SimplePropertyAttribute(name="Hyperlink")
    public boolean isHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(boolean hyperlink) {
        this.hyperlink = hyperlink;
    }

    public Map<String, Object> getColumnMeta() {
        return this.columnMeta;
    }

    public void setColumnMeta(Map<String, Object> columnMeta) {
        if (columnMeta != null) {
            this.columnMeta = columnMeta;
        }
    }

    @Override
    public Map<String, Object> getCustomEditor() {
        return this.customEditor;
    }

    @Override
    public void setCustomEditor(Map<String, Object> customEditor) {
        this.customEditor = customEditor;
        this.forceUseCustomEditor = true;
    }

    @Override
    public Map<String, Object> createColumn() {
        LinkedHashMap<String, Object> column = new LinkedHashMap<String, Object>(this.getColumnMeta());
        column.put("dataIndex", this.getFieldKey().replace(".", "_"));
        column.put("header", this.getCaption());
        column.put("editor", this.forceUseCustomEditor ? this.getCustomEditor() : this.createEditor());
        column.put("w", this.getWidth());
        if (this.isInvisible()) {
            column.put("vi", 0);
        } else {
            column.put("vi", this.getVisibleValue());
        }
        column.put("text-align", this.getTextAlign());
        column.put("fc", this.getForeColor());
        column.put("ln", this.isHyperlink());
        if (!this.forceUseCustomEditor) {
            column.put("fs", this.getFontSize());
        }
        return column;
    }

    protected Map<String, Object> createEditor() {
        Map<String, Object> colMeta = this.getColumnMeta();
        if (colMeta.get("editor") instanceof Map) {
            return (Map)colMeta.get("editor");
        }
        return new LinkedHashMap<String, Object>();
    }

    @Override
    public int getVisibleValue() {
        String visible = this.getVisible();
        if (visible == null) {
            return 63;
        }
        if (visible.contains(DEFAULT) || visible.contains(LOOKUP)) {
            String string = visible = StringUtils.isNotBlank((CharSequence)visible) && !visible.contains(INIT) ? String.format("%s,%s", visible, INIT) : visible;
        }
        if (StringUtils.isEmpty((CharSequence)visible)) {
            return 0;
        }
        String[] vs = visible.split(",");
        int ret = 0;
        for (String v : vs) {
            ret |= mapVis.get(v).intValue();
        }
        return ret;
    }

    static {
        mapVis.put("new", 1);
        mapVis.put("edit", 2);
        mapVis.put("view", 4);
        mapVis.put(INIT, 8);
        mapVis.put("submit", 16);
        mapVis.put("audit", 32);
    }
}

