/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.IListView;
import org.apache.commons.beanutils.ConvertUtils;

public class NavigationCache {
    public static final String CacheKey_NavigationPKValues = "navigationPKValues";
    public static final String CacheKey_NavigationPKValues_Page = "navigationPKValues_page";
    public static final String CacheKey_NavigationPageIndex = "navigationPageIndex";
    public static final String CacheKey_NavigationPKValue = "navigationPKValue";

    public static List<Object> getPKValuesFromCache(IFormView view) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String cacheValue = pageCache.get(CacheKey_NavigationPKValues);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            return null;
        }
        return (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
    }

    public static List<Object> getPKValuesFromListPage(IFormView view) {
        ArrayList<Object> pkValues = new ArrayList();
        HashSet<Object> sets = new HashSet<Object>();
        Object pkListCustParam = view.getFormShowParameter().getCustomParams().get("navigation_billids");
        if (StringUtils.isNotBlank((Object)pkListCustParam)) {
            pkValues = (List)SerializationUtils.fromJsonString((String)String.valueOf(pkListCustParam), List.class);
        } else {
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            if (!(parentView instanceof IListView)) {
                return pkValues;
            }
            FormConfig formConfig = FormMetadataCache.getFormConfig(((IListView)parentView).getBillFormId());
            if (!StringUtils.equals((CharSequence)view.getEntityId(), (CharSequence)formConfig.getEntityTypeId())) {
                return pkValues;
            }
            for (ListSelectedRow row : ((IListView)parentView).getCurrentListAllRowCollection()) {
                if (sets.contains(row.getPrimaryKeyValue())) continue;
                sets.add(row.getPrimaryKeyValue());
                pkValues.add(row.getPrimaryKeyValue());
            }
        }
        return pkValues;
    }

    public static List<Object> getPKValuesByPage(IFormView view, int pageIndex) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String cacheValue = pageCache.get(CacheKey_NavigationPKValues_Page + pageIndex);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            return null;
        }
        return (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
    }

    public static void putPKValuesByPage(IFormView view, int pageIndex, List<Object> pkValues) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(CacheKey_NavigationPKValues_Page + pageIndex, SerializationUtils.toJsonString(pkValues));
    }

    public static void putCachePKValues(IFormView view, List<Object> pkValues) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(CacheKey_NavigationPKValues, SerializationUtils.toJsonString(pkValues));
    }

    public static Integer getCachePageIndex(IFormView view) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String cacheValue = pageCache.get(CacheKey_NavigationPageIndex);
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            return Integer.valueOf(cacheValue);
        }
        return null;
    }

    public static void putCachePageIndex(IFormView view, int pageIndex) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(CacheKey_NavigationPageIndex, String.valueOf(pageIndex));
    }

    public static Object getCachePKValue(IFormView view) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String cacheValue = pageCache.get(CacheKey_NavigationPKValue);
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            Object pkValue = cacheValue;
            if (pkValue.getClass() != view.getModel().getDataEntityType().getPrimaryKey().getPropertyType()) {
                pkValue = ConvertUtils.convert((Object)pkValue, (Class)view.getModel().getDataEntityType().getPrimaryKey().getPropertyType());
            }
            return pkValue;
        }
        return null;
    }

    public static void putCachePKValue(IFormView view, Object pkValue) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(CacheKey_NavigationPKValue, pkValue.toString());
    }

    public static void addPKValue(IFormView view, Object pkValue) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        boolean refreshCache = false;
        List<Object> pkValues = NavigationCache.getPKValuesFromCache(view);
        if (pkValues == null) {
            pkValues = NavigationCache.getPKValuesFromListPage(view);
            refreshCache = true;
        }
        if (!pkValues.contains(pkValue)) {
            pkValues.add(pkValue);
            refreshCache = true;
        }
        if (refreshCache) {
            pageCache.put(CacheKey_NavigationPKValues, SerializationUtils.toJsonString(pkValues));
        }
    }

    public static void delPKValue(IFormView view, Object pkValue) {
        int index;
        List<Object> pkValues = NavigationCache.getPKValuesFromCache(view);
        if (pkValues == null) {
            pkValues = NavigationCache.getPKValuesFromListPage(view);
        }
        if ((index = pkValues.indexOf(pkValue)) >= 0) {
            pkValues.remove(index);
        }
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(CacheKey_NavigationPKValues, SerializationUtils.toJsonString(pkValues));
    }
}

