/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.interaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.interaction.IInteractionRequest;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;

public class InteractionHandler {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    public static void doInteraction(IFormView view, IInteractionRequest interactionRequest, OperateOption option, ConfirmCallBackListener callBack) {
        if (InteractionHandler.isCustInteraction(interactionRequest, option)) {
            InteractionHandler.doCustomInteraction(view, interactionRequest, option, callBack);
        } else {
            InteractionHandler.doValidateInteraction(view, interactionRequest, callBack);
        }
    }

    private static boolean isCustInteraction(IInteractionRequest interactionRequest, OperateOption option) {
        if (interactionRequest == null || interactionRequest.getInteractionContext() == null) {
            return false;
        }
        InteractionConfirmResult confirmResult = InteractionHandler.getConfirmResult(option);
        if (confirmResult.getResults().containsKey(interactionRequest.getSponsor()) || confirmResult.getResults().size() >= 3) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setLevel(ErrorLevel.FatalError);
            errorInfo.setMessage(interactionRequest.getInteractionContext().getSimpleMessage());
            interactionRequest.addErrorInfo(errorInfo);
            return false;
        }
        return true;
    }

    private static void doValidateInteraction(IFormView view, IInteractionRequest interactionRequest, ConfirmCallBackListener callBack) {
        ArrayList<String> warnMssages = new ArrayList<String>();
        List allOpInfo = interactionRequest.getAllErrorOrValidateInfo();
        for (IOperateInfo info : allOpInfo) {
            OperateErrorInfo errorInfo;
            if (!(info instanceof OperateErrorInfo) || (errorInfo = (OperateErrorInfo)info).getLevel() != ErrorLevel.Warning) continue;
            warnMssages.add(errorInfo.getMessage());
        }
        if (!warnMssages.isEmpty() && allOpInfo.size() == warnMssages.size()) {
            interactionRequest.setShowMessage(false);
            if (warnMssages.size() > 1) {
                int size = warnMssages.size();
                ArrayList<String> messagesWithNumber = new ArrayList<String>(size);
                for (int i = 0; i < size; ++i) {
                    messagesWithNumber.add(String.format("%d. %s", i + 1, warnMssages.get(i)));
                }
                String title = ResManager.loadKDString((String)"\u6709\u8b66\u544a\u6d88\u606f\u9700\u8981\u60a8\u786e\u8ba4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InteractionHandler_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
                view.showConfirm(title, StringUtils.join((Object[])messagesWithNumber.toArray(), (String)"\r\n"), MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
            } else if (((String)warnMssages.get(0)).length() > 20) {
                String title = ResManager.loadKDString((String)"\u6709\u8b66\u544a\u6d88\u606f\u9700\u8981\u60a8\u786e\u8ba4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InteractionHandler_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
                view.showConfirm(title, (String)warnMssages.get(0), MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
            } else {
                String warnMsg = (String)warnMssages.get(0);
                if (warnMsg.endsWith("\u3002")) {
                    warnMsg = warnMsg.substring(0, warnMsg.length() - 1);
                }
                String title = String.format(ResManager.loadKDString((String)"%s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InteractionHandler_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), warnMsg);
                view.showConfirm(title, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
            }
        }
    }

    private static void doCustomInteraction(IFormView view, IInteractionRequest interactionRequest, OperateOption option, ConfirmCallBackListener callBack) {
        if (StringUtils.isBlank((CharSequence)interactionRequest.getInteractionContext().getCustShowFormId())) {
            InteractionHandler.showStandardInteractionForm(view, interactionRequest, option, callBack);
        } else {
            InteractionHandler.showCustInteractionForm(view, interactionRequest, callBack);
        }
    }

    private static void showStandardInteractionForm(IFormView view, IInteractionRequest interactionRequest, OperateOption option, ConfirmCallBackListener callBack) {
        List infos = interactionRequest.getInteractionContext().getCustOperateInfos();
        int size = infos.size();
        ArrayList<String> warnMssages = new ArrayList<String>(size);
        if (size == 1) {
            warnMssages.add(((OperateErrorInfo)infos.get(0)).getMessage());
        } else {
            for (int i = 0; i < size; ++i) {
                warnMssages.add(String.format("%d. %s", i + 1, ((OperateErrorInfo)infos.get(i)).getMessage()));
            }
        }
        if (!warnMssages.isEmpty()) {
            interactionRequest.setShowMessage(false);
            InteractionConfirmResult confirmResult = InteractionHandler.getConfirmResult(option);
            confirmResult.put(interactionRequest.getSponsor(), MessageBoxResult.Yes.name());
            callBack.getOperateOption().put("interactionconfirmresult", confirmResult.toJsonString());
            if (warnMssages.size() > 1) {
                String title = ResManager.loadKDString((String)"\u6709\u591a\u6761\u4fe1\u606f\u9700\u8981\u60a8\u786e\u8ba4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InteractionHandler_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
                view.showConfirm(title, StringUtils.join((Object[])warnMssages.toArray(), (String)"\r\n"), MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
            } else {
                String warnMsg = (String)warnMssages.get(0);
                if (warnMsg.endsWith("\u3002")) {
                    warnMsg = warnMsg.substring(0, warnMsg.length() - 1);
                }
                String title = String.format(ResManager.loadKDString((String)"%s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InteractionHandler_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), warnMsg);
                view.showConfirm(title, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
            }
        }
    }

    private static void showCustInteractionForm(IFormView view, IInteractionRequest interactionRequest, ConfirmCallBackListener callBack) {
        interactionRequest.setShowMessage(false);
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        HashMap<String, String> cacheValue = new HashMap<String, String>();
        cacheValue.put("ConfirmCallBackListener.interactionhandler", SerializationUtils.toJsonString((Object)callBack));
        cacheValue.put("Interactionsponore", interactionRequest.getSponsor());
        cache.put(cacheValue);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(interactionRequest.getInteractionContext().getCustShowFormId());
        showParameter.getCustomParams().putAll(interactionRequest.getInteractionContext().getCustShowParameter());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.operate.interaction.InteractionCallBackHandler", "interactionhandler");
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    private static InteractionConfirmResult getConfirmResult(OperateOption option) {
        String json = option.getVariableValue("interactionconfirmresult", null);
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)json);
        return confirmResult;
    }
}

