/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.ApiFilter;
import kd.bos.form.operate.webapi.ApiPropConvertSeq;
import kd.bos.form.operate.webapi.ApiPropConverter;
import kd.bos.form.operate.webapi.AssignmentIdResult;
import kd.bos.form.operate.webapi.BizBasedataPk;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.IAssistantDataService;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.utils.DbTypeConverter;

class ApiBasedataPropConverter
extends ApiPropConverter {
    protected static final String NUMBER = "number";
    private static final String ORG_NUMBER = "number";
    private static final String ORG_NAME = "name";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    protected Map<BasedataItem, Set<String>> searchItems = new ConcurrentHashMap<BasedataItem, Set<String>>();
    protected Map<BasedataEntityType, Set<Object>> searchPKs = new ConcurrentHashMap<BasedataEntityType, Set<Object>>();

    ApiBasedataPropConverter() {
    }

    public BasedataProp getBasedataProp() {
        return (BasedataProp)this.getProp();
    }

    public BasedataEntityType getRefBDType(RowMapper row) {
        return (BasedataEntityType)((BasedataProp)this.getProp()).getComplexType();
    }

    public Map<BasedataItem, Set<String>> getSearchItems() {
        return this.searchItems;
    }

    public Map<BasedataEntityType, Set<Object>> getSearchPKs() {
        return this.searchPKs;
    }

    @Deprecated
    public Map<BasedataItem, Map<Object, DynamicObject>> getBaseObjs() {
        return new HashMap<BasedataItem, Map<Object, DynamicObject>>();
    }

    public String getUserOrgPropName() {
        if (this.getProp() instanceof IBasedataField) {
            return ((IBasedataField)this.getProp()).getOrgProp();
        }
        return null;
    }

    public Long getUseOrgId(RowMapper row) {
        Map mapVal;
        String useOrgPropKey = this.getUserOrgPropName();
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            useOrgPropKey = this.getContext().getModel().getDataEntityType().getMainOrg();
        }
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            return 0L;
        }
        if (StringUtils.equals((CharSequence)useOrgPropKey, (CharSequence)this.getContext().getModel().getDataEntityType().getMainOrg())) {
            return this.getContext().getMainOrgId();
        }
        Object orgVal = row.getValueFromSourceObj(useOrgPropKey, true);
        if (orgVal == null) {
            return 0L;
        }
        if (orgVal instanceof DynamicObject) {
            return (Long)((DynamicObject)orgVal).getPkValue();
        }
        if (orgVal instanceof Map && (mapVal = (Map)orgVal).containsKey("id")) {
            Object id = mapVal.get("id");
            if (id instanceof Long) {
                return (Long)id;
            }
            if (id != null) {
                return Long.valueOf(id.toString());
            }
        }
        return 0L;
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.BasedataProp.getValue();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        this.rowMapper = rowMapper;
        this.addSearchItem(rowMapper, value);
    }

    @Override
    public void endParseValue() {
        try {
            this.loadBasePKsFromDB();
            this.loadBaseObjsFromDB();
            this.searchItems.clear();
            this.searchPKs.clear();
        }
        catch (KDBizException bizException) {
            this.getContext().addErrorInfo(bizException.getMessage());
        }
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object srcVal) {
        try {
            Object targetVal = this.convertWebApiValue(rowMapper, srcVal);
            if (targetVal == null || targetVal instanceof DynamicObject) {
                this.getContext().getModel().setFieldValueForWebApi(this.getProp(), activeRow, targetVal, this.getContext().isCheckImportable());
            }
        }
        catch (KDBizException bizException) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), bizException.getMessage());
        }
    }

    protected BasedataItem buildBasedataItem(RowMapper rowMapper, Object val) {
        if (val == null || !(val instanceof Map)) {
            return null;
        }
        BasedataEntityType bdType = this.getRefBDType(rowMapper);
        if (bdType == null) {
            return null;
        }
        String searchKey = null;
        String searchValue = null;
        String dataType = "number";
        if (val instanceof Map) {
            Map map = (Map)val;
            if (map.containsKey("id")) {
                return null;
            }
            String importprop = (String)map.get("importprop");
            if (StringUtils.isBlank((CharSequence)importprop)) {
                importprop = map.containsKey("number") ? "number" : ORG_NAME;
                BasedataEntityType refPropType = (BasedataEntityType)this.getBasedataProp().getComplexType();
                dataType = this.convertDefaultImportProp(refPropType, importprop);
            } else {
                dataType = importprop;
            }
            searchValue = (String)map.get(importprop);
        }
        MasterBasedataProp masterIdProp = null;
        BasedataEntityType refMasterType = null;
        if (bdType.getMasteridType() == 2 && (masterIdProp = (MasterBasedataProp)bdType.findProperty(bdType.getMasteridPropName())) != null) {
            refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
        }
        if (StringUtils.isBlank((CharSequence)(searchKey = refMasterType == null ? dataType : masterIdProp.getName() + "." + dataType))) {
            return null;
        }
        Long useOrgId = this.getUseOrgId(rowMapper);
        BasedataItem item = new BasedataItem(this.getProp().getName(), bdType.getName(), bdType, useOrgId, searchKey, searchValue);
        return item;
    }

    protected String convertDefaultImportProp(BasedataEntityType refPropType, String importprop) {
        importprop = ORG_NAME.equals(importprop) ? refPropType.getNameProperty() : refPropType.getNumberProperty();
        return importprop;
    }

    protected void addSearchItem(RowMapper rowMapper, Object value) {
        if (this.addSerchId(rowMapper, value)) {
            return;
        }
        BasedataItem item = this.buildBasedataItem(rowMapper, value);
        if (item == null) {
            return;
        }
        if (this.getContext().getBasePKs().containsKey(item)) {
            return;
        }
        String searchValue = item.getSearchValue();
        item.setSearchValue(null);
        if (!this.getSearchItems().containsKey(item)) {
            HashSet searchValues = new HashSet();
            this.getSearchItems().put(item, searchValues);
        }
        this.getSearchItems().get(item).add(searchValue);
    }

    protected boolean addSerchId(RowMapper rowMapper, Object value) {
        Map map;
        if (!(value instanceof Map)) {
            return false;
        }
        Object id = null;
        if (value instanceof Map && StringUtils.isBlank(id = (Object)(map = (Map)value).get("id"))) {
            return false;
        }
        BasedataEntityType bdType = this.getRefBDType(rowMapper);
        if (bdType == null) {
            return false;
        }
        if (!this.getSearchPKs().containsKey(bdType)) {
            this.getSearchPKs().put(bdType, new HashSet());
        }
        id = DbTypeConverter.safeConvert((int)bdType.getPrimaryKey().getDbType(), id);
        this.getSearchPKs().get(bdType).add(id);
        return true;
    }

    private void loadBasePKsFromDB() {
        if (this.getSearchItems().isEmpty()) {
            return;
        }
        IBaseDataService baseDataService = (IBaseDataService)this.getContext().getModel().getService(IBaseDataService.class);
        ArrayList<Object> ids = new ArrayList<Object>(200);
        HashMap<BasedataItem, List<Object>> map = new HashMap<BasedataItem, List<Object>>(200);
        ArrayList<String> searchValues2 = new ArrayList<String>(200);
        HashMap<BasedataItem, Set<String>> tempSearchItems = new HashMap<BasedataItem, Set<String>>(this.getSearchItems());
        for (Map.Entry item : tempSearchItems.entrySet()) {
            BasedataItem basedataItem = (BasedataItem)item.getKey();
            Set searchValues = (Set)item.getValue();
            for (String searchValue : searchValues) {
                BasedataItem basedataItem2 = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag());
                if (StringUtils.isBlank((CharSequence)searchValue)) {
                    this.getContext().getBasePKs().put(basedataItem2, null);
                    continue;
                }
                if (this.getContext().getBasePKs().containsKey(basedataItem2)) continue;
                searchValues2.add(searchValue);
            }
            if (searchValues2.isEmpty()) continue;
            this.queryBasePk(baseDataService, basedataItem, map, ids, searchValues2);
            searchValues2.clear();
            ids.clear();
            map.clear();
        }
    }

    private void queryBasePk(IBaseDataService baseDataService, BasedataItem basedataItem, Map<BasedataItem, List<Object>> searchResult, List<Object> ids, List<String> searchValues) {
        ModelEventProxy modelEventProxy;
        Object searchResultIterator;
        ApiFilter filters = this.buildBaseDataFilter(basedataItem, searchValues);
        Set bdIdsForOrg = null;
        QFilter orgFilter = null;
        boolean isBaseDataFilter = false;
        if (basedataItem.getOrgId() != null && Long.compare(basedataItem.getOrgId(), 0L) != 0) {
            if (this.getBasedataProp() instanceof AssistantProp) {
                AssistantProp assistantProp = (AssistantProp)this.getBasedataProp();
                IAssistantDataService assistantDataService = (IAssistantDataService)ServiceFactory.getService(IAssistantDataService.class);
                orgFilter = assistantDataService.getAssistantDataFilter(Long.valueOf(Long.parseLong(assistantProp.getAsstTypeId())), basedataItem.getOrgId());
            } else {
                isBaseDataFilter = true;
            }
        }
        Map<BasedataItem, Object> basePKs = this.getContext().getBasePKs();
        Map<BasedataItem, BizBasedataPk> bizBasePKs = this.getContext().getBizBasePKs();
        if (isBaseDataFilter) {
            String fields = "id," + basedataItem.getSearchKey();
            DynamicObjectCollection collection = baseDataService.queryBaseData(basedataItem.getEntityNumber(), basedataItem.getOrgId(), filters.toQFilter(), fields);
            if (collection != null) {
                HashSet<String> notExistValues = new HashSet<String>(searchValues);
                for (DynamicObject row : collection) {
                    Object pkValue = row.get("id");
                    String searchValue = row.getString(basedataItem.getSearchKey());
                    if (bdIdsForOrg != null && !bdIdsForOrg.contains(pkValue)) continue;
                    BasedataItem basedataItem2 = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag());
                    if (!searchResult.containsKey(basedataItem2)) {
                        searchResult.put(basedataItem2, new ArrayList(4));
                    }
                    searchResult.get(basedataItem2).add(pkValue);
                    notExistValues.remove(searchValue);
                }
                searchResultIterator = searchResult.entrySet().iterator();
                while (searchResultIterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)searchResultIterator.next();
                    List pkIds = (List)entry.getValue();
                    if (pkIds.size() != 1) continue;
                    ids.add(pkIds.get(0));
                    basePKs.put((BasedataItem)entry.getKey(), pkIds.get(0));
                    searchResultIterator.remove();
                }
                for (String v : notExistValues) {
                    BasedataItem basedataItem2 = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), v, basedataItem.getBizTag());
                    searchResult.put(basedataItem2, new ArrayList());
                }
            }
        } else {
            if (orgFilter != null && StringUtils.equals((CharSequence)orgFilter.getProperty(), (CharSequence)"id") && StringUtils.equals((CharSequence)orgFilter.getCP(), (CharSequence)"in") && orgFilter.getValue() instanceof Set) {
                bdIdsForOrg = (Set)orgFilter.getValue();
                orgFilter = null;
            }
            if (orgFilter != null) {
                filters.getFilters().add(orgFilter);
                filters.getCommonfilterDesc().add(String.format(ResManager.loadKDString((String)"\u8be5\u57fa\u7840\u8d44\u6599\u5728\u4f7f\u7528\u7ec4\u7ec7\u201c\u5185\u7801=%s\u201d\u6216\u8005\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u4e2d", (String)"ApiBasedataPropConverter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), basedataItem.getOrgId()));
            }
            ORM orm = ORM.create();
            String fields = "id," + basedataItem.getSearchKey();
            DataSet ds = orm.queryDataSet("ApiBasedataPropConverter.loadBasePKsFromDB()", basedataItem.getEntityNumber(), fields, filters.toArray(), "");
            searchResultIterator = null;
            try {
                BasedataItem basedataItem2;
                HashSet<String> notExistValues = new HashSet<String>(searchValues);
                for (Row row : ds) {
                    Object pkValue = row.get("id");
                    String searchValue = row.getString(basedataItem.getSearchKey());
                    if (bdIdsForOrg != null && !bdIdsForOrg.contains(pkValue)) continue;
                    basedataItem2 = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag());
                    if (!searchResult.containsKey(basedataItem2)) {
                        searchResult.put(basedataItem2, new ArrayList(4));
                    }
                    searchResult.get(basedataItem2).add(pkValue);
                    notExistValues.remove(searchValue);
                }
                Iterator<Map.Entry<BasedataItem, List<Object>>> searchResultIterator2 = searchResult.entrySet().iterator();
                while (searchResultIterator2.hasNext()) {
                    Map.Entry<BasedataItem, List<Object>> entry = searchResultIterator2.next();
                    List<Object> pkIds = entry.getValue();
                    if (pkIds.size() != 1) continue;
                    ids.add(pkIds.get(0));
                    basePKs.put(entry.getKey(), pkIds.get(0));
                    searchResultIterator2.remove();
                }
                for (String v : notExistValues) {
                    basedataItem2 = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), v, basedataItem.getBizTag());
                    searchResult.put(basedataItem2, new ArrayList());
                }
            }
            catch (Throwable throwable) {
                searchResultIterator = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (searchResultIterator != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)searchResultIterator).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        if ((modelEventProxy = this.getContext().getModelEventProxy()) != null) {
            QueryImportBasedataEventArgs evt = new QueryImportBasedataEventArgs((Object)this.rowMapper, searchResult);
            modelEventProxy.fireQueryImportBasedata(evt);
        }
        for (Map.Entry<BasedataItem, List<Object>> item : searchResult.entrySet()) {
            List<Object> pkIds = item.getValue();
            if (pkIds == null) continue;
            if (pkIds.size() == 1) {
                bizBasePKs.put(item.getKey(), new BizBasedataPk(pkIds.get(0)));
                ids.add(pkIds.get(0));
                continue;
            }
            if (pkIds.size() > 1) {
                bizBasePKs.put(item.getKey(), new BizBasedataPk(pkIds, this.buildRepeatError(item, filters)));
                continue;
            }
            bizBasePKs.put(item.getKey(), new BizBasedataPk(pkIds, this.buildExistError(item, filters)));
        }
        if (!this.getSearchPKs().containsKey(basedataItem.getRefBDType())) {
            this.getSearchPKs().put(basedataItem.getRefBDType(), new HashSet(ids.size()));
        }
        this.getSearchPKs().get(basedataItem.getRefBDType()).addAll(ids);
    }

    private void loadBaseObjsFromDB() {
        if (this.getSearchPKs().isEmpty()) {
            return;
        }
        HashSet ids = new HashSet(1000);
        HashMap<BasedataEntityType, Set<Object>> tempSearchPKs = new HashMap<BasedataEntityType, Set<Object>>(this.getSearchPKs());
        for (Map.Entry item : tempSearchPKs.entrySet()) {
            BasedataEntityType bdType = (BasedataEntityType)item.getKey();
            Set pks = (Set)item.getValue();
            if (!this.getContext().getBaseObjs().containsKey(bdType.getName())) {
                ids.addAll(pks);
            } else {
                for (Object id : (Set)item.getValue()) {
                    if (this.getContext().getBaseObjs().get(bdType.getName()).containsKey(id)) continue;
                    ids.add(id);
                }
            }
            if (ids.isEmpty()) continue;
            Map objs = BusinessDataReader.loadFromCache((Object[])ids.toArray(), (DynamicObjectType)bdType);
            if (!this.getContext().getBaseObjs().containsKey(bdType.getName())) {
                this.getContext().getBaseObjs().put(bdType.getName(), new HashMap(objs.size()));
            }
            this.getContext().getBaseObjs().get(bdType.getName()).putAll(objs);
            ids.clear();
        }
    }

    private DynamicObject loadFromLocalCache(BasedataEntityType refBDType, Object id) {
        Object pkId = this.getBasedataProp().convertPKValueType((DynamicObjectType)refBDType, id);
        if (this.getContext().getBaseObjs().containsKey(refBDType.getName()) && this.getContext().getBaseObjs().get(refBDType.getName()).containsKey(pkId)) {
            return this.getContext().getBaseObjs().get(refBDType.getName()).get(pkId);
        }
        if (this.getContext().existPkIdsWithOutInDB((MainEntityType)refBDType, pkId)) {
            return null;
        }
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{pkId}, (DynamicObjectType)refBDType);
        if (!this.getContext().getBaseObjs().containsKey(refBDType.getName())) {
            this.getContext().getBaseObjs().put(refBDType.getName(), new HashMap());
        }
        this.getContext().getBaseObjs().get(refBDType.getName()).putAll(objs);
        if (objs.containsKey(pkId)) {
            return (DynamicObject)objs.get(pkId);
        }
        this.getContext().recordPkIdsWithOutInDB((MainEntityType)refBDType, pkId);
        return null;
    }

    protected ApiFilter buildBaseDataFilter(BasedataItem basedataItem, List<String> searchValues2) {
        ApiFilter apiFilter = new ApiFilter();
        StringBuilder sb = new StringBuilder();
        for (String value : searchValues2) {
            BasedataEntityType baseType = basedataItem.getRefBDType();
            BasedataItem item = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), value, basedataItem.getBizTag());
            sb.setLength(0);
            sb.append(this.getDisplayName((EntityType)baseType, basedataItem.getSearchKey()));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                sb.append("=").append(value);
            } else {
                sb.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"ApiBasedataPropConverter_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            }
            apiFilter.getSearchName().put(item, this.getDisplayName((EntityType)baseType, basedataItem.getSearchKey()));
            apiFilter.getFilterDesc().put(item, sb.toString());
        }
        if (searchValues2.size() == 1) {
            apiFilter.getFilters().add(new QFilter(basedataItem.getSearchKey(), "=", (Object)searchValues2.get(0)));
        } else {
            apiFilter.getFilters().add(new QFilter(basedataItem.getSearchKey(), "in", searchValues2));
        }
        if (this.getContext().isCheckBasedataPerm()) {
            IDataEntityProperty baseProp = this.getContext().getModel().getProperty(basedataItem.getFieldKey());
            List fieldFilters = FilterUtil.buildBaseDataF7QFilters((IBasedataField)((IBasedataField)baseProp), (IDataModel)this.getContext().getModel(), null, (String)basedataItem.getEntityNumber(), new ArrayList(), (String)"47150e89000000ac", (boolean)true);
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            QFilter qfilter = permissionService.getDataRuleForBdProp(Long.parseLong(RequestContext.get().getUserId()), null, this.getContext().getModel().getDataEntityType().getName(), basedataItem.getFieldKey());
            if (qfilter != null) {
                fieldFilters.add(qfilter);
            }
            if (fieldFilters != null) {
                apiFilter.getFilters().addAll(fieldFilters);
            }
        }
        return apiFilter;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object convertWebApiValue(RowMapper rowMapper, Object srcVal) {
        BasedataItem basedataItem;
        DynamicObject obj;
        Object id;
        block14: {
            if (srcVal == null || !(srcVal instanceof Map)) {
                return srcVal;
            }
            id = null;
            obj = null;
            basedataItem = this.buildBasedataItem(rowMapper, srcVal);
            if (basedataItem == null) {
                if (srcVal instanceof Map && ((Map)srcVal).containsKey("id")) {
                    id = ((Map)srcVal).get("id");
                    break block14;
                } else {
                    String errMsg = ResManager.loadKDString((String)"\u3010%s\u3011\u672a\u4f20\u5165\u5408\u6cd5\u503c\uff0c\u8bf7\u4f20\u5165id\u3001number\u6216name", (String)"ApiBasedataPropConverter_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
                    this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getProp().getDisplayName().toString()));
                    return null;
                }
            }
            if (this.getContext().getBasePKs().containsKey(basedataItem)) {
                id = this.getContext().getBasePKs().get(basedataItem);
            } else {
                String oldFieldKey = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)basedataItem.getEntityNumber(), (CharSequence)this.getContext().getModel().getDataEntityType().getName())) {
                    oldFieldKey = basedataItem.getFieldKey();
                    basedataItem.setFieldKey(this.getContext().getModel().getDataEntityType().getName());
                    if (this.getContext().getBasePKs().containsKey(basedataItem)) {
                        id = this.getContext().getBasePKs().get(basedataItem);
                    }
                }
                if (id == null) {
                    BizBasedataPk bizPk = this.getContext().getBizBasePKs().get(basedataItem);
                    if (bizPk == null && oldFieldKey != null) {
                        basedataItem.setFieldKey(oldFieldKey);
                        bizPk = this.getContext().getBizBasePKs().get(basedataItem);
                    }
                    if (bizPk != null) {
                        if (bizPk.getError() != null) {
                            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), bizPk.getError());
                            return null;
                        }
                        id = bizPk.getPk();
                    }
                }
            }
        }
        if (id != null) {
            BasedataEntityType bdType = null;
            bdType = basedataItem == null ? this.getRefBDType(rowMapper) : basedataItem.getRefBDType();
            obj = this.loadFromLocalCache(bdType, id);
        }
        if (obj != null) {
            return obj;
        }
        return id;
    }

    private String buildRepeatError(Map.Entry<BasedataItem, List<Object>> searchResult, ApiFilter filters) {
        StringBuilder sb = new StringBuilder();
        BasedataItem item = searchResult.getKey();
        sb.append(filters.getFilterDesc().get(item));
        for (String msg : filters.getCommonfilterDesc()) {
            sb.append('\uff0c').append(msg);
        }
        sb.append('\uff0c').append(ResManager.loadKDString((String)"\u7b26\u5408F7\u8fc7\u6ee4\u6761\u4ef6", (String)"ApiBasedataPropConverter_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        String displayName = this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), item.getFieldKey());
        return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684%2$s\u5728\u7cfb\u7edf\u4e2d\u4e0d\u552f\u4e00\uff0c\u91cd\u590d\u7684%3$s\u5185\u7801\uff1a%4$s", (String)"ApiBasedataPropConverter_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), sb.toString(), displayName, displayName, searchResult.getValue().size() > 3 ? searchResult.getValue().subList(0, 3) + "\u2026\u2026" : searchResult.getValue());
    }

    private String getUseOrgPropNameOrDefault() {
        String useOrgPropKey = this.getUserOrgPropName();
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            useOrgPropKey = this.getContext().getModel().getDataEntityType().getMainOrg();
        }
        return useOrgPropKey;
    }

    protected String getDisplayName(EntityType entityType, String propKey) {
        if ("id".equals(propKey)) {
            return ResManager.loadKDString((String)"\u5185\u7801", (String)"ApiBasedataPropConverter_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
        }
        if ("pid".equals(propKey)) {
            return ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ApiBasedataPropConverter_6", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
        }
        IDataEntityProperty prop = EntityTypeUtil.getDataEntityProperty((String)propKey, (EntityType)entityType, (boolean)false);
        if (prop == null) {
            return propKey;
        }
        LocaleString displayName = prop.getDisplayName();
        return displayName != null && StringUtils.isNotBlank((CharSequence)displayName.toString()) ? displayName.toString() : propKey;
    }

    private String buildExistError(Map.Entry<BasedataItem, List<Object>> searchResult, ApiFilter filters) {
        BasedataItem item = searchResult.getKey();
        StringBuilder sb = new StringBuilder(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u201c%2$s\u201d", (String)"ApiBasedataPropConverter_7", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), item.getFieldKey()), filters.getFilterDesc().get(item)));
        sb.append(ResManager.loadKDString((String)"\u5bfc\u5165\u4e0d\u6210\u529f\u3002\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001", (String)"ApiBasedataPropConverter_8", (String)BOS_FORM_METADATA, (Object[])new Object[0])).append(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u6b63\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6", (String)"ApiBasedataPropConverter_9", (String)BOS_FORM_METADATA, (Object[])new Object[0]), filters.getSearchName().get(item)));
        int i = 3;
        for (String msg : filters.getCommonfilterDesc()) {
            sb.append('\uff1b').append(i++).append('\u3001').append(msg).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u4f7f\u7528\u6743\u9650", (String)"ApiBasedataPropConverter_10", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
        return sb.append('\u3002').toString();
    }

    protected BasedataItem bulidItem(RowMapper rowMapper, Object srcVal) {
        return this.buildBasedataItem(rowMapper, srcVal);
    }

    protected boolean isContainsItem(BasedataItem basedataItem) {
        return this.getContext().getBasePKs().containsKey(basedataItem);
    }

    protected BasedataItem rebulidBaseDataItem(BasedataItem basedataItem, String searchValue) {
        return new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag(), basedataItem.getVersionControl());
    }

    protected List<QFilter> getF7QFilter(IDataEntityProperty baseProp, IDataModel model, String formShowParameterAppId, BasedataItem basedataItem) {
        return FilterUtil.buildBaseDataF7QFilters((IBasedataField)((IBasedataField)baseProp), (IDataModel)model, (String)formShowParameterAppId, (String)basedataItem.getEntityNumber(), new ArrayList(), (String)"47150e89000000ac", (boolean)true);
    }

    protected AssignmentIdResult assignmentId(RowMapper rowMapper, Object id, BasedataItem basedataItem, String oldFieldKey) {
        boolean isContainsError = false;
        BizBasedataPk bizPk = this.getContext().getBizBasePKs().get(basedataItem);
        if (bizPk == null && oldFieldKey != null) {
            basedataItem.setFieldKey(oldFieldKey);
            bizPk = this.getContext().getBizBasePKs().get(basedataItem);
        }
        if (bizPk != null) {
            if (bizPk.getError() == null) {
                id = bizPk.getPk();
            } else {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), bizPk.getError());
                isContainsError = true;
            }
        }
        return new AssignmentIdResult(id, isContainsError);
    }

    protected Object getPKFromItem(BasedataItem basedataItem) {
        return this.getContext().getBasePKs().get(basedataItem);
    }

    protected String getBaseDataPropDisplayName() {
        IDataEntityProperty prop = this.getProp();
        LocaleString displayName = prop.getDisplayName();
        if (displayName == null) {
            return prop.getName();
        }
        if (StringUtils.isNotBlank((CharSequence)displayName.toString())) {
            return displayName.toString();
        }
        return prop.getName();
    }
}

