/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.text.ParseException;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.operate.webapi.ApiPropConverter;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ApiDateTimePropConverter
extends ApiPropConverter {
    private static Log log = LogFactory.getLog(ApiDateTimePropConverter.class);
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        if (this.validateTimeRange(rowMapper, activeRow)) {
            super.execSetValue(rowMapper, activeRow, value);
        }
    }

    private boolean validateTimeRange(RowMapper rowMapper, DynamicObject activeRow) {
        DateTimeProp timeProp;
        IDataEntityProperty prop = this.getProp();
        if (prop instanceof DateTimeProp && StringUtils.isNotBlank((CharSequence)(timeProp = (DateTimeProp)prop).getRelateDateTimeRange())) {
            return this.validateTimeRangeForEmpty(timeProp, rowMapper) && this.validateDateTimeRangeForTimeUp(timeProp, rowMapper);
        }
        return true;
    }

    private boolean validateTimeRangeForEmpty(DateTimeProp timeProp, RowMapper rowMapper) {
        Object relateTimeRangeObj = rowMapper.getSourceObj().get(timeProp.getRelateDateTimeRange());
        Object timeObj = rowMapper.getSourceObj().get(timeProp.getName());
        if (StringUtils.isBlank((Object)relateTimeRangeObj) && StringUtils.isBlank((Object)timeObj)) {
            return true;
        }
        if (relateTimeRangeObj == null || StringUtils.isBlank((CharSequence)relateTimeRangeObj.toString())) {
            String displayName = timeProp.getDisplayName() == null ? timeProp.getName() : timeProp.getDisplayName().getLocaleValue();
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%s\uff1a\u6b64\u5c5e\u6027\u5bf9\u5e94\u7684\u8d77\u59cb\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u5b58\u5728", (String)"ApiDateTimePropConverter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), displayName));
            return false;
        }
        return true;
    }

    private boolean validateDateTimeRangeForTimeUp(DateTimeProp timeProp, RowMapper rowMapper) {
        String displayName = timeProp.getDisplayName() == null ? timeProp.getName() : timeProp.getDisplayName().getLocaleValue();
        String relateTimeRange = timeProp.getRelateDateTimeRange();
        if (timeProp.isStartDateTimeRange() && StringUtils.isNotBlank((CharSequence)relateTimeRange)) {
            Date endTime;
            Date startTime;
            Object startTimeObj = rowMapper.getSourceObj().get(timeProp.getName());
            Object endTimeObj = rowMapper.getSourceObj().get(relateTimeRange);
            IDataEntityProperty endTimeProp = (IDataEntityProperty)rowMapper.getTargetObj().getDataEntityType().getProperties().get((Object)relateTimeRange);
            try {
                startTime = startTimeObj instanceof Date ? (Date)startTimeObj : timeProp.parse((Object)rowMapper.getTargetObj(), startTimeObj.toString());
            }
            catch (ParseException e) {
                String errMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728", (String)"ApiDateTimePropConverter_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), displayName, startTimeObj);
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errMsg);
                return false;
            }
            try {
                endTime = endTimeObj instanceof Date ? (Date)endTimeObj : timeProp.parse((Object)rowMapper.getTargetObj(), endTimeObj.toString());
            }
            catch (ParseException e) {
                String errMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728", (String)"ApiDateTimePropConverter_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), displayName, endTimeObj);
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errMsg);
                return false;
            }
            if (StringUtils.isNotBlank((Object)startTimeObj) && StringUtils.isNotBlank((Object)endTimeObj) && startTime.after(endTime)) {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%s\uff1a\u8d77\u59cb\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"ApiDateTimePropConverter_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), displayName));
                return false;
            }
        }
        return true;
    }
}

