/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.ApiBasedataPropConverter;
import kd.bos.form.operate.webapi.ApiFilter;
import kd.bos.form.operate.webapi.ApiPropConvertSeq;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;

public class ApiOrgPropConverter
extends ApiBasedataPropConverter {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    @Override
    public Long getUseOrgId(RowMapper row) {
        return 0L;
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.OrgProp.getValue();
    }

    @Override
    protected ApiFilter buildBaseDataFilter(BasedataItem basedataItem, List<String> searchValues2) {
        ApiFilter filter = super.buildBaseDataFilter(basedataItem, searchValues2);
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        QFilter bizOrgFilter = orgService.getBizOrgFilter(((OrgProp)this.getProp()).getOrgFunc());
        if (bizOrgFilter != null) {
            filter.getFilters().add(bizOrgFilter);
            filter.getCommonfilterDesc().add(ResManager.loadKDString((String)"\u7b26\u5408\u4e1a\u52a1\u7ec4\u7ec7\u8fc7\u6ee4\u6761\u4ef6", (String)"ApiOrgPropConverter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
        return filter;
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object srcVal) {
        try {
            Object targetVal = this.convertWebApiValue(rowMapper, srcVal);
            if (this.getContext().isCheckImportable()) {
                ((IFieldHandle)this.getProp()).setFieldValueForWebApi(this.getContext().getModel(), (Object)activeRow, targetVal);
            } else {
                ((IFieldHandle)this.getProp()).setFieldValueForWebApi(this.getContext().getModel(), (Object)activeRow, targetVal, false);
            }
        }
        catch (KDBizException bizException) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), bizException.getMessage());
        }
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        Long orgId = 0L;
        boolean hasError = false;
        if (value instanceof Map) {
            Map orgVal = (Map)value;
            BasedataItem orgItem = this.buildBasedataItem(rowMapper, orgVal);
            if (orgItem == null) {
                if (orgVal.containsKey("id")) {
                    Object id = orgVal.get("id");
                    if (id instanceof Long) {
                        orgId = (Long)id;
                    } else if (id != null) {
                        orgId = Long.valueOf(id.toString());
                    }
                }
                if (Long.compare(orgId, 0L) == 0) {
                    String errMsg = ResManager.loadKDString((String)"\u3010%s\u3011\u672a\u4f20\u5165\u5408\u6cd5\u503c\uff0c\u8bf7\u4f20\u5165id\u3001number\u6216name", (String)"ApiOrgPropConverter_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
                    this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getPropDisplayName()));
                    hasError = true;
                }
            } else if (this.getContext().getBasePKs().containsKey(orgItem)) {
                orgId = (Long)this.getContext().getBasePKs().get(orgItem);
            } else if (StringUtils.isNotBlank((CharSequence)orgItem.getSearchValue())) {
                ArrayList<String> orgNumbers = new ArrayList<String>();
                orgNumbers.add(orgItem.getSearchValue());
                ApiFilter filter = this.buildBaseDataFilter(orgItem, orgNumbers);
                IBaseDataService baseDataService = (IBaseDataService)this.getContext().getModel().getService(IBaseDataService.class);
                DynamicObjectCollection objColl = baseDataService.queryBaseData(orgItem.getEntityNumber(), Long.valueOf(0L), filter.toQFilter(), "id," + orgItem.getSearchKey());
                if (objColl != null && !objColl.isEmpty()) {
                    orgId = (Long)((DynamicObject)objColl.get(0)).get("id");
                    this.getContext().getBasePKs().put(orgItem, orgId);
                } else {
                    String dataType = orgVal.containsKey("importprop") ? (String)orgVal.get("importprop") : (orgVal.containsKey("number") ? "number" : "name");
                    String msg = "number".equals(dataType) ? String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d", (String)"ApiOrgPropConverter_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), orgVal.get("number")) : String.format(ResManager.loadKDString((String)"\u540d\u79f0\u201c%s\u201d", (String)"ApiOrgPropConverter_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), orgVal.get("name"));
                    String errMsg = ResManager.loadKDString((String)"\u3010%1$s\u3011\u6570\u636e\u4e0d\u5b58\u5728\uff1a%2$s", (String)"ApiOrgPropConverter_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
                    this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getProp().getDisplayName().toString(), msg));
                    hasError = true;
                }
            }
            this.setValue(rowMapper, rowMapper.getTargetObj(), orgId);
            if (orgId != null && orgId > 0L) {
                orgVal.put("id", orgId);
            }
        } else if (value instanceof Number || value == null) {
            this.setValue(rowMapper, rowMapper.getTargetObj(), value);
        } else {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u4f20\u5165\u5408\u6cd5\u503c\uff0c\u8bf7\u4f20\u5165id\u3001number\u6216name", (String)"ApiOrgPropConverter_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getPropDisplayName()));
            hasError = true;
        }
        if (hasError || orgId == 0L) {
            return;
        }
        BasedataEntityType orgType = this.getRefBDType(rowMapper);
        if (!this.getSearchPKs().containsKey(orgType)) {
            this.getSearchPKs().put(orgType, new HashSet());
        }
        ((Set)this.getSearchPKs().get(orgType)).add(orgId);
    }

    protected String getPropDisplayName() {
        LocaleString display = this.getProp().getDisplayName();
        return display != null && StringUtils.isNotBlank((CharSequence)display.toString()) ? display.toString() : this.getProp().getName();
    }
}

