/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.operate.webapi.ApiPropConvertItem;
import kd.bos.form.operate.webapi.ApiPropConvertItemSort;
import kd.bos.form.operate.webapi.BizBasedataPk;
import kd.bos.form.operate.webapi.EntyRowMatchStyle;
import kd.bos.form.operate.webapi.IApiPropConverter;
import kd.bos.form.operate.webapi.RefBilldataItem;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.list.TreeList;

public class ApiPropConvertContext {
    public static final String ENTITYNUMBER = "number";
    private IDataModel model;
    private ModelEventProxy modelEventProxy;
    private HasPermDimObjResult hasPermResult;
    private String formShowParameterAppId;
    private boolean checkBasedataPerm = false;
    private boolean modify;
    private boolean importMode = false;
    private EntyRowMatchStyle entyRowMatchStyle = EntyRowMatchStyle.Postion;
    private Set<String> needUpdateFields;
    protected List<String> dataConvertOrder;
    private boolean checkImportable;
    protected Map<String, IApiPropConverter> propConverters = new HashMap<String, IApiPropConverter>(200);
    protected IApiPropConverter mainOrgPropConverter;
    private Long mainOrgId;
    private String mainOrgNumber;
    protected Map<BasedataItem, Object> basePKs = new HashMap<BasedataItem, Object>(1000);
    protected Map<RefBilldataItem, Object> refBillPKs = new HashMap<RefBilldataItem, Object>(1000);
    protected Map<BasedataItem, BizBasedataPk> bizBasePKs = new LinkedHashMap<BasedataItem, BizBasedataPk>(1000);
    protected Map<RefBilldataItem, String> refBillPKErrors = new LinkedHashMap<RefBilldataItem, String>(1000);
    protected Map<String, Map<Object, DynamicObject>> baseObjs = new HashMap<String, Map<Object, DynamicObject>>(1000);
    private Map<Integer, List<String>> errorInfo = new HashMap<Integer, List<String>>(10000);
    private int entityExcelRowIndex;
    private List<String> errorInfos = new TreeList();
    private FieldControlRules fieldControlRules;
    private Optional<List<Long>> mainOrgSuperiorOrgs;
    private boolean isCacheMainOrgSuperiorOrgs;
    private Map<String, Set<Object>> basedataPkIdsWithOutInDB = new HashMap<String, Set<Object>>();
    private BidiMap<Integer, Integer> entryRowMappingExcelRows = new DualHashBidiMap();
    private Map<String, QFilter> entityOrgIdQFilterMapping = new HashMap<String, QFilter>();

    @Deprecated
    public ApiPropConvertContext(IDataModel model) {
        this(model, null);
    }

    @Deprecated
    public ApiPropConvertContext(IDataModel model, Map<BasedataItem, Object> basePKs) {
        this(model, null, basePKs);
    }

    public ApiPropConvertContext(IDataModel model, ModelEventProxy modelEventProxy, Map<BasedataItem, Object> basePKs) {
        this.model = model;
        this.modelEventProxy = modelEventProxy;
        if (basePKs != null) {
            this.basePKs = basePKs;
        }
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        this.checkBasedataPerm = Boolean.TRUE.equals(systemParamService.loadPublicParameterFromCache("import_basedata_checkperm"));
        this.initFieldControlRule();
    }

    public ApiPropConvertContext(IDataModel model, ModelEventProxy modelEventProxy, Map<BasedataItem, Object> basePKs, Map<String, Map<Object, DynamicObject>> baseObjs) {
        this(model, modelEventProxy, basePKs);
        if (baseObjs != null) {
            this.baseObjs.putAll(baseObjs);
        }
    }

    public String getFormShowParameterAppId() {
        return this.formShowParameterAppId;
    }

    public void setFormShowParameterAppId(String formShowParameterAppId) {
        this.formShowParameterAppId = formShowParameterAppId;
    }

    public IDataModel getModel() {
        return this.model;
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setModify(boolean modify) {
        this.modify = modify;
    }

    public boolean isImportMode() {
        return this.importMode;
    }

    public void setImportMode(boolean importMode) {
        this.importMode = importMode;
    }

    public boolean isCheckBasedataPerm() {
        return this.checkBasedataPerm;
    }

    public EntyRowMatchStyle getEntyRowMatchStyle() {
        return this.entyRowMatchStyle;
    }

    public void setEntyRowMatchStyle(EntyRowMatchStyle entyRowMatchStyle) {
        this.entyRowMatchStyle = entyRowMatchStyle;
    }

    public Set<String> getNeedUpdateFields() {
        return this.needUpdateFields;
    }

    public void setNeedUpdateFields(Set<String> needUpdateFields) {
        this.needUpdateFields = needUpdateFields;
    }

    public Map<String, IApiPropConverter> getPropConverters() {
        return this.propConverters;
    }

    public IApiPropConverter getMainOrgPropConverter() {
        return this.mainOrgPropConverter;
    }

    public Long getMainOrgId() {
        DynamicObject mainOrg;
        if (this.mainOrgId == null && !StringUtils.isBlank((CharSequence)this.getModel().getDataEntityType().getMainOrg()) && (mainOrg = (DynamicObject)this.getModel().getValue(this.getModel().getDataEntityType().getMainOrg())) != null) {
            this.mainOrgId = (Long)mainOrg.getPkValue();
        }
        return this.mainOrgId;
    }

    public String getMainOrgNumber() {
        DynamicObject mainOrg;
        if (this.mainOrgNumber == null && !StringUtils.isBlank((CharSequence)this.getModel().getDataEntityType().getMainOrg()) && (mainOrg = (DynamicObject)this.getModel().getValue(this.getModel().getDataEntityType().getMainOrg())) != null) {
            this.mainOrgNumber = mainOrg.getString(ENTITYNUMBER);
        }
        return this.mainOrgNumber;
    }

    public void setMainOrgId(Long mainOrgId) {
        this.mainOrgId = mainOrgId;
    }

    public int getEntityExcelRowIndex() {
        return this.entityExcelRowIndex;
    }

    public void setEntityExcelRowIndex(int entityExcelRowIndex) {
        this.entityExcelRowIndex = entityExcelRowIndex;
    }

    public Map<BasedataItem, Object> getBasePKs() {
        return this.basePKs;
    }

    public Map<RefBilldataItem, Object> getRefBillPKs() {
        return this.refBillPKs;
    }

    public Map<String, Map<Object, DynamicObject>> getBaseObjs() {
        return this.baseObjs;
    }

    public boolean isNeedUpdate(IDataEntityProperty prop) {
        if (this.isImportMode() && prop instanceof IFieldHandle && !((IFieldHandle)prop).isImportable()) {
            return false;
        }
        if (this.getNeedUpdateFields() != null && !this.getNeedUpdateFields().isEmpty()) {
            String entityKeyTmp = this.getModel().getDataEntityType().getName() + "." + prop.getName();
            if (!this.getNeedUpdateFields().contains(prop.getName()) && !this.getNeedUpdateFields().contains(entityKeyTmp)) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public IApiPropConverter getPropConverter(String propName) {
        if (!this.propConverters.containsKey(propName)) {
            IApiPropConverter propConverter = IApiPropConverter.create(this, propName);
            if (propConverter != null) {
                this.propConverters.put(propName, propConverter);
            }
            if (propConverter != null && propConverter.getProp() instanceof MainOrgProp) {
                this.mainOrgPropConverter = propConverter;
            }
        }
        return this.propConverters.get(propName);
    }

    public IApiPropConverter getPropConverter(EntityType entityType, String propName) {
        if ("id".equalsIgnoreCase(propName) && entityType instanceof EntryType) {
            propName = entityType.getName() + ".id";
        }
        if ("pid".equalsIgnoreCase(propName) && entityType instanceof TreeEntryType) {
            propName = entityType.getName() + ".pid";
        }
        if (!this.propConverters.containsKey(propName)) {
            IApiPropConverter propConverter = IApiPropConverter.create(this, propName);
            if (propConverter != null) {
                this.propConverters.put(propName, propConverter);
            }
            if (propConverter != null && propConverter.getProp() instanceof MainOrgProp) {
                this.mainOrgPropConverter = propConverter;
            }
        }
        return this.propConverters.get(propName);
    }

    @Deprecated
    public List<ApiPropConvertItem> sortPropConverters(Map<String, Object> sourceRow) {
        ArrayList<ApiPropConvertItem> items = new ArrayList<ApiPropConvertItem>(sourceRow.size());
        for (Map.Entry<String, Object> fieldItem : sourceRow.entrySet()) {
            IApiPropConverter propConverter = this.getPropConverter(fieldItem.getKey());
            Object value = fieldItem.getValue();
            items.add(new ApiPropConvertItem(propConverter, value));
        }
        items.sort(new ApiPropConvertItemSort());
        return items;
    }

    public List<ApiPropConvertItem> sortPropConverters(EntityType entityType, Map<String, Object> sourceRow) {
        ArrayList<ApiPropConvertItem> items = new ArrayList<ApiPropConvertItem>(sourceRow.size());
        for (Map.Entry<String, Object> fieldItem : sourceRow.entrySet()) {
            IApiPropConverter propConverter = this.getPropConverter(entityType, fieldItem.getKey());
            if (propConverter.getProp() == null || !StringUtils.equalsIgnoreCase((CharSequence)propConverter.getProp().getParent().getName(), (CharSequence)entityType.getName())) continue;
            Object value = fieldItem.getValue();
            items.add(new ApiPropConvertItem(propConverter, value));
        }
        items.sort(new ApiPropConvertItemSort(this.dataConvertOrder));
        return items;
    }

    @Deprecated
    public void addErrorInfos(String errorInfos) {
        this.errorInfos.add(errorInfos);
    }

    @Deprecated
    public List<String> getErrorInfos() {
        return this.errorInfos;
    }

    public void clearErrorInfos() {
        this.errorInfos.clear();
        this.errorInfo.clear();
    }

    public void addErrorInfo(String errInfo) {
        this.addErrorInfo(this.entityExcelRowIndex, errInfo);
    }

    public void addErrorInfo(int rowIndex, String errInfo) {
        if (StringUtils.isBlank((CharSequence)errInfo)) {
            return;
        }
        TreeList errInfoList = this.errorInfo.get(rowIndex);
        if (CollectionUtils.isNotEmpty(errInfoList) && errInfoList.contains(errInfo)) {
            return;
        }
        if (CollectionUtils.isEmpty(errInfoList)) {
            errInfoList = new TreeList();
        }
        if (this.limitFieldNum((List<String>)errInfoList)) {
            return;
        }
        errInfo = this.limitFieldLength(errInfo);
        errInfoList.add(errInfo);
        this.errorInfo.put(rowIndex, (List<String>)errInfoList);
    }

    public boolean limitFieldNum(List<String> errInfoList) {
        return errInfoList.size() >= 50;
    }

    public String limitFieldLength(String errInfo) {
        errInfo = errInfo.length() <= 1000 ? errInfo : errInfo.substring(0, 1000);
        return errInfo;
    }

    public Map<Integer, List<String>> getErrorInfo() {
        return this.errorInfo;
    }

    public HasPermDimObjResult getHasPermResult() {
        return this.hasPermResult;
    }

    public void setHasPermResult(HasPermDimObjResult hasPermResult) {
        this.hasPermResult = hasPermResult;
    }

    public ModelEventProxy getModelEventProxy() {
        return this.modelEventProxy;
    }

    public void setModelEventProxy(ModelEventProxy modelEventProxy) {
        this.modelEventProxy = modelEventProxy;
    }

    public Map<BasedataItem, BizBasedataPk> getBizBasePKs() {
        return this.bizBasePKs;
    }

    public Map<RefBilldataItem, String> getRefBillPKErrors() {
        return this.refBillPKErrors;
    }

    public FieldControlRules getFieldControlRules() {
        return this.fieldControlRules;
    }

    public void setFieldControlRules(FieldControlRules fieldControlRules) {
        this.fieldControlRules = fieldControlRules;
    }

    public BidiMap<Integer, Integer> getEntryRowMappingExcelRows() {
        return this.entryRowMappingExcelRows;
    }

    public Map<String, QFilter> getEntityOrgIdQFilterMapping() {
        return this.entityOrgIdQFilterMapping;
    }

    public void setEntityOrgIdQFilterMapping(Map<String, QFilter> entityOrgIdQFilterMapping) {
        this.entityOrgIdQFilterMapping = entityOrgIdQFilterMapping;
    }

    private void initFieldControlRule() {
        String formId = this.model.getDataEntityType().getName();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        String appId = bizAppService.getAppIdByFormNum(formId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, appId, formId);
        if (fieldControlRules == null || fieldControlRules.getFieldControlRuleDtos() == null || fieldControlRules.getFieldControlRuleDtos().isEmpty()) {
            return;
        }
        this.fieldControlRules = fieldControlRules;
    }

    public ApiPropConvertContext setDataConvertOrder(List<String> dataConvertOrder) {
        this.dataConvertOrder = dataConvertOrder;
        return this;
    }

    public void setCheckImportable(boolean checkImportable) {
        this.checkImportable = checkImportable;
    }

    public boolean isCheckImportable() {
        return this.checkImportable;
    }

    public Optional<List<Long>> getMainOrgSuperiorOrgs() {
        return this.mainOrgSuperiorOrgs;
    }

    public void setMainOrgSuperiorOrgs(Optional<List<Long>> mainOrgSuperiorOrgs) {
        this.mainOrgSuperiorOrgs = mainOrgSuperiorOrgs;
    }

    public boolean isCacheMainOrgSuperiorOrgs() {
        return this.isCacheMainOrgSuperiorOrgs;
    }

    public void setCacheMainOrgSuperiorOrgs(boolean cacheMainOrgSuperiorOrgs) {
        this.isCacheMainOrgSuperiorOrgs = cacheMainOrgSuperiorOrgs;
    }

    public void recordPkIdsWithOutInDB(MainEntityType entityType, Object pkId) {
        Set pkIdsWithOutInDB = this.basedataPkIdsWithOutInDB.computeIfAbsent(entityType.getName(), x -> new HashSet());
        pkIdsWithOutInDB.add(pkId);
    }

    public boolean existPkIdsWithOutInDB(MainEntityType entityType, Object pkId) {
        Set pkIdsWithOutInDB = this.basedataPkIdsWithOutInDB.computeIfAbsent(entityType.getName(), x -> new HashSet());
        return pkIdsWithOutInDB.contains(pkId);
    }

    public void addEntryRowMappingExcelRowNum(String entryName, Map<Integer, Integer> mapping) {
        this.entryRowMappingExcelRows.putAll(mapping);
    }

    public ApiPropConvertContext convert2WebApiApiPropConvertContext() {
        ApiPropConvertContext apiPropConvertContext = new ApiPropConvertContext(this.model, this.modelEventProxy, this.basePKs, this.baseObjs);
        apiPropConvertContext.setHasPermResult(this.hasPermResult);
        apiPropConvertContext.setImportMode(this.importMode);
        apiPropConvertContext.setNeedUpdateFields(this.needUpdateFields);
        apiPropConvertContext.setDataConvertOrder(this.dataConvertOrder);
        apiPropConvertContext.setCheckImportable(this.checkImportable);
        apiPropConvertContext.setMainOrgId(this.mainOrgId);
        apiPropConvertContext.getBizBasePKs().putAll(this.bizBasePKs);
        apiPropConvertContext.getErrorInfos().addAll(this.errorInfos);
        apiPropConvertContext.setFieldControlRules(this.fieldControlRules);
        apiPropConvertContext.setMainOrgSuperiorOrgs(this.mainOrgSuperiorOrgs);
        apiPropConvertContext.setCacheMainOrgSuperiorOrgs(this.isCacheMainOrgSuperiorOrgs);
        return apiPropConvertContext;
    }
}

