/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.ApiPropConvertContext;
import kd.bos.form.operate.webapi.ApiPropConvertSeq;
import kd.bos.form.operate.webapi.IApiPropConverter;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.PermRes;
import kd.bos.permission.model.perm.req.field.FieldControlRules2RuleReq;
import kd.bos.service.ServiceFactory;

class ApiPropConverter
implements IApiPropConverter {
    private ApiPropConvertContext context;
    private IDataEntityProperty prop;
    protected RowMapper rowMapper;

    ApiPropConverter() {
    }

    public ApiPropConvertContext getContext() {
        return this.context;
    }

    public void setContext(ApiPropConvertContext context) {
        this.context = context;
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
    }

    @Override
    public IDataEntityProperty getProp() {
        return this.prop;
    }

    public void setProp(IDataEntityProperty prop) {
        this.prop = prop;
    }

    public IFieldHandle getFieldHandle() {
        return (IFieldHandle)this.getProp();
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.SimpleProp.getValue();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        this.rowMapper = rowMapper;
    }

    @Override
    public void endParseValue() {
    }

    @Override
    public void setValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        Object fldValue = value;
        if (StringUtils.isBlank((Object)value)) {
            if (!this.getContext().isModify()) {
                return;
            }
            fldValue = null;
        }
        if (!this.hasFieldWriteControl()) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u65e0\u5b57\u6bb5\u5bfc\u5165\u6743\u9650", (String)"ApiPropConverter_0", (String)"bos-form-metadata", (Object[])new Object[0]), this.getProp().getDisplayName().toString()));
            return;
        }
        this.execSetValue(rowMapper, activeRow, fldValue);
    }

    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        try {
            this.getContext().getModel().setFieldValueForWebApi(this.getProp(), activeRow, value, this.getContext().isCheckImportable());
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), e.getMessage());
            }
            throw e;
        }
    }

    private FieldControlRule getFieldControl(Long orgId) {
        FieldControlRules fieldControlRules = this.context.getFieldControlRules();
        if (fieldControlRules == null) {
            return null;
        }
        MainEntityType dataEntityType = this.context.getModel().getDataEntityType();
        String mainOrg = dataEntityType.getMainOrg();
        PermissionControlType permissionControlType = null == dataEntityType ? null : dataEntityType.getPermissionControlType();
        String dimension = null == permissionControlType ? "" : permissionControlType.getDimension();
        String dataDimensionField = null == permissionControlType ? "" : permissionControlType.getDataDimensionField();
        DynamicObject dyn = this.context.getModel().getDataEntity();
        DynamicObjectCollection doc = new DynamicObjectCollection();
        doc.add((Object)dyn);
        FieldControlRules2RuleReq req = new FieldControlRules2RuleReq(doc, fieldControlRules, mainOrg, dimension, dataDimensionField);
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        PermRes fieldControlRuleMapPermRes = permissionService.fieldControlRules2RuleMap(req);
        Map fieldControlRuleMap = (Map)fieldControlRuleMapPermRes.getData();
        return (FieldControlRule)fieldControlRuleMap.get(String.valueOf(dyn.getPkValue()));
    }

    protected boolean hasFieldWriteControl() {
        IDataEntityProperty fieldProp = this.getProp();
        Long mainOrgId = this.context.getMainOrgId();
        FieldControlRule fieldControlRule = this.getFieldControl(mainOrgId);
        if (fieldControlRule == null) {
            return true;
        }
        String fieldName = fieldProp.getName();
        return !fieldControlRule.getCanNotWriteFields().contains(fieldName) && !fieldControlRule.getCanNotReadFields().contains(fieldName);
    }
}

