/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class FlexValueCacheKey {
    private Object bdPk;
    private String bdFldKey;
    private String flexFldKey;
    private FlexEntityType flexType;
    private List<String> flexItems = new ArrayList<String>();
    private List<Object> flexItemValues = new ArrayList<Object>();

    public String getBdFldKey() {
        return this.bdFldKey;
    }

    public String getFlexFldKey() {
        return this.flexFldKey;
    }

    public List<String> getFlexItems() {
        return this.flexItems;
    }

    public FlexEntityType getflexType() {
        return this.flexType;
    }

    public List<Object> getFlexItemValues() {
        return this.flexItemValues;
    }

    public FlexValueCacheKey(String bdFldKey, String flexFldKey) {
        this.bdFldKey = bdFldKey;
        this.flexFldKey = flexFldKey;
    }

    @Deprecated
    public static FlexValueCacheKey create(BasedataProp batadataProp, FlexProp flexProp, FlexEntityType flexType, Map<String, Object> flexValue) {
        return FlexValueCacheKey.create(batadataProp, flexProp, flexType, flexValue, 0);
    }

    public static FlexValueCacheKey create(BasedataProp batadataProp, FlexProp flexProp, FlexEntityType flexType, Map<String, Object> flexValue, Object basePk) {
        FlexValueCacheKey cacheKey = new FlexValueCacheKey(batadataProp.getName(), flexProp.getName()).setBasePk(basePk);
        cacheKey.flexType = flexType;
        boolean isNumberType = flexValue.containsKey("flextype") && flexValue.get("flextype").equals("number");
        for (IDataEntityProperty flexItemProp : flexType.getProperties()) {
            Optional<FlexProperty> optional;
            if (flexItemProp.getName().split("__").length == 1) continue;
            String flexItemCaption = ((DynamicProperty)flexItemProp).getDisplayName() == null ? flexItemProp.getName() : ((DynamicProperty)flexItemProp).getDisplayName().toString();
            String flexItemNumber = null;
            if (isNumberType && (optional = flexType.getFlexProperties().stream().filter(x -> x.getFlexField().equals(flexItemProp.getName().split("__")[1])).findFirst()).isPresent()) {
                flexItemNumber = optional.get().getNumber();
            }
            if (!flexValue.containsKey(flexItemCaption) && (!isNumberType || !flexValue.containsKey(flexItemNumber))) continue;
            if (flexItemProp instanceof TextProp) {
                cacheKey.getFlexItems().add(flexItemProp.getName());
                cacheKey.getFlexItemValues().add(flexValue.get(flexItemCaption));
                continue;
            }
            if (!(flexItemProp instanceof BasedataProp)) continue;
            BasedataProp flexItemBaseProp = (BasedataProp)flexItemProp;
            BasedataEntityType flexItemRefBDType = (BasedataEntityType)flexItemBaseProp.getComplexType();
            String searchKey = null;
            String searchValue = null;
            Object itemValue = isNumberType ? flexValue.get(flexItemNumber) : flexValue.get(flexItemCaption);
            if (itemValue instanceof Map) {
                Map flexItem = (Map)itemValue;
                if (!flexItem.isEmpty()) {
                    if (flexItem.containsKey("id")) {
                        searchKey = "id";
                        searchValue = flexItem.get("id");
                    } else if (flexItem.containsKey("importprop")) {
                        searchKey = (String)flexItem.get("importprop");
                        searchValue = flexItem.get(searchKey);
                    } else {
                        Map.Entry entry = flexItem.entrySet().iterator().next();
                        searchKey = (String)entry.getKey();
                        searchValue = entry.getValue();
                    }
                }
            } else if (itemValue != null) {
                String[] fv = (String[])itemValue;
                searchKey = fv[0];
                searchValue = fv[1];
            }
            if (!StringUtils.isNotBlank(searchKey)) continue;
            if ("name".equals(searchKey)) {
                searchKey = flexItemRefBDType.getNameProperty();
            } else if ("number".equals(searchKey)) {
                searchKey = flexItemRefBDType.getNumberProperty();
            }
            cacheKey.getFlexItems().add(flexItemProp.getName());
            if (searchValue == null) {
                String msg = String.format(ResManager.loadKDString((String)"%s\u7684\u641c\u7d22\u5b57\u6bb5\u503c\u4e3a\u7a7a", (String)"FlexValueCacheKey_0", (String)"bos-form-metadata", (Object[])new Object[0]), searchKey);
                throw new KDException(BosErrorCode.nullError, new Object[]{msg});
            }
            cacheKey.getFlexItemValues().add(searchKey + ":=" + searchValue);
        }
        return cacheKey;
    }

    private FlexValueCacheKey setBasePk(Object basePk) {
        this.bdPk = basePk;
        return this;
    }

    public String toString() {
        return String.format("{bdPk=%s, bdfieldKey=%s, flexfieldkey=%s, flexitems=[%s], itemvalues=[%s]}", this.bdPk, this.bdFldKey, this.flexFldKey, StringUtils.join((Object[])this.flexItems.toArray(), (String)","), StringUtils.join((Object[])this.flexItemValues.toArray(), (String)","));
    }

    public int hashCode() {
        int hashcode = 1;
        hashcode = 31 * hashcode + (this.bdPk == null ? 0 : this.bdPk.hashCode());
        hashcode = 31 * hashcode + (this.bdFldKey == null ? 0 : this.bdFldKey.hashCode());
        hashcode = 31 * hashcode + (this.flexFldKey == null ? 0 : this.flexFldKey.hashCode());
        hashcode = 31 * hashcode + (this.flexItems == null ? 0 : this.flexItems.hashCode());
        hashcode = 31 * hashcode + (this.flexItemValues == null ? 0 : this.flexItemValues.hashCode());
        return hashcode;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof FlexValueCacheKey)) {
            return false;
        }
        FlexValueCacheKey other = (FlexValueCacheKey)obj;
        if (!this.equalsValue(this.bdPk, other.getBdPk())) {
            return false;
        }
        if (!this.equalsValue(this.bdFldKey, other.getBdFldKey())) {
            return false;
        }
        if (!this.equalsValue(this.flexFldKey, other.getFlexFldKey())) {
            return false;
        }
        if (this.flexItems.size() != other.getFlexItems().size()) {
            return false;
        }
        for (i = 0; i < this.flexItems.size(); ++i) {
            if (this.equalsValue(this.flexItems.get(i), other.getFlexItems().get(i))) continue;
            return false;
        }
        if (this.flexItemValues.size() != other.getFlexItemValues().size()) {
            return false;
        }
        for (i = 0; i < this.flexItemValues.size(); ++i) {
            if (this.equalsValue(this.flexItemValues.get(i), other.getFlexItemValues().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        return v1.equals(v2);
    }

    public Object getBdPk() {
        return this.bdPk;
    }
}

