/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.manager.EventMethod;
import kd.bos.entity.plugin.manager.IConditionEvent;
import kd.bos.entity.plugin.manager.IPluginManager;
import kd.bos.entity.plugin.manager.PluginManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoCheckDataPermissionArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.CustomPrintDataObjectArgs;
import kd.bos.form.events.FlexBeforeClosedEvent;
import kd.bos.form.events.InitOperateOptionEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.TimerElapsedArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.IMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormViewPluginProxy {
    private static Log logger = LogFactory.getLog(FormViewPluginProxy.class);
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<IFormPlugin> plugIns = new ArrayList<IFormPlugin>();
    private IPluginManager pluginManager;

    public final List<IFormPlugin> getPlugIns() {
        return this.plugIns;
    }

    public IFormPlugin getPlugin(String className) {
        for (IFormPlugin plugin : this.plugIns) {
            if (!className.equals(plugin.getPluginName())) continue;
            return plugin;
        }
        return null;
    }

    public final void registerPlugins(List<IFormPlugin> list) {
        this.plugIns.addAll(list);
    }

    public final void registerPlugin(IFormPlugin plugin) {
        this.getPlugIns().add(plugin);
    }

    public final void removePlugIn(IFormPlugin plugIn) {
        this.getPlugIns().remove(plugIn);
    }

    public boolean isNotOverride(Class<?> pluginClass, String methodName, Class<?> ... parameterTypes) {
        return this.isNotOverride(pluginClass, methodName, (IConditionEvent)null, parameterTypes);
    }

    public boolean isNotOverride(Class<?> pluginClass, String methodName, IConditionEvent conditionEvent, Class<?> ... parameterTypes) {
        EventMethod eventMethod = EventMethod.create((String)methodName, (IConditionEvent)conditionEvent, (Class[])parameterTypes);
        if (Objects.isNull(this.pluginManager)) {
            return true;
        }
        boolean isNotOverride = this.pluginManager.isNotOverride(eventMethod, pluginClass);
        if (!isNotOverride) {
            logger.warn(pluginClass.getName() + "." + methodName + "\u7981\u7528\u6267\u884c" + (conditionEvent != null ? "\uff0c\u53c2\u6570\u6761\u4ef6\uff1a" + conditionEvent.getVarMap() : ""));
        }
        return isNotOverride;
    }

    public void initPluginManager(IFormView formView) {
        try {
            FormConfig config = formView.getFormShowParameter().getFormConfig();
            ArrayList pluginEntities = config != null ? config.getPlugins() : new ArrayList();
            ArrayList plugins = new ArrayList();
            this.pluginManager = this.createPluginManager();
            for (int i = 0; i < this.plugIns.size(); ++i) {
                IFormPlugin pl = this.plugIns.get(i);
                pluginEntities.forEach(pluginEntity -> {
                    if (StringUtils.equals((CharSequence)pluginEntity.getClassName(), (CharSequence)pl.getClass().getName())) {
                        plugins.add(pluginEntity);
                    }
                });
            }
            this.pluginManager.init(plugins);
            IDataModel dataModel = (IDataModel)formView.getService(IDataModel.class);
            dataModel.addPluginManager(this.pluginManager);
        }
        catch (Throwable e) {
            logger.error("\u63d2\u4ef6\u7ba1\u7406\u5668\u521d\u59cb\u5316\u5f02\u5e38", e);
        }
    }

    protected IPluginManager createPluginManager() {
        return new PluginManager();
    }

    protected void invokeMethod(Consumer<IFormPlugin> consumer, String methodName, Class<?> ... parameterTypes) {
        this.invokeMethod(consumer, methodName, (IConditionEvent)null, parameterTypes);
    }

    protected void invokeMethod(Consumer<IFormPlugin> consumer, String methodName, IConditionEvent conditionEvent, Class<?> ... parameterTypes) {
        for (IFormPlugin pl : this.plugIns) {
            if (!this.isNotOverride(pl.getClass(), methodName, conditionEvent, parameterTypes)) continue;
            consumer.accept(pl);
        }
    }

    public void setView(IFormView formView) {
        ArrayList<IFormPlugin> plugins = new ArrayList<IFormPlugin>(this.getPlugIns());
        for (IFormPlugin plugin : plugins) {
            if (!this.isNotOverride(plugin.getClass(), "setView", IFormView.class)) continue;
            plugin.setView(formView);
        }
    }

    public void fireInitialize() {
        for (int i = 0; i < this.plugIns.size(); ++i) {
            IFormPlugin pl = this.plugIns.get(i);
            if (!this.isNotOverride(pl.getClass(), "initialize", new Class[0])) continue;
            this.plugIns.get(i).initialize();
        }
    }

    public void fireOnGetControl(OnGetControlArgs e) {
        this.invokeMethod((IFormPlugin plugin) -> plugin.onGetControl(e), "onGetControl", e, OnGetControlArgs.class);
    }

    public void fireMessageBoxClosed(MessageBoxClosedEvent e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".messageBoxClosed"));){
                plugin.messageBoxClosed(e);
            }
        }, "messageBoxClosed", e, MessageBoxClosedEvent.class);
    }

    public void fireBeforeClosed(BeforeClosedEvent e) {
        this.invokeMethod((IFormPlugin plugin) -> plugin.beforeClosed(e), "beforeClosed", BeforeClosedEvent.class);
    }

    public void fireClosedCallBack(CloseCallBack closeCallBack, Object ret) {
        ClosedCallBackEvent closedCallBackEvent = new ClosedCallBackEvent(this, closeCallBack.getActionId(), ret);
        this.invokeMethod((IFormPlugin plugin) -> {
            if (plugin.getPluginName().equals(closeCallBack.getClassName())) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".closedCallBack"));){
                    plugin.closedCallBack(closedCallBackEvent);
                }
            }
        }, "closedCallBack", closedCallBackEvent, ClosedCallBackEvent.class);
    }

    public void fireConfirmedCallBack(MessageBoxClosedEvent messageBoxClosedEvent, String className) {
        this.invokeMethod((IFormPlugin plugin) -> {
            if (className.equals(plugin.getPluginName()) || StringUtils.isBlank((CharSequence)className)) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".confirmCallBack"));){
                    plugin.confirmCallBack(messageBoxClosedEvent);
                }
            }
        }, "confirmCallBack", messageBoxClosedEvent, MessageBoxClosedEvent.class);
    }

    public void fireAfterBindData(EventObject e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".afterBindData"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                plugin.afterBindData(e);
            }
        }, "afterBindData", EventObject.class);
    }

    public void fireBeforeBindData(EventObject e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeBindData"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                plugin.beforeBindData(e);
            }
        }, "beforeBindData", EventObject.class);
    }

    public void fireInitOperateOption(InitOperateOptionEventArgs args) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".initOperateOption"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                plugin.initOperateOption(args);
            }
        }, "initOperateOption", args, InitOperateOptionEventArgs.class);
    }

    public void fireBeforeDoOperation(BeforeDoOperationEventArgs args) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeDoOperation"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                plugin.beforeDoOperation(args);
            }
        }, "beforeDoOperation", args, BeforeDoOperationEventArgs.class);
    }

    public void fireAfterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".afterDoOperation"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                plugin.afterDoOperation(afterDoOperationEventArgs);
            }
        }, "afterDoOperation", afterDoOperationEventArgs, AfterDoOperationEventArgs.class);
    }

    public void fireContextMenuClick(String source, String itemKey) {
        ContextMenuClickEvent e = new ContextMenuClickEvent(this, source, itemKey);
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".contextMenuClick"));){
                plugin.contextMenuClick(e);
            }
        }, "contextMenuClick", ContextMenuClickEvent.class);
    }

    public void fireCustomEvent(CustomEventArgs e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".customEvent"));){
                plugin.customEvent(e);
            }
        }, "customEvent", e, CustomEventArgs.class);
    }

    public void fireDestory() {
        this.invokeMethod(IFormPlugin::destory, "destory", new Class[0]);
    }

    public void fireTimerElapsed(TimerElapsedArgs e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".TimerElapsed"));){
                plugin.TimerElapsed(e);
            }
        }, "TimerElapsed", TimerElapsedArgs.class);
    }

    public void firePageRelease(EventObject e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".pageRelease"));){
                plugin.pageRelease(e);
            }
        }, "pageRelease", EventObject.class);
    }

    public void fireCustomPrintDataObject(CustomPrintDataObjectArgs e) {
        this.invokeMethod((IFormPlugin plugin) -> plugin.customPrintDataObject(e), "customPrintDataObject", CustomPrintDataObjectArgs.class);
    }

    public void fireRegisterListener(EventObject e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".registerListener"));){
                plugin.registerListener(e);
            }
        }, "registerListener", EventObject.class);
    }

    public void fireBeforeFieldPostBack(BeforeFieldPostBackEvent e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeFieldPostBack"));){
                plugin.beforeFieldPostBack(e);
            }
        }, "beforeFieldPostBack", e, BeforeFieldPostBackEvent.class);
    }

    public void fireFlexBeforeClosed(FlexBeforeClosedEvent e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".flexBeforeClosed"));){
                plugin.flexBeforeClosed(e);
            }
        }, "flexBeforeClosed", FlexBeforeClosedEvent.class);
    }

    public void fireClientCallBack(ClientCallBackEvent e) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".clientCallBack"));){
                plugin.clientCallBack(e);
            }
        }, "clientCallBack", ClientCallBackEvent.class);
    }

    public void fireBeforeCheckDataPermission(BeforeDoCheckDataPermissionArgs args) {
        this.invokeMethod((IFormPlugin plugin) -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeCheckDataPermission"));){
                plugin.beforeCheckDataPermission(args);
            }
        }, "beforeCheckDataPermission", BeforeDoCheckDataPermissionArgs.class);
    }

    public void fireBeforeExecClientCmd(Map<String, Object> args, String operateKey) {
        this.invokeMethod((IFormPlugin plugin) -> {
            if (plugin instanceof IMobFormPlugin) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeExecClientCmd"));){
                    ((IMobFormPlugin)((Object)plugin)).beforeExecClientCmd(args, operateKey);
                }
            }
        }, "beforeExecClientCmd", Map.class, String.class);
    }
}

