/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.transfer;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.transfer.TransferNode;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TransferTreeNode
extends TransferNode {
    private String parentid;
    private List<TransferTreeNode> children;
    private Boolean isOpened;

    public TransferTreeNode() {
    }

    public TransferTreeNode(String parentId, String id, String text) {
        this.setParentid(parentId);
        this.setId(id);
        this.setText(text);
    }

    public TransferTreeNode(String id, String text, Boolean disabled) {
        this.setId(id);
        this.setText(text);
        this.setDisabled(disabled);
    }

    public String getParentid() {
        return this.parentid;
    }

    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    public List<TransferTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TransferTreeNode> children) {
        this.children = children;
        if (StringUtils.isNotBlank((CharSequence)this.getId())) {
            for (TransferTreeNode childrenNode : children) {
                childrenNode.setParentid(this.getId());
            }
        }
    }

    public Boolean getIsOpened() {
        return this.isOpened;
    }

    public void setIsOpened(Boolean isOpened) {
        this.isOpened = isOpened;
    }

    public TransferTreeNode addChild(TransferTreeNode node) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<TransferTreeNode>());
        }
        if (node != null) {
            this.getChildren().add(node);
        }
        return this;
    }

    public String toString() {
        return String.format("%s, %s", this.getId(), this.getText());
    }
}

