/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.widget;

import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class Widget
extends Control {
    private String widgetId;
    private String cardId;
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static Log logger = LogFactory.getLog(Widget.class);

    @SimplePropertyAttribute
    public String getWidgetId() {
        return this.widgetId;
    }

    @Override
    public void bindData(BindingContext object) {
        if (this.widgetId != null) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(this.getWidgetId());
            parameter.setPageId(this.getItemPageId());
            parameter.setCustomParam("_noloadsetting_", true);
            parameter.setCustomParam("cardid", this.cardId);
            parameter.setCustomParam("widgetid", this.key);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(this.getKey());
            try {
                this.getView().showForm(parameter);
            }
            catch (Exception e) {
                String errorInfo = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8868\u5355\u663e\u793a\u5f02\u5e38, \u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7", (String)"Widget_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.widgetId);
                this.getView().showErrorNotification(errorInfo);
                logger.error(errorInfo, (Throwable)e);
            }
        }
    }

    public String getItemPageId() {
        return this.getView().getPageId() + "." + this.getKey();
    }

    public void reLoadContent() {
        IFormView view = this.getView().getView(this.getItemPageId());
        if (view != null) {
            view.updateView();
            this.getView().sendFormAction(view);
        }
    }

    public void setWidgetId(String widgetId) {
        this.widgetId = widgetId;
    }

    @SimplePropertyAttribute
    public String getCardId() {
        return this.cardId;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }
}

