/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.widget.Widget;
import kd.bos.form.widget.events.WidgetChangedEvent;
import kd.bos.form.widget.events.WidgetContainerDesignerListener;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class WidgetContainer
extends Container {
    protected List<ItemClickListener> barItemClickListeners = new ArrayList<ItemClickListener>();
    private List<WidgetContainerDesignerListener> widgetContainerDesignerListener = new ArrayList<WidgetContainerDesignerListener>();
    private Map<String, Object> content;
    private static final String SPAN_TYPE_PLUGIN = "plugin";

    @Override
    public void addItemClickListener(ItemClickListener listener) {
        this.barItemClickListeners.add(listener);
    }

    public void addWidgetContainerDesignerListener(WidgetContainerDesignerListener listener) {
        this.widgetContainerDesignerListener.add(listener);
    }

    @Override
    public void postBack(Object value) {
        this.content = (Map)value;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public void itemClick(String id, String operationKey) {
        BeforeItemClickEvent evt = new BeforeItemClickEvent(this, id, operationKey);
        this.fireBeforeItemClick(evt);
        if (!evt.isCancel()) {
            ItemClickEvent evt1 = new ItemClickEvent(this, id, operationKey);
            this.fireItemClick(evt1);
        }
    }

    public void widgetChanged(Map<String, Object> widget) {
        for (WidgetContainerDesignerListener l : this.widgetContainerDesignerListener) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".widgetChanged"));
            Throwable throwable = null;
            try {
                l.widgetChanged(new WidgetChangedEvent(this, widget));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireBeforeItemClick(BeforeItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeItemClick"));
            Throwable throwable = null;
            try {
                l.beforeItemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireItemClick(ItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".itemClick"));
            Throwable throwable = null;
            try {
                l.itemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void setDesignMode(boolean value, Map<String, Object> designerMeta) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setDesignMode", designerMeta);
    }

    public void addGroup(Map<String, Object> designerGroup, Map<String, Object> runtimeGroup) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "addGroup", designerGroup, runtimeGroup);
    }

    public void addWidget(String groupId, Map<String, Object> designerWidget, Map<String, Object> runtimeWidget) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "addWidget", groupId, designerWidget, runtimeWidget);
    }

    public void setWidgetProperty(String id, Map<String, Object> designerProperty, Map<String, Object> runtimeProperty) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setWidgetProperty", id, designerProperty, runtimeProperty);
    }

    public void renameGroup(Map<String, Object> designerGroup, Map<String, Object> runtimeGroup) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "renameGroup", designerGroup, runtimeGroup);
    }

    public void refresh() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "refresh", new Object[0]);
    }

    public List<Widget> getWidgets() {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        this.addWidgetToList(widgets, this.getItems());
        return widgets;
    }

    private void addWidgetToList(List<Widget> widgets, List<Control> items) {
        for (Control c : items) {
            if (c instanceof Container) {
                this.addWidgetToList(widgets, ((Container)c).getItems());
                continue;
            }
            if (!(c instanceof Widget)) continue;
            widgets.add((Widget)c);
        }
    }

    public void reloadWidgetContent() {
        List<Widget> widgets = this.getWidgets();
        for (Widget w : widgets) {
            w.setView(this.getView());
            w.reLoadContent();
        }
    }
}

