/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.ctsy.api.ICtsyApiDispatchService;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICtsyShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.SelectedRowCondition;
import kd.bos.list.SelectedRowValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.url.UrlService;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.codec.digest.DigestUtils;

@KSObject
@SdkPublic
public class CtsyListShowParameter
extends ListShowParameter
implements ICtsyShowParameter {
    private static final long serialVersionUID = 1L;
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String FORM_ID = "bos_listf7";
    public static final String CTSYLIST_TYPE = "CtsyList";
    public static final String FORMVIEW_TYPE_LIST = "list";
    public static final String FORMVIEW_TYPE_FORM = "form";
    public static final String FORMVIEW_TYPE_BILL = "bill";
    public static final String OPENAPI_URL = "v2/ctsy/ctform/handle";
    public static final String WEBAPI_URL = "/v2/ctsy/ctform/handle";
    public static final String CTSY_CACHE_TYPE = "ctsy_showparameter";
    private static DistributeSessionlessCache ctsyCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ctsy_showparameter", new DistributeCacheHAPolicy(true, true));
    public static final String CTSY_NONCE = "ctsynonce";
    private static Log log = LogFactory.getLog(CtsyListShowParameter.class);
    private String tenantCode;
    private String accountId;

    @Override
    @SimplePropertyAttribute
    public String getTenantCode() {
        return this.tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @Override
    @SimplePropertyAttribute
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getCloseCallBackActionIdSuffix() {
        return "$" + this.tenantCode + "$" + this.accountId + "$" + CTSYLIST_TYPE;
    }

    @Override
    protected String getViewClass() {
        return "kd.bos.mvc.list.CtsyListView";
    }

    public CtsyListShowParameter() {
    }

    public CtsyListShowParameter(String tenantCode, String accountId, String billFormId) {
        this.tenantCode = tenantCode;
        this.accountId = accountId;
        this.billFormId = billFormId;
        this.setFormId(FORM_ID);
        this.setMultiSelect(true);
        this.setLookUp(true);
        this.setF7Style(0);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        openStyle.setInlineStyleCss(css);
        this.setOpenStyle(openStyle);
        this.setShowTitle(false);
        this.setShowApproved(true);
    }

    @Override
    public Map<String, Object> createClientConfig(Map<String, Object> setting) {
        if (StringUtils.isBlank((CharSequence)this.tenantCode) || StringUtils.isBlank((CharSequence)this.accountId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79df\u6237\u7f16\u7801\u548c\u6570\u636e\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CtsyListShowParameter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
        if (CtsyListShowParameter.isSelfTenant(this)) {
            return super.createClientConfig(setting);
        }
        Map<String, Object> config = CtsyListShowParameter.getRemoteConfig(this, FORMVIEW_TYPE_LIST);
        return this.callBuilderFunc(() -> this.formShowParameterBuilder.createClientConfig(config), () -> config);
    }

    @Override
    public boolean isRuntimeMetaChanged() {
        return false;
    }

    public static String getCtsynonce(String tenantCode, String accountId, boolean callWebApi) {
        String ctsynonceVal = tenantCode + "," + accountId + "," + callWebApi;
        String ctsynonce = DigestUtils.sha256Hex((String)ctsynonceVal);
        String ctsynonceCacheKey = CtsyListShowParameter.getCtsynonceCacheKey(ctsynonce);
        if (StringUtils.isBlank((CharSequence)((CharSequence)ctsyCache.get(ctsynonceCacheKey)))) {
            ctsyCache.put(ctsynonceCacheKey, (Object)ctsynonceVal, 1800, TimeUnit.SECONDS);
        }
        return ctsynonce;
    }

    public static String getCtsynonceVal(String ctsynonce) {
        return (String)ctsyCache.get(CtsyListShowParameter.getCtsynonceCacheKey(ctsynonce));
    }

    public static void saveCacheCtsyPageId(String pageId, String remotePageId) {
        String cacheKey = CtsyListShowParameter.getCtsyPageIdCacheKey(pageId);
        if (StringUtils.isBlank((CharSequence)((CharSequence)ctsyCache.get(cacheKey)))) {
            ctsyCache.put(cacheKey, (Object)remotePageId, 1800, TimeUnit.SECONDS);
        }
    }

    public static String getCtsyRemotePageId(String pageId) {
        return (String)ctsyCache.get(CtsyListShowParameter.getCtsyPageIdCacheKey(pageId));
    }

    private static String getCtsynonceCacheKey(String ctsynonce) {
        return CacheKeyUtil.getAcctId() + "." + ctsynonce;
    }

    private static String getCtsyPageIdCacheKey(String pageId) {
        return CacheKeyUtil.getAcctId() + "." + pageId;
    }

    public static boolean isSelfTenant(ICtsyShowParameter showParameter) {
        String currTenantCode = RequestContext.get().getTenantCode();
        String currAccountId = RequestContext.get().getAccountId();
        return currTenantCode.equals(showParameter.getTenantCode()) && currAccountId.equals(showParameter.getAccountId());
    }

    public static Map<String, Object> getRemoteConfig(FormShowParameter showParameter, String type) {
        boolean callWebApi;
        if (!(showParameter instanceof ICtsyShowParameter)) {
            return null;
        }
        ICtsyShowParameter ctsyShowParameter = (ICtsyShowParameter)((Object)showParameter);
        String tenantCode = ctsyShowParameter.getTenantCode();
        String accountId = ctsyShowParameter.getAccountId();
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(1);
        params.put("params", CtsyListShowParameter.getRequestParams(showParameter, type));
        String configstr = "";
        ICtsyApiDispatchService ctsyApiDispatchService = (ICtsyApiDispatchService)ServiceFactory.getService(ICtsyApiDispatchService.class);
        boolean bl = callWebApi = showParameter.getCustomParams().get("callWebApi") == null ? true : (Boolean)showParameter.getCustomParams().get("callWebApi");
        if (callWebApi) {
            Object resultMap = ctsyApiDispatchService.invokeWebApi(tenantCode, accountId, WEBAPI_URL, params);
            if (resultMap instanceof Map && ((Map)resultMap).get("data") instanceof String) {
                configstr = (String)((Map)resultMap).get("data");
                log.info("openApiResultData:" + configstr);
            }
        } else {
            String result = ctsyApiDispatchService.post(tenantCode, accountId, OPENAPI_URL, SerializationUtils.toJsonString(params));
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            if (openApiResult.get("data") instanceof String) {
                configstr = (String)openApiResult.get("data");
                log.info("openApiResultData:" + configstr);
            }
        }
        if (StringUtils.isEmpty((CharSequence)configstr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8fdc\u7aef\u79df\u6237\u7684config\u4fe1\u606f\u3002", (String)"CtsyListShowParameter_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
        if (configstr.contains("\"a\":\"showErrMsg\"") || configstr.contains("\"a\":\"ShowNotificationMsg\"")) {
            throw new KDBizException(configstr);
        }
        Map config = (Map)SerializationUtils.fromJsonString((String)configstr, Map.class);
        FormConfig configTemp = (FormConfig)SerializationUtils.fromJsonString((String)configstr, FormConfig.class);
        if (configTemp != null) {
            if (FORMVIEW_TYPE_LIST.equals(type)) {
                configTemp.setEntityTypeId(showParameter.getFormId());
            }
            showParameter.setFormConfig(configTemp);
        }
        config.put("parentPageId", showParameter.getParentPageId());
        config.put("openStyle", showParameter.getOpenStyle().getConfig());
        if (showParameter.getOpenStyle() != null && showParameter.getOpenStyle().getInlineStyleCss() != null) {
            config.put("width", showParameter.getOpenStyle().getInlineStyleCss().getWidth());
            config.put("height", showParameter.getOpenStyle().getInlineStyleCss().getHeight());
        }
        config.put("isShowTitle", showParameter.isShowTitle());
        config.put(CTSY_NONCE, CtsyListShowParameter.getCtsynonce(tenantCode, accountId, callWebApi));
        config.remove("sysParam");
        config.remove("attPreview");
        config.remove("langSetting");
        config.remove("showTrayMenu");
        config.remove("caConfig");
        config.remove("accountId");
        config.remove("accountName");
        config.remove("tenantId");
        config.remove("tenantName");
        config.remove("userOpenId");
        config.remove("userId");
        config.remove("cloudUserId");
        config.remove("cookieName");
        config.remove("instanceNumber");
        String remotePageId = config.get("pageId") == null ? "" : (String)config.get("pageId");
        String remoteAppId = config.get("appId") == null ? "" : (String)config.get("appId");
        showParameter.setCustomParam("remotePageId", remotePageId);
        config.put("pageId", showParameter.getPageId());
        String imageFullUrl = UrlService.getCheckAuthImageUrl((String)"");
        String fileServerUrl = UrlService.getCheckAuthImageUrl((String)"");
        config.put("imageurl", imageFullUrl);
        config.put("fileserver", fileServerUrl);
        if (config.get("appId") != null) {
            showParameter.setCustomParam("ServiceAppId", remoteAppId);
        }
        return config;
    }

    private static Map<String, Object> getRequestParams(FormShowParameter showParameter, String type) {
        BillShowParameter billShowParameter;
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        if (FORMVIEW_TYPE_LIST.equals(type)) {
            ListFilterParameter listFilterParameter;
            SelectedRowCondition selectedRowCondition;
            ListShowParameter lShowParameter = (ListShowParameter)showParameter;
            params = new HashMap(16);
            params.put("type", type);
            params.put("billFormId", lShowParameter.getBillFormId());
            params.put("lookUp", lShowParameter.isLookUp());
            params.put("multiSelect", lShowParameter.isMultiSelect());
            params.put("showFrequent", lShowParameter.isShowFrequent());
            ListSelectedRowCollection listSelectedRowCollection = lShowParameter.getListSelectedRowCollection();
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                ArrayList<Object> selectedRows = new ArrayList<Object>(listSelectedRowCollection.size());
                for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                    if (listSelectedRow.getPrimaryKeyValue() == null) continue;
                    selectedRows.add(listSelectedRow.getPrimaryKeyValue());
                }
                params.put("selectedRows", selectedRows);
            }
            if ((selectedRowCondition = lShowParameter.getSelectedRowCondition()) != null) {
                ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>(2);
                dataEntityTypes.add(OrmUtils.getDataEntityType(SelectedRowCondition.class));
                dataEntityTypes.add(OrmUtils.getDataEntityType(SelectedRowValue.class));
                DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
                params.put("selectedRowCondition", dcJsonSerializer.serializeToString((Object)selectedRowCondition, null));
            }
            if ((listFilterParameter = lShowParameter.getListFilterParameter()) != null) {
                ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>(1);
                dataEntityTypes.add(OrmUtils.getDataEntityType(ListFilterParameter.class));
                DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
                params.put("listFilterParameter", dcJsonSerializer.serializeToString((Object)listFilterParameter, null));
            }
        } else if (FORMVIEW_TYPE_BILL.equals(type) && (billShowParameter = (BillShowParameter)showParameter).getPkId() != null) {
            params.put("pkId", billShowParameter.getPkId());
        }
        if (showParameter.getStatus() != null) {
            params.put("Status", (Object)showParameter.getStatus());
        }
        params.put("method", "getConfig");
        params.put("formId", showParameter.getFormId());
        params.put("customParams", showParameter.getCustomParams());
        params.put("rootPageId", showParameter.getRootPageId());
        params.put("parentPageId", showParameter.getPageId());
        CloseCallBack closeCallBack = showParameter.getCloseCallBack();
        if (closeCallBack != null) {
            ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>(1);
            dataEntityTypes.add(OrmUtils.getDataEntityType(CloseCallBack.class));
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
            params.put("closeCallBack", dcJsonSerializer.serializeToString((Object)closeCallBack, null));
        }
        return params;
    }
}

