/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.notification.NotificationFormInfo;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class NotificationClientCache {
    private static final String CACHE_DISTRIBUTESESSION = "bos_form_core";
    private static final String CACHE_TYPE = "notification";
    private static final String NOTIFICATION_INFO = "notificationinfo";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_form_core", new DistributeCacheHAPolicy(true, true));

    private static String buildCacheType(String userId) {
        return String.format("%s.%s.%s", CACHE_TYPE, RequestContext.get().getAccountId(), userId == null ? RequestContext.get().getUserId() : userId);
    }

    private static String buildCacheKey(String notificationId, String key) {
        return String.format("%s.%s", notificationId, key);
    }

    public static void clearCache() {
        String type = NotificationClientCache.buildCacheType(null);
        cache.remove(type);
    }

    public static void removeNotification(String userId, String notificationId) {
        String type = NotificationClientCache.buildCacheType(userId);
        String[] keys = new String[]{NotificationClientCache.buildCacheKey(notificationId, NOTIFICATION_INFO)};
        cache.remove(type, keys);
    }

    public static void putNotificationFormInfo(String userId, String notificationId, NotificationFormInfo notificationFormInfo) {
        String type = NotificationClientCache.buildCacheType(userId);
        String key = NotificationClientCache.buildCacheKey(notificationId, NOTIFICATION_INFO);
        String jobInfoStr = SerializationUtils.toJsonString((Object)notificationFormInfo);
        cache.put(type, key, jobInfoStr, 8, TimeUnit.HOURS);
    }

    public static NotificationFormInfo getNotificationFormInfo(String notificationId) {
        String key;
        String type = NotificationClientCache.buildCacheType(null);
        String notificationInfoStr = (String)cache.get(type, key = NotificationClientCache.buildCacheKey(notificationId, NOTIFICATION_INFO));
        if (StringUtils.isBlank((CharSequence)notificationInfoStr)) {
            return null;
        }
        return (NotificationFormInfo)SerializationUtils.fromJsonString((String)notificationInfoStr, NotificationFormInfo.class);
    }

    public static List<NotificationFormInfo> getUserAllNotificationFormInfos(String userId) {
        ArrayList<NotificationFormInfo> notificationFormInfoList = new ArrayList<NotificationFormInfo>(16);
        String type = NotificationClientCache.buildCacheType(userId);
        Map all = cache.getAll(type);
        for (Map.Entry next : all.entrySet()) {
            String notificationInfoStr = (String)next.getValue();
            if (!StringUtils.isNotBlank((CharSequence)notificationInfoStr)) continue;
            notificationFormInfoList.add((NotificationFormInfo)SerializationUtils.fromJsonString((String)notificationInfoStr, NotificationFormInfo.class));
        }
        return notificationFormInfoList;
    }
}

