/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.parameter;

import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
@KSObject
public class ParameterShowParameter
extends FormShowParameter {
    @Override
    protected String getViewClass() {
        return "kd.bos.mvc.parameter.ParameterView";
    }

    public static ParameterShowParameter createUserOptionShowParameter(String entityId, String extend) {
        ParameterShowParameter showParameter = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String option = entityType.getUserOption();
        if (StringUtils.isNotBlank((CharSequence)option)) {
            showParameter = new ParameterShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId(option);
            showParameter.setCustomParam("bindformid", entityId);
            showParameter.setCustomParam("extend", extend);
        }
        return showParameter;
    }

    public static ParameterShowParameter createBillParameterShowParameter(String entityId) {
        ParameterShowParameter showParameter = null;
        BillEntityType entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        String billParameter = entityType.getBillParameter();
        if (StringUtils.isNotBlank((CharSequence)billParameter)) {
            showParameter = new ParameterShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId(billParameter);
            showParameter.setCustomParam("bindformid", entityId);
        }
        return showParameter;
    }

    public static ParameterShowParameter createSystemParameterShowParameter(SystemParameterType parameterType, String subsystem, long orgId, long acctbookId) {
        ParameterShowParameter showParameter = null;
        subsystem = parameterType.toString() + "/" + subsystem;
        StringBuilder sql = new StringBuilder(" SELECT FFORMID FROM T_BAS_SYSPARACONSOLE WHERE FSUBSYSTEM = ? AND FENABLED = '1' AND FFORMID IS NOT NULL ");
        DynamicObjectCollection collection = SingleORM.query(null, (String)sql.toString(), (Object[])new SqlParameter[]{new SqlParameter(12, (Object)subsystem)});
        if (collection != null && !collection.isEmpty()) {
            showParameter = new ParameterShowParameter();
            showParameter.setFormId(((DynamicObject)collection.get(0)).getString(0));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("orgid", orgId);
            showParameter.setCustomParam("acctbookid", acctbookId);
            showParameter.setCustomParam("subsystem", subsystem);
        }
        return showParameter;
    }

    public static ParameterShowParameter createSystemParameterShowParameter(String subsystem, long orgId, long acctbookId) {
        ParameterShowParameter showParameter = null;
        StringBuilder sql = new StringBuilder(" SELECT FFORMID FROM T_BAS_SYSPARACONSOLE WHERE FSUBSYSTEM = ? AND FENABLED = '1' AND FFORMID IS NOT NULL ");
        DynamicObjectCollection collection = SingleORM.query(null, (String)sql.toString(), (Object[])new SqlParameter[]{new SqlParameter(12, (Object)subsystem)});
        if (collection != null && !collection.isEmpty()) {
            showParameter = new ParameterShowParameter();
            showParameter.setFormId(((DynamicObject)collection.get(0)).getString(0));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("orgid", orgId);
            showParameter.setCustomParam("acctbookid", acctbookId);
            showParameter.setCustomParam("subsystem", subsystem);
        }
        return showParameter;
    }

    public static enum SystemParameterType {
        PUBLIC("public"),
        CLOUD("cloud"),
        APPLICATION("application");

        private final String type;

        private SystemParameterType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

