/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;

public class FieldApInfoUtils {
    private static final Log log = LogFactory.getLog(FieldApInfoUtils.class);

    public static Map<String, BillTypeControlInfo> getFullControlInfos(String formId) {
        return FieldApInfoUtils.getFullControlInfos(formId, formId);
    }

    private static Map<String, BillTypeControlInfo> sort(Map<String, BillTypeControlInfo> infos, EntityMetadata entityMeta) {
        LinkedHashMap<String, BillTypeControlInfo> ret = new LinkedHashMap<String, BillTypeControlInfo>();
        List<Entity<?, ?>> items = entityMeta.getEntitys();
        for (Entity<?, ?> entity : items) {
            for (EntityItem<?> item : entity.getItems()) {
                infos.forEach((k, v) -> {
                    if (v.getFieldId().equals(item.getId())) {
                        ret.put((String)k, (BillTypeControlInfo)v);
                    }
                });
            }
        }
        if (!ret.isEmpty()) {
            infos = ret;
        }
        return infos;
    }

    public static Map<String, BillTypeControlInfo> getFullControlInfos(String formId, String originalFormId) {
        return FieldApInfoUtils.getFullControlInfos(formId, originalFormId, false);
    }

    public static Map<String, BillTypeControlInfo> getFullControlInfos(String formId, String originalFormId, boolean isMob) {
        try (EntityTraceSpan span = EntityTracer.create((String)"BillType", (String)"getFullControlInfos");){
            span.addTag("formId", formId);
            span.addTag("originalFormId", originalFormId);
            span.addTag("isRuntime", "false");
            HashMap<String, BillTypeControlInfo> result = new HashMap(10);
            result = FieldApInfoUtils.getFullDesignControlInfos(formId, originalFormId, isMob);
            span.addLocaleTag("result", result);
            HashMap<String, BillTypeControlInfo> hashMap = result;
            return hashMap;
        }
    }

    private static Map<String, BillTypeControlInfo> getFullDesignControlInfos(String formId, String originalFormId, boolean isMob) {
        BillFormAp rootAp;
        LinkedHashMap<String, BillTypeControlInfo> infos = new LinkedHashMap<String, BillTypeControlInfo>(50);
        String id = MetadataDao.getIdByNumber(formId, MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta(id, MetaCategory.Form);
        if (isMob && (rootAp = (BillFormAp)formMeta.getRootAp()).getMobMeta() != null) {
            formMeta = rootAp.getMobMeta();
            formMeta.createIndex();
        }
        FieldApInfoUtils.toBillTypeCtlInfo(infos, formMeta);
        id = MetadataDao.getIdByNumber(originalFormId, MetaCategory.Entity);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta(id, MetaCategory.Entity);
        FieldApInfoUtils.toBillTypeCtlInfo(infos, entityMeta);
        return FieldApInfoUtils.sort(infos, entityMeta);
    }

    public static Map<String, String> getFieldVisibleInfo(FormMetadata formmeta) {
        LinkedHashMap<String, String> visMap = new LinkedHashMap<String, String>();
        Consumer<FieldAp> consumer = fieldAp -> visMap.put(fieldAp.getKey(), fieldAp.getVisible());
        FieldApInfoUtils.travelFieldApInfo(formmeta, consumer);
        return visMap;
    }

    public static Map<String, String> getFieldLockInfo(FormMetadata formmeta) {
        LinkedHashMap<String, String> lockMap = new LinkedHashMap<String, String>();
        Consumer<FieldAp> consumer = fieldAp -> lockMap.put(fieldAp.getKey(), fieldAp.getLock());
        FieldApInfoUtils.travelFieldApInfo(formmeta, consumer);
        return lockMap;
    }

    public static Map<String, String> getFieldName(EntityMetadata entityMeta) {
        LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>();
        Consumer<Field<?>> consumer = field -> nameMap.put(field.getKey(), field.getName().getLocaleValue());
        FieldApInfoUtils.travelFieldEntityInfo(entityMeta, consumer);
        return nameMap;
    }

    public static void travelFieldEntityInfo(EntityMetadata entityMeta, Consumer<Field<?>> consumer) {
        LinkedHashSet<MainEntity> entityContainer = new LinkedHashSet<MainEntity>();
        entityContainer.add(entityMeta.getRootEntity());
        Predicate<EntityItem> predicate = item -> item instanceof EntryEntity;
        boolean isChanged = false;
        do {
            isChanged = false;
            LinkedHashSet<MainEntity> tmpContainer = new LinkedHashSet<MainEntity>();
            tmpContainer.addAll(entityContainer);
            int n = entityContainer.size();
            entityContainer.forEach(entity -> entity.getItems().stream().filter(predicate).forEach(item -> tmpContainer.add((MainEntity)((Object)((EntryEntity)item)))));
            if (n == tmpContainer.size()) continue;
            isChanged = true;
            entityContainer.addAll(tmpContainer);
        } while (isChanged);
        for (Entity entity2 : entityContainer) {
            for (EntityItem<?> item2 : entity2.getItems()) {
                if (!(item2 instanceof Field)) continue;
                Field field = (Field)item2;
                consumer.accept(field);
            }
        }
    }

    public static void travelFieldApInfo(FormMetadata formmeta, Consumer<FieldAp> consumer) {
        for (ControlAp<?> ctlAp : formmeta.getItems()) {
            if (!(ctlAp instanceof FieldAp) || ctlAp.isHidden() || StringUtils.isBlank((CharSequence)ctlAp.getVisible())) continue;
            consumer.accept((FieldAp)ctlAp);
        }
    }

    private static void toBillTypeCtlInfo(Map<String, BillTypeControlInfo> infos, FormMetadata formmeta) {
        Consumer<FieldAp> consumer = fieldAp -> {
            BillTypeControlInfo ctlInfo = (BillTypeControlInfo)infos.get(fieldAp.getKey());
            if (ctlInfo == null) {
                ctlInfo = new BillTypeControlInfo();
                ctlInfo.setFieldKey(fieldAp.getKey());
                ctlInfo.setFieldId(fieldAp.getFieldId());
            }
            ctlInfo.setVisible(fieldAp.getVisibleValue());
            ctlInfo.setLockInStr(fieldAp.getLock());
            String fieldPrefix = FieldApInfoUtils.findFieldPrefix(formmeta, fieldAp);
            String name = fieldPrefix + fieldAp.getName().getLocaleValue();
            ctlInfo.setFieldName(name);
            infos.put(fieldAp.getKey(), ctlInfo);
        };
        FieldApInfoUtils.travelFieldApInfo(formmeta, consumer);
    }

    private static String findFieldPrefix(FormMetadata formmeta, ControlAp fieldAp) {
        String fieldPrefix = "";
        ControlAp<?> pControl = formmeta.getItem(fieldAp.getParentId());
        if (pControl != null) {
            if (pControl instanceof EntryAp) {
                fieldPrefix = pControl.getName().getLocaleValue() + ".";
            } else if (pControl instanceof CardEntryRowAp) {
                pControl = null == (pControl = formmeta.getItem(pControl.getParentId())) ? null : formmeta.getItem(pControl.getParentId());
                fieldPrefix = null == pControl ? "" : pControl.getName().getLocaleValue() + ".";
            } else {
                fieldPrefix = FieldApInfoUtils.findFieldPrefix(formmeta, pControl);
            }
        }
        return fieldPrefix;
    }

    private static void toBillTypeCtlInfo(Map<String, BillTypeControlInfo> infos, EntityMetadata entityMeta) {
        LinkedHashSet<MainEntity> entityContainer = new LinkedHashSet<MainEntity>();
        entityContainer.add(entityMeta.getRootEntity());
        Predicate<EntityItem> predicate = item -> item instanceof EntryEntity;
        boolean isChanged = false;
        HashMap<String, Field> mapAllField = new HashMap<String, Field>();
        do {
            isChanged = false;
            LinkedHashSet<MainEntity> tmpContainer = new LinkedHashSet<MainEntity>();
            tmpContainer.addAll(entityContainer);
            int n = entityContainer.size();
            entityContainer.forEach(entity -> entity.getItems().stream().filter(predicate).forEach(item -> tmpContainer.add((MainEntity)((Object)((EntryEntity)item)))));
            if (n == tmpContainer.size()) continue;
            isChanged = true;
            entityContainer.addAll(tmpContainer);
        } while (isChanged);
        for (Entity entity2 : entityContainer) {
            for (EntityItem<?> item2 : entity2.getItems()) {
                if (!(item2 instanceof Field)) continue;
                mapAllField.put(item2.getId(), (Field)item2);
            }
        }
        for (Map.Entry entry : infos.entrySet()) {
            String fieldId = ((BillTypeControlInfo)entry.getValue()).getFieldId();
            Field field = (Field)mapAllField.get(fieldId);
            BillTypeControlInfo ctlInfo = (BillTypeControlInfo)entry.getValue();
            if (field == null) continue;
            ctlInfo.setEntityFieldKey(field.getKey());
            ctlInfo.setDefValueType(field.getDefValueType());
            ctlInfo.setMustInputType(field.getMustInputType());
            ctlInfo.setMustInput(field.isMustInput());
            ctlInfo.setFieldType(field.getClass().getSimpleName());
        }
    }
}

