/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.billtype;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.FieldApInfoUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

public class BillTypeFieldUtils {
    private static final Log log = LogFactory.getLog(BillTypeFieldUtils.class);

    private static Map<String, BillTypeControlInfo> getRuntimeControlInfos(FormRoot root, MainEntityType dt) {
        LinkedHashMap<String, BillTypeControlInfo> infos = new LinkedHashMap<String, BillTypeControlInfo>(50);
        BillTypeFieldUtils.toBillTypeRuntimeCtlInfo(infos, root, dt);
        return infos;
    }

    private static boolean canReadRuntime(MainEntityType dt) {
        try {
            if (dt == null) {
                return false;
            }
            String runtimeVer = dt.getVersion();
            if (StringUtils.isBlank((CharSequence)runtimeVer)) {
                return false;
            }
            if (runtimeVer.length() < 23) {
                return false;
            }
            String dateStr = runtimeVer.substring(runtimeVer.length() - 23);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            SimpleDateFormat patchSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date buildData = sdf.parse(dateStr);
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            List datas = service.getIndustryVersion("cosmic_bos");
            int patchVersion = 5;
            int littleVer = 0;
            Date upgradeDate = new Date();
            for (Map info : datas) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)"kingdee", (CharSequence)String.valueOf(info.get("isv")))) continue;
                upgradeDate = patchSdf.parse(String.valueOf(info.get("upgradeTime")));
                String[] verPaths = String.valueOf(info.get("version")).split("\\.");
                patchVersion = Integer.parseInt(verPaths[0]);
                littleVer = Integer.parseInt(verPaths[2]);
                break;
            }
            return (patchVersion > 6 || patchVersion == 6 && littleVer >= 2) && buildData.after(upgradeDate);
        }
        catch (Exception e) {
            log.error("parse dt version error", (Throwable)e);
            return false;
        }
    }

    public static Map<String, BillTypeControlInfo> getRuntimeFullControlInfos(String formId, String originalFormId) {
        return BillTypeFieldUtils.getRuntimeFullControlInfos(formId, originalFormId, false);
    }

    public static Map<String, BillTypeControlInfo> getRuntimeFullControlInfos(String formId, String originalFormId, boolean isMobLayout) {
        try (EntityTraceSpan span = EntityTracer.create((String)"BillType", (String)"getRuntimeFullControlInfos");){
            span.addTag("formId", formId);
            span.addTag("originalFormId", originalFormId);
            span.addLocaleTag("isMobLayout", (Object)isMobLayout);
            span.addTag("isRuntime", "true");
            HashMap<String, BillTypeControlInfo> result = new HashMap(10);
            try {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)originalFormId);
                if (BillTypeFieldUtils.canReadRuntime(dt)) {
                    span.addTag("useRuntimeDT", "true");
                    FormRoot root = FormMetadataCache.getRootControl((String)formId);
                    result = BillTypeFieldUtils.getRuntimeControlInfos(root, dt);
                } else {
                    span.addTag("useRuntimeDT", "false");
                    result = FieldApInfoUtils.getFullControlInfos(formId, originalFormId, isMobLayout);
                }
            }
            catch (Exception e) {
                log.error(String.format("GetRuntimeFullControlInfos error , formId is %s", formId), (Throwable)e);
                result = FieldApInfoUtils.getFullControlInfos(formId, originalFormId, isMobLayout);
            }
            span.addLocaleTag("result", result);
            HashMap<String, BillTypeControlInfo> hashMap = result;
            return hashMap;
        }
    }

    public static Map<String, BillTypeControlInfo> getRuntimeFullControlInfos(String formId) {
        return BillTypeFieldUtils.getRuntimeFullControlInfos(formId, false);
    }

    public static Map<String, BillTypeControlInfo> getRuntimeFullControlInfos(String formId, boolean isMobLayout) {
        return BillTypeFieldUtils.getRuntimeFullControlInfos(formId, formId, isMobLayout);
    }

    private static void toBillTypeRuntimeCtlInfo(Map<String, BillTypeControlInfo> infos, FormRoot formRoot, MainEntityType mainEntityType) {
        try (EntityTraceSpan span = EntityTracer.create((String)"BillType", (String)"toBillTypeRuntimeCtlInfo");){
            HashMap unrecognizedField = new HashMap(10);
            HashMap<String, Control> ctlMaps = new HashMap<String, Control>(formRoot.getItems().size());
            HashMap<String, FieldEdit> fieldEditMaps = new HashMap<String, FieldEdit>(10);
            BillTypeFieldUtils.createCtlIndex(ctlMaps, fieldEditMaps, (Control)formRoot);
            Map allFields = mainEntityType.getAllFields();
            Consumer<FieldEdit> consumer = fieldEdit -> {
                BillTypeControlInfo ctlInfo = (BillTypeControlInfo)infos.get(fieldEdit.getKey());
                if (ctlInfo == null) {
                    ctlInfo = new BillTypeControlInfo();
                    ctlInfo.setFieldKey(fieldEdit.getKey());
                    ctlInfo.setFieldId(fieldEdit.getId());
                }
                ctlInfo.setVisible(fieldEdit.getVisibleIntegerVal().intValue());
                ctlInfo.setLock(fieldEdit.getLockIntegerVal().intValue());
                ctlInfo.setFieldName(fieldEdit.getDisplayName().getLocaleValue());
                String fieldKey = fieldEdit.getFieldKey();
                IDataEntityProperty prop = (IDataEntityProperty)allFields.get(fieldKey);
                if (prop instanceof IFieldHandle) {
                    boolean mustInput = ctlInfo.isMustInput();
                    if (prop instanceof FieldProp) {
                        mustInput = ((FieldProp)prop).isMustInput();
                    } else if (prop instanceof MulBasedataProp) {
                        mustInput = ((MulBasedataProp)prop).isMustInput();
                    } else if (prop instanceof BasedataProp) {
                        mustInput = ((BasedataProp)prop).isMustInput();
                    } else if (prop instanceof RefBillProp) {
                        mustInput = ((RefBillProp)prop).isMustInput();
                    } else {
                        unrecognizedField.put(prop.getName(), prop.getClass().getName());
                    }
                    ctlInfo.setEntityFieldKey(fieldKey);
                    ctlInfo.setMustInput(mustInput);
                }
                infos.put(fieldEdit.getKey(), ctlInfo);
            };
            for (Map.Entry it : fieldEditMaps.entrySet()) {
                consumer.accept((FieldEdit)it.getValue());
            }
            if (!unrecognizedField.isEmpty()) {
                span.addTag("unrecognizedField", SerializationUtils.toJsonString(unrecognizedField));
            }
        }
    }

    private static void createCtlIndex(Map<String, Control> ctlMaps, Map<String, FieldEdit> fieldEditMaps, Control current) {
        if (current == null) {
            return;
        }
        ctlMaps.put(current.getKey(), current);
        if (current instanceof FieldEdit && !current.isDesignHidden() && current.getVisibleIntegerVal() != 0) {
            fieldEditMaps.put(current.getKey(), (FieldEdit)current);
        } else if (current instanceof Container) {
            for (Control item : ((Container)current).getItems()) {
                BillTypeFieldUtils.createCtlIndex(ctlMaps, fieldEditMaps, item);
            }
            for (Control item : ((Container)current).getHiddenItems()) {
                BillTypeFieldUtils.createCtlIndex(ctlMaps, fieldEditMaps, item);
            }
        }
    }
}

