/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.EntityMetadata;

public class CreateBDBitMapTable {
    private static final Log LOGGER = LogFactory.getLog(CreateBDBitMapTable.class);
    private static final String CREATE_BIT_MAP_TABLE_SQL = " IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s')   create table %s (  FORGID\t\tbigint          not null,  FDATA      \tblob          not null,  constraint PK_%s primary key (FORGID) ) ";
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";
    private static final String FIELD_IS_EXISTED_SQL = "select top 1 FSOURCEDATAID,FBITINDEX,FSOURCEBITINDEX from %s ";
    private static final String CREATE_INDEX_SQL = "create index %s on %s (FCreateOrgID ASC)";
    private static final String ADD_SOURCE_ID_SQL = " ALTER TABLE %s ADD (FSOURCEDATAID BIGINT DEFAULT 0 NOT NULL );";
    private static final String ADD_BIT_INDEX_SQL = " ALTER TABLE %s ADD (FBITINDEX INT DEFAULT 0 NOT NULL );";
    private static final String ADD_SOURCE_BIT_INDEX_SQL = " ALTER TABLE %s ADD (FSOURCEBITINDEX INT DEFAULT 0 NOT NULL );";
    private static final String ADD_SOURCE_ORG_ID_SQL = " ALTER TABLE %s ADD (FSRCCREATEORGID BIGINT DEFAULT 0 NOT NULL );";
    private EntityMetadata baseDataEntity;

    public void create(EntityMetadata baseDataEntity) {
        if (this.ignoreCreateTable(baseDataEntity)) {
            return;
        }
        this.baseDataEntity = baseDataEntity;
        String baseDataTableName = this.getBaseDataTableName();
        if (baseDataTableName == null || baseDataTableName.trim().length() == 0) {
            return;
        }
        try {
            this.checkAndField();
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u91cd\u5efa\u5143\u6570\u636e\u65f6\uff0c\u7ed9\u53d7\u63a7\u8d44\u6599\u4e3b\u8868\u3010%s\u3011\u6dfb\u52a0FBITINDEX\uff0cFSOURCEBITINDEX\u548cFSOURCEDATAID\u5b57\u6bb5\u5931\u8d25...", baseDataTableName), (Throwable)e);
        }
        try {
            this.createTable();
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u91cd\u5efa\u5143\u6570\u636e\u65f6\uff0c\u521b\u5efa\u4f4d\u56fe\u8868\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u4e3b\u8868\u4e3a\u3010%s\u3011...", baseDataTableName), (Throwable)e);
        }
    }

    private void checkAndField() {
        String tableName = this.getBaseDataTableName();
        DBRoute route = DBRoute.of((String)this.baseDataEntity.getDBRouteKey());
        if (!this.fieldIsExisted(FIELD_IS_EXISTED_SQL)) {
            DB.execute((DBRoute)route, (String)String.format(ADD_SOURCE_ID_SQL, tableName), null);
            DB.execute((DBRoute)route, (String)String.format(ADD_BIT_INDEX_SQL, tableName), null);
            DB.execute((DBRoute)route, (String)String.format(ADD_SOURCE_BIT_INDEX_SQL, tableName), null);
        }
        String srcOrgIdField = "FSRCCREATEORGID";
        if (!this.fieldIsExisted("select top 1 FSRCCREATEORGID from %s ")) {
            DB.execute((DBRoute)route, (String)String.format(ADD_SOURCE_ORG_ID_SQL, tableName), null);
        }
    }

    private boolean tableIsExisted() {
        String sql = String.format(TABLE_IS_EXISTED_SQL, this.buildTableName());
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
    }

    private boolean fieldIsExisted(String sqlFormate) {
        String sql = String.format(sqlFormate, this.getBaseDataTableName());
        boolean isFieldIsExisted = true;
        try {
            DB.query((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws Exception {
                    return rs.next();
                }
            });
        }
        catch (Exception e) {
            isFieldIsExisted = false;
        }
        return isFieldIsExisted;
    }

    private void createTable() {
        String createSQL = String.format(CREATE_BIT_MAP_TABLE_SQL, this.buildTableName(), this.buildTableName(), this.buildTableName());
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)createSQL, null);
    }

    private String getBaseDataTableName() {
        String tableName = null;
        BaseEntity rootEntity = (BaseEntity)this.baseDataEntity.getRootEntity();
        tableName = rootEntity.getTableName();
        return tableName.toUpperCase();
    }

    private String buildTableName() {
        String tableName = null;
        BaseEntity rootEntity = (BaseEntity)this.baseDataEntity.getRootEntity();
        tableName = rootEntity.getTableName() + "_BIT";
        return tableName.toUpperCase();
    }

    private String buildIndexName() {
        return "IDX_" + this.buildTableName() + "_I";
    }

    private void createIndex() {
        String sql = String.format(CREATE_INDEX_SQL, this.buildIndexName(), this.buildTableName());
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null);
    }

    private boolean ignoreCreateTable(EntityMetadata meta) {
        if (meta == null) {
            return true;
        }
        String inheritPath = meta.getInheritPath();
        if (inheritPath == null || inheritPath.trim().length() == 0) {
            return true;
        }
        return inheritPath.indexOf("6138b0d200000eac") < 0 && inheritPath.indexOf("ab7efc31000015ac") < 0 && inheritPath.indexOf("b0d31cea000006ac") < 0;
    }
}

