/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.report.IReportEntity;
import kd.bos.service.CoreLicenseService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EntityMetadataUtil {
    private static final String ITEMS = "Items";
    private static final String BILL_FIELDS = "billFields";
    private static final String THREE_STR_PLACEHOLDER = "%s.%s.%s";
    private static final String TWO_STR_PLACEHOLDER = "%s.%s";
    private static final String BOS_METADATA = "bos-metadata";
    private static final String BILL_LIST = "billList";
    private static final String CREATE_TYPE = "CreateType";
    private static final String ENTITY_METADATA_UTIL = "EntityMetadataUtil_14";
    private Map<String, Boolean> invisibleFields = new HashMap<String, Boolean>();
    private boolean expandBasedata = true;
    IDataModel model;
    List<Map<String, Object>> formContext;
    String entryKey;
    String parentKey;
    String fieldIdKey;
    String fieldNameKey;
    String checkBoxKey;
    EntityMetadata entityMetadata;

    public EntityMetadataUtil(IDataModel model, List<Map<String, Object>> formContext, String entryKey, String parentKey, String fieldIdKey, String fieldNameKey, String checkBoxKey) {
        this.model = model;
        this.formContext = formContext;
        this.entryKey = entryKey;
        this.parentKey = parentKey;
        this.fieldIdKey = fieldIdKey;
        this.fieldNameKey = fieldNameKey;
        this.checkBoxKey = checkBoxKey;
    }

    public EntityMetadataUtil() {
        this.invisibleFields.put(EntryEntity.class.getSimpleName(), true);
        this.invisibleFields.put(MuliLangTextField.class.getSimpleName(), true);
    }

    public void setExpandBasedata(boolean expandOption) {
        this.expandBasedata = expandOption;
    }

    public static Map<String, Object> getFieldlist(List<Map<String, Object>> items) {
        return EntityMetadataUtil.getFieldlist(items, true);
    }

    public static Map<String, Object> getFieldlist(List<Map<String, Object>> items, boolean isNeedSeq) {
        EntityMetadata meta = EntityMetadataUtil.getEntityMetadata(items);
        return EntityMetadataUtil.getlistFieldTree(meta, 3, isNeedSeq, true);
    }

    public static Map<String, Object> getListFields(String entityId) {
        return EntityMetadataUtil.getListFields(entityId, true);
    }

    public static Map<String, Object> getListFields(String entityId, boolean isNeedSeq) {
        EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta(entityId, MetaCategory.Entity);
        return EntityMetadataUtil.getlistFieldTree(meta, 3, isNeedSeq, true);
    }

    public static EntityMetadata getEntityMetadata(List<Map<String, Object>> formContext) {
        HashMap<String, Object> formMeta = new HashMap<String, Object>();
        formContext.get(0).remove("ReportFilterMeta");
        formMeta.put(ITEMS, formContext);
        formMeta.put("_Type_", "EntityMetadata");
        String type = formContext.get(0).get("_Type_").toString();
        String modelType = EntityMetadataUtil.getModelTypeByEntity(type);
        MetadataSerializer template = new MetadataSerializer(modelType);
        return (EntityMetadata)template.deserializeFromMap(formMeta, null);
    }

    public static String getModelTypeByEntity(String type) {
        String modelType = "DynamicFormModel";
        if ("BillEntity".equalsIgnoreCase(type)) {
            modelType = "BillFormModel";
        } else if ("MainEntity".equalsIgnoreCase(type)) {
            modelType = "DynamicFormModel";
        } else if ("BaseEntity".equalsIgnoreCase(type)) {
            modelType = "BaseFormModel";
        } else if ("KMEntity".equalsIgnoreCase(type)) {
            modelType = "KMModel";
        } else if ("ParameterEntity".equalsIgnoreCase(type)) {
            modelType = "ParameterFormModel";
        } else if ("ReportEntity".equalsIgnoreCase(type)) {
            modelType = "ReportFormModel";
        } else if ("BalanceEntity".equalsIgnoreCase(type)) {
            modelType = "BalanceModel";
        } else if ("QueryEntity".equalsIgnoreCase(type)) {
            modelType = "QueryListModel";
        } else if ("ReportQueryEntity".equalsIgnoreCase(type)) {
            modelType = "ReportQueryListModel";
        } else if ("LogBillEntity".equals(type)) {
            modelType = "LogBillFormModel";
        } else if ("KMEntity".equals(type)) {
            modelType = "KMModel";
        }
        return modelType;
    }

    public static String getModelTypeByForm(String formType) {
        String modelType = "DynamicFormModel";
        if ("MobileBillFormAp".equalsIgnoreCase(formType)) {
            modelType = "MobileBillFormModel";
        } else if ("BasedataFormAp".equalsIgnoreCase(formType)) {
            modelType = "BaseFormModel";
        } else if ("BillFormAp".equalsIgnoreCase(formType)) {
            modelType = "BillFormModel";
        } else if ("MobileListFormAp".equalsIgnoreCase(formType)) {
            modelType = "MobileListModel";
        } else if ("FormAp".equalsIgnoreCase(formType)) {
            modelType = "DynamicFormModel";
        } else if ("MobileFormAp".equalsIgnoreCase(formType)) {
            modelType = "MobileFormModel";
        } else if ("ReportFormAp".equalsIgnoreCase(formType)) {
            modelType = "ReportFormModel";
        } else if ("LogBillFormAp".equalsIgnoreCase(formType)) {
            modelType = "LogBillFormModel";
        } else if ("KMFormAp".equals(formType)) {
            modelType = "KMModel";
        } else if ("CardAp".equalsIgnoreCase(formType)) {
            modelType = "CardModel";
        } else if ("QueryListFormAp".equals(formType)) {
            modelType = "QueryListModel";
        }
        return modelType;
    }

    public static Map<String, Object> getBillFieldTree(List<Map<String, Object>> items) {
        EntityMetadata meta = EntityMetadataUtil.getEntityMetadata(items);
        MainEntity entity = meta.getRootEntity();
        return entity.createFieldsTree(BILL_FIELDS, true);
    }

    public static Map<String, Object> getBillFieldTreeByKey(List<Map<String, Object>> items) {
        EntityMetadata meta = EntityMetadataUtil.getEntityMetadata(items);
        MainEntity entity = meta.getRootEntity();
        return entity.createFieldsTreeByKey(BILL_FIELDS, true);
    }

    public static Map<String, Object> getBillFieldTreeByNumber(String number) {
        String formId = MetadataDao.getIdByNumber(number, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta(formId, MetaCategory.Entity);
        MainEntity entity = entityMetadata.getRootEntity();
        return entity.createFieldsTreeByKey(BILL_FIELDS, true);
    }

    public static EntityItem<?> getEntityItem(Map<String, Object> item) {
        return EntityMetadataUtil.getEntityItem("DynamicFormModel", item);
    }

    public static EntityItem<?> getEntityItem(String modelType, Map<String, Object> item) {
        modelType = modelType == null ? "DynamicFormModel" : modelType;
        MetadataSerializer template = new MetadataSerializer(modelType);
        return (EntityItem)template.deserializeFromMap(item, null);
    }

    private void baseDataItemWalker(EntityItem<?> element, BaseDataItemWalker baseDataItemWalker, String srcFieldName, String srcFieldCaption) {
        if (((BasedataField)element).getBaseEntityId() != null && !((BasedataField)element).getBaseEntityId().isEmpty()) {
            String baseId = ((BasedataField)element).getBaseEntityId();
            String number = MetadataDao.getEntityNumberById(baseId);
            if (number == null) {
                return;
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)number);
            if (((BasedataField)element).getRefProps() != null) {
                List<RefProp> refProps = ((BasedataField)element).getRefProps();
                if (refProps.isEmpty()) {
                    RefProp nameRefProp = new RefProp();
                    nameRefProp.setName(((BasedataEntityType)dt).getNameProperty());
                    RefProp numberRefProp = new RefProp();
                    numberRefProp.setName(((BasedataEntityType)dt).getNumberProperty());
                    refProps.add(nameRefProp);
                    refProps.add(numberRefProp);
                }
                ArrayList<String> containRefPropsList = new ArrayList<String>(10);
                for (RefProp ref : refProps) {
                    String name = ref.getName();
                    if (StringUtils.isBlank((CharSequence)name) || containRefPropsList.contains(name)) continue;
                    containRefPropsList.add(name);
                    IDataEntityProperty prop = dt.findProperty(name.split("\\.")[0]);
                    if (prop instanceof BasedataProp) {
                        String refBaseName = ((BasedataProp)prop).getDisplayName().getLocaleValue();
                        DynamicObjectType refDt = ((BasedataProp)prop).getDynamicComplexPropertyType();
                        for (IDataEntityProperty refProp : refDt.getProperties()) {
                            if (name.split("\\.").length > 1 && !name.split("\\.")[1].equalsIgnoreCase(refProp.getName()) || refProp instanceof ICollectionProperty || refProp instanceof MuliLangTextProp) continue;
                            String srcFieldName1 = StringUtils.isNotBlank((CharSequence)srcFieldName) ? String.format(THREE_STR_PLACEHOLDER, srcFieldName, element.getKey(), prop.getName()) : String.format(TWO_STR_PLACEHOLDER, element.getKey(), prop.getName());
                            String srcFieldCaption1 = StringUtils.isNotBlank((CharSequence)srcFieldCaption) ? String.format(THREE_STR_PLACEHOLDER, srcFieldName, element.getName(), refBaseName) : String.format(TWO_STR_PLACEHOLDER, element.getName(), refBaseName);
                            BaseDataItemWalkerArgs baseDataItemWalkerArgs = new BaseDataItemWalkerArgs(refProp, element, prop, srcFieldName1, srcFieldCaption1);
                            baseDataItemWalker.callBack(baseDataItemWalkerArgs);
                        }
                        continue;
                    }
                    String srcFieldName1 = StringUtils.isNotBlank((CharSequence)srcFieldName) ? String.format(TWO_STR_PLACEHOLDER, srcFieldCaption, element.getKey()) : element.getKey();
                    String srcFieldCaption1 = StringUtils.isNotBlank((CharSequence)srcFieldCaption) ? String.format(TWO_STR_PLACEHOLDER, srcFieldCaption, element.getName().getLocaleValue()) : element.getName().getLocaleValue();
                    BaseDataItemWalkerArgs baseDataItemWalkerArgs = new BaseDataItemWalkerArgs(prop, element, null, srcFieldName1, srcFieldCaption1);
                    baseDataItemWalker.callBack(baseDataItemWalkerArgs);
                }
            }
        }
    }

    private void entityMetaDataWalker(List<EntityItem<?>> dataEntityItems, EntityMetadataWalker entityMetadataWalker, BaseDataItemWalker baseDataItemWalker, EntityItem<?> srcDataEntityItem, String srcFieldName, String srcFieldCaption) {
        for (EntityItem<?> element : dataEntityItems) {
            if (element instanceof MuliLangTextField) continue;
            if (element instanceof EntryEntity) {
                String srcFieldCaption1 = StringUtils.isNotBlank((CharSequence)srcFieldCaption) ? String.format(TWO_STR_PLACEHOLDER, srcFieldCaption, element.getName().getLocaleValue()) : element.getName().getLocaleValue();
                this.entityMetaDataWalker(((EntryEntity)element).getItems(), entityMetadataWalker, baseDataItemWalker, element, srcFieldName, srcFieldCaption1);
                continue;
            }
            if (element instanceof BasedataField) {
                this.baseDataItemWalker(element, baseDataItemWalker, srcFieldName, srcFieldCaption);
                continue;
            }
            EntityMetadataWalkerArgs entityMetadataWalkerArgs = new EntityMetadataWalkerArgs(element, srcDataEntityItem, srcFieldName, srcFieldCaption);
            entityMetadataWalker.callBack(entityMetadataWalkerArgs);
        }
    }

    private String getType(EntityItem<?> field) {
        if (field instanceof ComboField) {
            return "enum";
        }
        if (field instanceof DateField) {
            return "date";
        }
        if (field instanceof TextField) {
            return "text";
        }
        return "text";
    }

    private Map<String, Object> createFilterColumn(String fieldName, String fieldCaption, String type, String entryEntity, List<ValueMapItem> comboItems, List<CompareType> compareTypes, String compareGroupId, int fieldType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldName", fieldName);
        map.put("fieldCaption", fieldCaption);
        map.put("type", type);
        if (entryEntity != null) {
            map.put("entryEntity", entryEntity);
        }
        if (comboItems != null) {
            map.put("items", comboItems);
        }
        map.put("compareTypes", compareTypes);
        map.put("compareGroupID", compareGroupId);
        map.put("fieldType", fieldType);
        return map;
    }

    public List<FilterField> getFilterFields(EntityMetadata entityMetadata) {
        List<Map<String, Object>> filterColumns = this.getFilterColumns(entityMetadata);
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>(10);
        for (Map<String, Object> filterColumn : filterColumns) {
            FilterField filterField = new FilterField(new LocaleString(filterColumn.get("fieldCaption").toString()), filterColumn.get("fieldName").toString(), filterColumn.get("entryEntity").toString(), filterColumn.get("compareGroupID").toString(), Integer.parseInt(filterColumn.get("fieldType").toString()));
            filterFields.add(filterField);
        }
        return filterFields;
    }

    public List<Map<String, Object>> getFilterColumns(EntityMetadata entityMetadata) {
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>();
        EntityMetadataWalker entityMetadataWalker = entityTypeWalkerArgs -> {
            EntityItem<?> dataEntityProperty = entityTypeWalkerArgs.getDataEntityItem();
            if (dataEntityProperty instanceof Field) {
                Field field = (Field)dataEntityProperty;
                if (field.getName() == null) {
                    return;
                }
                String type = this.getType(dataEntityProperty);
                String entryEntity = null;
                ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>();
                String fieldName = StringUtils.isNotBlank((CharSequence)entityTypeWalkerArgs.getSrcFieldName()) ? String.format(TWO_STR_PLACEHOLDER, entityTypeWalkerArgs.getSrcFieldName(), field.getKey()) : field.getKey();
                String fieldCaption = StringUtils.isNotBlank((CharSequence)entityTypeWalkerArgs.getSrcFieldCaption()) ? String.format(TWO_STR_PLACEHOLDER, entityTypeWalkerArgs.getSrcFieldCaption(), field.getName().getLocaleValue()) : field.getName().getLocaleValue();
                entryEntity = entityTypeWalkerArgs.getSrcDataEntityItem() instanceof EntryEntity ? entityTypeWalkerArgs.getSrcDataEntityItem().getKey() : entityMetadata.getRootEntity().getKey();
                if ("enum".equals(type)) {
                    for (ComboItem comboItem : ((ComboField)field).getItems()) {
                        ValueMapItem valueMapItem = new ValueMapItem(comboItem.getImageKey(), comboItem.getValue(), comboItem.getCaption());
                        comboItems.add(valueMapItem);
                    }
                } else if ("text".equals(type) && entityTypeWalkerArgs.getSrcDataEntityItem() instanceof BasedataField) {
                    type = "basedata";
                }
                List compareTypes = FilterMetadata.get().getCompareTypes(field.getCompareGroupID() + ",9");
                filterColumns.add(this.createFilterColumn(fieldName, fieldCaption, type, entryEntity, comboItems, compareTypes, field.getCompareGroupID(), field.getFieldDBType()));
            }
        };
        BaseDataItemWalker baseDataItemWalker = entityTypeWalkerArgs -> {
            IDataEntityProperty dataEntityProperty = entityTypeWalkerArgs.getDataEntityProperty();
            if (dataEntityProperty instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)dataEntityProperty;
                String type = fieldProp.getFilterControlType();
                String entryEntity = null;
                List<ValueMapItem> comboItems = null;
                ArrayList<CompareType> compareTypes = new ArrayList<CompareType>();
                String compareGroupId = fieldProp.getCompareGroupID();
                if (fieldProp.getDisplayName() == null) {
                    return;
                }
                compareTypes.addAll(fieldProp.getCompareTypes());
                String fieldName = StringUtils.isNotBlank((CharSequence)entityTypeWalkerArgs.getSrcFieldName()) ? String.format(TWO_STR_PLACEHOLDER, entityTypeWalkerArgs.getSrcFieldName(), fieldProp.getName()) : fieldProp.getName();
                String fieldCaption = StringUtils.isNotBlank((CharSequence)entityTypeWalkerArgs.getSrcFieldCaption()) ? String.format(TWO_STR_PLACEHOLDER, entityTypeWalkerArgs.getSrcFieldCaption(), fieldProp.getDisplayName().getLocaleValue()) : fieldProp.getDisplayName().getLocaleValue();
                entryEntity = entityTypeWalkerArgs.getSrcDataEntityItem() instanceof EntryEntity ? entityTypeWalkerArgs.getSrcDataEntityItem().getKey() : entityMetadata.getRootEntity().getKey();
                if (entityTypeWalkerArgs.getSrcFieldProp() != null) {
                    BasedataProp basedataProp = (BasedataProp)entityTypeWalkerArgs.getSrcFieldProp();
                    compareTypes.addAll(basedataProp.getCompareTypes());
                } else {
                    BasedataField basedataField = (BasedataField)entityTypeWalkerArgs.getSrcDataEntityItem();
                    compareTypes.addAll(basedataField.getCompareTypes());
                }
                Map<String, Object> map = this.createFilterColumn(fieldName, fieldCaption, type, entryEntity, comboItems, compareTypes, compareGroupId, fieldProp.getDbType());
                map.put("entityId", ((BasedataField)entityTypeWalkerArgs.getSrcDataEntityItem()).getRefBaseEntityMeta().getKey());
                filterColumns.add(map);
            }
        };
        this.entityMetaDataWalker(entityMetadata.getRootEntity().getItems(), entityMetadataWalker, baseDataItemWalker, null, null, null);
        return filterColumns;
    }

    private void addSimpleProperty(String parentKeyValue, EntityItem<?> element, boolean isSelected) {
        String fieldName = element.getName().toString();
        String fieldKey = element.getKey();
        int rowKey = this.model.createNewEntryRow(this.entryKey);
        this.model.setValue(this.parentKey, (Object)parentKeyValue, rowKey);
        this.model.setValue(this.fieldIdKey, (Object)fieldKey, rowKey);
        this.model.setValue(this.fieldNameKey, (Object)fieldName, rowKey);
        this.model.setValue(this.checkBoxKey, (Object)isSelected, rowKey);
    }

    public void initFields(List<String> selectedFields, List<String> selectedFieldKeys, List<String> selectFieldsDesc, boolean isOnlyHeader) {
        boolean isSelected;
        this.entityMetadata = EntityMetadataUtil.getEntityMetadata(this.formContext);
        this.entityMetadata.createIndex();
        String rootName = this.entityMetadata.getRootEntity().getName().toString();
        for (EntityItem<?> entityItem : this.entityMetadata.getRootEntity().getItems()) {
            if (entityItem instanceof Entity) continue;
            isSelected = selectedFields.contains(entityItem.getId());
            if (isSelected) {
                selectedFieldKeys.add(entityItem.getKey());
                selectFieldsDesc.add(entityItem.getName().toString());
            }
            this.addSimpleProperty(rootName, entityItem, isSelected);
        }
        if (!isOnlyHeader) {
            for (Entity entity : this.entityMetadata.getEntitys()) {
                isSelected = selectedFields.contains(entity.getId());
                if (isSelected) {
                    selectedFieldKeys.add(entity.getKey());
                    selectFieldsDesc.add(entity.getName().toString());
                }
                this.addSimpleProperty(entity.getName().toString(), entity, isSelected);
            }
        }
    }

    public TreeNode initTreeFields(List<Map<String, Object>> formContext, boolean isOnlyHeader) {
        this.entityMetadata = EntityMetadataUtil.getEntityMetadata(formContext);
        this.entityMetadata.createIndex();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId("");
        root.setData((Object)this.entityMetadata.getRootEntity().getId());
        if (this.entityMetadata.getRootEntity().getName() == null) {
            root.setText(this.entityMetadata.getKey());
        } else {
            root.setText(this.entityMetadata.getRootEntity().getName().toString());
        }
        String headId = this.entityMetadata.getRootEntity().getId();
        TreeNode headNode = this.getHeadTreeNode(this.entityMetadata, ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityMetadataUtil_0", (String)BOS_METADATA, (Object[])new Object[0]));
        if (headNode.getChildren() != null && !headNode.getChildren().isEmpty()) {
            root.addChild(headNode);
        }
        if (!isOnlyHeader) {
            for (Entity<?, ?> element : this.entityMetadata.getEntitys()) {
                if (!(element instanceof EntryEntity) && !(element instanceof IReportEntity) || element instanceof SubEntryEntity) continue;
                TreeNode entryNode = new TreeNode();
                entryNode.setParentid(headId);
                entryNode.setId(element.getKey());
                if (element.getName() == null) {
                    entryNode.setText(String.format(ResManager.loadKDString((String)"%s(\u5355\u636e\u4f53)", (String)"EntityMetadataUtil_1", (String)BOS_METADATA, (Object[])new Object[0]), element.getKey()));
                } else {
                    entryNode.setText(String.format(ResManager.loadKDString((String)"%s(\u5355\u636e\u4f53)", (String)"EntityMetadataUtil_1", (String)BOS_METADATA, (Object[])new Object[0]), element.getName().toString()));
                }
                this.EntityToTreeNode(entryNode, element, true);
                root.addChild(entryNode);
            }
        }
        return root;
    }

    public TreeNode getHeadTreeNode(EntityMetadata entityMetadata, String title) {
        String headId = "_headNode_";
        TreeNode headNode = new TreeNode();
        headNode.setParentid(entityMetadata.getRootEntity().getId());
        headNode.setId(headId);
        headNode.setText(title);
        for (EntityItem<?> element : entityMetadata.getRootEntity().getItems()) {
            String fieldName = "";
            fieldName = element.getName() == null ? element.getKey() : element.getName().toString();
            String fieldKey = element.getKey();
            if (this.expandBasedata && element instanceof BasedataField) {
                TreeNode baseNode = this.baseDataRefProps(element, headId);
                headNode.addChild(baseNode);
                continue;
            }
            if (this.getInvisibleFields().get(element.getClass().getSimpleName()) != null && this.getInvisibleFields().get(element.getClass().getSimpleName()).booleanValue() || !(element instanceof Field)) continue;
            TreeNode node = new TreeNode();
            node.setParentid(headId);
            node.setId(fieldKey);
            node.setText(fieldName + "(" + fieldKey + ")");
            headNode.addChild(node);
        }
        return headNode;
    }

    public TreeNode getFieldList(EntityMetadata entityMetadata, String title) {
        String headId = "_headNode_";
        TreeNode headNode = new TreeNode();
        headNode.setParentid(entityMetadata.getRootEntity().getId());
        headNode.setId(headId);
        headNode.setText(title);
        this.addTreeNode(headNode, entityMetadata.getRootEntity().getItems());
        return headNode;
    }

    private void addTreeNode(TreeNode headNode, List<EntityItem<?>> items) {
        for (EntityItem<?> element : items) {
            String fieldName = "";
            fieldName = element.getName() == null ? element.getKey() : element.getName().toString();
            String fieldKey = element.getKey();
            if (element instanceof BasedataField) {
                TreeNode baseNode = this.baseDataRefProps(element, headNode.getId());
                headNode.addChild(baseNode);
                continue;
            }
            if (element instanceof EntryEntity) {
                this.addTreeNode(headNode, ((EntryEntity)element).getItems());
                continue;
            }
            if (!(element instanceof Field)) continue;
            TreeNode node = new TreeNode();
            node.setParentid(headNode.getId());
            node.setId(fieldKey);
            node.setText(fieldName + "(" + fieldKey + ")");
            headNode.addChild(node);
        }
    }

    public void EntityToTreeNode(TreeNode entityTreeNode, Entity<?, ?> element, Boolean subentry) {
        for (EntityItem<?> controlAp : element.getItems()) {
            TreeNode node;
            if (controlAp instanceof BasedataField) {
                if (this.expandBasedata) {
                    TreeNode baseNode = this.baseDataRefProps(controlAp, entityTreeNode.getId());
                    entityTreeNode.addChild(baseNode);
                    continue;
                }
                node = new TreeNode();
                node.setParentid(entityTreeNode.getId());
                node.setId(controlAp.getKey());
                node.setText(controlAp.getName().toString() + "(" + controlAp.getKey() + ")");
                entityTreeNode.addChild(node);
                continue;
            }
            if (controlAp instanceof Field) {
                node = new TreeNode();
                node.setParentid(entityTreeNode.getId());
                node.setId(controlAp.getKey());
                node.setText(controlAp.getName().toString() + "(" + controlAp.getKey() + ")");
                entityTreeNode.addChild(node);
                continue;
            }
            if (!(controlAp instanceof SubEntryEntity) || !subentry.booleanValue()) continue;
            TreeNode subNode = new TreeNode();
            subNode.setParentid(entityTreeNode.getId());
            subNode.setId(controlAp.getKey());
            if (controlAp.getName() == null) {
                subNode.setText(String.format(ResManager.loadKDString((String)"%s(\u5b50\u5355\u636e\u4f53)", (String)"EntityMetadataUtil_2", (String)BOS_METADATA, (Object[])new Object[0]), controlAp.getKey()));
            } else {
                subNode.setText(String.format(ResManager.loadKDString((String)"%s(\u5b50\u5355\u636e\u4f53)", (String)"EntityMetadataUtil_2", (String)BOS_METADATA, (Object[])new Object[0]), controlAp.getName()));
            }
            entityTreeNode.addChild(subNode);
            this.EntityToTreeNode(subNode, (Entity)controlAp, false);
        }
    }

    public TreeNode baseDataRefProps(EntityItem<?> element, String headId) {
        String fieldName = "";
        fieldName = element.getName() == null ? element.getKey() : element.getName().toString();
        String fieldKey = element.getKey();
        TreeNode bdFldNode = new TreeNode();
        bdFldNode.setParentid(headId);
        bdFldNode.setId(fieldKey);
        bdFldNode.setText(fieldName + "(" + fieldKey + ")");
        String refBaseEntityId = ((BasedataField)element).getBaseEntityId();
        if (StringUtils.isBlank((CharSequence)refBaseEntityId)) {
            return bdFldNode;
        }
        String refBaseEntityNumber = MetadataDao.getEntityNumberById(refBaseEntityId);
        if (refBaseEntityNumber == null) {
            return bdFldNode;
        }
        BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)refBaseEntityNumber, ((IBasedataField)((Object)element)).getRuntimeRefProps());
        String baseName = dt.getDisplayName().toString();
        for (IDataEntityProperty refProp : dt.getProperties()) {
            String key = refProp.getName();
            if (!(refProp instanceof ICollectionProperty) && !this.isSysField(refProp) && this.isInvisibleField(refProp.getClass().getSimpleName())) {
                if (refProp instanceof BasedataProp) {
                    String refBaseName = ((BasedataProp)refProp).getDisplayName().toString();
                    DynamicObjectType refDt = ((BasedataProp)refProp).getDynamicComplexPropertyType();
                    for (IDataEntityProperty refProp2 : refDt.getProperties()) {
                        if (refProp2 instanceof ICollectionProperty || this.isSysField(refProp2) || !this.isInvisibleField(refProp2.getClass().getSimpleName())) continue;
                        String displayName = ((DynamicProperty)refProp2).getDisplayName().toString();
                        TreeNode refPropNode = new TreeNode();
                        refPropNode.setParentid(fieldKey);
                        refPropNode.setId(String.format(THREE_STR_PLACEHOLDER, fieldKey, refProp.getName(), refProp2.getName()));
                        refPropNode.setText(String.format(THREE_STR_PLACEHOLDER, baseName, refBaseName, displayName));
                        bdFldNode.addChild(refPropNode);
                    }
                    continue;
                }
                String displayName = ((DynamicProperty)refProp).getDisplayName().toString();
                TreeNode refPropNode = new TreeNode();
                refPropNode.setParentid(fieldKey);
                refPropNode.setId(fieldKey + "." + refProp.getName());
                refPropNode.setText(baseName + "." + displayName);
                bdFldNode.addChild(refPropNode);
                continue;
            }
            if (!(refProp instanceof MulBasedataProp) || ((BasedataField)element).getRefProps() == null) continue;
            List<RefProp> refProps = ((BasedataField)element).getRefProps();
            for (RefProp ref : refProps) {
                String name = ref.getName();
                if (!(refProp instanceof MulBasedataProp)) continue;
                String refBaseName = ((MulBasedataProp)refProp).getDisplayName().toString();
                DynamicObjectType refDt = ((MulBasedataProp)refProp).getDynamicCollectionItemPropertyType();
                IDataEntityProperty datapro = this.getBaseDataProp(refDt);
                if (datapro == null) continue;
                for (IDataEntityProperty refProp2 : ((BasedataProp)datapro).getDynamicComplexPropertyType().getProperties()) {
                    if (refProp2 instanceof ICollectionProperty || this.isSysField(refProp2) || !this.isInvisibleField(refProp2.getClass().getSimpleName()) || !name.equals(key + "." + refProp2.getName())) continue;
                    String displayName = ((DynamicProperty)refProp2).getDisplayName().toString();
                    TreeNode refPropNode = new TreeNode();
                    refPropNode.setParentid(fieldKey);
                    refPropNode.setId(fieldKey + "." + ref.getName());
                    refPropNode.setText(baseName + "." + refBaseName + "." + displayName);
                    bdFldNode.addChild(refPropNode);
                }
            }
        }
        return bdFldNode;
    }

    private boolean isSysField(IDataEntityProperty property) {
        if (property instanceof IFieldHandle) {
            return ((IFieldHandle)property).isSysField();
        }
        return false;
    }

    private IDataEntityProperty getBaseDataProp(DynamicObjectType dt) {
        IDataEntityProperty basedataProp = null;
        for (IDataEntityProperty prop : dt.getProperties()) {
            if (!(prop instanceof BasedataProp)) continue;
            basedataProp = prop;
            break;
        }
        return basedataProp;
    }

    public static Map<String, Object> getMoblistFieldTree(List<Map<String, Object>> items) {
        HashMap<String, Object> node = new HashMap<String, Object>(4);
        node.put("Id", "root");
        node.put("Type", BILL_LIST);
        node.put("Name", ResManager.loadKDString((String)"\u5217\u8868\u5143\u7d20", (String)"EntityMetadataUtil_3", (String)BOS_METADATA, (Object[])new Object[0]));
        node.put(CREATE_TYPE, 1);
        List<Map<String, Object>> nodeItems = EntityMetadataUtil.getSystemMobListElements();
        node.put(ITEMS, nodeItems);
        EntityMetadata meta = EntityMetadataUtil.getEntityMetadata(items);
        nodeItems.add(EntityMetadataUtil.getlistFieldTree(meta, 3, true, false));
        return node;
    }

    public static Map<String, Object> getlistFieldTree(List<Map<String, Object>> items) {
        return EntityMetadataUtil.getlistFieldTree(items, Lang.get());
    }

    public static Map<String, Object> getlistFieldTree(List<Map<String, Object>> items, Lang lang) {
        HashMap<String, Object> node = new HashMap<String, Object>(4);
        node.put("Id", "root");
        node.put("Type", BILL_LIST);
        node.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u5217\u8868\u5143\u7d20", (String)"EntityMetadataUtil_3", (String)BOS_METADATA), lang));
        node.put(CREATE_TYPE, 1);
        List<Map<String, Object>> nodeItems = EntityMetadataUtil.getSystemListElements();
        node.put(ITEMS, nodeItems);
        EntityMetadata meta = EntityMetadataUtil.getEntityMetadata(items);
        nodeItems.add(EntityMetadataUtil.getlistFieldTree(meta, 3, true, false));
        return node;
    }

    private static String getDisplayName(LocaleString data, Lang lang) {
        String value = (String)data.get((Object)lang.toString());
        if (StringUtils.isBlank((CharSequence)value)) {
            value = data.toString();
        }
        return value;
    }

    public static List<Map<String, Object>> getSystemMobListElements() {
        return EntityMetadataUtil.getSystemMobListElements(Lang.get());
    }

    public static List<Map<String, Object>> getSystemMobListElements(Lang lang) {
        List<Map<String, Object>> nodeItems = EntityMetadataUtil.getSystemListElements();
        HashMap<String, Object> nodeItem = new HashMap<String, Object>(4);
        nodeItem.put("Id", "MobFilterPanelAp");
        nodeItem.put("Type", "MobFilterPanelAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u79fb\u52a8\u8fc7\u6ee4\u9879", (String)"EntityMetadataUtil_19", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "MobSortPanelAp");
        nodeItem.put("Type", "MobSortPanelAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u79fb\u52a8\u6392\u5e8f\u9879", (String)"EntityMetadataUtil_20", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "MobAdvFilterPanelAp");
        nodeItem.put("Type", "MobAdvFilterPanelAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u9ad8\u7ea7\u7b5b\u9009\u9762\u677f", (String)"EntityMetadataUtil_21", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "MToolbarAp");
        nodeItem.put("Type", "MToolbarAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u5de5\u5177\u680f", (String)"EntityMetadataUtil_16", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "MBarItemAp");
        nodeItem.put("Type", "MBarItemAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u5de5\u5177\u680f\u9879", (String)"EntityMetadataUtil_17", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        return nodeItems;
    }

    public static List<Map<String, Object>> getSystemListElements() {
        return EntityMetadataUtil.getSystemListElements(Lang.get());
    }

    public static List<Map<String, Object>> getSystemListElements(Lang lang) {
        ArrayList<Map<String, Object>> nodeItems = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> nodeItem = new HashMap<String, Object>(4);
        nodeItem.put("Id", "ListColumnGroupAp");
        nodeItem.put("Type", "ListColumnGroupAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u5217\u8868\u5b57\u6bb5\u5206\u7ec4", (String)"EntityMetadataUtil_4", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "MergeListColumnAp");
        nodeItem.put("Type", "MergeListColumnAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u5408\u5e76\u5217\u8868\u5b57\u6bb5", (String)"EntityMetadataUtil_5", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "DynamicTextListColumnAp");
        nodeItem.put("Type", "DynamicTextListColumnAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u52a8\u6001\u6587\u672c\u5217\u8868\u5b57\u6bb5", (String)"EntityMetadataUtil_6", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "CardFlexPanelAp");
        nodeItem.put("Type", "CardFlexPanelAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u5361\u7247\u5e03\u5c40\u5bb9\u5668", (String)"EntityMetadataUtil_7", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "LabelAp");
        nodeItem.put("Type", "LabelAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u6807\u7b7e", (String)"EntityMetadataUtil_8", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "ButtonAp");
        nodeItem.put("Type", "ButtonAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u6309\u94ae", (String)"EntityMetadataUtil_9", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "ImageAp");
        nodeItem.put("Type", "ImageAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u56fe\u7247", (String)"EntityMetadataUtil_10", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "VectorAp");
        nodeItem.put("Type", "VectorAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u77e2\u91cf\u56fe\u6807", (String)"EntityMetadataUtil_11", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "CardSelectorAp");
        nodeItem.put("Type", "CardSelectorAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u5361\u7247\u9009\u62e9\u6807\u5fd7", (String)"EntityMetadataUtil_12", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "ListOperationColumnAp");
        nodeItem.put("Type", "ListOperationColumnAp");
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u64cd\u4f5c\u5217", (String)"EntityMetadataUtil_13", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "VoucherNoListColumnAp");
        nodeItem.put("Type", "VoucherNoListColumnAp");
        if (CoreLicenseService.getModelType() != 4) {
            nodeItem.put("SchemeFilterApType", "SchemeVoucherFilterColumnAp");
        }
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u51ed\u8bc1\u53f7\u5217\u8868\u5b57\u6bb5", (String)"EntityMetadataUtil_22", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        nodeItem = new HashMap(4);
        nodeItem.put("Id", "ApproverListColumnAp");
        nodeItem.put("Type", "ApproverListColumnAp");
        nodeItem.put("FilterApType", "FilterColumnAp");
        nodeItem.put("CommonFilterApType", "CommonApproverFilterColumnAp");
        nodeItem.put("SchemeFilterApType", "SchemeApproverFilterColumnAp");
        nodeItem.put("IsMulti", true);
        nodeItem.put("Custom", false);
        nodeItem.put("Name", EntityMetadataUtil.getDisplayName(ResManager.getLocaleString((String)"\u5f53\u524d\u5ba1\u6279\u4eba\u5b57\u6bb5", (String)"EntityMetadataUtil_18", (String)BOS_METADATA), lang));
        nodeItem.put(CREATE_TYPE, 1);
        nodeItems.add(nodeItem);
        return nodeItems;
    }

    public static Map<String, Object> getlistFieldTree(EntityMetadata meta) {
        return EntityMetadataUtil.getlistFieldTree(meta, 3, false, true);
    }

    public static Map<String, Object> getlistFieldTree(EntityMetadata meta, int level, boolean isNeedSeq, boolean isIncludeEntry) {
        MainEntity entity = meta.getRootEntity();
        return entity.createEntityTree(BILL_LIST, isNeedSeq, true, level, isIncludeEntry);
    }

    public static Map<String, Object> getRptFieldTree(List<Map<String, Object>> items) {
        EntityMetadata meta = EntityMetadataUtil.getEntityMetadata(items);
        MainEntity entity = meta.getRootEntity();
        return entity.createEntityTree("report", true, true, 3, false);
    }

    public Map<String, Boolean> getInvisibleFields() {
        return this.invisibleFields;
    }

    public void setInvisibleFields(Map<String, Boolean> invisibleFields) {
        this.invisibleFields = invisibleFields;
    }

    public void addInvisibleField(String fieldName, boolean isVisible) {
        this.invisibleFields.put(fieldName, isVisible);
    }

    private boolean isInvisibleField(String fieldType) {
        if (this.invisibleFields.containsKey(fieldType)) {
            return this.invisibleFields.get(fieldType);
        }
        return true;
    }

    static interface BaseDataItemWalker {
        public void callBack(BaseDataItemWalkerArgs var1);
    }

    class BaseDataItemWalkerArgs {
        IDataEntityProperty dataEntityProperty;
        EntityItem<?> srcDataEntityItem;
        IDataEntityProperty srcFieldProp;
        String srcFieldName;
        String srcFieldCaption;

        public BaseDataItemWalkerArgs(IDataEntityProperty dataEntityProperty, EntityItem<?> srcDataEntityItem, IDataEntityProperty srcFieldProp, String srcFieldName, String srcFieldCaption) {
            this.dataEntityProperty = dataEntityProperty;
            this.srcDataEntityItem = srcDataEntityItem;
            this.srcFieldName = srcFieldName;
            this.srcFieldCaption = srcFieldCaption;
            this.srcFieldProp = srcFieldProp;
        }

        public IDataEntityProperty getSrcFieldProp() {
            return this.srcFieldProp;
        }

        public void setSrcFieldProp(IDataEntityProperty srcFieldProp) {
            this.srcFieldProp = srcFieldProp;
        }

        public String getSrcFieldName() {
            return this.srcFieldName;
        }

        public void setSrcFieldName(String srcFieldName) {
            this.srcFieldName = srcFieldName;
        }

        public String getSrcFieldCaption() {
            return this.srcFieldCaption;
        }

        public void setSrcFieldCaption(String srcFieldCaption) {
            this.srcFieldCaption = srcFieldCaption;
        }

        public EntityItem<?> getSrcDataEntityItem() {
            return this.srcDataEntityItem;
        }

        public void setSrcDataEntityItem(EntityItem<?> srcDataEntityItem) {
            this.srcDataEntityItem = srcDataEntityItem;
        }

        public IDataEntityProperty getDataEntityProperty() {
            return this.dataEntityProperty;
        }

        public void setDataEntityProperty(IDataEntityProperty dataEntityProperty) {
            this.dataEntityProperty = dataEntityProperty;
        }
    }

    static interface EntityMetadataWalker {
        public void callBack(EntityMetadataWalkerArgs var1);
    }

    class EntityMetadataWalkerArgs {
        EntityItem<?> dataEntityItem;
        EntityItem<?> srcDataEntityItem;
        String srcFieldName;
        String srcFieldCaption;

        public EntityMetadataWalkerArgs(EntityItem<?> dataEntityItem, EntityItem<?> srcDataEntityItem, String srcFieldName, String srcFieldCaption) {
            this.dataEntityItem = dataEntityItem;
            this.srcDataEntityItem = srcDataEntityItem;
            this.srcFieldName = srcFieldName;
            this.srcFieldCaption = srcFieldCaption;
        }

        public EntityItem<?> getDataEntityItem() {
            return this.dataEntityItem;
        }

        public void setDataEntityItem(EntityItem<?> dataEntityItem) {
            this.dataEntityItem = dataEntityItem;
        }

        public EntityItem<?> getSrcDataEntityItem() {
            return this.srcDataEntityItem;
        }

        public void setSrcDataEntityItem(EntityItem<?> srcDataEntityItem) {
            this.srcDataEntityItem = srcDataEntityItem;
        }

        public String getSrcFieldName() {
            return this.srcFieldName;
        }

        public void setSrcFieldName(String srcFieldName) {
            this.srcFieldName = srcFieldName;
        }

        public String getSrcFieldCaption() {
            return this.srcFieldCaption;
        }

        public void setSrcFieldCaption(String srcFieldCaption) {
            this.srcFieldCaption = srcFieldCaption;
        }
    }
}

