/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataNode;
import kd.bos.metadata.dao.MetadataTree;

class ExtMetadataNode
extends MetadataNode
implements Cloneable {
    private Log log = LogFactory.getLog(ExtMetadataNode.class);
    private String masterId;
    private String bizappId;
    private String devType;

    public String getBizappId() {
        return this.bizappId;
    }

    public void setBizappId(String bizappId) {
        this.bizappId = bizappId;
    }

    public ExtMetadataNode(String masterId, String id, String parentId, String xml) {
        super(id, parentId, xml);
        this.masterId = masterId;
    }

    public ExtMetadataNode(String masterId, String id, String parentId, String xml, String isv) {
        super(id, parentId, xml, isv);
        this.masterId = masterId;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public static List<ExtMetadataNode> loadExtendNode(IDataEntityType designerMetaType, MetadataTree tree, final Set<String> withoutIds) {
        final HashSet<String> inTreeIds = new HashSet<String>();
        inTreeIds.addAll(tree.getNodeIds());
        String ids = StringUtils.join((Object[])tree.getNodeIds().toArray(), (String)"','");
        String tableName = designerMetaType.getAlias();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID, FMasterId, FParentId, FData from ", new Object[0]).append(tableName, new Object[0]).append(" WHERE ", new Object[0]).appendIn("FMasterId", tree.getNodeIds().toArray()).append(" and FType = '2' order by FInheritPath", new Object[0]);
        ResultSetHandler<List<ExtMetadataNode>> action = new ResultSetHandler<List<ExtMetadataNode>>(){

            public List<ExtMetadataNode> handle(ResultSet rs) throws Exception {
                ArrayList<ExtMetadataNode> list = new ArrayList<ExtMetadataNode>();
                while (rs.next()) {
                    String id = rs.getString("FId");
                    String masterId = rs.getString("FMasterId");
                    String parentId = rs.getString("FParentID");
                    if (withoutIds.contains(id) || inTreeIds.contains(id)) continue;
                    if (withoutIds.contains(parentId)) {
                        withoutIds.add(id);
                        continue;
                    }
                    inTreeIds.add(id);
                    ExtMetadataNode node = new ExtMetadataNode(masterId, id, parentId, rs.getString("FDATA"));
                    list.add(node);
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)ExtMetadataNode.getDbRoute(designerMetaType), (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }

    private static DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }

    public ExtMetadataNode clone() {
        try {
            ExtMetadataNode newNode = (ExtMetadataNode)super.clone();
            newNode.getExtendNodes().clear();
            return newNode;
        }
        catch (CloneNotSupportedException ex) {
            this.log.error((Throwable)ex);
            return null;
        }
    }

    public String getDevType() {
        return this.devType;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }
}

