/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.dao.CacheType;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaVersionManager;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.devportal.AppDesignMetaReader;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppWriter;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;

public class MetaRebuilder {
    private static final String METABUILDER = "MetaBuilder";
    private static final String BOS_METADATA = "bos-metadata";
    private static final String FNUMBER = ":FNumber";
    private static final String FNUMBER_NO_COMMENT = "Fnumber";
    private static final String T_META_BIZAPP = "t_meta_bizapp";
    private static final String T_META_BIZUNITREFROM = "T_META_BIZUNITRELFORM";
    private static final String ERROR_STR_SQL = "Error:%s. sql:%s";
    private static final String LOWER_CASE_NUMBER = "number";
    private static final String UPPER_CASE_NUMBER = "Number";
    private static final String APP_META_DATA = "AppMetadata";
    private static final String APP_META_DATA_ = "AppMetadata-";
    private static final String RUNTIME_APP_META_DATA_ = "Runtime-AppMetadata-";
    private static final String DESIGN_APP_META_DATA_ = "Design-AppMetadata-";
    private static final Log logger = LogFactory.getLog(MetaRebuilder.class);
    private String appGroup;
    private boolean force;

    public void setForce(boolean force) {
        this.force = force;
    }

    public MetaRebuilder(String appGroup) {
        this.appGroup = appGroup;
    }

    public void rebuildRuntimeAppMetaByNumber(String number) {
        block13: {
            try (TraceSpan span = Tracer.create((String)METABUILDER, (String)("rebuildRuntimeAppMetaByNumber,number:" + number));){
                AppDesignMetaReader amr = new AppDesignMetaReader();
                amr.setAppGroup(this.appGroup);
                String id = amr.getAppIdByNumber(number);
                if (id != null) {
                    this.rebuildRuntimeAppMetaById(id);
                    break block13;
                }
                throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"number\u4e3a%s\u7684\u5e94\u7528\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MetaRebuilder_0", (String)BOS_METADATA, (Object[])new Object[0]), number)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildRuntimeAppMetaById(String id) {
        block33: {
            try (TraceSpan span = Tracer.create((String)METABUILDER, (String)"rebuildRuntimeAppMetaById");){
                if (StringUtils.isEmpty((CharSequence)id)) {
                    return;
                }
                AppDesignMetaReader amr = new AppDesignMetaReader();
                amr.setAppGroup(this.appGroup);
                AppMetadata appMetadata = amr.loadMeta(id, true);
                if (appMetadata == null) {
                    throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"id\u4e3a%s\u7684\u5e94\u7528\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MetaRebuilder_1", (String)BOS_METADATA, (Object[])new Object[0]), id)});
                }
                AppWriter appWrite = new AppWriter("AppModel");
                appWrite.setAppGroup(this.appGroup);
                try (DLock lock = DLock.create((String)("rebuildRuntimeAppMeta_" + RequestContext.get().getAccountId()));){
                    if (lock.tryLock(600000L)) {
                        try {
                            appWrite.rebuildRuntimeAppMeta(appMetadata);
                            break block33;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u91cd\u5efa\u5143\u6570\u636e\u9501\u8d85\u65f6(10\u5206\u949f), id=%s", (String)"MetaRebuilder_2", (String)BOS_METADATA, (Object[])new Object[0]), id));
                }
            }
        }
    }

    public void rebuildRuntimeMetaByNumber(String number) {
        this.rebuildRuntimeMetaByNumber(number, false);
    }

    public void rebuildRuntimeMetaDiffVer(String number) {
        this.rebuildRuntimeMetaByNumber(number, true);
    }

    private void rebuildRuntimeMetaByNumber(String number, boolean diffVer) {
        block16: {
            try (TraceSpan span = Tracer.create((String)METABUILDER, (String)("rebuildRuntimeMetaByNumber,number:" + number));){
                String id = this.getIdByNumber(number, MetaCategory.Form);
                if (id != null) {
                    if (diffVer) {
                        this.rebuildMetaOfDiffVerById(id, "");
                    } else {
                        this.rebuildRuntimeMetaById(id);
                    }
                    break block16;
                }
                if (number.endsWith("_mob")) {
                    number = number.substring(0, number.length() - 4);
                    this.rebuildRuntimeMetaByNumber(number, diffVer);
                    break block16;
                }
                String msg = String.format(ResManager.loadKDString((String)"number\u4e3a%s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MetaRebuilder_3", (String)BOS_METADATA, (Object[])new Object[]{number}), new Object[0]);
                String err = String.format("%s appgroup:%s", msg, this.appGroup);
                throw new KDException(BosErrorCode.metaNotFound, new Object[]{err});
            }
        }
    }

    public int rebuildMetaOfDiffVerById(String id, String currRuntimeVersion) {
        try (TraceSpan span = Tracer.create((String)METABUILDER, (String)"rebuildMetaOfDiffVerById");){
            if (StringUtils.isEmpty((CharSequence)id)) {
                int n = 2;
                return n;
            }
            MetaVersionManager verManager = new MetaVersionManager();
            verManager.setAppGroup(this.appGroup);
            String version = verManager.buildRuntimeVersion(id);
            if (version != null) {
                String oldVer = currRuntimeVersion;
                if (StringUtils.isEmpty((CharSequence)currRuntimeVersion)) {
                    String number = this.getNumberById(id);
                    ArrayList<String> numbers = new ArrayList<String>();
                    numbers.add(number);
                    Map<String, String> map = verManager.getRuntimeMetaVersion(numbers);
                    oldVer = map.get(number);
                }
                if (StringUtils.isNotEmpty((CharSequence)oldVer) && verManager.compareRuntimeVersion(version, oldVer)) {
                    int n = 3;
                    return n;
                }
            }
            this.rebuildRuntimeMetaById(id);
            int n = 1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildRuntimeMetaById(String id) {
        try (TraceSpan span = Tracer.create((String)METABUILDER, (String)"rebuildRuntimeMetaById");){
            if (StringUtils.isEmpty((CharSequence)id)) {
                return;
            }
            String tId = id.replace("/", "aaaaaa");
            DLock lock = DLock.create((String)("GrayMetaRebuilder_rebuildRuntimeMetaById_" + RequestContext.get().getAccountId() + "_" + tId)).fastMode();
            try {
                if (lock.tryLock()) {
                    long time = System.currentTimeMillis();
                    AbstractMetadata formMetadata = this.readRuntimeMeta(id, MetaCategory.Form);
                    if (formMetadata == null) {
                        throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"id\u4e3a%s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MetaRebuilder_4", (String)BOS_METADATA, (Object[])new Object[0]), id)});
                    }
                    if ("2".equals(formMetadata.getDevType())) {
                        StringBuilder sb = new StringBuilder();
                        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
                        int size = Math.min(stes.length, 50);
                        for (int j = 1; j < size; ++j) {
                            sb.append("\r\nat ").append(stes[j]);
                        }
                        logger.info("\u5143\u6570\u636e\u91cd\u5efa\uff0c\u4f20\u5165\u6269\u5c55\u5355(id:{})", (Object)formMetadata.getId());
                        logger.info(sb.toString());
                        return;
                    }
                    this.saveRuntimeMeta(formMetadata);
                    long cost = System.currentTimeMillis() - time;
                    if (cost > 500L) {
                        logger.info("rebuildRuntimeMetaById({}) time:{}", (Object)formMetadata.getId(), (Object)cost);
                    }
                } else {
                    long time = System.currentTimeMillis();
                    lock.lock();
                    logger.info("rebuildRuntimeMetaById({}) lock time:{}", (Object)id, (Object)(System.currentTimeMillis() - time));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public List<BuildFormDesignMeta> getRebuildFormDesignMeta(List<String> formIds) {
        int i;
        if (formIds == null || formIds.isEmpty()) {
            return new ArrayList<BuildFormDesignMeta>();
        }
        int listsize = formIds.size();
        Object[] dbParams = new Object[listsize];
        dbParams[0] = formIds.get(0);
        for (int i2 = 1; i2 < listsize; ++i2) {
            dbParams[i2] = formIds.get(i2);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select FId, Fnumber, FModelType, FType, FMasterId, FParentId, FBizAppId from ", new Object[0]).append(this.getGrayTableName("t_meta_formdesign"), new Object[0]).append(" where", new Object[0]).appendIn("FId", dbParams);
        List<BuildFormDesignMeta> originalMetaList = MetaRebuilder.queryBuildFormDesignMeta(sqlBuilder);
        ArrayList<String> extendFormIds = new ArrayList<String>();
        HashMap<String, BuildFormDesignMeta> metas = new HashMap<String, BuildFormDesignMeta>();
        for (BuildFormDesignMeta meta : originalMetaList) {
            if ("2".equals(meta.getDevType())) {
                extendFormIds.add(meta.getMasterId());
                continue;
            }
            metas.put(meta.getNumber(), meta);
        }
        SqlBuilder sqlInheritMeta = new SqlBuilder();
        sqlInheritMeta.append("select c.FId, c.Fnumber, c.FModelType, c.FType, c.FMasterId, c.FParentId,c.FBizAppId from ", new Object[0]).append(this.getGrayTableName("t_meta_formdesign"), new Object[0]).append(" a inner join ", new Object[0]).append(this.getGrayTableName("t_meta_formdesign"), new Object[0]).append(" c on charindex(a.fid, c.finheritpath) > 0 where", new Object[0]).appendIn("a.FId", dbParams);
        List<BuildFormDesignMeta> inheritMetalist = MetaRebuilder.queryBuildFormDesignMeta(sqlInheritMeta);
        int size = inheritMetalist.size();
        Map map = new HashMap();
        if (size > 0) {
            Object[] entityInfoParams = new Object[size];
            entityInfoParams[0] = inheritMetalist.get(0).getNumber();
            for (i = 1; i < size; ++i) {
                entityInfoParams[i] = inheritMetalist.get(i).getNumber();
            }
            sqlInheritMeta = new SqlBuilder();
            sqlInheritMeta.append("select FId, FTableName from ", new Object[0]).append("T_META_MAINENTITYINFO", new Object[0]).append(" where ", new Object[0]).appendIn("FId", entityInfoParams);
            map = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlInheritMeta, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    while (rs.next()) {
                        map.put(rs.getString("FId"), rs.getString("FTableName"));
                    }
                    return map;
                }
            });
        }
        for (BuildFormDesignMeta meta : inheritMetalist) {
            if ("2".equals(meta.getDevType())) {
                extendFormIds.add(meta.getMasterId());
                continue;
            }
            if (metas.containsKey(meta.getNumber())) continue;
            meta.setDevType("1");
            metas.put(meta.getNumber(), meta);
            String tableName = (String)map.get(meta.getNumber());
            if (StringUtils.isBlank((CharSequence)tableName)) continue;
            meta.setTableName(tableName);
        }
        if (extendFormIds.size() > 0) {
            Object[] params = new Object[extendFormIds.size()];
            params[0] = extendFormIds.get(0);
            for (i = 1; i < extendFormIds.size(); ++i) {
                params[i] = extendFormIds.get(i);
            }
            SqlBuilder sqlInherit = new SqlBuilder();
            sqlInherit.append("select FId, Fnumber, FModelType, FType, FMasterId,FparentId,FBizAppId from ", new Object[0]).append(this.getGrayTableName("t_meta_formdesign"), new Object[0]).append(" where", new Object[0]).appendIn("FId", params);
            List<BuildFormDesignMeta> extendMetaList = MetaRebuilder.queryBuildFormDesignMeta(sqlInherit);
            for (BuildFormDesignMeta meta : extendMetaList) {
                metas.put(meta.getNumber(), meta);
            }
        }
        if (metas.size() > 0) {
            ArrayList list = new ArrayList();
            list.addAll(metas.values());
            Object[] entityInfoParams = new Object[list.size()];
            if (!list.isEmpty()) {
                entityInfoParams[0] = ((BuildFormDesignMeta)list.get(0)).getId();
                for (int i3 = 1; i3 < list.size(); ++i3) {
                    entityInfoParams[i3] = ((BuildFormDesignMeta)list.get(i3)).getId();
                }
                SqlBuilder sb = new SqlBuilder();
                sb.append("select a.FId, a.Fnumber, a.FModelType, a.FType, a.FMasterId,b.FREFENTITYID, b.FREFOBJECTTYPEID from ", new Object[0]).append(this.getGrayTableName("t_meta_formdesign"), new Object[0]).append(" a inner join ", new Object[0]).append(this.getGrayTableName("t_meta_objecttyperef"), new Object[0]).append(" b on b.fentityid = a.fid where ", new Object[0]).appendIn("b.frefentityid", dbParams);
                List refList = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                    public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                        ArrayList<Map<String, Object>> refList = new ArrayList<Map<String, Object>>(10);
                        while (rs.next()) {
                            HashMap<String, String> map = new HashMap<String, String>(16);
                            String modelType = rs.getString(3);
                            if ("PrintModel".equals(modelType)) continue;
                            String id = rs.getString(1);
                            String number = rs.getString(2);
                            String type = rs.getString(4);
                            String masterId = rs.getString(5);
                            String refEntityId = rs.getString(6);
                            String refObjectTypeId = rs.getString(7);
                            map.put("id", id);
                            map.put(MetaRebuilder.LOWER_CASE_NUMBER, number);
                            map.put("modelType", modelType);
                            map.put("type", type);
                            map.put("masterId", masterId);
                            map.put("refEntityId", refEntityId);
                            map.put("refObjectTypeId", refObjectTypeId);
                            refList.add(map);
                        }
                        return refList;
                    }
                });
                HashMap<String, BuildFormDesignMeta> originalMap = new HashMap<String, BuildFormDesignMeta>(originalMetaList.size());
                for (BuildFormDesignMeta meta : originalMetaList) {
                    originalMap.put(meta.getId(), meta);
                }
                for (Map ref : refList) {
                    String originalNumber;
                    String refNumber = (String)ref.get("refObjectTypeId");
                    String refEntityId = (String)ref.get("refEntityId");
                    String refFormId = (String)ref.get("id");
                    BuildFormDesignMeta orginMeta = (BuildFormDesignMeta)originalMap.get(refEntityId);
                    if (orginMeta == null || (originalNumber = orginMeta.getNumber()).equalsIgnoreCase(refNumber)) continue;
                    BuildFormDesignMeta meta = new BuildFormDesignMeta();
                    meta.setId(refFormId);
                    meta.setNumber((String)ref.get(LOWER_CASE_NUMBER));
                    meta.setModelType((String)ref.get("modelType"));
                    meta.setDevType((String)ref.get("type"));
                    meta.setMasterId((String)ref.get("masterId"));
                    meta.setDevType("3");
                    metas.put(meta.getNumber(), meta);
                }
            }
        }
        ArrayList<BuildFormDesignMeta> buildFormMetas = new ArrayList<BuildFormDesignMeta>();
        buildFormMetas.addAll(metas.values());
        return buildFormMetas;
    }

    public void delRuntimeMeta(String[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)METABUILDER, (String)"delRuntimeMeta");
             TXHandle h = TX.requiresNew((String)"delRuntimeMeta");){
            String sql = String.format("delete from %s where fid=?", this.getGrayTableName("t_meta_form"));
            ArrayList<Object[]> list = new ArrayList<Object[]>(10);
            for (int i = 0; i < ids.length; ++i) {
                Object[] param = new Object[]{ids[i]};
                list.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.meta, (String)sql, list);
            sql = String.format("delete from %s where fid=?", this.getGrayTableName("t_meta_entity"));
            DB.executeBatch((DBRoute)DBRoute.meta, (String)sql, list);
        }
    }

    private AbstractMetadata readRuntimeMeta(String id, MetaCategory category) {
        AbstractMetadata meta;
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(this.appGroup);
        if (category == MetaCategory.Entity) {
            meta = reader.readMeta(id, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
            if (meta == null && this.isGray()) {
                reader = new MetadataReader();
                meta = reader.readMeta(id, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
            }
        } else {
            meta = reader.readMeta(id, OrmUtils.getDataEntityType(DesignFormMeta.class), true);
            if (meta == null && this.isGray()) {
                reader = new MetadataReader();
                meta = reader.readMeta(id, OrmUtils.getDataEntityType(DesignFormMeta.class), true);
            }
        }
        return meta;
    }

    private void saveRuntimeMeta(AbstractMetadata formMetaData) {
        MetadataWriter metadataWriter = new MetadataWriter(formMetaData.getModelType());
        metadataWriter.setAppGroup(this.appGroup);
        metadataWriter.rebuildRuntimeMeta(formMetaData);
    }

    public List<BuildFormDesignMeta> getAllRebuildFormDesignMeta() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FId, Fnumber, FModelType, FType, FMasterId, FVersion, FParentId,FBizAppId from ", new Object[0]).append(this.getGrayTableName("t_meta_formdesign"), new Object[0]);
        sqlBuilder.append(" order by fnumber ", new Object[0]);
        return MetaRebuilder.queryBuildFormDesignMeta(sqlBuilder, true);
    }

    private static List<BuildFormDesignMeta> queryBuildFormDesignMeta(SqlBuilder sqlBuilder) {
        return MetaRebuilder.queryBuildFormDesignMeta(sqlBuilder, false);
    }

    private static List<BuildFormDesignMeta> queryBuildFormDesignMeta(SqlBuilder sqlBuilder, final boolean loadVer) {
        ResultSetHandler<List<BuildFormDesignMeta>> action = new ResultSetHandler<List<BuildFormDesignMeta>>(){

            public List<BuildFormDesignMeta> handle(ResultSet rs) throws Exception {
                ArrayList<BuildFormDesignMeta> list = new ArrayList<BuildFormDesignMeta>(10);
                HashMap<String, ArrayList<BuildFormDesignMeta>> grpMetas = new HashMap<String, ArrayList<BuildFormDesignMeta>>(16);
                while (rs.next()) {
                    ArrayList<BuildFormDesignMeta> metaList;
                    String modelType = rs.getString("FModelType");
                    String id = rs.getString("FId");
                    String masterId = rs.getString("FMasterId");
                    String parentId = rs.getString("FParentId");
                    String type = rs.getString("FType");
                    String bizAppId = rs.getString("FBizAppId");
                    BuildFormDesignMeta meta = new BuildFormDesignMeta();
                    meta.setId(id);
                    meta.setNumber(rs.getString(MetaRebuilder.FNUMBER_NO_COMMENT));
                    meta.setModelType(modelType);
                    meta.setDevType(type);
                    meta.setMasterId(masterId);
                    meta.setParentId(parentId);
                    meta.setBizAppId(bizAppId);
                    if (loadVer) {
                        if (!"2".equals(type)) {
                            list.add(meta);
                        }
                    } else {
                        list.add(meta);
                    }
                    if (!loadVer) continue;
                    meta.setVersion(rs.getLong("FVersion"));
                    String groupId = masterId;
                    if (StringUtils.isBlank((CharSequence)masterId)) {
                        groupId = id;
                    }
                    if ((metaList = (ArrayList<BuildFormDesignMeta>)grpMetas.get(groupId)) == null) {
                        metaList = new ArrayList<BuildFormDesignMeta>();
                    }
                    metaList.add(meta);
                    grpMetas.put(groupId, metaList);
                }
                if (loadVer) {
                    MetaRebuilder.setMergerVersion(list, grpMetas);
                }
                return list;
            }
        };
        List list = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return list;
    }

    private static void setMergerVersion(List<BuildFormDesignMeta> list, Map<String, List<BuildFormDesignMeta>> grpMetas) {
        if (list == null || grpMetas == null) {
            return;
        }
        HashMap<String, String> verMap = new HashMap<String, String>(16);
        for (Map.Entry<String, List<BuildFormDesignMeta>> entry : grpMetas.entrySet()) {
            String groupId = entry.getKey();
            List<BuildFormDesignMeta> metaList = entry.getValue();
            if (metaList == null) continue;
            AtomicLong totalVer = new AtomicLong();
            metaList.forEach(meta -> {
                long ver = meta.getVersion();
                totalVer.addAndGet(ver);
            });
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            String mergerVer = String.format("%s.%s.%s", BOSRuntime.getVersion(), totalVer, sdf.format(new Date()));
            verMap.put(groupId, mergerVer);
        }
        list.forEach(meta -> {
            String id = meta.getId();
            String megerVer = verMap.get(id) == null ? "" : (String)verMap.get(id);
            meta.setMergeVersion(megerVer);
        });
    }

    private String getGrayTableName(String tabName) {
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, this.appGroup);
    }

    private void delRuntimeMetaByNumber(String number) {
        try (TraceSpan span = Tracer.create((String)METABUILDER, (String)"delRuntimeMetaByNumber");
             TXHandle h = TX.requiresNew((String)"delRuntimeMetaByNumber");){
            String sql = String.format("delete from %s where fnumber=?", this.getGrayTableName("t_meta_form"));
            Object[] params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number)};
            DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
            params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)(number + "_mob"))};
            DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
            sql = String.format("delete from %s where fnumber=?", this.getGrayTableName("t_meta_entity"));
            params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number)};
            DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
        }
    }

    private void clearSubRuntimeMeta(List<String> formIds) {
        List<BuildFormDesignMeta> formDesignMetas = this.getRebuildFormDesignMeta(formIds);
        ArrayList<String> delFormIds = new ArrayList<String>();
        for (int i = 0; i < formDesignMetas.size(); ++i) {
            BuildFormDesignMeta meta = formDesignMetas.get(i);
            if (meta.getDevType().compareTo("3") == 0) {
                delFormIds.add(meta.getId());
                continue;
            }
            if (formIds.contains(meta.getId())) continue;
            try {
                this.rebuildRuntimeMetaById(meta.getId());
                continue;
            }
            catch (Exception e) {
                String stack = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.warn("\u91cd\u5efa\u5b50\u5355\u636e\u8fd0\u884c\u65f6\u51fa\u73b0\u4e86\u4e00\u4e9b\u5f02\u5e38\uff0cERR:" + stack);
            }
        }
        this.delRuntimeMeta(delFormIds.toArray(new String[0]));
        this.clearCache(formDesignMetas);
    }

    public void clearAppCache(String appId, String appMasterId) {
        String id = appMasterId;
        if (StringUtils.isBlank((CharSequence)id)) {
            id = appId;
        }
        AppDesignMetaReader amr = new AppDesignMetaReader();
        amr.setAppGroup(this.appGroup);
        String appNumber = amr.getAppNumberById(id);
        String accountId = CacheKeyUtil.getAcctId();
        String prefixRuntime = RUNTIME_APP_META_DATA_ + accountId + "-";
        String prefixDesign = DESIGN_APP_META_DATA_ + accountId + "-";
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APP_META_DATA, new DistributeCacheHAPolicy());
        String portalAllAppkey = RUNTIME_APP_META_DATA_ + accountId + "-portalapp";
        DataEntityCacheManager appCacheManager = new DataEntityCacheManager(T_META_BIZAPP);
        appCacheManager.removeByPrimaryKey(new Object[]{appId});
        String cacheKey = this.getCacheKey(APP_META_DATA, accountId);
        cache.remove(cacheKey, prefixDesign + appId);
        cache.remove(cacheKey, portalAllAppkey);
        if (StringUtils.isNotEmpty((CharSequence)appMasterId)) {
            cache.remove(cacheKey, prefixRuntime + appMasterId);
        } else {
            cache.remove(cacheKey, prefixRuntime + appId);
        }
        if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
            MetaCacheUtils.removeAppmetaDistributeCache(this.appGroup, appNumber);
            AppMetadataCache.removeAppmetaLocalCache((String)appNumber);
        }
        AppMetadataCache.removeCache();
        amr.removeAppNumberAndIdCache(appId, appNumber);
    }

    public void cleanAllAppMetadataCache() {
        String accountId = CacheKeyUtil.getAcctId();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APP_META_DATA, new DistributeCacheHAPolicy());
        cache.remove(this.getCacheKey(APP_META_DATA, accountId));
        AppDesignMetaReader amr = new AppDesignMetaReader();
        amr.setAppGroup(this.appGroup);
        Map<String, String> apps = amr.getAllOriAppNumbers();
        if (apps != null && apps.size() > 0) {
            String[] numbers = apps.values().toArray(new String[apps.size()]);
            for (int i = 0; i < numbers.length; ++i) {
                MetaCacheUtils.removeAppMetaDistributeCache(this.appGroup, numbers[i]);
            }
            AppMetadataCache.removeAppmetaLocalCache((String[])numbers);
            logger.info("MetaRebuilder.cleanAllAppMetadataCache: appGroup={}, numbers={}", (Object)this.appGroup, (Object)numbers);
        }
        AppMetadataCache.removeCache();
        amr.cleanAllAppNumberAndIdCache();
    }

    public void clearCache(List<BuildFormDesignMeta> metas) {
        this.clearCache(this.appGroup, metas);
    }

    private void clearCache(String appGroup, List<BuildFormDesignMeta> metas) {
        ArrayList<String> metaNumbers = new ArrayList<String>(metas.size());
        for (BuildFormDesignMeta meta : metas) {
            metaNumbers.add(meta.getNumber());
        }
        MetaCacheUtils.removeGroupDistributeCache(appGroup, metaNumbers);
        for (BuildFormDesignMeta meta : metas) {
            MetaCacheUtils.removeGroupDistributeCache(appGroup, meta.getId(), "entitynumber", 0);
            EntityMetadataCache.removeDataEntityTypeLocalCache((String)meta.getNumber());
            if (!StringUtils.isBlank((CharSequence)meta.getTableName())) {
                DataEntityCacheManager cm = new DataEntityCacheManager(meta.getTableName());
                cm.removeByDt();
            }
            ArrayList<String> numbers = new ArrayList<String>();
            String key = meta.getNumber();
            String mobKey = String.format("%s_mob", key);
            String filterKey = String.format("%s_filter", key);
            numbers.add(key);
            numbers.add(mobKey);
            numbers.add(filterKey);
            MetaCacheUtils.removeGroupDistributeCache(appGroup, numbers);
            MetaCacheUtils.removeGroupDistributeCache(appGroup, meta.getId(), "formnumber", 0);
            FormMetadataCache.removeLocalCache((String)key);
            FormMetadataCache.removeLocalCache((String)mobKey);
            FormMetadataCache.removeLocalCache((String)filterKey);
            String cacheVerKey = CacheType.getCacheVersionKey(key);
            MetaCacheUtils.putDistributeCache(key, cacheVerKey, 0, String.valueOf(new Date().getTime()));
            this.clearGrayCache(appGroup, meta, key, mobKey, filterKey);
        }
    }

    private void clearGrayCache(String appGroup, BuildFormDesignMeta meta, String key, String mobKey, String filterKey) {
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            EntityMetadataCache.removeDataEntityTypeLocalCache((String)appGroup, (String)meta.getNumber());
            if (StringUtils.isNotBlank((CharSequence)meta.getTableName())) {
                DataEntityCacheManager cm = new DataEntityCacheManager(this.getGrayTableName(meta.getTableName()));
                cm.removeByDt();
            }
            FormMetadataCache.removeLocalCache((String)appGroup, (String)meta.getNumber());
            FormMetadataCache.removeLocalCache((String)appGroup, (String)key);
            FormMetadataCache.removeLocalCache((String)appGroup, (String)mobKey);
            FormMetadataCache.removeLocalCache((String)appGroup, (String)filterKey);
        }
    }

    private String getNumberById(String id) {
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(this.appGroup);
        String number = reader.getNumberById(id);
        if (StringUtils.isBlank((CharSequence)number) && this.isGray()) {
            reader = new MetadataReader();
            number = reader.getNumberById(id);
        }
        return number;
    }

    private String getIdByNumber(String id, MetaCategory category) {
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(this.appGroup);
        String formId = reader.loadIdByNumber(id, category);
        if (StringUtils.isBlank((CharSequence)formId) && this.isGray()) {
            reader = new MetadataReader();
            formId = reader.loadIdByNumber(id, category);
        }
        return formId;
    }

    private boolean isGray() {
        return StringUtils.isNotBlank((CharSequence)this.appGroup) && !"defaultGroup".equals(this.appGroup);
    }

    private String getCacheKey(String key, String number) {
        return String.format("%s_%s_%s", key, this.appGroup, number);
    }
}

