/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import com.alibaba.fastjson.JSONObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.DesignConvertRuleMetaL;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.botp.DesignWriteBackRuleMetaL;
import kd.bos.metadata.dao.CacheType;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.deploy.DeployCard;
import kd.bos.metadata.deploy.DeployCardBinder;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.deploy.DeploySchema;
import kd.bos.metadata.deploy.DeploySchemaBinder;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.metadata.deploy.DeployScriptBinder;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.AppWriter;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.devportal.DesignAppMetaL;
import kd.bos.metadata.devportal.DesignCloudMeta;
import kd.bos.metadata.devportal.DesignCloudMetaL;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.extensible.BizObjExtMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.mservice.runmode.RunModeService;
import kd.bos.mservice.svc.earlywarn.IEarlyWarnProxy;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.SAXReaderUtil;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.kingscript.lib.version.ScriptVersionManager;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

@SdkPublic
public class MetadataDao {
    private static final String METADATA_DAO = "MetadataDao";
    private static final String BOS_METADATA = "bos-metadata";
    private static final String FNUMBER = ":FNumber";
    private static final String ERROR_S = "Error:%s";
    private static final String FTYPE = ":FTYPE";
    private static final String FID = ":FID";
    private static final String FNUMBER_NO_COMMENT = "Fnumber";
    private static final String T_META_BIZAPP = "t_meta_bizapp";
    private static final String T_META_BIZUNITREFROM = "T_META_BIZUNITRELFORM";
    private static final String ERROR_STR_SQL = "Error:%s. sql:%s";
    private static final String LOWER_CASE_NUMBER = "number";
    private static final String UPPER_CASE_NUMBER = "Number";
    private static final String APP_META_DATA = "AppMetadata";
    private static final String RUNTIME_APP_META_DATA_ = "Runtime-AppMetadata-";
    private static final String DESIGN_APP_META_DATA_ = "Design-AppMetadata-";
    private static final String T_META_FORMDESIN_L = "t_meta_formdesign_l";
    public static final String REBUILD_SPEED_MODEL = "rebuild.speed.model";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final Log log = LogFactory.getLog(MetadataDao.class);
    private static ConcurrentHashMap<String, Object> lockMap = new ConcurrentHashMap(16);

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APP_META_DATA, new DistributeCacheHAPolicy());
    }

    public static AbstractMetadata readMeta(String id, MetaCategory category) {
        if (category == MetaCategory.Entity) {
            return MetadataDao.readGroupMeta(id, DesignEntityMeta.class, false);
        }
        return MetadataDao.readGroupMeta(id, DesignFormMeta.class, false);
    }

    public static AbstractMetadata readBaseMeta(String id, MetaCategory category) {
        if (category == MetaCategory.Entity) {
            return MetadataDao.readGroupMeta(id, DesignEntityMeta.class, false, true);
        }
        return MetadataDao.readGroupMeta(id, DesignFormMeta.class, false, true);
    }

    public static AbstractMetadata readDefaultLayout(String entityId) {
        return MetadataDao.readDefaultLayout(entityId, false);
    }

    public static AbstractMetadata readDefaultLayout(String entityId, boolean runtime) {
        return MetadataDao.readGroupMeta(entityId, DesignFormMeta.class, runtime);
    }

    public static AbstractMetadata readRuntimeMeta(String id, MetaCategory category) {
        if (category == MetaCategory.Entity) {
            return MetadataDao.readGroupMeta(id, DesignEntityMeta.class, true);
        }
        return MetadataDao.readGroupMeta(id, DesignFormMeta.class, true);
    }

    public static void rebuildRuntimeAppMetaByNumber(String number) {
        block13: {
            try (TraceSpan span = Tracer.create((String)("MetadataDao_rebuildAppMeta_" + number), (String)("rebuildRuntimeAppMetaByNumber,number:" + number));){
                String id = AppReader.getAppIdByNumber(number);
                if (id != null) {
                    MetadataDao.rebuildRuntimeAppMetaById(id);
                    break block13;
                }
                throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"number\u4e3a%s\u7684\u5e94\u7528\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MetadataDao_0", (String)BOS_METADATA, (Object[])new Object[0]), number)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildRuntimeAppMetaById(String id) {
        try (TraceSpan span = Tracer.create((String)"MetadataDao_rebuildAppMetaById", (String)"rebuildRuntimeAppMetaById");){
            if (StringUtils.isEmpty((CharSequence)id)) {
                return;
            }
            Object lockObj = lockMap.get(id);
            if (lockObj == null) {
                lockObj = new Object();
                lockMap.put(id, lockObj);
            }
            Object object = lockObj;
            synchronized (object) {
                AppMetadata appMetadata = AppReader.loadMeta(id, true);
                if (appMetadata == null) {
                    throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"id\u4e3a%s\u7684\u5e94\u7528\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MetadataDao_1", (String)BOS_METADATA, (Object[])new Object[0]), id)});
                }
                AppWriter appWrite = new AppWriter("AppModel");
                String tId = id.replace("/", "aaaaaa");
                try (DLock lock = DLock.create((String)("rebuildRuntimeAppMetaById_" + RequestContext.get().getAccountId() + "_" + tId)).fastMode();){
                    if (lock.tryLock(600000L)) {
                        try {
                            appWrite.rebuildRuntimeAppMeta(appMetadata);
                        }
                        finally {
                            lock.unlock();
                        }
                    } else {
                        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u91cd\u5efa\u5143\u6570\u636e\u9501\u8d85\u65f6(10\u5206\u949f), id=%s", (String)"MetadataDao_2", (String)BOS_METADATA, (Object[])new Object[0]), id));
                    }
                    lockMap.remove(id);
                }
            }
        }
    }

    public static String getIdByNumber(String id, MetaCategory category) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        String number = reader.loadIdByNumber(id, category);
        if (StringUtils.isBlank((CharSequence)number) && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            number = reader.loadIdByNumber(id, category);
        }
        return number;
    }

    public static List<String> getIdsByNumbers(List<String> ids, MetaCategory category) {
        ArrayList<String> result = new ArrayList<String>(ids.size());
        for (String id : ids) {
            result.add(MetadataDao.getIdByNumber(id, category));
        }
        return result;
    }

    @Deprecated
    public static void rebuildRuntimeMetaByNumber(String number) {
        MetadataDao.rebuildRuntimeMetaByNumber(number, false);
    }

    @Deprecated
    public static void rebuildRuntimeMetaDiffVer(String number) {
        MetadataDao.rebuildRuntimeMetaByNumber(number, true);
    }

    private static void rebuildRuntimeMetaByNumber(String number, boolean diffVer) {
        block16: {
            try (TraceSpan span = Tracer.create((String)("MetadataDao_rebuildRuntimeMetaByNumber_number:" + number), (String)"rebuildRuntimeMetaByNumber");){
                String id = MetadataDao.getIdByNumber(number, MetaCategory.Form);
                if (id != null) {
                    if (diffVer) {
                        MetadataDao.rebuildMetaOfDiffVerById(id);
                    } else {
                        MetadataDao.rebuildRuntimeMetaById(id);
                    }
                    break block16;
                }
                if (number.endsWith("_mob")) {
                    number = number.substring(0, number.length() - 4);
                    MetadataDao.rebuildRuntimeMetaByNumber(number, diffVer);
                    break block16;
                }
                throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"number\u4e3a%s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MetadataDao_3", (String)BOS_METADATA, (Object[])new Object[0]), number)});
            }
        }
    }

    public static void delRuntimeMeta(String[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        MetaRebuilder mr = new MetaRebuilder(MetadataDao.getAppGroup());
        mr.delRuntimeMeta(ids);
    }

    public static int rebuildMetaOfDiffVerById(String id) {
        return MetadataDao.rebuildMetaOfDiffVerById(id, "");
    }

    public static int rebuildMetaOfDiffVerById(String id, String currRuntimeVersion) {
        try (TraceSpan span = Tracer.create((String)"MetadataDao_rebuildMetaOfDiffVerById", (String)"rebuildMetaOfDiffVerById");){
            String version;
            if (StringUtils.isEmpty((CharSequence)id)) {
                int n = 2;
                return n;
            }
            Object lockObj = lockMap.get(id);
            if (lockObj == null) {
                lockObj = new Object();
                lockMap.put(id, lockObj);
            }
            if ((version = MetadataDao.buildRuntimeVersion(id)) != null) {
                String oldVer = currRuntimeVersion;
                if (StringUtils.isEmpty((CharSequence)currRuntimeVersion)) {
                    String number = MetadataDao.getNumberById(id);
                    ArrayList<String> numbers = new ArrayList<String>();
                    numbers.add(number);
                    Map<String, String> map = MetadataDao.getRuntimeMetaVersion(numbers);
                    oldVer = map.get(number);
                }
                if (StringUtils.isNotEmpty((CharSequence)oldVer) && MetadataDao.compareRuntimeVersion(version, oldVer)) {
                    int n = 3;
                    return n;
                }
            }
            MetadataDao.rebuildRuntimeMetaById(id);
            int n = 1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildRuntimeMetaById(String id) {
        try (TraceSpan span = Tracer.create((String)"MetadataDao_rebuildRuntimeMetaById", (String)"rebuildRuntimeMetaById");){
            if (StringUtils.isEmpty((CharSequence)id)) {
                return;
            }
            String tId = id.replace("/", "aaaaaa");
            DLock lock = DLock.create((String)("MetadataDao_rebuildRuntimeMetaById_" + RequestContext.get().getAccountId() + "_" + tId)).fastMode();
            try {
                if (lock.tryLock()) {
                    AbstractMetadata formMetadata = MetadataDao.readRuntimeMeta(id, MetaCategory.Form);
                    if (formMetadata == null) {
                        String errMsg = String.format(ResManager.loadKDString((String)"id\u4e3a%s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MetadataDao_4", (String)BOS_METADATA, (Object[])new Object[0]), id);
                        log.error(errMsg);
                        throw new KDException(BosErrorCode.metaNotFound, new Object[]{errMsg});
                    }
                    MetadataWriter metadataWriter = MetadataDao.getMetadataWriter(formMetadata.getModelType());
                    metadataWriter.rebuildRuntimeMeta(formMetadata);
                } else {
                    lock.lock();
                    if (!MetadataDao.checkMetaDataExist(id)) {
                        throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"id\u4e3a%s\u7684\u5143\u6570\u636e\u91cd\u5efa\u5931\u8d25\uff0c\u56e0\u5f53\u524d\u7b49\u5f85\u7ebf\u7a0b\u68c0\u6d4b\u5230\u83b7\u53d6\u5230\u9501\u7684\u7ebf\u7a0b\u5df2\u91cd\u5efa\u5931\u8d25\u3002", (String)"MetadataDao_5", (String)BOS_METADATA, (Object[])new Object[0]), id)});
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static boolean checkNumber(String number) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        boolean ret = reader.checkNumber(number);
        if (!ret && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            ret = reader.checkNumber(number);
        }
        return ret;
    }

    public static boolean checkNumber(String number, String id) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        boolean ret = reader.checkNumber(number, id);
        if (!ret && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            ret = reader.checkNumber(number, id);
        }
        return ret;
    }

    public static String getMasterId(String id) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        String masterId = reader.getMasterId(id);
        if (StringUtils.isBlank((CharSequence)masterId) && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            masterId = reader.getMasterId(id);
        }
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return id;
        }
        return masterId;
    }

    public static String getNumberById(String id) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        String num = reader.getNumberById(id);
        if (StringUtils.isBlank((CharSequence)num) && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            num = reader.getNumberById(id);
        }
        return num;
    }

    public static String getEntityNumberById(String id) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        String num = reader.getEntityNumberById(id);
        if (StringUtils.isBlank((CharSequence)num) && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            num = reader.getEntityNumberById(id);
        }
        return num;
    }

    public static boolean checkName(String name) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        boolean ret = reader.checkName(name);
        if (!ret && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            ret = reader.checkName(name);
        }
        return ret;
    }

    public static Map<String, Object> loadDesignerMetadata(String id) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        AbstractMetadata metadata = reader.readMetaForMetadataDao(id, MetadataDao.getDataEntityType(DesignFormMeta.class), false, false);
        if (metadata == null && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            metadata = reader.readMetaForMetadataDao(id, MetadataDao.getDataEntityType(DesignFormMeta.class), false, false);
        }
        if (metadata == null) {
            return null;
        }
        return metadata.buildDesignMeta("zh_CN");
    }

    public static Map<String, Object> loadDesignerMetadata(String id, String lang) {
        MetadataReader reader = new MetadataReader(false, lang);
        reader.setAppGroup(MetadataDao.getAppGroup());
        AbstractMetadata metadata = reader.readMetaForMetadataDao(id, MetadataDao.getDataEntityType(DesignFormMeta.class), false, false);
        if (metadata == null && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader(false, lang);
            metadata = reader.readMetaForMetadataDao(id, OrmUtils.getDataEntityType(DesignFormMeta.class), false, false);
        }
        if (metadata == null) {
            return null;
        }
        return metadata.buildDesignMeta(lang);
    }

    public static Map<String, Object> delFormMetadata(String id) {
        MetadataWriter writer = new MetadataWriter();
        return writer.delFormMetadata(id);
    }

    public static String getAppNumberByAppId(String appId) {
        return AppReader.getAppNumberById(appId);
    }

    public static String getAppNumberByEntityNumber(String entityNumber) {
        String bizAppNumber = EntityMetadataCache.getBizAppNumber((String)entityNumber);
        if (StringUtils.isBlank((CharSequence)bizAppNumber)) {
            String entityId = MetadataDao.getIdByNumber(entityNumber, MetaCategory.Entity);
            if (StringUtils.isBlank((CharSequence)entityId)) {
                return null;
            }
            String bizAppId = MetadataDao.getAppIdByFormId(entityId);
            if (StringUtils.isBlank((CharSequence)bizAppId)) {
                return null;
            }
            bizAppNumber = MetadataDao.getAppNumberByAppId(bizAppId);
            if (StringUtils.isNotBlank((CharSequence)bizAppNumber)) {
                EntityMetadataCache.putBizAppNumber((String)entityNumber, (String)bizAppNumber);
            }
        }
        return bizAppNumber;
    }

    public static AppInfo getAppInfo(String appId) {
        String sql = String.format("select FType,FNumber,FBizCloudId from %s where FId = ? ", T_META_BIZAPP);
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)appId)};
        ResultSetHandler<AppInfo> action = new ResultSetHandler<AppInfo>(){

            public AppInfo handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    AppInfo appInfo = new AppInfo();
                    appInfo.setType(rs.getString(1));
                    appInfo.setNumber(rs.getString(2));
                    appInfo.setCloudId(rs.getString(3));
                    return appInfo;
                }
                return null;
            }
        };
        return (AppInfo)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static AppInfo getMasterAppInfo(String appId) {
        return AppReader.getMasterAppInfo(appId);
    }

    public static String getAppIdByFormId(String formId) {
        String sql = String.format("select FBizAppId from %s where FFormId = ? ", "t_meta_bizunitrelform");
        Object[] params = new SqlParameter[]{new SqlParameter(":FBizAppId", 12, (Object)formId)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static String getAppIdFromUnitrel(String formId) {
        String sql = String.format("select FBIZAPPID from %s where FFORMID = ? ", T_META_BIZUNITREFROM);
        Object[] params = new SqlParameter[]{new SqlParameter(":FBIZAPPID", 12, (Object)formId)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static String getUnitIdFromUnitrel(String formId) {
        String sql = String.format("select FBIZUNITID from %s where FFORMID = ? ", T_META_BIZUNITREFROM);
        Object[] params = new SqlParameter[]{new SqlParameter(":FBIZUNITID", 12, (Object)formId)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    @Deprecated
    public static void deployScript(String content) {
        MetadataDao.deployScript(content, null, null);
    }

    public static void deployScript(String content, String bizUnitid, String bizAppid) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployScript deployNew = (DeployScript)serializer.deserializeFromString(content, null);
        List<DynamicObject> designDatas = deployNew.getScripts();
        try (TXHandle h = TX.required();){
            try {
                if (designDatas.size() > 0) {
                    Object[] pks = new Object[designDatas.size()];
                    int i = 0;
                    for (DynamicObject o : designDatas) {
                        if (StringUtils.isNotEmpty((CharSequence)bizUnitid) && StringUtils.isNotEmpty((CharSequence)bizAppid)) {
                            o.set("bizunitid", (Object)bizUnitid);
                            o.set("bizappid", (Object)bizAppid);
                        }
                        pks[i] = o.get("id");
                        o.getDataEntityState().setDirty(true);
                        ++i;
                    }
                    BusinessDataWriter.delete((IDataEntityType)designDatas.get(0).getDataEntityType(), (Object[])pks);
                    BusinessDataWriter.save((IDataEntityType)designDatas.get(0).getDataEntityType(), (Object[])designDatas.toArray());
                }
            }
            catch (Throwable e) {
                h.markRollback();
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deployScript")});
            }
        }
        for (DynamicObject o : designDatas) {
            MetaCacheUtils.removeDistributeCache(o.getString(LOWER_CASE_NUMBER));
            String className = o.getString("classname");
            if (!StringUtils.isNotBlank((CharSequence)className)) continue;
            Date modifyDate = o.getDate("modifydate");
            long version = System.currentTimeMillis();
            if (modifyDate != null) {
                try {
                    version = dateFormat.parse(dateFormat.format(modifyDate)).getTime();
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            ScriptVersionManager.setVersion((String)className, (String)String.valueOf(version), null);
        }
    }

    @Deprecated
    public static void deployCard(String content) {
        MetadataDao.deployCard(content, null, null);
    }

    public static void deployCard(String content, String bizUnitid, String bizAppid) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployCard.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployCard deployNew = (DeployCard)serializer.deserializeFromString(content, null);
        List<DynamicObject> designDatas = deployNew.getCards();
        try (TXHandle h = TX.required();){
            try {
                if (designDatas.size() > 0) {
                    Object[] pks = new Object[designDatas.size()];
                    int i = 0;
                    for (DynamicObject o : designDatas) {
                        if (StringUtils.isNotEmpty((CharSequence)bizUnitid) && StringUtils.isNotEmpty((CharSequence)bizAppid)) {
                            o.set("bizunitid", (Object)bizUnitid);
                            o.set("appid", (Object)bizAppid);
                        }
                        pks[i] = o.get("id");
                        o.getDataEntityState().setDirty(true);
                        DynamicObjectCollection multilangCols = o.getDynamicObjectCollection("multilanguagetext");
                        if (multilangCols != null) {
                            for (DynamicObject multilang : multilangCols) {
                                multilang.getDataEntityState().setDirty(true);
                            }
                        }
                        ++i;
                    }
                    BusinessDataWriter.delete((IDataEntityType)designDatas.get(0).getDataEntityType(), (Object[])pks);
                    BusinessDataWriter.save((IDataEntityType)designDatas.get(0).getDataEntityType(), (Object[])designDatas.toArray());
                }
            }
            catch (Throwable e) {
                h.markRollback();
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deployCard")});
            }
        }
    }

    @Deprecated
    public static void deploySchema(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeploySchema.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeploySchema deployNew = (DeploySchema)serializer.deserializeFromString(content, null);
        List<DynamicObject> designDatas = deployNew.getSchemas();
        try (TXHandle h = TX.required();){
            try {
                if (designDatas.size() > 0) {
                    Object[] pks = new Object[designDatas.size()];
                    int i = 0;
                    for (DynamicObject o : designDatas) {
                        pks[i] = o.get("id");
                        o.getDataEntityState().setDirty(true);
                        DynamicObjectCollection multilangCols = o.getDynamicObjectCollection("multilanguagetext");
                        if (multilangCols != null) {
                            for (DynamicObject multilang : multilangCols) {
                                multilang.getDataEntityState().setDirty(true);
                            }
                        }
                        ++i;
                    }
                    BusinessDataWriter.delete((IDataEntityType)designDatas.get(0).getDataEntityType(), (Object[])pks);
                    BusinessDataWriter.save((IDataEntityType)designDatas.get(0).getDataEntityType(), (Object[])designDatas.toArray());
                }
            }
            catch (Throwable e) {
                h.markRollback();
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deploySchema")});
            }
        }
    }

    @Deprecated
    public static List<String> deployMetadata(String content) {
        return MetadataDao.deployMetadata(content, null, null);
    }

    public static List<String> deployMetadata(String content, String bizUnitid, String bizAppid) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
        String id = MetadataDao.deployMetadata(deployNew, bizUnitid, bizAppid);
        ArrayList<String> list = new ArrayList<String>();
        list.add(id);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deployMetadata(DeployMetadata deployNew, String bizUnitid, String bizAppid) {
        block41: {
            String formId = deployNew.getId();
            try (DLock lock = DLock.create((String)("/MetadataDao/deployMetadata/" + RequestContext.get().getAccountId() + "_" + formId.replace("/", "aaaaaa"))).fastMode();){
                try {
                    if (lock.tryLock()) {
                        List<AbstractDesignMeta> designDatas = deployNew.getDesignMetas();
                        try (TXHandle h = TX.requiresNew();){
                            try {
                                IDataEntityType metadataType;
                                if (!deployNew.isMultilanguage()) {
                                    if (StringUtils.isBlank((CharSequence)bizUnitid)) {
                                        bizUnitid = deployNew.getBizunitId();
                                    }
                                    if (StringUtils.isBlank((CharSequence)bizAppid)) {
                                        bizAppid = deployNew.getBizappId();
                                    }
                                    if (StringUtils.isNotEmpty((CharSequence)bizUnitid) && StringUtils.isNotEmpty((CharSequence)bizAppid)) {
                                        MetadataDao.insertPageIntoDevportal(formId, bizUnitid, bizAppid);
                                        for (AbstractDesignMeta dmeta : designDatas) {
                                            if (dmeta == null || !(dmeta instanceof DesignFormMeta) && !(dmeta instanceof DesignEntityMeta)) continue;
                                            ((DesignMeta)dmeta).setBizappId(bizAppid);
                                        }
                                    }
                                }
                                for (AbstractDesignMeta dmeta : designDatas) {
                                    dmeta.deployMetadata();
                                    metadataType = MetadataDao.getDataEntityType(dmeta.getClass());
                                    if (dmeta instanceof DesignMetaL) {
                                        MetadataWriter.delFormMetadataLang((DesignMetaL)dmeta);
                                        continue;
                                    }
                                    if (dmeta instanceof DesignMeta && ((DesignMeta)dmeta).getSubSysId() == null) {
                                        ((DesignMeta)dmeta).setSubSysId(0);
                                    }
                                    BusinessDataWriter.delete((IDataEntityType)metadataType, (Object[])new Object[]{dmeta.getId()});
                                }
                                for (AbstractDesignMeta dmeta : designDatas) {
                                    metadataType = MetadataDao.getDataEntityType(dmeta.getClass());
                                    BusinessDataWriter.save((IDataEntityType)metadataType, (Object[])new Object[]{dmeta});
                                }
                                break block41;
                            }
                            catch (Throwable e) {
                                h.markRollback();
                                if (e instanceof KDException) {
                                    throw (KDException)e;
                                }
                                if (e instanceof OrmException) {
                                    throw (OrmException)e;
                                }
                                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "DeployMetadata")});
                            }
                        }
                    }
                    lock.lock();
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return deployNew.getMasterId() == null ? deployNew.getId() : deployNew.getMasterId();
    }

    @Deprecated
    public static List<String> deployMetadata(String content, String bizUnitid) {
        return MetadataDao.deployMetadata(content, bizUnitid, null);
    }

    @Deprecated
    public static List<String> deployAppMetadata(String content) {
        return MetadataDao.deployAppMetadata(content, null);
    }

    public static List<String> deployAppMetadata(String content, String bizCloudId) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployAppMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployAppMetadata deployNew = (DeployAppMetadata)serializer.deserializeFromString(content, null);
        String masterId = MetadataDao.deployAppMetadata(deployNew, bizCloudId);
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(masterId);
        return appIds;
    }

    public static String deployAppMetadata(DeployAppMetadata deployNew, String bizCloudId) {
        List<AbstractDesignMeta> designDatas = deployNew.getDesignMetas();
        try (TXHandle h = TX.required();){
            try {
                IDataEntityType metadataType;
                for (AbstractDesignMeta dmeta : designDatas) {
                    metadataType = MetadataDao.getDataEntityType(dmeta.getClass());
                    if (dmeta instanceof DesignMetaL) {
                        MetadataWriter.delFormMetadataLang((DesignMetaL)dmeta);
                        continue;
                    }
                    BusinessDataWriter.delete((IDataEntityType)metadataType, (Object[])new Object[]{dmeta.getId()});
                }
                for (AbstractDesignMeta dmeta : designDatas) {
                    if (dmeta instanceof DesignAppMeta) {
                        DesignAppMeta desianAppMeta = (DesignAppMeta)dmeta;
                        if (StringUtils.isNotEmpty((CharSequence)bizCloudId)) {
                            desianAppMeta.setBizCloudID(bizCloudId);
                        }
                        if (desianAppMeta.getIndustryId() == null) {
                            desianAppMeta.setIndustryId(0L);
                        }
                        IDataEntityType metadataType2 = MetadataDao.getDataEntityType(dmeta.getClass());
                        BusinessDataWriter.save((IDataEntityType)metadataType2, (Object[])new Object[]{desianAppMeta});
                        continue;
                    }
                    metadataType = MetadataDao.getDataEntityType(dmeta.getClass());
                    BusinessDataWriter.save((IDataEntityType)metadataType, (Object[])new Object[]{dmeta});
                }
            }
            catch (OrmException e) {
                h.markRollback();
                throw e;
            }
            catch (Throwable e) {
                h.markRollback();
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "DeployAppMetadata")});
            }
        }
        String id = deployNew.getMasterId() == null ? deployNew.getId() : deployNew.getMasterId();
        MetadataDao.cleanAppCache(deployNew.getId(), id);
        return id;
    }

    public static Map<String, Long> getMetaVersion(String appNumber) {
        String sql = "select a.FID, a.FVERSION from T_META_FORMDESIGN a inner join T_META_BIZAPP b on a.FBIZAPPID = b.FID where b.FNUMBER=? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)appNumber)};
        ResultSetHandler<Map<String, Long>> action = new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws Exception {
                HashMap<String, Long> map = new HashMap<String, Long>(16);
                while (rs.next()) {
                    map.put(rs.getString("FID"), rs.getLong("FVERSION"));
                }
                return map;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static Map<String, Long> getMetaLVersion(String appNumber, String localeId) {
        String sql = "select a.FID,c.FVERSION from T_META_FORMDESIGN a inner join T_META_BIZAPP b on a.FBIZAPPID = b.FID inner join T_META_FORMDESIGN_L c on a.fid = c.fid where b.FNUMBER=? and c.FLOCALEID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)appNumber), new SqlParameter(":FLOCALEID", 12, (Object)localeId)};
        ResultSetHandler<Map<String, Long>> action = new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws Exception {
                HashMap<String, Long> map = new HashMap<String, Long>(16);
                while (rs.next()) {
                    map.put(rs.getString("FID"), rs.getLong("FVERSION"));
                }
                return map;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static void clearExtendCache(List<String> extendFormIds) {
        if (null == extendFormIds || extendFormIds.isEmpty()) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FId, Fnumber, FModelType, FType, FMasterId from t_meta_formdesign WHERE FType='2' and ", new Object[0]).appendIn("FId", extendFormIds.toArray());
        List<BuildFormDesignMeta> formDesignMetas = MetadataDao.queryBuildFormDesignMeta(sqlBuilder);
        if (null == formDesignMetas || formDesignMetas.isEmpty()) {
            return;
        }
        MetadataDao.clearCache(formDesignMetas);
    }

    public static void clearSubRuntimeMeta(List<String> formIds) {
        List<BuildFormDesignMeta> formDesignMetas = MetadataDao.getRebuildFormDesignMeta(formIds);
        ArrayList<String> delFormIds = new ArrayList<String>();
        for (int i = 0; i < formDesignMetas.size(); ++i) {
            BuildFormDesignMeta meta = formDesignMetas.get(i);
            if (meta.getDevType().compareTo("3") == 0) {
                delFormIds.add(meta.getId());
                continue;
            }
            if (formIds.contains(meta.getId())) continue;
            MetadataDao.rebuildRuntimeMetaById(meta.getId());
        }
        MetadataDao.delRuntimeMeta(delFormIds.toArray(new String[0]));
        MetadataDao.clearCache(formDesignMetas);
    }

    public static void cleanAllAppMetadataCache() {
        String accountId = CacheKeyUtil.getAcctId();
        DistributeSessionlessCache cache = MetadataDao.getCache();
        cache.remove(MetadataDao.getCacheKey(APP_META_DATA, accountId));
        DataEntityCacheManager appCacheManager = new DataEntityCacheManager(T_META_BIZAPP);
        appCacheManager.removeByDt();
        Map<String, String> apps = AppReader.getAllOriAppNumbers();
        if (apps != null && apps.size() > 0) {
            String[] numbers = apps.values().toArray(new String[apps.size()]);
            MetaCacheUtils.removeAppMetaDistributeCache(numbers);
            AppMetadataCache.removeAppmetaLocalCache((String[])numbers);
        }
        AppMetadataCache.removeCache();
        AppReader.cleanAllAppNumberAndIdCache();
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        permService.clearAllUserAppCache();
        RunModeService runModeService = (RunModeService)ServiceFactory.getService(RunModeService.class);
        runModeService.removeCache("all");
    }

    public static void cleanPreinsdataCache() {
        DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_meta_bizcloud");
        cacheManager.removeByDt();
    }

    public static String getAllPortalAppCache() {
        DistributeSessionlessCache cache = MetadataDao.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = RUNTIME_APP_META_DATA_ + accountId + "-portalapp";
        String portalAppInfo = (String)cache.get(MetadataDao.getCacheKey(APP_META_DATA, accountId), key);
        return portalAppInfo;
    }

    public static void putAllPortalAppCache(String portalAppInfo) {
        DistributeSessionlessCache cache = MetadataDao.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = RUNTIME_APP_META_DATA_ + accountId + "-portalapp";
        cache.put(MetadataDao.getCacheKey(APP_META_DATA, accountId), key, (Object)portalAppInfo);
    }

    public static void cleanAllPortalAppCache() {
        DistributeSessionlessCache cache = MetadataDao.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = RUNTIME_APP_META_DATA_ + accountId + "-portalapp";
        cache.remove(MetadataDao.getCacheKey(APP_META_DATA, accountId), key);
    }

    public static void cleanAppCache(String appId, String appMasterId) {
        String id = appMasterId;
        if (StringUtils.isBlank((CharSequence)id)) {
            id = appId;
        }
        String number = AppReader.getAppNumberById(id);
        MetadataDao.cleanAppCache(appId, appMasterId, number);
    }

    public static void cleanAppCache(String appId, String appMasterId, String appNumber) {
        String accountId = CacheKeyUtil.getAcctId();
        String prefixRuntime = RUNTIME_APP_META_DATA_ + accountId + "-";
        String prefixDesign = DESIGN_APP_META_DATA_ + accountId + "-";
        DistributeSessionlessCache cache = MetadataDao.getCache();
        String portalAllAppkey = RUNTIME_APP_META_DATA_ + accountId + "-portalapp";
        DataEntityCacheManager appCacheManager = new DataEntityCacheManager(T_META_BIZAPP);
        appCacheManager.removeByPrimaryKey(new Object[]{appId});
        cache.remove(MetadataDao.getCacheKey(APP_META_DATA, accountId), prefixDesign + appId);
        cache.remove(MetadataDao.getCacheKey(APP_META_DATA, accountId), portalAllAppkey);
        if (StringUtils.isNotEmpty((CharSequence)appMasterId)) {
            cache.remove(MetadataDao.getCacheKey(APP_META_DATA, accountId), prefixRuntime + appMasterId);
        } else {
            cache.remove(MetadataDao.getCacheKey(APP_META_DATA, accountId), prefixRuntime + appId);
        }
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        permService.clearAllUserAppCache();
        if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
            MetaCacheUtils.removeAppmetaDistributeCache(appNumber);
            AppMetadataCache.removeAppmetaLocalCache((String)appNumber);
            RunModeService runModeService = (RunModeService)ServiceFactory.getService(RunModeService.class);
            runModeService.removeCache("all");
        }
        AppMetadataCache.removeCache();
        AppReader.removeAppNumberAndIdCache(appId, appNumber);
    }

    public static String getAppCacheById(String appId, boolean runtime) {
        DistributeSessionlessCache cache = MetadataDao.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String prefix = DESIGN_APP_META_DATA_ + accountId + "-";
        if (runtime) {
            prefix = RUNTIME_APP_META_DATA_ + accountId + "-";
        }
        String appXml = (String)cache.get(MetadataDao.getCacheKey(APP_META_DATA, accountId), prefix + appId);
        return appXml;
    }

    public static void putAppCache(String appId, String appXml, boolean runtime) {
        DistributeSessionlessCache cache = MetadataDao.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String prefix = DESIGN_APP_META_DATA_ + accountId + "-";
        if (runtime) {
            prefix = RUNTIME_APP_META_DATA_ + accountId + "-";
        }
        cache.put(MetadataDao.getCacheKey(APP_META_DATA, accountId), prefix + appId, (Object)appXml);
    }

    public static List<String> getRelationApps(String id) {
        String sql = "SELECT FID from T_Meta_BizApp WHERE FInheritPath like ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FInheritPath", 12, (Object)("%" + id + "%"))};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FId"));
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static List<String> getSubApps(String id) {
        String sql = "SELECT FID from T_Meta_BizApp WHERE FPARENTID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FPARENTID", 12, (Object)id)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FId"));
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static Map<String, JSONObject> getRelationAppsInfo(String soureId) {
        String sql = "SELECT FID,FVERSION,FIMAGE from T_Meta_BizApp WHERE FInheritPath like ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FInheritPath", 12, (Object)("%" + soureId + "%"))};
        ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

            public Map<String, JSONObject> handle(ResultSet rs) throws Exception {
                LinkedHashMap<String, JSONObject> objs = null;
                while (rs.next()) {
                    String image;
                    String version;
                    JSONObject obj = new JSONObject();
                    String id = rs.getString("FID");
                    if (StringUtils.isNotEmpty((CharSequence)id)) {
                        obj.put("id", (Object)id);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(version = rs.getString("FVERSION")))) {
                        obj.put("version", (Object)version);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(image = rs.getString("FIMAGE")))) {
                        obj.put("image", (Object)image);
                    }
                    if (objs == null) {
                        objs = new LinkedHashMap<String, JSONObject>();
                    }
                    objs.put(id, obj);
                }
                return objs;
            }
        };
        Map rt = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        if (rt != null) {
            StringBuilder ids = new StringBuilder();
            for (String id : rt.keySet()) {
                ids.append("'").append(id).append("',");
            }
            String langSql = String.format("SELECT FID,FLOCALEID,FNAME,FDESCRIPTION FROM %s_L WHERE FID in (%s)", "T_Meta_BizApp", ids.substring(0, ids.length() - 1));
            ResultSetHandler callBackLangHanlder = rs -> {
                try {
                    while (rs.next()) {
                        String localeId = rs.getString("FLOCALEID");
                        String id = rs.getString("FID");
                        if (!StringUtils.isNotEmpty((CharSequence)localeId) || !StringUtils.isNotEmpty((CharSequence)id)) continue;
                        JSONObject sRet = (JSONObject)rt.get(id);
                        String name = rs.getString("FNAME");
                        if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                        LocaleString langObj = (LocaleString)sRet.get((Object)"name");
                        if (langObj != null) {
                            langObj.setItem(localeId, (Object)name);
                            continue;
                        }
                        langObj = new LocaleString(localeId, name);
                        sRet.put("name", (Object)langObj);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
                }
                return null;
            };
            DB.query((DBRoute)DBRoute.meta, (String)langSql, null, (ResultSetHandler)callBackLangHanlder);
        }
        return rt;
    }

    private static void insertPageIntoDevportal(String formid, String bizUnitId, String bizAppId) {
        ArrayList<SqlObject> list = new ArrayList<SqlObject>();
        String delSql = String.format("delete from T_META_BIZUNITRELFORM where FFORMID = '%s';", formid);
        list.add(new SqlObject(delSql, null));
        String insertSql = String.format("insert into T_META_BIZUNITRELFORM (FID,FBIZAPPID,FBIZUNITID,FFORMID) values ('%s','%s','%s','%s');", DB.genStringId((String)T_META_BIZUNITREFROM), bizAppId, bizUnitId, formid);
        list.add(new SqlObject(insertSql, null));
        if (list.size() > 0) {
            try {
                for (SqlObject sqlObject : list) {
                    DB.execute((DBRoute)DBRoute.meta, (String)sqlObject.getSql(), null);
                }
            }
            catch (Throwable e) {
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "DeployMetadata")});
            }
        }
    }

    public static List<DeployFile> getScriptDeployFile(String ... ids) {
        DynamicObject[] objects;
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        for (DynamicObject o : objects = BusinessDataReader.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((URL)DeployScriptBinder.class.getResource("/SystemEntity/ScriptEntity.xml")), (Boolean)false)) {
            DeployScript deploy = new DeployScript();
            String enginetype = o.getString("enginetype");
            String suffix = "1".equals(enginetype) ? ".ts" : ".ks";
            deploy.getScripts().add(o);
            files.add(deploy.toDeployFile(o.getString(UPPER_CASE_NUMBER).toLowerCase() + suffix));
        }
        return files;
    }

    public static List<DeployFile> getCardDeployFile(String ... ids) {
        DynamicObject[] objects;
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        for (DynamicObject o : objects = BusinessDataReader.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((URL)DeployCardBinder.class.getResource("/SystemEntity/CardEntity.xml")), (Boolean)false)) {
            DeployCard deploy = new DeployCard();
            deploy.getCards().add(o);
            files.add(deploy.toDeployFile(o.getString(UPPER_CASE_NUMBER).toLowerCase() + ".card"));
        }
        return files;
    }

    public static List<DeployFile> getSchemaDeployFile(String ... ids) {
        DynamicObject[] objects;
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        for (DynamicObject o : objects = BusinessDataReader.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((URL)DeploySchemaBinder.class.getResource("/SystemEntity/SchemaEntity.xml")), (Boolean)false)) {
            DeploySchema deploy = new DeploySchema();
            deploy.getSchemas().add(o);
            files.add(deploy.toDeployFile(o.getString(UPPER_CASE_NUMBER).toLowerCase() + ".sch"));
        }
        return files;
    }

    public static List<DeployFile> getSceneDeployFile(String ... ids) {
        DynamicObject[] objects;
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        for (DynamicObject o : objects = BusinessDataReader.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((URL)DeployScriptBinder.class.getResource("/SystemEntity/SceneEntity.xml")), (Boolean)false)) {
            DeployScript deploy = new DeployScript();
            deploy.getScripts().add(o);
            files.add(deploy.toDeployFile(o.getString(UPPER_CASE_NUMBER).toLowerCase() + "_scene.ks"));
        }
        return files;
    }

    public static List<DeployFile> getConvertRuleDeployFile(String id) {
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        DesignConvertRuleMeta designMeta = (DesignConvertRuleMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignConvertRuleMeta.class), (Boolean)false);
        DeployMetadata deploy = new DeployMetadata();
        deploy.getDesignMetas().add(designMeta);
        String fileName = String.format("%s_%s_%s", designMeta.getSourceEntityNumber(), designMeta.getTargetEntityNumber(), id);
        deploy.setId(id);
        files.add(deploy.toDeployFile(fileName + ".cr"));
        List<Object> designFormMetaLs = MetadataDao.getLocale(OrmUtils.getDataEntityType(DesignConvertRuleMetaL.class), id);
        for (Object fm : designFormMetaLs) {
            DesignMetaL fmL = (DesignMetaL)fm;
            deploy = new DeployMetadata();
            deploy.setId(id);
            deploy.getDesignMetas().add(fmL);
            files.add(deploy.toDeployFile(fileName + "." + fmL.getLocaleId() + ".crx"));
        }
        return files;
    }

    public static List<DeployFile> getWriteBackRuleDeployFile(String id) {
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        DesignWriteBackRuleMeta designMeta = (DesignWriteBackRuleMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class), (Boolean)false);
        DeployMetadata deploy = new DeployMetadata();
        deploy.getDesignMetas().add(designMeta);
        String fileName = String.format("%s_%s_%s", designMeta.getSourceEntityNumber(), designMeta.getTargetEntityNumber(), id);
        deploy.setId(id);
        files.add(deploy.toDeployFile(fileName + ".wb"));
        List<Object> designFormMetaLs = MetadataDao.getLocale(OrmUtils.getDataEntityType(DesignWriteBackRuleMetaL.class), id);
        for (Object fm : designFormMetaLs) {
            DesignMetaL fmL = (DesignMetaL)fm;
            deploy = new DeployMetadata();
            deploy.setId(id);
            deploy.getDesignMetas().add(fmL);
            files.add(deploy.toDeployFile(fileName + "." + fmL.getLocaleId() + ".wbx"));
        }
        return files;
    }

    public static List<DeployFile> getCustMetadataDeployFile(String id, IDataEntityType designMetaType, IDataEntityType designMetaType_Lang, String fileSuffix) {
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        AbstractDesignMeta designMeta = (AbstractDesignMeta)BusinessDataReader.read((Object)id, (IDataEntityType)designMetaType, (Boolean)false);
        DeployMetadata deploy = new DeployMetadata();
        deploy.getDesignMetas().add(designMeta);
        String fileName = designMeta.getNumber();
        deploy.setId(id);
        files.add(deploy.toDeployFile(fileName + "." + fileSuffix));
        if (designMetaType_Lang != null) {
            List<Object> designFormMetaLs = MetadataDao.getLocale(designMetaType_Lang, id);
            for (Object fm : designFormMetaLs) {
                DesignMetaL fmL = (DesignMetaL)fm;
                deploy = new DeployMetadata();
                deploy.setId(id);
                deploy.getDesignMetas().add(fmL);
                files.add(deploy.toDeployFile(fileName + "." + fmL.getLocaleId() + "." + fileSuffix + "x"));
            }
        }
        return files;
    }

    public static List<DeployFile> getFormDeployFile(String id) {
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        DesignFormMeta designMeta = (DesignFormMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
        DeployMetadata deploy = new DeployMetadata();
        deploy.setBizappId(MetadataDao.getAppIdFromUnitrel(id));
        deploy.setBizunitId(MetadataDao.getUnitIdFromUnitrel(id));
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designMeta);
        if (designMeta.getId().equals(designMeta.getEntityId())) {
            deploy.getDesignMetas().add((DesignEntityMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMeta.class), (Boolean)false));
        }
        String masterId = "2".equals(designMeta.getDevType()) ? designMeta.getMasterId() : id;
        deploy.setMasterId(masterId);
        deploy.setId(id);
        deploy.setVersion(designMeta.getVersion());
        DeployFile deployFile = deploy.toDeployFile(designMeta.getNumber() + ".dym");
        deployFile.setModelType(designMeta.getModelType());
        files.add(deployFile);
        List<Object> designFormMetaLs = MetadataDao.getLocale(OrmUtils.getDataEntityType(DesignFormMetaL.class), id);
        HashMap<String, DesignMetaL> designEntityMetaLMap = new HashMap<String, DesignMetaL>();
        if (designMeta.getId().equals(designMeta.getEntityId())) {
            List<Object> designEntityMetaLs = MetadataDao.getLocale(OrmUtils.getDataEntityType(DesignEntityMetaL.class), id);
            for (Object em : designEntityMetaLs) {
                DesignMetaL am = (DesignMetaL)em;
                designEntityMetaLMap.put(am.getId() + "." + am.getLocaleId(), am);
            }
        }
        for (Object fm : designFormMetaLs) {
            DesignMetaL fmL = (DesignMetaL)fm;
            deploy = new DeployMetadata();
            deploy.setMasterId(masterId);
            deploy.setId(id);
            deploy.setVersion(designMeta.getVersion());
            if (fmL instanceof DesignFormMetaL && ((DesignFormMetaL)fmL).getVersion() != 0L) {
                deploy.setVersion(((DesignFormMetaL)fmL).getVersion());
            }
            deploy.getDesignMetas().add(fmL);
            AbstractDesignMeta emL = (AbstractDesignMeta)designEntityMetaLMap.get(fmL.getId() + "." + fmL.getLocaleId());
            if (emL != null) {
                deploy.getDesignMetas().add(emL);
            }
            files.add(deploy.toDeployFile(designMeta.getNumber() + "." + fmL.getLocaleId() + ".dymx"));
        }
        return files;
    }

    public static List<DeployFile> getFormDeployFile(String id, String bizAppId, String unitId) {
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        DesignFormMeta designMeta = (DesignFormMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
        DeployMetadata deploy = new DeployMetadata();
        deploy.setBizappId(bizAppId);
        deploy.setBizunitId(unitId);
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designMeta);
        if (designMeta.getId().equals(designMeta.getEntityId())) {
            deploy.getDesignMetas().add((DesignEntityMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMeta.class), (Boolean)false));
        }
        String masterId = "2".equals(designMeta.getDevType()) ? designMeta.getMasterId() : id;
        deploy.setMasterId(masterId);
        deploy.setId(id);
        deploy.setVersion(designMeta.getVersion());
        DeployFile deployFile = deploy.toDeployFile(designMeta.getNumber() + ".dym");
        deployFile.setModelType(designMeta.getModelType());
        files.add(deployFile);
        List<Object> designFormMetaLs = MetadataDao.getLocale(OrmUtils.getDataEntityType(DesignFormMetaL.class), id);
        HashMap<String, DesignMetaL> designEntityMetaLMap = new HashMap<String, DesignMetaL>();
        if (designMeta.getId().equals(designMeta.getEntityId())) {
            List<Object> designEntityMetaLs = MetadataDao.getLocale(OrmUtils.getDataEntityType(DesignEntityMetaL.class), id);
            for (Object em : designEntityMetaLs) {
                DesignMetaL am = (DesignMetaL)em;
                designEntityMetaLMap.put(am.getId() + "." + am.getLocaleId(), am);
            }
        }
        for (Object fm : designFormMetaLs) {
            DesignMetaL fmL = (DesignMetaL)fm;
            deploy = new DeployMetadata();
            deploy.setMasterId(masterId);
            deploy.setId(id);
            deploy.setVersion(designMeta.getVersion());
            if (fmL instanceof DesignFormMetaL && ((DesignFormMetaL)fmL).getVersion() != 0L) {
                deploy.setVersion(((DesignFormMetaL)fmL).getVersion());
            }
            deploy.getDesignMetas().add(fmL);
            AbstractDesignMeta emL = (AbstractDesignMeta)designEntityMetaLMap.get(fmL.getId() + "." + fmL.getLocaleId());
            if (emL != null) {
                deploy.getDesignMetas().add(emL);
            }
            files.add(deploy.toDeployFile(designMeta.getNumber() + "." + fmL.getLocaleId() + ".dymx"));
        }
        return files;
    }

    private static List<Object> getLocale(final IDataEntityType designerMetaType, String id) {
        String tableName = designerMetaType.getAlias();
        ArrayList<String> fieldNames = new ArrayList<String>(10);
        for (ISimpleProperty property : designerMetaType.getProperties().getSimpleProperties(true)) {
            String fieldName = property.getAlias();
            if (!StringUtils.isNotBlank((CharSequence)fieldName)) continue;
            fieldNames.add(fieldName);
        }
        String sql = String.format("select %s from %s where FId=? ", StringUtils.join((Object[])fieldNames.toArray(), (String)","), tableName);
        Object[] params = new SqlParameter[]{designerMetaType.getPrimaryKey() != null && designerMetaType.getPrimaryKey().getDbType() == -5 ? new SqlParameter(":FId", -5, (Object)Long.valueOf(id)) : new SqlParameter(":FId", 12, (Object)id)};
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> objs = new ArrayList<Object>(10);
                while (rs.next()) {
                    Object obj = designerMetaType.createInstance();
                    for (ISimpleProperty property : designerMetaType.getProperties().getSimpleProperties(true)) {
                        if (property.getPropertyType() == String.class) {
                            property.setValue(obj, (Object)rs.getString(property.getAlias()));
                            continue;
                        }
                        if (property.getPropertyType() == Long.TYPE) {
                            property.setValue(obj, (Object)rs.getLong(property.getAlias()));
                            continue;
                        }
                        property.setValue(obj, rs.getObject(property.getAlias()));
                    }
                    objs.add(obj);
                }
                return objs;
            }
        };
        return (List)DB.query((DBRoute)new DBRoute(designerMetaType.getDBRouteKey()), (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    @Deprecated
    public static Map<String, String> getAllFormNumbers() {
        String sql = "SELECT Fnumber, FModelType from t_meta_formdesign WHERE FType='0' order by fnumber ";
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> list = new HashMap<String, String>(16);
                while (rs.next()) {
                    list.put(rs.getString(MetadataDao.FNUMBER_NO_COMMENT), rs.getString("FModelType"));
                }
                return list;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
    }

    @Deprecated
    public static List<BuildFormDesignMeta> getRebuildFormDesignMeta(List<String> formIds) {
        int i;
        if (formIds == null || formIds.isEmpty()) {
            return new ArrayList<BuildFormDesignMeta>();
        }
        int listsize = formIds.size();
        Object[] dbParams = new Object[listsize];
        dbParams[0] = formIds.get(0);
        for (int i2 = 1; i2 < listsize; ++i2) {
            dbParams[i2] = formIds.get(i2);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select FId, Fnumber, FModelType, FType, FMasterId from t_meta_formdesign where", new Object[0]).appendIn("FId", dbParams);
        List<BuildFormDesignMeta> originalMetaList = MetadataDao.queryBuildFormDesignMeta(sqlBuilder);
        ArrayList<String> extendFormIds = new ArrayList<String>();
        HashMap<String, BuildFormDesignMeta> metas = new HashMap<String, BuildFormDesignMeta>();
        for (BuildFormDesignMeta meta : originalMetaList) {
            if ("2".equals(meta.getDevType())) {
                extendFormIds.add(meta.getMasterId());
                continue;
            }
            metas.put(meta.getNumber(), meta);
        }
        SqlBuilder sqlInheritMeta = new SqlBuilder();
        sqlInheritMeta.append("select c.FId, c.Fnumber, c.FModelType, c.FType, c.FMasterId from t_meta_formdesign a inner join t_meta_formdesign c on charindex(a.fid, c.finheritpath) > 0 where", new Object[0]).appendIn("a.FId", dbParams);
        List<BuildFormDesignMeta> inheritMetalist = MetadataDao.queryBuildFormDesignMeta(sqlInheritMeta);
        int size = inheritMetalist.size();
        Map map = new HashMap();
        if (size > 0) {
            Object[] entityInfoParams = new Object[size];
            entityInfoParams[0] = inheritMetalist.get(0).getNumber();
            for (i = 1; i < size; ++i) {
                entityInfoParams[i] = inheritMetalist.get(i).getNumber();
            }
            sqlInheritMeta = new SqlBuilder();
            sqlInheritMeta.append("select FId, FTableName from T_META_MAINENTITYINFO where ", new Object[0]).appendIn("FId", entityInfoParams);
            map = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlInheritMeta, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    while (rs.next()) {
                        map.put(rs.getString("FId"), rs.getString("FTableName"));
                    }
                    return map;
                }
            });
        }
        for (BuildFormDesignMeta meta : inheritMetalist) {
            if ("2".equals(meta.getDevType())) {
                extendFormIds.add(meta.getMasterId());
                continue;
            }
            if (metas.containsKey(meta.getNumber())) continue;
            meta.setDevType("1");
            metas.put(meta.getNumber(), meta);
            String tableName = (String)map.get(meta.getNumber());
            if (StringUtils.isBlank((CharSequence)tableName)) continue;
            meta.setTableName(tableName);
        }
        if (extendFormIds.size() > 0) {
            Object[] params = new Object[extendFormIds.size()];
            params[0] = extendFormIds.get(0);
            for (i = 1; i < extendFormIds.size(); ++i) {
                params[i] = extendFormIds.get(i);
            }
            SqlBuilder sqlInherit = new SqlBuilder();
            sqlInherit.append("select FId, Fnumber, FModelType, FType, FMasterId from t_meta_formdesign where", new Object[0]).appendIn("FId", params);
            List<BuildFormDesignMeta> extendMetaList = MetadataDao.queryBuildFormDesignMeta(sqlInherit);
            for (BuildFormDesignMeta meta : extendMetaList) {
                metas.put(meta.getNumber(), meta);
            }
        }
        if (metas.size() > 0) {
            MetadataDao.addRefereceMeta(metas, dbParams, originalMetaList);
        }
        ArrayList<BuildFormDesignMeta> buildFormMetas = new ArrayList<BuildFormDesignMeta>();
        buildFormMetas.addAll(metas.values());
        return buildFormMetas;
    }

    private static void addRefereceMeta(Map<String, BuildFormDesignMeta> metas, Object[] dbParams, List<BuildFormDesignMeta> originalMetaList) {
        if (metas == null || metas.isEmpty()) {
            return;
        }
        ArrayList<BuildFormDesignMeta> list = new ArrayList<BuildFormDesignMeta>();
        list.addAll(metas.values());
        Object[] entityInfoParams = new Object[list.size()];
        if (!list.isEmpty()) {
            entityInfoParams[0] = ((BuildFormDesignMeta)list.get(0)).getId();
            for (int i = 1; i < list.size(); ++i) {
                entityInfoParams[i] = ((BuildFormDesignMeta)list.get(i)).getId();
            }
            SqlBuilder sb = new SqlBuilder();
            sb.append("select a.FId, a.Fnumber, a.FModelType, a.FType, a.FMasterId, b.FREFENTITYID, b.FREFOBJECTTYPEID from t_meta_formdesign a  inner join t_meta_objecttyperef b   on b.fentityid = a.fid where ", new Object[0]).appendIn("b.frefentityid", dbParams);
            List refList = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                    ArrayList<Map<String, Object>> refList = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>(16);
                        String modelType = rs.getString(3);
                        if ("PrintModel".equals(modelType)) continue;
                        String id = rs.getString(1);
                        String number = rs.getString(2);
                        String type = rs.getString(4);
                        String masterId = rs.getString(5);
                        String refEntityId = rs.getString(6);
                        String refObjectTypeId = rs.getString(7);
                        map.put("id", id);
                        map.put(MetadataDao.LOWER_CASE_NUMBER, number);
                        map.put("modelType", modelType);
                        map.put("type", type);
                        map.put("masterId", masterId);
                        map.put("refEntityId", refEntityId);
                        map.put("refObjectTypeId", refObjectTypeId);
                        refList.add(map);
                    }
                    return refList;
                }
            });
            HashMap<String, BuildFormDesignMeta> originalMap = new HashMap<String, BuildFormDesignMeta>(originalMetaList.size());
            for (BuildFormDesignMeta meta : originalMetaList) {
                originalMap.put(meta.getId(), meta);
            }
            for (Map ref : refList) {
                String originalNumber;
                String refNumber = (String)ref.get("refObjectTypeId");
                String refEntityId = (String)ref.get("refEntityId");
                String refFormId = (String)ref.get("id");
                BuildFormDesignMeta orginMeta = (BuildFormDesignMeta)originalMap.get(refEntityId);
                if (orginMeta == null || (originalNumber = orginMeta.getNumber()).equalsIgnoreCase(refNumber)) continue;
                BuildFormDesignMeta meta = new BuildFormDesignMeta();
                meta.setId(refFormId);
                meta.setNumber((String)ref.get(LOWER_CASE_NUMBER));
                meta.setModelType((String)ref.get("modelType"));
                meta.setDevType((String)ref.get("type"));
                meta.setMasterId((String)ref.get("masterId"));
                meta.setDevType("3");
                metas.put(meta.getNumber(), meta);
            }
        }
    }

    public static void clearCache(List<BuildFormDesignMeta> metas) {
        for (BuildFormDesignMeta meta : metas) {
            MetaCacheUtils.removeDistributeCache(meta.getNumber());
            MetaCacheUtils.removeDistributeCache(meta.getId(), "entitynumber", 0);
            EntityMetadataCache.removeDataEntityTypeLocalCache((String)meta.getNumber());
            if (!StringUtils.isBlank((CharSequence)meta.getTableName())) {
                DataEntityCacheManager cm = new DataEntityCacheManager(meta.getTableName());
                cm.removeByDt();
            }
            String key = meta.getNumber();
            String mobKey = String.format("%s_mob", key);
            String filterKey = String.format("%s_filter", key);
            MetaCacheUtils.removeDistributeCache(key, mobKey, filterKey);
            MetaCacheUtils.removeDistributeCache(meta.getId(), "formnumber", 0);
            FormMetadataCache.removeLocalCache((String)key);
            FormMetadataCache.removeLocalCache((String)mobKey);
            FormMetadataCache.removeLocalCache((String)filterKey);
            String cacheVerKey = CacheType.getCacheVersionKey(key);
            MetaCacheUtils.putDistributeCache(key, cacheVerKey, 0, String.valueOf(new Date().getTime()));
        }
    }

    public static List<BuildFormDesignMeta> getAllRebuildFormDesignMeta() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FId, Fnumber, FModelType, FType, FMasterId from t_meta_formdesign WHERE FType !='2' order by fnumber ", new Object[0]);
        return MetadataDao.queryBuildFormDesignMeta(sqlBuilder);
    }

    private static List<BuildFormDesignMeta> queryBuildFormDesignMeta(SqlBuilder sqlBuilder) {
        ResultSetHandler<List<BuildFormDesignMeta>> action = new ResultSetHandler<List<BuildFormDesignMeta>>(){

            public List<BuildFormDesignMeta> handle(ResultSet rs) throws Exception {
                ArrayList<BuildFormDesignMeta> list = new ArrayList<BuildFormDesignMeta>(10);
                while (rs.next()) {
                    String modelType = rs.getString("FModelType");
                    BuildFormDesignMeta meta = new BuildFormDesignMeta();
                    meta.setId(rs.getString("FId"));
                    meta.setNumber(rs.getString(MetadataDao.FNUMBER_NO_COMMENT));
                    meta.setModelType(modelType);
                    meta.setDevType(rs.getString("FType"));
                    meta.setMasterId(rs.getString("FMasterId"));
                    list.add(meta);
                }
                return list;
            }
        };
        List list = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return list;
    }

    public static List<String> getAllExts(List<String> types, String day) {
        String sqlPre = "SELECT Fnumber from t_meta_formdesign WHERE Ftype in (";
        String sqlDiff = "";
        Object[] params = null;
        if (StringUtils.isNotBlank((CharSequence)day) && StringUtils.isNotEmpty((CharSequence)day)) {
            sqlDiff = " and FCREATEDATE >= ? ";
            params = new SqlParameter[1];
            Date now = new Date();
            int days = Integer.parseInt(day);
            days = 0 - days;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(6, days);
            now = calendar.getTime();
            params[0] = new SqlParameter(":FCREATEDATE", 91, (Object)now);
        }
        String sqlEnd = ") and Fmodeltype in ('BaseFormModel','BillFormModel','MobileBillFormModel') " + sqlDiff + "order by fnumber";
        StringBuilder curTypes = new StringBuilder();
        for (int i = 0; i < types.size(); ++i) {
            curTypes.append("'").append(types.get(i)).append("',");
        }
        String sql = sqlPre + curTypes.toString().substring(0, curTypes.length() - 1) + sqlEnd;
        return MetadataDao.queryExts(sql, params);
    }

    private static List<String> queryExts(String sql, Object[] dbParams) {
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    String number = rs.getString(MetadataDao.FNUMBER_NO_COMMENT);
                    list.add(number);
                }
                return list;
            }
        };
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])dbParams, (ResultSetHandler)action);
        return list;
    }

    public static List<DeployFile> getCloudDeployFile(String id) {
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        DesignCloudMeta designCloudMeta = (DesignCloudMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignCloudMeta.class), (Boolean)false);
        DeployMetadata deploy = new DeployMetadata();
        deploy.setId(id);
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designCloudMeta);
        files.add(deploy.toDeployFile(designCloudMeta.getNumber().toLowerCase() + ".cld"));
        List<Object> designCloudMetaLs = MetadataDao.getCloudLocale(OrmUtils.getDataEntityType(DesignCloudMetaL.class), id);
        for (Object obj : designCloudMetaLs) {
            DesignCloudMetaL designCloudMeteaL = (DesignCloudMetaL)obj;
            deploy = new DeployMetadata();
            deploy.setId(id);
            deploy.getDesignMetas().add(designCloudMeteaL);
            files.add(deploy.toDeployFile(designCloudMeta.getNumber().toLowerCase() + "." + designCloudMeteaL.getLocaleId() + ".cldx"));
        }
        return files;
    }

    @Deprecated
    public static void deployCloudMetadata(String content) {
        MetadataDao.deployCloud(content);
    }

    public static void deployCloud(String content) {
        if (content.contains("DeployCloudMetadata")) {
            SAXReader reader = SAXReaderUtil.getSAXReader();
            StringReader strReader = new StringReader(content);
            try {
                Document doc = reader.read((Reader)strReader);
                String rooElementName = doc.getDocument().getRootElement().getName();
                if ("DeployCloudMetadata".equals(rooElementName)) {
                    return;
                }
            }
            catch (DocumentException ex) {
                throw new OrmException("Deserialize.DocumentException", ex.getMessage(), (Throwable)ex);
            }
        }
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
        List<AbstractDesignMeta> designDatas = deployNew.getDesignMetas();
        try (TXHandle h = TX.required();){
            try {
                for (AbstractDesignMeta dmeta : designDatas) {
                    IDataEntityType metadataType = MetadataDao.getDataEntityType(dmeta.getClass());
                    if (dmeta instanceof DesignCloudMetaL) {
                        MetadataWriter.delFormMetadataLang((DesignMetaL)dmeta);
                    } else {
                        BusinessDataWriter.delete((IDataEntityType)metadataType, (Object[])new Object[]{dmeta.getId()});
                    }
                    BusinessDataWriter.save((IDataEntityType)metadataType, (Object[])new Object[]{dmeta});
                }
            }
            catch (KDException e) {
                h.markRollback();
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "DeployAppMetadata")});
            }
            catch (OrmException e) {
                h.markRollback();
                throw e;
            }
        }
        MetadataDao.cleanPreinsdataCache();
        MetadataDao.cleanAllPortalAppCache();
    }

    public static List<DeployFile> getAppDeployFile(String id) {
        DesignAppMeta designMeta = (DesignAppMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignAppMeta.class), (Boolean)false);
        List<Object> designAppMetaLs = MetadataDao.getAppLocale(OrmUtils.getDataEntityType(DesignAppMetaL.class), id);
        return MetadataDao.getAppDeployFile(designMeta, designAppMetaLs);
    }

    public static List<DeployFile> getAppDeployFile(AppMetadata appMeta) {
        ArrayList<Object> designAppMetaLs = new ArrayList<Object>();
        DesignAppMeta designAppMeta = null;
        MetadataWriter writer = new MetadataWriter(appMeta.getModelType());
        List<AbstractDesignMeta> appDesigners = writer.convertToDesignMeta(appMeta);
        for (AbstractDesignMeta abstractDesignMeta : appDesigners) {
            if (abstractDesignMeta instanceof DesignAppMetaL) {
                designAppMetaLs.add(abstractDesignMeta);
                continue;
            }
            if (!(abstractDesignMeta instanceof DesignAppMeta)) continue;
            designAppMeta = (DesignAppMeta)abstractDesignMeta;
        }
        return MetadataDao.getAppDeployFile(designAppMeta, designAppMetaLs);
    }

    private static List<DeployFile> getAppDeployFile(DesignAppMeta designMeta, List<Object> designAppMetaLs) {
        if (designMeta == null) {
            log.warn("kd.bos.metadata.dao.MetadataDao.getAppDeployFile(DesignAppMeta,List<java.lang.Object>)\uff0cDesignAppMeta\u53c2\u6570\u4e3a\u7a7a");
            return new ArrayList<DeployFile>(0);
        }
        String id = designMeta.getId();
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        DeployAppMetadata deploy = new DeployAppMetadata();
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designMeta);
        String masterId = "2".equals(designMeta.getDevType()) ? designMeta.getMasterId() : id;
        deploy.setMasterId(masterId);
        deploy.setId(id);
        deploy.setVersion(designMeta.getVersion());
        files.add(deploy.toDeployFile(designMeta.getNumber().toLowerCase() + ".app"));
        HashMap designEntityMetaLMap = new HashMap();
        for (Object fm : designAppMetaLs) {
            DesignMetaL fmL = (DesignMetaL)fm;
            deploy = new DeployAppMetadata();
            deploy.setMasterId(masterId);
            deploy.setId(id);
            deploy.setVersion(designMeta.getVersion());
            deploy.getDesignMetas().add(fmL);
            AbstractDesignMeta emL = (AbstractDesignMeta)designEntityMetaLMap.get(fmL.getId() + "." + fmL.getLocaleId());
            if (emL != null) {
                deploy.getDesignMetas().add(emL);
            }
            files.add(deploy.toDeployFile(designMeta.getNumber().toLowerCase() + "." + fmL.getLocaleId() + ".appx"));
        }
        return files;
    }

    private static List<Object> getAppLocale(final IDataEntityType designerMetaType, String id) {
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION,FDATA from %s where FId=? ", tableName);
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> objs = new ArrayList<Object>(10);
                while (rs.next()) {
                    Object obj = designerMetaType.createInstance();
                    for (ISimpleProperty property : designerMetaType.getProperties().getSimpleProperties(true)) {
                        if (property.getPropertyType() == String.class) {
                            property.setValue(obj, (Object)rs.getString(property.getAlias()));
                            continue;
                        }
                        property.setValue(obj, rs.getObject(property.getAlias()));
                    }
                    objs.add(obj);
                }
                return objs;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private static List<Object> getCloudLocale(final IDataEntityType designerMetaType, String id) {
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION from %s where FId=? ", tableName);
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> objs = new ArrayList<Object>(10);
                while (rs.next()) {
                    Object obj = designerMetaType.createInstance();
                    for (ISimpleProperty property : designerMetaType.getProperties().getSimpleProperties(true)) {
                        property.setValue(obj, rs.getObject(property.getAlias()));
                    }
                    objs.add(obj);
                }
                return objs;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static List<DeployFile> getFormDeployFile(DesignFormMeta designFormMeta, DesignEntityMeta designEntityMeta, List<Object> designFormMetaLs, List<Object> designEntityMetaLs) {
        if (designFormMeta == null) {
            return null;
        }
        String id = designFormMeta.getId();
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(10);
        DeployMetadata deploy = new DeployMetadata();
        deploy.setBizappId(MetadataDao.getAppIdFromUnitrel(id));
        deploy.setBizunitId(MetadataDao.getUnitIdFromUnitrel(id));
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designFormMeta);
        if (designFormMeta.getId().equals(designFormMeta.getEntityId()) && designEntityMeta != null) {
            deploy.getDesignMetas().add(designEntityMeta);
        }
        String masterId = "2".equals(designFormMeta.getDevType()) ? designFormMeta.getMasterId() : id;
        deploy.setMasterId(masterId);
        deploy.setId(id);
        deploy.setVersion(designFormMeta.getVersion());
        files.add(deploy.toDeployFile(designFormMeta.getNumber() + ".dym"));
        HashMap<String, DesignMetaL> designEntityMetaLMap = new HashMap<String, DesignMetaL>();
        if (designFormMeta.getId().equals(designFormMeta.getEntityId()) && designEntityMetaLs != null) {
            for (Object em : designEntityMetaLs) {
                DesignMetaL am = (DesignMetaL)em;
                designEntityMetaLMap.put(am.getId() + "." + am.getLocaleId(), am);
            }
        }
        for (Object fm : designFormMetaLs) {
            DesignMetaL fmL = (DesignMetaL)fm;
            long version = designFormMeta.getVersion();
            if (fmL instanceof DesignFormMetaL && ((DesignFormMetaL)fmL).getVersion() == 0L) {
                ((DesignFormMetaL)fmL).setVersion(version);
            } else {
                version = ((DesignFormMetaL)fmL).getVersion();
            }
            deploy = new DeployMetadata();
            deploy.setMasterId(masterId);
            deploy.setId(id);
            deploy.setVersion(version);
            deploy.getDesignMetas().add(fmL);
            AbstractDesignMeta emL = (AbstractDesignMeta)designEntityMetaLMap.get(fmL.getId() + "." + fmL.getLocaleId());
            if (emL != null) {
                deploy.getDesignMetas().add(emL);
            }
            files.add(deploy.toDeployFile(designFormMeta.getNumber() + "." + fmL.getLocaleId() + ".dymx"));
        }
        return files;
    }

    public static List<DeployFile> getEarlyWarnDeployFile(String id) {
        IEarlyWarnProxy earlyWarnService = (IEarlyWarnProxy)ServiceFactory.getService(IEarlyWarnProxy.class);
        return earlyWarnService.getEarlyWarnDeployFile(id);
    }

    public static List<String> getIdByVerDiff(List<String> formIds) {
        IDataEntityType dt = MetadataDao.getDataEntityType(DesignFormMeta.class);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID, FISV, FVERSION, FMASTERID, FTYPE, FNUMBER from ", new Object[0]).append(dt.getAlias(), new Object[0]).append(" WHERE ", new Object[0]).appendIn("FID", formIds.toArray()).append(" OR (", new Object[0]).appendIn("FMasterId", formIds.toArray()).append(" and FType = '2')", new Object[0]);
        Map map = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, List<Object[]>>>(){

            public Map<String, List<Object[]>> handle(ResultSet rs) throws Exception {
                HashMap<String, List<Object[]>> metaMap = new HashMap<String, List<Object[]>>();
                while (rs.next()) {
                    String masterId = rs.getString(4);
                    String id = rs.getString(1);
                    String type = rs.getString(5);
                    String key = "2".equals(type) ? masterId : id;
                    ArrayList<Object[]> list = (ArrayList<Object[]>)metaMap.get(key);
                    if (list == null) {
                        list = new ArrayList<Object[]>();
                        metaMap.put(id, list);
                    }
                    String isv = rs.getString(2);
                    long ver = rs.getLong(3);
                    String number = rs.getString(6);
                    Object[] v = new Object[]{id, isv, ver, masterId, type, number};
                    list.add(v);
                }
                return metaMap;
            }
        });
        HashMap<String, String> numberIdMap = new HashMap<String, String>();
        ArrayList<String> metaNumbers = new ArrayList<String>();
        HashMap<String, String> designMetaVersions = new HashMap<String, String>(16);
        for (Map.Entry entry : map.entrySet()) {
            String metaId = (String)entry.getKey();
            long totalVer = 0L;
            for (Object[] v : (List)entry.getValue()) {
                String id = (String)v[0];
                String number = v[5].toString();
                if (metaId.equals(id)) {
                    numberIdMap.put(number, id);
                }
                long ver = (Long)v[2];
                totalVer += ver;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSS");
            String version = String.format("%s.%s.%s", BOSRuntime.getVersion(), totalVer, sdf.format(new Date()));
            designMetaVersions.put(metaId, version);
        }
        Map<String, String> oldVerMap = MetadataDao.getRuntimeMetaVersion(metaNumbers);
        ArrayList<String> diffIds = new ArrayList<String>();
        for (Map.Entry entry : numberIdMap.entrySet()) {
            String oldVer;
            String number = (String)entry.getKey();
            String id = (String)entry.getValue();
            String ver = (String)designMetaVersions.get(id);
            if (MetadataDao.compareRuntimeVersion(ver, oldVer = oldVerMap.get(number))) continue;
            diffIds.add(id);
        }
        return diffIds;
    }

    public static String buildRuntimeVersion(String masterId) {
        IDataEntityType dt = MetadataDao.getDataEntityType(DesignFormMeta.class);
        String sql = String.format("SELECT FID, FISV, FVERSION, FTYPE from %s WHERE FID = ? OR (FMasterId = ? and FType = '2') ", dt.getAlias());
        Object[] params = new Object[]{masterId, masterId};
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> list = new ArrayList<Object[]>(10);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String isv = rs.getString(2);
                    long ver = rs.getLong(3);
                    String type = rs.getString(4);
                    Object[] v = new Object[]{id, isv, ver, type};
                    list.add(v);
                }
                return list;
            }
        });
        long totalVer = 0L;
        for (Object[] v : list) {
            String id = (String)v[0];
            if (masterId.equals(id) && "2".equals(v[3])) {
                return null;
            }
            long ver = (Long)v[2];
            totalVer += ver;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return String.format("%s.%s.%s", BOSRuntime.getVersion(), totalVer, sdf.format(new Date()));
    }

    public static Map<String, String> getRuntimeMetaVersion(List<String> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return new HashMap<String, String>();
        }
        StringBuilder numberIns = new StringBuilder();
        int listsize = numbers.size();
        numberIns.append("'").append(numbers.get(0)).append("'");
        for (int i = 1; i < listsize; ++i) {
            numberIns.append(", '").append(numbers.get(i)).append("'");
        }
        IDataEntityType runtimeFormMetaType = MetadataDao.getDataEntityType(RuntimeFormMeta.class);
        ORM orm = ORM.create();
        orm.setDataEntityType(runtimeFormMetaType.getName(), runtimeFormMetaType);
        QFilter[] qfilters = new QFilter[]{new QFilter(LOWER_CASE_NUMBER, "in", numbers), new QFilter("type", "=", (Object)10)};
        HashMap<String, String> verMap = new HashMap<String, String>(16);
        try (DataSet ds = orm.queryDataSet("MetadataDao.getRuntimeMetaVersion", runtimeFormMetaType.getName(), "id,number,data", qfilters);){
            ds.forEach(row -> verMap.put(row.getString(1), row.getString(2)));
        }
        return verMap;
    }

    public static boolean compareRuntimeVersion(String ver1, String ver2) {
        String bosver2;
        if (StringUtils.isBlank((CharSequence)ver1) || StringUtils.isBlank((CharSequence)ver2)) {
            return false;
        }
        int bosVerLength = BOSRuntime.getVersion().length();
        int ind1 = ver1.lastIndexOf(46);
        String ver1core = ver1.substring(bosVerLength + 1, ind1);
        int ind2 = ver2.lastIndexOf(46);
        if (ind2 < bosVerLength) {
            return false;
        }
        String bosver1 = ver1.substring(0, bosVerLength);
        int comp = bosver1.compareTo(bosver2 = ver2.substring(0, bosVerLength));
        if (comp < 0) {
            return true;
        }
        if (comp > 0) {
            return false;
        }
        String ver2core = ver2.substring(bosVerLength + 1, ind2);
        if (StringUtils.isNumeric((CharSequence)ver1core) && StringUtils.isNumeric((CharSequence)ver2core)) {
            return Long.valueOf(ver1core).compareTo(Long.valueOf(ver2core)) <= 0;
        }
        if (StringUtils.isNumeric((CharSequence)ver1core) && !StringUtils.isNumeric((CharSequence)ver2core)) {
            return false;
        }
        return ver1core.compareTo(ver2core) < 1;
    }

    public static Map<String, Map<String, Object>> loadFullMetaTerm(IDataEntityType designerMetaType, String id, String[] inheritIds) {
        ArrayList<String> ids = new ArrayList<String>();
        if (inheritIds != null && inheritIds.length > 0) {
            for (String i : inheritIds) {
                ids.add(i);
            }
        }
        ids.add(id);
        StringBuilder inSql = new StringBuilder(22 * ids.size());
        inSql.append("?");
        for (int i = 1; i < ids.size(); ++i) {
            inSql.append(",").append("?");
        }
        String sql = String.format("select fid,flocaleid, fdata from " + designerMetaType.getAlias() + "_Term where  %1$s in (%2$s)", "fid", inSql);
        SqlBuilder sbBuilder = new SqlBuilder();
        sbBuilder.append(sql, ids.toArray());
        Map res = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sbBuilder, rs -> {
            HashMap<String, LocaleString> result = new HashMap<String, LocaleString>();
            while (rs.next()) {
                LocaleString localeString;
                String v = rs.getString("fdata");
                String localid = rs.getString("flocaleid");
                if (result.get(rs.getString("fid")) == null) {
                    localeString = new LocaleString();
                    localeString.put(localid, (Object)v);
                    result.put(rs.getString("fid"), localeString);
                    continue;
                }
                localeString = (LocaleString)result.get(rs.getString("fid"));
                localeString.put(localid, (Object)v);
            }
            return result;
        });
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (String i : ids) {
            LocaleString data = (LocaleString)res.get(i);
            if (data == null || data.isEmpty()) continue;
            for (Map.Entry row : data.entrySet()) {
                Map localeData = (Map)SerializationUtils.fromJsonString((String)((String)row.getValue()), Map.class);
                for (Map.Entry r : localeData.entrySet()) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)r.getValue()))) continue;
                    if (result.containsKey(r.getKey())) {
                        ((Map)result.get(r.getKey())).put(row.getKey(), r.getValue());
                        continue;
                    }
                    HashMap localeString = new HashMap();
                    localeString.put(row.getKey(), r.getValue());
                    result.put((String)r.getKey(), localeString);
                }
            }
        }
        return result;
    }

    public static Map<String, Map<String, Object>> loadFullMetaTerm(IDataEntityType designerMetaType, String id) {
        MetadataReader reader = new MetadataReader();
        AbstractMetadata meta = reader.readMetaForMetadataDao(id, designerMetaType, false, false);
        String inheritPath = meta.getInheritPath();
        String[] inheritIds = null;
        if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
            inheritIds = inheritPath.split(",");
        }
        return MetadataDao.loadFullMetaTerm(designerMetaType, id, inheritIds);
    }

    public static Map<String, String> loadMetaTermByLang(IDataEntityType designerMetaType, String id, Lang lang, boolean includeParentRes) {
        MetadataReader reader;
        AbstractMetadata meta;
        String inheritPath;
        ArrayList<String> idStrings = new ArrayList<String>();
        if (includeParentRes && StringUtils.isNotBlank((CharSequence)(inheritPath = (meta = (reader = new MetadataReader()).readMetaForMetadataDao(id, designerMetaType, false, false)).getInheritPath()))) {
            idStrings.addAll(Arrays.asList(inheritPath.split(",")));
        }
        idStrings.add(id);
        String sql = "select flocaleid, fdata from " + designerMetaType.getAlias() + "_Term where flocaleid = ?  and ";
        SqlBuilder sbBuilder = new SqlBuilder();
        SqlParameter localeParam = new SqlParameter(":flocaleid", 12, (Object)lang.toString());
        sbBuilder.append(sql, new Object[]{localeParam}).appendIn("fid", idStrings.toArray());
        HashMap<String, String> data = new HashMap();
        data = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sbBuilder, rs -> {
            HashMap result = new HashMap();
            while (rs.next()) {
                String v = rs.getString("fdata");
                Map res = (Map)SerializationUtils.fromJsonString((String)v, Map.class);
                if (res == null) continue;
                result.putAll(res);
            }
            return result;
        });
        return data;
    }

    public static AbstractMetadata readMeta(String id, IDataEntityType designerMetaType) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        AbstractMetadata metadata = reader.readMetaForMetadataDao(id, designerMetaType, false, false);
        if (metadata == null && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            metadata = reader.readMetaForMetadataDao(id, designerMetaType, false, false);
        }
        return metadata;
    }

    private static MetadataReader getMetadataReader() {
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(MetadataDao.getAppGroup());
        return reader;
    }

    private static MetadataWriter getMetadataWriter(String modelType) {
        MetadataWriter metadataWriter = new MetadataWriter(modelType);
        metadataWriter.setAppGroup(MetadataDao.getAppGroup());
        return metadataWriter;
    }

    private static AbstractMetadata readGroupMeta(String id, Class<?> designMetaClass, boolean runtime) {
        return MetadataDao.readGroupMeta(id, designMetaClass, runtime, false);
    }

    private static AbstractMetadata readGroupMeta(String id, Class<?> designMetaClass, boolean runtime, boolean isBaseMeta) {
        MetadataReader reader = MetadataDao.getMetadataReader();
        AbstractMetadata metadata = reader.readMetaForMetadataDao(id, MetadataDao.getDataEntityType(designMetaClass), runtime, isBaseMeta);
        if (metadata == null && MetadataDao.isGrayGroup()) {
            reader = new MetadataReader();
            metadata = reader.readMetaForMetadataDao(id, OrmUtils.getDataEntityType(designMetaClass), runtime, isBaseMeta);
        }
        return metadata;
    }

    private static IDataEntityType getDataEntityType(Class<?> cls) {
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(cls);
        if (MetadataDao.isGrayGroup()) {
            IDataEntityType det;
            try {
                det = (IDataEntityType)dataEntityType.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
            }
            det.setAlias(AppGroupUtils.getCurrentAppGroupTableName((String)det.getAlias()));
            return det;
        }
        return dataEntityType;
    }

    public static Map<String, Long> getLocaleVersionMap(String id) {
        String sql = String.format("select FLOCALEID,FVERSION from %s where FId = ? ", T_META_FORMDESIN_L);
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
        ResultSetHandler<Map<String, Long>> action = new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws Exception {
                HashMap<String, Long> localeVersionMap = new HashMap<String, Long>(16);
                while (rs.next()) {
                    String localeId = rs.getString("FLOCALEID");
                    Long version = rs.getLong("FVERSION");
                    if (!StringUtils.isNotBlank((CharSequence)localeId)) continue;
                    localeVersionMap.put(localeId, version);
                }
                return localeVersionMap;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private static boolean checkMetaDataExist(String id) {
        String sql = "select count(1) from t_meta_form where FID = ? and FTYPE = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(FID, 12, (Object)id), new SqlParameter(FTYPE, 5, (Object)RuntimeMetaType.Version.getValue())};
        ResultSetHandler callBackHanlder = rs -> {
            try {
                if (rs.next()) {
                    int count = rs.getInt(1);
                    return count > 0;
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return false;
        };
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    private static boolean isGrayGroup() {
        return AppGroupUtils.isGrayGroup();
    }

    private static String getAppGroup() {
        return AppGroupUtils.getCurrentAppGroup();
    }

    private static String getCacheKey(String key, String number) {
        return String.format("%s_%s_%s", key, MetadataDao.getAppGroup(), number);
    }

    public static DeployMetadata getBizObjExtMetadata(String formId) {
        DesignFormMeta designMeta = (DesignFormMeta)BusinessDataReader.read((Object)formId, (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
        BizObjExtMeta bizObjExtMeta = (BizObjExtMeta)BusinessDataReader.read((Object)formId, (IDataEntityType)OrmUtils.getDataEntityType(BizObjExtMeta.class), (Boolean)false);
        if (!"3".equals(bizObjExtMeta.getStatus()) && StringUtils.isNotBlank((CharSequence)bizObjExtMeta.getFormdata())) {
            designMeta.setDataXml(bizObjExtMeta.getFormdata());
            designMeta.setModifierId(String.valueOf(bizObjExtMeta.getModifierId()));
            if (bizObjExtMeta.getModifyDate() != null) {
                designMeta.setModifyDate(bizObjExtMeta.getModifyDate());
                designMeta.setVersion(bizObjExtMeta.getModifyDate().getTime());
            }
        }
        DeployMetadata deploy = new DeployMetadata();
        deploy.setBizappId(bizObjExtMeta.getBizAppId());
        deploy.setBizunitId(MetadataDao.getUnitIdFromUnitrel(formId));
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designMeta);
        if (designMeta.getId().equals(designMeta.getEntityId())) {
            DesignEntityMeta designEntityMeta = (DesignEntityMeta)BusinessDataReader.read((Object)formId, (IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMeta.class), (Boolean)false);
            if (!"3".equals(bizObjExtMeta.getStatus()) && StringUtils.isNotBlank((CharSequence)bizObjExtMeta.getEntitydata())) {
                designEntityMeta.setDataXml(bizObjExtMeta.getEntitydata());
                designEntityMeta.setModifyDate(bizObjExtMeta.getModifyDate());
            }
            deploy.getDesignMetas().add(designEntityMeta);
        }
        String masterId = "2".equals(designMeta.getDevType()) ? designMeta.getMasterId() : formId;
        deploy.setMasterId(masterId);
        deploy.setId(formId);
        deploy.setVersion(designMeta.getVersion());
        return deploy;
    }
}

