/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MetadataExtends {
    public static void resetParent(String formId, String newParentId) {
        MetadataReader reader = new MetadataReader(false);
        FormMetadata currentFormMetadata = (FormMetadata)reader.readMeta(formId, OrmUtils.getDataEntityType(DesignFormMeta.class));
        FormMetadata parentFormMetadata = (FormMetadata)reader.readMeta(newParentId, OrmUtils.getDataEntityType(DesignFormMeta.class));
        EntityMetadata currentEntityMetadata = (EntityMetadata)reader.readMeta(formId, OrmUtils.getDataEntityType(DesignEntityMeta.class));
        EntityMetadata parentEntityMetadata = (EntityMetadata)reader.readMeta(newParentId, OrmUtils.getDataEntityType(DesignEntityMeta.class));
        currentFormMetadata.bindEntityMetadata(currentEntityMetadata);
        currentFormMetadata.setEntityId(currentEntityMetadata.getId());
        parentFormMetadata.bindEntityMetadata(parentEntityMetadata);
        Map<String, String> entityResetItemIds = MetadataExtends.resetParent(currentEntityMetadata, parentEntityMetadata);
        MetadataExtends.resetParent(currentFormMetadata, parentFormMetadata, entityResetItemIds);
        MetadataWriter writer = new MetadataWriter(currentFormMetadata.getModelType());
        writer.save(currentFormMetadata, currentEntityMetadata);
        List<String> layoutFormIds = MetadataExtends.getLayoutByEntityId(currentEntityMetadata.getId());
        for (String lid : layoutFormIds) {
            FormMetadata layoutMeta = (FormMetadata)reader.readMeta(lid, OrmUtils.getDataEntityType(DesignFormMeta.class));
            layoutMeta.resetEntityItemId(entityResetItemIds);
            writer.save(layoutMeta);
        }
    }

    private static void resetParent(FormMetadata current, FormMetadata parent, Map<String, String> entityResetItemIds) {
        current.setParentId(parent.getId());
        FormAp currentRoot = current.getRootAp();
        FormAp parentRoot = parent.getRootAp();
        currentRoot.setPkId(parentRoot.getPkId());
        AbstractElement[] parentItems = parent.getItems().toArray(new AbstractElement[0]);
        AbstractElement[] items = current.getItems().toArray(new AbstractElement[0]);
        Map<String, String> idMap = MetadataExtends.resetItemId(parentItems, items);
        current.resetItemId(idMap);
        current.resetEntityItemId(entityResetItemIds);
        MetadataExtends.setInheritPath(current, parent);
    }

    private static List<String> getLayoutByEntityId(String entityId) {
        IDataEntityType metaType = OrmUtils.getDataEntityType(DesignFormMeta.class);
        String tableName = metaType.getAlias();
        String sql = String.format("SELECT FID FROM %s WHERE FEntityId=? and FId<>FEntityId", tableName);
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    list.add(id);
                }
                return list;
            }
        };
        String routeKey = metaType.getDBRouteKey();
        DBRoute route = StringUtils.isBlank((CharSequence)routeKey) ? DBRoute.meta : DBRoute.of((String)routeKey);
        List list = (List)DB.query((DBRoute)route, (String)sql, (Object[])new SqlParameter[]{new SqlParameter((Object)entityId)}, (ResultSetHandler)action);
        return list;
    }

    private static Map<String, String> resetParent(EntityMetadata current, EntityMetadata parent) {
        current.setParentId(parent.getId());
        MainEntity currentRoot = current.getRootEntity();
        MainEntity parentRoot = parent.getRootEntity();
        currentRoot.setPkId(parentRoot.getPkId());
        AbstractElement[] parentItems = parent.getItems().toArray(new AbstractElement[0]);
        AbstractElement[] items = current.getItems().toArray(new AbstractElement[0]);
        Map<String, String> idMap = MetadataExtends.resetItemId(parentItems, items);
        current.resetItemId(idMap);
        MetadataExtends.setInheritPath(current, parent);
        return idMap;
    }

    private static void setInheritPath(AbstractMetadata current, AbstractMetadata parent) {
        String inheritPath = parent.getInheritPath();
        inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? parent.getId() : inheritPath + ',' + parent.getId();
        current.setInheritPath(inheritPath);
    }

    private static Map<String, String> resetItemId(AbstractElement[] parentItems, AbstractElement[] items) {
        int size = parentItems.length;
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (size > 1) {
            HashMap<String, AbstractElement> mapParentItems = new HashMap<String, AbstractElement>(size - 1);
            AbstractElement parentItem = null;
            for (int i = 1; i < size; ++i) {
                parentItem = parentItems[i];
                mapParentItems.put(parentItem.getKey().toLowerCase(), parentItem);
            }
            AbstractElement currentItem = null;
            for (int i = 1; i < items.length; ++i) {
                currentItem = items[i];
                parentItem = (AbstractElement)mapParentItems.get(currentItem.getKey().toLowerCase());
                if (parentItem == null || currentItem.getClass() != parentItem.getClass()) continue;
                idMap.put(currentItem.getId(), parentItem.getId());
                currentItem.setId(parentItem.getId());
            }
        }
        return idMap;
    }
}

