/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.AbstractMetadataReader;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MetadataReader
extends AbstractMetadataReader {
    private boolean isExtend;
    private static final String FORMDESIGN_TABLE = "T_META_FORMDESIGN";
    private static final String ENTITYDESIGN_TABLE = "T_META_ENTITYDESIGN";
    private static final String FORMDESIGN_L_TABLE = "T_META_FORMDESIGN_L";
    private static final String ENTITYDESIGN_L_TABLE = "T_META_ENTITYDESIGN_L";
    private static final String CACHEKEY_FORMNUMBER = "formnumber";
    private static final String CACHEKEY_ENTITYNUMBER = "entitynumber";
    private static final String CACHEKEY_FORMID = "formid";
    private static final String CACHEKEY_ENTITYID = "entityid";
    private static final String FNUMBER = ":FNUMBER";
    private String localeId = "zh_CN";

    public MetadataReader() {
        this(false);
    }

    public MetadataReader(boolean isExtend) {
        this.isExtend = isExtend;
    }

    public MetadataReader(boolean isExtend, String localeId) {
        this.isExtend = isExtend;
        this.localeId = localeId;
    }

    public AbstractMetadata readMeta(String id, MetaCategory category) {
        if (category == MetaCategory.Entity) {
            return this.readMeta(id, OrmUtils.getDataEntityType(DesignEntityMeta.class));
        }
        return this.readMeta(id, OrmUtils.getDataEntityType(DesignFormMeta.class));
    }

    public AbstractMetadata readMeta(String id, IDataEntityType designerMetaType) {
        return this.readMeta(id, designerMetaType, false, false);
    }

    public AbstractMetadata design2Metadata(DesignMeta designMeta, IDataEntityType designerMetaType) {
        return this.design2Metadata(designMeta, designerMetaType, false, false);
    }

    public AbstractMetadata readMeta(String id, IDataEntityType designerMetaType, boolean runtime) {
        return this.readMeta(id, designerMetaType, runtime, false);
    }

    public AbstractMetadata readEntityMetaByFormId(String id) {
        String entityId = this.loadEntityIdById(id, MetaCategory.Form);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        return this.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class));
    }

    protected boolean checkNumber(String number) {
        String sql = String.format("select 1 from %s where FNUMBER = ? ", this.getGrayTableName(FORMDESIGN_TABLE));
        Object[] params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number)};
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, this.existAction());
    }

    protected boolean checkNumber(String number, String id) {
        String sql = String.format("select 1 from %s where FNUMBER = ? and FID <> ?", this.getGrayTableName(FORMDESIGN_TABLE));
        Object[] params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number), new SqlParameter(":FID", 12, (Object)id)};
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, this.existAction());
    }

    protected boolean checkName(String name) {
        String sql = String.format("select 1 from %s where FNAME = ? ", this.getGrayTableName(FORMDESIGN_L_TABLE));
        Object[] params = new SqlParameter[]{new SqlParameter(":FNAME", 12, (Object)name)};
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, this.existAction());
    }

    protected String getMasterId(String id) {
        String sql = String.format("select FType, FMasterId from %s where FId = ? ", this.getGrayTableName(FORMDESIGN_TABLE));
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    String devType = rs.getString(1);
                    if (StringUtils.equals((CharSequence)devType, (CharSequence)"2")) {
                        return rs.getString(2);
                    }
                    return null;
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    protected String getNumberById(final String id) {
        String number = (String)ThreadCache.get((Object)(id + ".formnumber"), (CacheLoader)new CacheLoader<String>(){

            public String load() {
                String num = MetaCacheUtils.getDistributeCache(id, MetadataReader.CACHEKEY_FORMNUMBER, 0);
                if (num != null) {
                    return num;
                }
                String sql = String.format("select FNumber from %s where FId = ? ", MetadataReader.this.getGrayTableName(MetadataReader.FORMDESIGN_TABLE));
                Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
                ResultSetHandler<String> action = new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            return rs.getString(1);
                        }
                        return null;
                    }
                };
                num = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
                if (StringUtils.isNotBlank((CharSequence)num)) {
                    MetaCacheUtils.putDistributeCache(id, MetadataReader.CACHEKEY_FORMNUMBER, 0, num);
                }
                return num;
            }
        });
        return number;
    }

    public String loadIdByNumber(final String number, final MetaCategory category) {
        String id = (String)ThreadCache.get((Object)(number + "." + category.name() + ".id"), (CacheLoader)new CacheLoader<String>(){

            public String load() {
                ResultSetHandler<String> action;
                Object[] params;
                String cacheId = MetaCacheUtils.getDistributeCache(number, category == MetaCategory.Form ? MetadataReader.CACHEKEY_FORMID : MetadataReader.CACHEKEY_ENTITYID, 0);
                if (cacheId != null) {
                    return cacheId;
                }
                String sql = String.format("select FID from %s where FNUMBER = ? ", MetadataReader.this.getGrayTableName(category));
                cacheId = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])(params = new SqlParameter[]{new SqlParameter(MetadataReader.FNUMBER, 12, (Object)number)}), (ResultSetHandler)(action = new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            return rs.getString("FID");
                        }
                        return null;
                    }
                }));
                if (StringUtils.isNotBlank((CharSequence)cacheId)) {
                    MetaCacheUtils.putDistributeCache(number, category == MetaCategory.Form ? MetadataReader.CACHEKEY_FORMID : MetadataReader.CACHEKEY_ENTITYID, 0, cacheId);
                }
                return cacheId;
            }
        });
        return id;
    }

    private String loadEntityIdById(String id, MetaCategory category) {
        String sql = String.format("select FEntityId from %s where FID = ? ", this.getGrayTableName(category));
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString("FEntityId");
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public String getEntityNumberById(final String id) {
        String number = (String)ThreadCache.get((Object)this.buildThreadCacheKey(id), (CacheLoader)new CacheLoader<String>(){

            public String load() {
                String num = MetaCacheUtils.getDistributeCache(id, MetadataReader.CACHEKEY_ENTITYNUMBER, 0);
                if (num != null) {
                    return num;
                }
                String sql = String.format("select FNumber from %s where FId = ? ", MetadataReader.this.getGrayTableName(MetadataReader.ENTITYDESIGN_TABLE));
                Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
                ResultSetHandler<String> action = new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            return rs.getString(1);
                        }
                        return null;
                    }
                };
                num = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
                if (StringUtils.isNotBlank((CharSequence)num)) {
                    MetaCacheUtils.putDistributeCache(id, MetadataReader.CACHEKEY_ENTITYNUMBER, 0, num);
                }
                return num;
            }
        });
        return number;
    }

    public Map<String, String> getEntityNumberByIdList(List<String> idList) {
        if (idList == null || idList.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        SqlBuilder builder = new SqlBuilder();
        String selectPart = String.format("SELECT FID,FNUMBER FROM %s  ", this.getGrayTableName(ENTITYDESIGN_TABLE));
        builder.append(selectPart, new Object[0]).append(" where ", new Object[0]).appendIn("FID", (Object[])idList.toArray(new String[idList.size()]));
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            HashMap<String, String> mapping = new HashMap<String, String>(10);
            while (rs.next()) {
                String fid = rs.getString("FID");
                String fnumber = rs.getString("FNUMBER");
                mapping.put(fid, fnumber);
                ThreadCache.put((Object)this.buildThreadCacheKey(fid), (Object)fnumber);
            }
            return mapping;
        });
    }

    private String buildThreadCacheKey(String entityPkId) {
        return entityPkId + ".entitynumber";
    }

    public List<Object> readMetaValues(String id, MetaCategory category) {
        switch (category) {
            case Entity: {
                return this.doReadEntityMeta(id);
            }
        }
        return this.doReadFormMeta(id);
    }

    @Deprecated
    public List<String> readFormMetaLangValues(String id) {
        return this.readMetaLang(id, FORMDESIGN_L_TABLE);
    }

    @Deprecated
    public List<String> readEntityMetaLangValues(String id) {
        return this.readMetaLang(id, ENTITYDESIGN_L_TABLE);
    }

    public List<Map<String, Object>> doReadCheckFormInfoList(String appnumbers) {
        String table = this.getGrayTableName(MetaCategory.Form);
        String sql = "select meta.fid formid,meta.fnumber formnumber,app.fnumber appnumber,app.fname appname from " + table + " meta left join (select aaa.fnumber, aaa.fname, b.fformid from (select a.fid,a.fnumber,aa.fname from t_meta_bizapp a left join t_meta_bizapp_l aa on a.fid = aa.fid and aa.flocaleid = 'zh_CN') aaa left join t_meta_bizunitrelform b on aaa.fid = b.fbizappid) app on meta.fid = app.fformid where meta.ftype ='0'";
        if (StringUtils.isNotBlank((CharSequence)appnumbers)) {
            String apps = appnumbers.replaceAll(",", "','");
            sql = sql + " and app.fnumber  in ('" + apps + "')";
        }
        ResultSetHandler<List<Map<String, Object>>> action = new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                while (rs.next()) {
                    HashMap<String, String> itemInfo = new HashMap<String, String>();
                    String id = rs.getString(MetadataReader.CACHEKEY_FORMID);
                    String number = rs.getString(MetadataReader.CACHEKEY_FORMNUMBER);
                    String appnumber = rs.getString("appnumber");
                    String appname = rs.getString("appname");
                    itemInfo.put("n", number);
                    itemInfo.put("a", appnumber);
                    itemInfo.put("an", appname);
                    list.add(itemInfo);
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
    }

    private List<Object> doReadFormMeta(final String id) {
        final String table = this.getGrayTableName(MetaCategory.Form);
        String sql = this.getReadMetaSql(table);
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>();
                if (!rs.next()) {
                    throw new KDException(BosErrorCode.designMetaDataNotExist, new Object[]{table, id});
                }
                String number = rs.getString("FNumber");
                String entityId = rs.getString("FEntityID");
                String modelType = rs.getString("FMODELTYPE");
                String subSysId = rs.getString("FSUBSYSID");
                String parentId = rs.getString("FParentID");
                String type = rs.getString("FTYPE");
                String data = rs.getString("FData");
                String inheritPath = rs.getString("FInheritPath");
                String isv = rs.getString("FISV");
                long version = rs.getLong("FVERSION");
                String bizAppID = rs.getString("FBIZAPPID");
                String masterId = rs.getString("FMasterId");
                list.add(number);
                list.add(entityId);
                list.add(modelType);
                list.add(subSysId);
                list.add(parentId);
                list.add(type);
                list.add(data);
                list.add(inheritPath);
                list.add(isv);
                list.add(version);
                list.add(bizAppID);
                list.add(masterId);
                return list;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private List<Object> doReadEntityMeta(final String id) {
        final String table = this.getGrayTableName(MetaCategory.Entity);
        String sql = this.getReadMetaSql(table);
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>();
                if (!rs.next()) {
                    throw new KDException(BosErrorCode.designMetaDataNotExist, new Object[]{table, id});
                }
                String number = rs.getString("FNumber");
                String entityId = rs.getString("FID");
                String modelType = rs.getString("FMODELTYPE");
                String subSysId = rs.getString("FSUBSYSID");
                String parentId = rs.getString("FParentID");
                String type = rs.getString("FTYPE");
                String data = rs.getString("FData");
                String inheritPath = rs.getString("FInheritPath");
                String isv = rs.getString("FISV");
                long version = rs.getLong("FVERSION");
                String bizAppID = rs.getString("FBIZAPPID");
                String masterId = rs.getString("FMasterId");
                list.add(number);
                list.add(entityId);
                list.add(modelType);
                list.add(subSysId);
                list.add(parentId);
                list.add(type);
                list.add(data);
                list.add(inheritPath);
                list.add(isv);
                list.add(version);
                list.add(bizAppID);
                list.add(masterId);
                return list;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private List<String> readMetaLang(String id, String table) {
        String sql = String.format("select FNAME, FDATA from %s where FID = ? and FLOCALEID = ?", this.getGrayTableName(table));
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id), new SqlParameter(":FLOCALEID", 12, (Object)this.localeId)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>();
                if (rs.next()) {
                    list.add(rs.getString(1));
                    list.add(rs.getString(2));
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private String getReadMetaSql(String tableName) {
        String sql = FORMDESIGN_TABLE.equalsIgnoreCase(tableName) ? String.format("select FID, FNumber, FEntityID, FMODELTYPE, FSUBSYSID, FParentID, FTYPE, FData, FInheritPath, FISV, FVERSION, FBIZAPPID, FMasterId from %s where FID = ? ", tableName) : String.format("select FID, FNumber, FMODELTYPE, FSUBSYSID, FParentID, FTYPE, FData, FInheritPath, FISV, FVERSION, FBIZAPPID, FMasterId from %s where FID = ? ", tableName);
        return sql;
    }

    private ResultSetHandler<Boolean> existAction() {
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1) > 0;
                }
                return false;
            }
        };
        return action;
    }

    private String getGrayTableName(MetaCategory category) {
        switch (category) {
            case Entity: {
                return this.getGrayTableName(ENTITYDESIGN_TABLE);
            }
            case Form: {
                return this.getGrayTableName(FORMDESIGN_TABLE);
            }
        }
        return "";
    }
}

