/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import kd.bos.dataentity.TypesContainer;
import kd.bos.metadata.dao.FormmetaDaoPlugin;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.metadata.dao.ReportmetaDaoPlugin;
import kd.bos.metadata.devportal.AppMetaDaoPlugin;
import kd.bos.mservice.svc.earlywarn.IEarlyWarnProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.service.botp.BOTPServiceFactory;
import kd.bos.service.botp.metadata.IConvertRuleMetaDaoPlugin;
import kd.bos.service.botp.metadata.ICtConvertRuleMetaDaoPlugin;
import kd.bos.service.botp.metadata.IWriteBackRuleMetaDaoPlugin;
import kd.bos.service.metadata.design.DesignMetadataService;

public class MetadataServicePlugInProxy {
    public static IMetadataDaoPlugIn create(String modelTypeId) {
        IMetadataDaoPlugIn plugIn = null;
        switch (modelTypeId) {
            case "PrintModel": {
                plugIn = (IMetadataDaoPlugIn)TypesContainer.createInstance((String)"kd.bos.metadata.dao.PrintmetaDaoPlugin");
                break;
            }
            case "ConvertRuleModel": {
                plugIn = (IMetadataDaoPlugIn)BOTPServiceFactory.getPrototypeService(IConvertRuleMetaDaoPlugin.class);
                break;
            }
            case "CtConvertRuleModel": {
                plugIn = (IMetadataDaoPlugIn)BOTPServiceFactory.getPrototypeService(ICtConvertRuleMetaDaoPlugin.class);
                break;
            }
            case "WriteBackRuleModel": {
                plugIn = (IMetadataDaoPlugIn)BOTPServiceFactory.getPrototypeService(IWriteBackRuleMetaDaoPlugin.class);
                break;
            }
            case "AppModel": {
                plugIn = MetadataServicePlugInProxy.getAppMetaDaoPlugin();
                break;
            }
            case "BalanceModel": {
                plugIn = MetadataServicePlugInProxy.newBalanceFormMetaDaoPlugin();
                break;
            }
            case "BalanceUpdateModel": {
                plugIn = MetadataServicePlugInProxy.newBalanceUpdateRuleMetaDaoPlugin();
                break;
            }
            case "ReportFormModel": {
                plugIn = MetadataServicePlugInProxy.getReportMetadaoPlugin();
                break;
            }
            case "EarlyWarnModel": {
                plugIn = MetadataServicePlugInProxy.newEarlyWarnMetaDaoPlugin();
                break;
            }
            case "WarnScheduleModel": {
                plugIn = MetadataServicePlugInProxy.newWarnScheduleMetaDaoPlugin();
                break;
            }
            default: {
                plugIn = MetadataServicePlugInProxy.getFormmetdaoPlugin(modelTypeId);
            }
        }
        return plugIn;
    }

    private static IMetadataDaoPlugIn getReportMetadaoPlugin() {
        if (Boolean.getBoolean("enablesharemeta")) {
            return (IMetadataDaoPlugIn)TypesContainer.createInstance((String)"kd.bos.metadata.dao.ShareReportmetaDaoPlugin");
        }
        return new ReportmetaDaoPlugin();
    }

    private static IMetadataDaoPlugIn getFormmetdaoPlugin(String modelTypeId) {
        if (Boolean.getBoolean("enablesharemeta")) {
            return (IMetadataDaoPlugIn)TypesContainer.createInstance((String)"kd.bos.metadata.dao.ShareFormmetaDaoPlugin");
        }
        IMetadataDaoPlugIn customMetadataDaoPlugIn = MetadataServicePlugInProxy.getCustomMetadataDaoPlugIn(modelTypeId);
        if (customMetadataDaoPlugIn != null) {
            return customMetadataDaoPlugIn;
        }
        return new FormmetaDaoPlugin();
    }

    private static IMetadataDaoPlugIn getAppMetaDaoPlugin() {
        if (Boolean.getBoolean("enablesharemeta")) {
            return (IMetadataDaoPlugIn)TypesContainer.createInstance((String)"kd.bos.metadata.devportal.ShareAppMetaDaoPlugin");
        }
        return new AppMetaDaoPlugin();
    }

    private static IMetadataDaoPlugIn newWarnScheduleMetaDaoPlugin() {
        IEarlyWarnProxy earlyWarnService = (IEarlyWarnProxy)ServiceFactory.getService(IEarlyWarnProxy.class);
        return (IMetadataDaoPlugIn)earlyWarnService.newWarnScheduleMetaDaoPlugin();
    }

    private static IMetadataDaoPlugIn newEarlyWarnMetaDaoPlugin() {
        IEarlyWarnProxy earlyWarnService = (IEarlyWarnProxy)ServiceFactory.getService(IEarlyWarnProxy.class);
        return (IMetadataDaoPlugIn)earlyWarnService.newEarlyWarnMetaDaoPlugin();
    }

    private static IMetadataDaoPlugIn newBalanceFormMetaDaoPlugin() {
        return (IMetadataDaoPlugIn)TypesContainer.createInstance((String)"kd.bos.metadata.balance.BalanceFormMetaDaoPlugin");
    }

    private static IMetadataDaoPlugIn newBalanceUpdateRuleMetaDaoPlugin() {
        return (IMetadataDaoPlugIn)TypesContainer.createInstance((String)"kd.bos.metadata.balance.BalanceUpdateRuleMetaDaoPlugin");
    }

    private static IMetadataDaoPlugIn getCustomMetadataDaoPlugIn(String modelTypeId) {
        DesignMetadataService designMetadataService = (DesignMetadataService)ServiceFactory.getService(DesignMetadataService.class);
        return (IMetadataDaoPlugIn)designMetadataService.getCustomMetadataDaoPlugIn(modelTypeId);
    }
}

