/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.BillTypeField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.ItemClassTypeField;
import kd.bos.metadata.entity.businessfield.MasterIdField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.PeriodField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;

public class PrintDataSourceReader {
    public static final String DS_TYPE_HEAD = "1";
    public static final String DS_TYPE_ENTRY = "2";
    public static final String DS_TYPE_SUBENTRY = "3";
    public static final String DS_TYPE_APPROVELINE = "4";
    public static final String DS_TYPE_CUSTOM = "5";
    public static final String DS_TYPE_MAINENT = "6";
    public static final String DS_TYPE_QUERYENTITY = "7";
    public static final String DS_TYPE_APPROVEACTIVITY = "8";
    public static final String DS_TYPE_IMPORTENTITY = "9";
    public static final String DS_TYPE_ATTACH = "10";
    public static final String DS_NAME_ATTACH = "attachpanel";
    public static final String DS_NAME_APPROVELINE = "workflow.approveline";
    public static final String DS_NAME_ACTIVITY = "workflow.activity";
    private static final String BOS_METADATA = "bos-metadata";
    private static final String TWO_STR_PLACEHOLDER = "%s.%s";
    private static final String DS_TYPE = "DsType";
    private static final String ITEMS = "Items";
    private static final String TEXT_FIELD = "TextField";
    private static final List<Class<?>> NO_SUPPORT_FIELDS = Arrays.asList(PeriodField.class, AdminDivisionField.class, TimeRangeField.class);
    private Map<String, EntityMetadata> baseDataMetaCache = new HashMap<String, EntityMetadata>();

    public static boolean isSupportInPrint(EntityItem<?> field) {
        return !NO_SUPPORT_FIELDS.contains(field.getClass());
    }

    public Map<String, Object> buildDataSourceTree(String entityId) {
        return this.buildDataSourceTree(entityId, null);
    }

    public Map<String, Object> buildDataSourceTree(String entityId, List<Class<? extends Field<?>>> showFields) {
        return this.buildDataSourceTree(entityId, null, showFields);
    }

    public Map<String, Object> buildDataSourceTree(String entityId, String entityKey, List<Class<? extends Field<?>>> showFields) {
        MetadataReader mReader = new MetadataReader();
        EntityMetadata meta = (EntityMetadata)mReader.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
        return this.buildDataSourceTree(meta, entityKey, showFields, true);
    }

    public Map<String, Object> buildDataSourceTree(EntityMetadata entityMetadata) {
        return this.buildDataSourceTree(entityMetadata, null);
    }

    public Map<String, Object> buildDataSourceTree(EntityMetadata entityMetadata, boolean isCheckDBField) {
        return this.buildDataSourceTree(entityMetadata, null, null, isCheckDBField);
    }

    public Map<String, Object> buildDataSourceTree(EntityMetadata entityMetadata, List<Class<? extends Field<?>>> showFields) {
        return this.buildDataSourceTree(entityMetadata, null, showFields, true);
    }

    public Map<String, Object> buildDataSourceTree(EntityMetadata entityMetadata, String entityKey, List<Class<? extends Field<?>>> showFields, boolean isCheckDBField) {
        HashMap<String, Object> root = new HashMap<String, Object>(4);
        ArrayList<Object> nodes = new ArrayList<Object>();
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            for (EntityItem<?> element : entityMetadata.getRootEntity().getItems()) {
                String newKey;
                if (element instanceof EntryEntity) {
                    if (isCheckDBField && StringUtils.isEmpty((CharSequence)((EntryEntity)element).getTableName())) continue;
                    this.entryEntityNode((EntryEntity)element, element.getKey(), element.getName().toString(), 1, nodes, showFields, isCheckDBField);
                }
                if (element instanceof BasedataField) {
                    if (StringUtils.isEmpty((CharSequence)((BasedataField)element).getFieldName())) continue;
                    this.basedataEntityNode((BasedataField)element, element.getKey(), element.getName().toString(), 2, nodes, showFields);
                    continue;
                }
                if (!(element instanceof Field) || element instanceof BasedataPropField || showFields != null && !showFields.isEmpty() && showFields.stream().noneMatch(clazz -> clazz.equals(element.getClass())) || element instanceof RadioField) continue;
                if (element instanceof BasedataPropField) {
                    BasedataPropField basdataProp = (BasedataPropField)element;
                    newKey = basdataProp.getControlField().getKey() + "." + basdataProp.getRefDisplayProp();
                    PrintDataSourceReader.putInToItemsList(nodes, element, newKey, basdataProp.getName().getLocaleValue());
                    continue;
                }
                if (element instanceof MulBasedataField) {
                    PrintDataSourceReader.putInToItemsList(nodes, element, element.getKey(), element.getName().toString());
                    continue;
                }
                if (element instanceof DateRangeField) {
                    String newname;
                    DateRangeField dateRange = (DateRangeField)element;
                    if (!isCheckDBField || StringUtils.isNotBlank((CharSequence)dateRange.getStartDateFieldName())) {
                        newKey = dateRange.getStartDateFieldKey();
                        newname = String.format(ResManager.loadKDString((String)"%s.\u5f00\u59cb", (String)"PrintDataSourceReader_24", (String)BOS_METADATA, (Object[])new Object[0]), element.getName());
                        PrintDataSourceReader.putInToItemsList(nodes, element, newKey, newname);
                    }
                    if (isCheckDBField && !StringUtils.isNotBlank((CharSequence)dateRange.getEndDateFieldName())) continue;
                    newKey = dateRange.getEndDateFieldKey();
                    newname = String.format(ResManager.loadKDString((String)"%s.\u7ed3\u675f", (String)"PrintDataSourceReader_25", (String)BOS_METADATA, (Object[])new Object[0]), element.getName());
                    PrintDataSourceReader.putInToItemsList(nodes, element, newKey, newname);
                    continue;
                }
                if (isCheckDBField && StringUtils.isEmpty((CharSequence)((Field)element).getFieldName())) continue;
                PrintDataSourceReader.putInToItemsList(nodes, element, element.getKey(), element.getName().toString());
            }
            root.put("Id", entityMetadata.getKey());
            root.put("Type", entityMetadata.getModelType());
            root.put("Name", entityMetadata.getName().toString());
            root.put(DS_TYPE, DS_TYPE_HEAD);
            root.put(ITEMS, nodes);
        } else if (entityMetadata.getKey().equalsIgnoreCase(entityKey)) {
            for (EntityItem<?> element : entityMetadata.getRootEntity().getItems()) {
                if (element instanceof BasedataField) {
                    this.basedataEntityNode((BasedataField)element, element.getKey(), element.getName().toString(), 2, nodes, showFields);
                    continue;
                }
                if (!(element instanceof Field) || element instanceof RadioField || showFields != null && !showFields.isEmpty() && showFields.stream().noneMatch(clazz -> clazz.equals(element.getClass()))) continue;
                if (element instanceof BasedataPropField) {
                    BasedataPropField basdataProp = (BasedataPropField)element;
                    if (basdataProp.getControlField() == null) continue;
                    String newKey = basdataProp.getControlField().getKey() + "." + basdataProp.getRefDisplayProp();
                    PrintDataSourceReader.putInToItemsList(nodes, element, newKey, basdataProp.getName().getLocaleValue());
                    continue;
                }
                PrintDataSourceReader.putInToItemsList(nodes, element, element.getKey(), element.getName().toString());
            }
            root.put("Id", entityMetadata.getKey());
            root.put("Type", entityMetadata.getModelType());
            root.put("Name", entityMetadata.getName().toString());
            root.put(DS_TYPE, DS_TYPE_ENTRY);
            root.put(ITEMS, nodes);
        } else {
            for (Entity<?, ?> ele : entityMetadata.getEntitys()) {
                if (!entityKey.equalsIgnoreCase(ele.getKey())) continue;
                this.entryEntityNode((EntryEntity)ele, ele.getKey(), ele.getName().toString(), 1, nodes, showFields, isCheckDBField);
                root.put("Id", entityMetadata.getKey());
                root.put("Type", entityMetadata.getModelType());
                root.put("Name", entityMetadata.getName().toString());
                root.put(ITEMS, nodes);
            }
        }
        return root;
    }

    public Map<String, Object> buildQueryEntityDataSourceTree(EntityMetadata entityMetadata) {
        HashMap<String, Object> root = new HashMap<String, Object>(4);
        ArrayList nodes = new ArrayList(10);
        QueryEntity rootEntiry = (QueryEntity)entityMetadata.getRootEntity();
        List<QuerySelectField> mainSelectFields = rootEntiry.getSelectFields();
        for (QuerySelectField selectfield : mainSelectFields) {
            HashMap<String, String> eleNode = new HashMap<String, String>();
            eleNode.put("Id", selectfield.getAlias());
            eleNode.put("Type", TEXT_FIELD);
            eleNode.put("Name", selectfield.getDisplayName());
            nodes.add(eleNode);
        }
        root.put("Id", rootEntiry.getKey());
        root.put("Type", entityMetadata.getModelType());
        root.put("Name", rootEntiry.getName().toString());
        root.put(ITEMS, nodes);
        return root;
    }

    public Map<String, Object> buildFormulaTree() {
        List<Object> formulaNodes = this.buildFormulaNodes();
        HashMap<String, Object> formulaRoot = new HashMap<String, Object>(4);
        formulaRoot.put("Id", "formula");
        formulaRoot.put("Type", "formula");
        formulaRoot.put("Name", ResManager.loadKDString((String)"\u516c\u5f0f", (String)"PrintDataSourceReader_3", (String)BOS_METADATA, (Object[])new Object[0]));
        formulaRoot.put(ITEMS, formulaNodes);
        return formulaRoot;
    }

    private List<Object> buildFormulaNodes() {
        String key1 = "=getPageNumber()";
        String key2 = "=getPageTotal()";
        String key3 = ResManager.loadKDString((String)"=\"\u7b2c\" + getPageNumber() + \"/\" + getPageTotal() + \"\u9875\"", (String)"PrintDataSourceReader_4", (String)BOS_METADATA, (Object[])new Object[0]);
        String key4 = ResManager.loadKDString((String)"=\"\u7b2c\" + getPageNumber() + \"\u9875\uff0c\u5171\" + getPageTotal() + \"\u9875\"", (String)"PrintDataSourceReader_5", (String)BOS_METADATA, (Object[])new Object[0]);
        String key5 = "=now()";
        String key6 = "=getUserName()";
        String key7 = "=getRowNumber(0)";
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
        fieldMap.put(key1, ResManager.loadKDString((String)"\u9875\u7801", (String)"PrintDataSourceReader_6", (String)BOS_METADATA, (Object[])new Object[0]));
        fieldMap.put(key2, ResManager.loadKDString((String)"\u603b\u9875\u6570", (String)"PrintDataSourceReader_7", (String)BOS_METADATA, (Object[])new Object[0]));
        fieldMap.put(key3, ResManager.loadKDString((String)"\u7b2cX/Y\u9875", (String)"PrintDataSourceReader_8", (String)BOS_METADATA, (Object[])new Object[0]));
        fieldMap.put(key4, ResManager.loadKDString((String)"\u7b2cX\u9875, \u5171Y\u9875", (String)"PrintDataSourceReader_9", (String)BOS_METADATA, (Object[])new Object[0]));
        fieldMap.put(key5, ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4", (String)"PrintDataSourceReader_10", (String)BOS_METADATA, (Object[])new Object[0]));
        fieldMap.put(key6, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237", (String)"PrintDataSourceReader_11", (String)BOS_METADATA, (Object[])new Object[0]));
        fieldMap.put(key7, ResManager.loadKDString((String)"\u6570\u636e\u884c\u884c\u53f7", (String)"PrintDataSourceReader_12", (String)BOS_METADATA, (Object[])new Object[0]));
        ArrayList<Object> formulaNodes = new ArrayList<Object>(10);
        for (Map.Entry entry : fieldMap.entrySet()) {
            HashMap<String, Object> eleNode = new HashMap<String, Object>();
            eleNode.put("Id", entry.getKey());
            eleNode.put("Type", TEXT_FIELD);
            eleNode.put("Name", entry.getValue());
            formulaNodes.add(eleNode);
        }
        return formulaNodes;
    }

    public Map<String, Object> buildAttachPanelTree(String entityNumber) {
        ArrayList attachPanelNodes = new ArrayList(10);
        HashMap<String, Object> attachPanelRoot = new HashMap<String, Object>(16);
        attachPanelRoot.put("Id", DS_NAME_ATTACH);
        attachPanelRoot.put("Type", DS_NAME_ATTACH);
        attachPanelRoot.put("IsDS", true);
        attachPanelRoot.put(DS_TYPE, DS_TYPE_ATTACH);
        attachPanelRoot.put("Name", ResManager.loadKDString((String)"\u9644\u4ef6\u9762\u677f", (String)"PrintDataSourceReader_13", (String)BOS_METADATA, (Object[])new Object[0]));
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta(entityNumber, MetaCategory.Form);
        for (ControlAp<?> element : formMetadata.getItems()) {
            if (!"kd.bos.metadata.form.control.AttachmentPanelAp".equals(element.getClass().getName())) continue;
            HashMap<String, String> eleNode = new HashMap<String, String>();
            eleNode.put("Id", element.getKey());
            eleNode.put("Type", TEXT_FIELD);
            eleNode.put("Name", element.getName().getLocaleValue());
            attachPanelNodes.add(eleNode);
        }
        if (attachPanelNodes.isEmpty()) {
            return null;
        }
        attachPanelRoot.put(ITEMS, attachPanelNodes);
        return attachPanelRoot;
    }

    public void entryEntityNode(EntryEntity entry, String headKey, String headName, int treeHeight, List<Object> fatherNode, List<Class<? extends Field<?>>> showFields, boolean isCheckDBField) {
        String curHeadKey = null;
        String curHeadName = null;
        ArrayList<Object> entityNodes = new ArrayList<Object>();
        if (treeHeight <= 2) {
            if (showFields == null && StringUtils.isNotBlank((CharSequence)entry.getSeqFieldName())) {
                HashMap<String, String> eleNode = new HashMap<String, String>();
                eleNode.put("Id", entry.getKey() + ".seq");
                eleNode.put("Type", String.class.getName());
                eleNode.put("Name", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"PrintDataSourceReader_14", (String)BOS_METADATA, (Object[])new Object[0]));
                entityNodes.add(eleNode);
            }
            for (EntityItem<?> element : entry.getItems()) {
                curHeadKey = element.getKey();
                curHeadName = element.getName().toString();
                if (element instanceof BasedataField) {
                    if (isCheckDBField && StringUtils.isEmpty((CharSequence)((BasedataField)element).getFieldName())) continue;
                    this.basedataEntityNode((BasedataField)element, curHeadKey, curHeadName, treeHeight + 1, entityNodes, showFields);
                    continue;
                }
                if (element instanceof SubEntryEntity) {
                    if (StringUtils.isEmpty((CharSequence)((SubEntryEntity)element).getTableName())) continue;
                    this.entryEntityNode((EntryEntity)element, curHeadKey, curHeadName, treeHeight + 1, fatherNode, showFields, isCheckDBField);
                    continue;
                }
                if (element instanceof MulBasedataField) {
                    PrintDataSourceReader.putInToItemsList(entityNodes, element, curHeadKey, curHeadName);
                    continue;
                }
                if (!(element instanceof Field)) continue;
                if (element instanceof DateRangeField) {
                    String newname;
                    String newKey;
                    DateRangeField dateRange = (DateRangeField)element;
                    if (!isCheckDBField || StringUtils.isNotBlank((CharSequence)dateRange.getStartDateFieldName())) {
                        newKey = dateRange.getStartDateFieldKey();
                        newname = String.format(ResManager.loadKDString((String)"%s.\u5f00\u59cb", (String)"PrintDataSourceReader_24", (String)BOS_METADATA, (Object[])new Object[0]), element.getName());
                        PrintDataSourceReader.putInToItemsList(entityNodes, element, newKey, newname);
                    }
                    if (isCheckDBField && !StringUtils.isNotBlank((CharSequence)dateRange.getEndDateFieldName())) continue;
                    newKey = dateRange.getEndDateFieldKey();
                    newname = String.format(ResManager.loadKDString((String)"%s.\u7ed3\u675f", (String)"PrintDataSourceReader_25", (String)BOS_METADATA, (Object[])new Object[0]), element.getName());
                    PrintDataSourceReader.putInToItemsList(entityNodes, element, newKey, newname);
                    continue;
                }
                if (isCheckDBField && StringUtils.isEmpty((CharSequence)((Field)element).getFieldName()) || showFields != null && !showFields.isEmpty() && !(element instanceof SubEntryEntity) && showFields.stream().noneMatch(clazz -> clazz.isInstance(element)) || element instanceof RadioField) continue;
                if (element instanceof BasedataPropField) {
                    BasedataPropField basdataProp = (BasedataPropField)element;
                    if (basdataProp.getControlField() == null) continue;
                    curHeadKey = basdataProp.getControlField().getKey() + "." + basdataProp.getRefDisplayProp();
                    curHeadName = basdataProp.getName().getLocaleValue();
                    PrintDataSourceReader.putInToItemsList(entityNodes, element, curHeadKey, curHeadName);
                    continue;
                }
                PrintDataSourceReader.putInToItemsList(entityNodes, element, curHeadKey, curHeadName);
            }
            PrintDataSourceReader.putInToItemsList(fatherNode, entry, entry.getKey(), entry.getName().toString(), entityNodes);
        } else if (treeHeight == 3 || treeHeight >= 4) {
            // empty if block
        }
    }

    public void basedataEntityNode(AbstractBasedataField basedataField, String headKey, String headName, int treeHeight, List<Object> fatherNode, List<Class<? extends Field<?>>> showFields) {
        this.basedataEntityNode(basedataField, headKey, headName, treeHeight, fatherNode, showFields, Boolean.FALSE);
    }

    private void basedataEntityNode(AbstractBasedataField basedataField, String headKey, String headName, int treeHeight, List<Object> fatherNode, List<Class<? extends Field<?>>> showFields, boolean isLoadMateriaBizData) {
        HashMap eleNode = new HashMap();
        String baseEntityId = basedataField.getBaseEntityId();
        if (basedataField instanceof ItemClassField) {
            ArrayList<Object> itemsList = new ArrayList<Object>();
            String curHeadKey = headKey + ".number";
            String curHeadName = String.format(ResManager.loadKDString((String)"%s.\u7f16\u7801", (String)"PrintDataSourceReader_22", (String)BOS_METADATA, (Object[])new Object[0]), headName);
            PrintDataSourceReader.putInToItemsList(itemsList, basedataField, curHeadKey, curHeadName);
            String curHeadKey1 = headKey + ".name";
            String curHeadName1 = String.format(ResManager.loadKDString((String)"%s.\u540d\u79f0", (String)"PrintDataSourceReader_23", (String)BOS_METADATA, (Object[])new Object[0]), headName);
            PrintDataSourceReader.putInToItemsList(itemsList, basedataField, curHeadKey1, curHeadName1);
            String curHeadKey2 = "";
            curHeadKey2 = StringUtils.equals((CharSequence)headKey, (CharSequence)basedataField.getKey()) ? headKey : headKey + "." + basedataField.getKey();
            PrintDataSourceReader.putInToItemsList(fatherNode, basedataField, curHeadKey2, basedataField.getName().toString(), itemsList);
        } else if (StringUtils.isNotBlank((CharSequence)baseEntityId) && StringUtils.isNotBlank((CharSequence)basedataField.getFieldName())) {
            Object dt;
            MetadataReader bsdReader = new MetadataReader();
            EntityMetadata baseMetadata = null;
            if (!this.baseDataMetaCache.containsKey(baseEntityId)) {
                baseMetadata = (EntityMetadata)bsdReader.readMeta(baseEntityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
                this.baseDataMetaCache.put(baseEntityId, baseMetadata);
            } else {
                baseMetadata = this.baseDataMetaCache.get(baseEntityId);
            }
            String number = baseMetadata.getKey();
            if (StringUtils.isBlank((CharSequence)number)) {
                fatherNode.add(eleNode);
            }
            boolean isControlShowfield = showFields != null && !showFields.isEmpty();
            ArrayList<Object> itemsList = new ArrayList<Object>();
            if (treeHeight >= 3 || basedataField instanceof BillTypeField || basedataField instanceof AssistantField) {
                if (!isControlShowfield) {
                    dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)number);
                    String string = dt.getNameProperty();
                    String numberProperty = dt.getNumberProperty();
                    for (EntityItem<?> entityItem : baseMetadata.getItems()) {
                        if (!StringUtils.equals((CharSequence)entityItem.getKey(), (CharSequence)string) && !StringUtils.equals((CharSequence)entityItem.getKey(), (CharSequence)numberProperty)) continue;
                        String curHeadKey = headKey + "." + entityItem.getKey();
                        String curHeadName = headName + "." + entityItem.getName();
                        PrintDataSourceReader.putInToItemsList(itemsList, basedataField, curHeadKey, curHeadName);
                    }
                }
            } else if (basedataField instanceof OrgField) {
                if (!isControlShowfield) {
                    dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)number);
                    Map map = dt.getAllFields();
                    Set properties = map.keySet();
                    for (String string : properties) {
                        for (EntityItem<?> element : baseMetadata.getItems()) {
                            if (!StringUtils.equals((CharSequence)element.getKey(), (CharSequence)string)) continue;
                            if (element instanceof BasedataField) {
                                BasedataEntityType subEType = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)number, basedataField.getRuntimeRefProps());
                                String nameProperty = subEType.getNameProperty();
                                String numberProperty = subEType.getNumberProperty();
                                for (EntityItem<?> item : baseMetadata.getItems()) {
                                    if (!StringUtils.equals((CharSequence)item.getKey(), (CharSequence)nameProperty) && !StringUtils.equals((CharSequence)item.getKey(), (CharSequence)numberProperty)) continue;
                                    String curHeadKey = headKey + "." + element.getKey() + "." + item.getKey();
                                    String curHeadName = headName + "." + element.getName() + "." + item.getName();
                                    PrintDataSourceReader.putInToItemsList(itemsList, basedataField, curHeadKey, curHeadName);
                                }
                                continue;
                            }
                            String curHeadKey = headKey + "." + element.getKey();
                            String curHeadName = headName + "." + element.getName();
                            PrintDataSourceReader.putInToItemsList(itemsList, basedataField, curHeadKey, curHeadName);
                        }
                    }
                }
            } else {
                for (EntityItem entityItem : baseMetadata.getRootEntity().getItems()) {
                    boolean bl;
                    if (entityItem instanceof DateRangeField) {
                        Object newKey;
                        DateRangeField dateRange = (DateRangeField)entityItem;
                        if (StringUtils.isNotBlank((CharSequence)dateRange.getStartDateFieldName())) {
                            newKey = headKey + "." + dateRange.getStartDateFieldKey();
                            String string = String.format(ResManager.loadKDString((String)"%1$s.%2$s.\u5f00\u59cb", (String)"PrintDataSourceReader_26", (String)BOS_METADATA, (Object[])new Object[0]), headName, entityItem.getName());
                            PrintDataSourceReader.putInToItemsList(itemsList, entityItem, (String)newKey, string);
                        }
                        if (StringUtils.isNotBlank((CharSequence)dateRange.getEndDateFieldName())) {
                            newKey = headKey + "." + dateRange.getEndDateFieldKey();
                            String string = String.format(ResManager.loadKDString((String)"%1$s.%2$s.\u7ed3\u675f", (String)"PrintDataSourceReader_27", (String)BOS_METADATA, (Object[])new Object[0]), headName, entityItem.getName());
                            PrintDataSourceReader.putInToItemsList(itemsList, entityItem, (String)newKey, string);
                        }
                    }
                    if (!(entityItem instanceof MulBasedataField) && entityItem instanceof Field && StringUtils.isBlank((CharSequence)((Field)entityItem).getFieldName()) || showFields != null && !showFields.isEmpty() && showFields.stream().noneMatch(clazz -> clazz.equals(element.getClass())) || entityItem instanceof AssistantField || entityItem instanceof ItemClassTypeField || entityItem instanceof ItemClassField || entityItem instanceof RadioField) continue;
                    if (entityItem instanceof EntryEntity) {
                        EntryEntity entityElement = (EntryEntity)entityItem;
                        if (StringUtils.isEmpty((CharSequence)entityElement.getTableName())) continue;
                        for (EntityItem entityItem2 : entityElement.getItems()) {
                            String curHeadKey = headKey + "." + entityElement.getKey() + "." + entityItem2.getKey();
                            String curHeadName = headName + "." + entityElement.getName() + "." + entityItem2.getName();
                            if (entityItem2 instanceof BasedataField) {
                                if (StringUtils.isBlank((CharSequence)((BasedataField)entityItem2).getFieldName())) continue;
                                String curHeadKey1 = curHeadKey + ".number";
                                String curHeadName1 = String.format(ResManager.loadKDString((String)"%s.\u7f16\u7801", (String)"PrintDataSourceReader_22", (String)BOS_METADATA, (Object[])new Object[0]), curHeadName);
                                PrintDataSourceReader.putInToItemsList(itemsList, entityItem2, curHeadKey1, curHeadName1);
                                curHeadKey1 = curHeadKey + ".name";
                                curHeadName1 = String.format(ResManager.loadKDString((String)"%s.\u540d\u79f0", (String)"PrintDataSourceReader_23", (String)BOS_METADATA, (Object[])new Object[0]), curHeadName);
                                PrintDataSourceReader.putInToItemsList(itemsList, entityItem2, curHeadKey1, curHeadName1);
                                continue;
                            }
                            if (!(entityItem2 instanceof Field) || StringUtils.isBlank((CharSequence)((Field)entityItem2).getFieldName())) continue;
                            PrintDataSourceReader.putInToItemsList(itemsList, entityItem2, curHeadKey, curHeadName);
                        }
                    }
                    String curHeadKey = headKey + "." + entityItem.getKey();
                    String curHeadName = headName + "." + entityItem.getName();
                    boolean bl2 = false;
                    boolean bl3 = bl = basedataField instanceof BasedataField && ((BasedataField)basedataField).isBizBasedata() && entityItem instanceof MasterIdField;
                    if (bl) {
                        this.basedataEntityNode((AbstractBasedataField)entityItem, curHeadKey, curHeadName, treeHeight, itemsList, showFields, Boolean.TRUE);
                        continue;
                    }
                    if (entityItem instanceof BasedataField) {
                        this.basedataEntityNode((BasedataField)entityItem, curHeadKey, curHeadName, treeHeight + 1, itemsList, showFields);
                        continue;
                    }
                    if (!(entityItem instanceof Field)) continue;
                    PrintDataSourceReader.putInToItemsList(itemsList, entityItem, curHeadKey, curHeadName);
                }
            }
            String curHeadKey = "";
            curHeadKey = StringUtils.equals((CharSequence)headKey, (CharSequence)basedataField.getKey()) || isLoadMateriaBizData ? headKey : headKey + "." + basedataField.getKey();
            if (itemsList.size() > 0) {
                PrintDataSourceReader.putInToItemsList(fatherNode, basedataField, curHeadKey, basedataField.getName().toString(), itemsList);
            }
        }
    }

    private static void putInToItemsList(List<Object> entityNodes, EntityItem<?> field, String curHeadKey, String curHeadName) {
        if (PrintDataSourceReader.isSupportInPrint(field)) {
            PrintDataSourceReader.putInToItemsList(entityNodes, field, curHeadKey, curHeadName, null);
        }
    }

    private static void putInToItemsList(List<Object> entityNodes, EntityItem<?> element, String curHeadKey, String curHeadName, List<Object> items) {
        HashMap<String, Object> eleNode = new HashMap<String, Object>();
        eleNode.put("Id", curHeadKey);
        eleNode.put("Type", element.getClass().getSimpleName());
        eleNode.put("Name", curHeadName);
        if (items != null && !items.isEmpty()) {
            eleNode.put(ITEMS, items);
        }
        if (element instanceof EntryEntity) {
            eleNode.put(DS_TYPE, DS_TYPE_ENTRY);
        }
        entityNodes.add(eleNode);
    }
}

