/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class RedisAppMetadataCache {
    RedisAppMetadataCache() {
    }

    static String get(DistributeSessionlessCache cache, int metaType, String appNumber, String key) {
        return (String)cache.get(RedisAppMetadataCache.getAppCacheType(appNumber), RedisAppMetadataCache.getCacheKey(key, metaType));
    }

    static void put(DistributeSessionlessCache cache, int metaType, String appNumber, String key, String val) {
        cache.put(RedisAppMetadataCache.getAppCacheType(appNumber), RedisAppMetadataCache.getCacheKey(key, metaType), (Object)val);
    }

    static void remove(DistributeSessionlessCache cache, int metaType, String appNumber, String key) {
        cache.remove(RedisAppMetadataCache.getAppCacheType(appNumber), RedisAppMetadataCache.getCacheKey(key, metaType));
    }

    static void remove(DistributeSessionlessCache cache, String appNumber) {
        cache.remove(RedisAppMetadataCache.getAppCacheType(appNumber));
    }

    static void remove(DistributeSessionlessCache cache, String appGroup, String appNumber) {
        cache.remove(RedisAppMetadataCache.getAppCacheType(appGroup, appNumber));
    }

    static void removeBatch(DistributeSessionlessCache cache, String ... appNumbers) {
        String[] cacheKeys = new String[appNumbers.length];
        for (int i = 0; i < appNumbers.length; ++i) {
            cacheKeys[i] = RedisAppMetadataCache.getAppCacheType(appNumbers[i]);
        }
        cache.remove(cacheKeys);
    }

    private static String getAppCacheType(String appNumber) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return RedisAppMetadataCache.getAppCacheType(appGroup, appNumber);
    }

    private static String getAppCacheType(String appGroup, String appNumber) {
        String accountId = CacheKeyUtil.getAcctId();
        if ("defaultGroup".equals(appGroup)) {
            return String.format("%s_appmeta_%s", accountId, appNumber);
        }
        return String.format("%s_appmeta_%s_%s", accountId, appGroup, appNumber);
    }

    private static String getCacheKey(String key, int metaType) {
        return String.format("%s_%s", metaType, key);
    }
}

