/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.util.List;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class RedisEntityTypeCache {
    static final int ENTITY_TYPE = 11;

    RedisEntityTypeCache() {
    }

    static String get(DistributeSessionlessCache cache, String number, String key) {
        return (String)cache.get(RedisEntityTypeCache.getCacheType(), number);
    }

    static List<String> get(DistributeSessionlessCache cache, String[] numbers) {
        return cache.get(RedisEntityTypeCache.getCacheType(), numbers);
    }

    static void put(DistributeSessionlessCache cache, String number, String key, String val) {
        cache.put(RedisEntityTypeCache.getCacheType(), number, (Object)val);
    }

    static void put(DistributeSessionlessCache cache, Map<String, String> map) {
        cache.put(RedisEntityTypeCache.getCacheType(), map);
    }

    static void remove(DistributeSessionlessCache cache, String number, String key) {
        cache.remove(RedisEntityTypeCache.getCacheType(), number);
    }

    static void remove(DistributeSessionlessCache cache, String[] numbers) {
        cache.remove(RedisEntityTypeCache.getCacheType(), numbers);
    }

    static void removeAppGroup(DistributeSessionlessCache cache, String appGroup, List<String> numbers) {
        cache.remove(RedisEntityTypeCache.getCacheType(appGroup), numbers.toArray(new String[0]));
    }

    private static String getCacheType() {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return RedisEntityTypeCache.getCacheType(appGroup);
    }

    private static String getCacheType(String appGroup) {
        String accountId = CacheKeyUtil.getAcctId();
        if ("defaultGroup".equals(appGroup)) {
            return String.format("%s_meta_%s", accountId, 11);
        }
        return String.format("%s_meta_%s_%s", accountId, appGroup, 11);
    }
}

