/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.converter.IMetadataConverter;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.service.ServiceFactory;

public abstract class MetadataConverter
implements IMetadataConverter {
    private static final String ZH_CN = "zh_CN";
    private static final Log logger = LogFactory.getLog(MetadataConverter.class);
    protected MetadataSerializer serializer;

    @Override
    public AbstractMetadata convertTo(Map<String, Object> content) {
        Map formMeta = (Map)content.get("formmeta");
        String modelType = (String)formMeta.get("ModelType");
        String bizappid = (String)content.get("bizappid");
        Integer subSystemId = (Integer)content.get("subSystem");
        subSystemId = subSystemId == null ? Integer.valueOf(1) : subSystemId;
        this.serializer = new MetadataSerializer(modelType);
        if (this.serializer.getBinder() instanceof DomainModelBinder) {
            ((DomainModelBinder)this.serializer.getBinder()).setInheritFix(true);
        }
        String defaultLCid = this.getLang(content);
        this.serializer.getBinder().setLCId(defaultLCid);
        AbstractMetadata metadata = (AbstractMetadata)this.serializer.deserializeFromMap(formMeta, null);
        Map localeItems = (Map)content.get("localeItems");
        if (localeItems != null) {
            List formlocaleItems = (List)localeItems.get("form");
            this.restoreLang(metadata, formlocaleItems, defaultLCid);
        }
        metadata.setBizappId(bizappid);
        return metadata;
    }

    @Override
    public String getLang(Map<String, Object> content) {
        String lang = (String)content.get("language");
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = ZH_CN;
        }
        return lang;
    }

    protected void restoreLang(AbstractMetadata metadata, List<Map<String, Map<String, Object>>> localeItems, String excludeLang) {
        LangWriter writer = new LangWriter(this.serializer.getBinder(), metadata, localeItems);
        ArrayList<String> langs = new ArrayList<String>();
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List<String> designerLangs = new ArrayList<String>();
        List languages = inteService.getEnabledLang();
        if (null != languages && !languages.isEmpty()) {
            for (EnabledLang lang : languages) {
                if (!StringUtils.isNotBlank((CharSequence)lang.getNumber())) continue;
                designerLangs.add(lang.getNumber());
            }
        }
        if (null == designerLangs || designerLangs.isEmpty()) {
            designerLangs = Arrays.asList(ZH_CN, "zh_TW", "en_US");
        }
        for (String dlang : designerLangs) {
            if (dlang.equals(excludeLang)) continue;
            langs.add(dlang);
        }
        writer.setLoaceValue(langs);
        for (String dlang : designerLangs) {
            if (ZH_CN.equals(dlang)) continue;
            writer.setNullLoaceValue(dlang, ZH_CN);
        }
    }
}

