/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.converter.MetadataConverter;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.service.ServiceFactory;

public class PrintMetadataConverter
extends MetadataConverter {
    private static final String ZH_CN = "zh_CN";

    @Override
    protected void restoreLang(AbstractMetadata metadata, List<Map<String, Map<String, Object>>> localeItems, String excludeLang) {
        LangWriter writer = new LangWriter(this.serializer.getBinder(), metadata, localeItems);
        ArrayList<String> langs = new ArrayList<String>();
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List<String> designerLangs = new ArrayList<String>();
        List languages = inteService.getLocalLangForPrint("1");
        if (null != languages && !languages.isEmpty()) {
            for (EnabledLang lang : languages) {
                if (!StringUtils.isNotBlank((CharSequence)lang.getNumber())) continue;
                designerLangs.add(lang.getNumber());
            }
        }
        if (null == designerLangs || designerLangs.isEmpty()) {
            designerLangs = Arrays.asList(ZH_CN, "zh_TW", "en_US");
        }
        for (String dlang : designerLangs) {
            if (dlang.equals(excludeLang)) continue;
            langs.add(dlang);
        }
        writer.setLoaceValue(langs);
        for (String dlang : designerLangs) {
            if (ZH_CN.equals(dlang)) continue;
            writer.setNullLoaceValue(dlang, ZH_CN, false);
        }
    }
}

