/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao.sharding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.configchanged.DBShardingConfigNotifier;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.LinkEntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.TreeEntryEntity;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import org.apache.commons.codec.binary.StringUtils;

public class ShardingUtil {
    private static final String BOS_METADATA = "bos-metadata";
    private static Set<String> formSet = new HashSet<String>(9);

    public static boolean isUseShardingAndCheckReady(AbstractMetadata ... metadatas) {
        if (DB.isXDBEnable()) {
            for (AbstractMetadata metadata : metadatas) {
                if (!(metadata instanceof FormMetadata)) continue;
                String oldEntityName = MetadataDao.getEntityNumberById(metadata.getId());
                if (oldEntityName == null || formSet.contains(oldEntityName)) {
                    return false;
                }
                ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(oldEntityName);
                if (configEntity != null && ShardConfigStatusEnum.ENABLE != configEntity.getConfigstatus() && ShardConfigStatusEnum.DISABLE != configEntity.getConfigstatus()) {
                    throw new RuntimeException(ResManager.loadKDString((String)"\u5206\u7247\u914d\u7f6e\u751f\u6548\u4e2d\uff0c\u6570\u636e\u5c1a\u672a\u8fc1\u79fb\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u66f4\u6539: ", (String)"ShardingUtil_0", (String)BOS_METADATA, (Object[])new Object[0]));
                }
                String entityName = ((FormMetadata)metadata).getRootAp().getKey();
                if (configEntity != null && !StringUtils.equals((CharSequence)entityName, (CharSequence)oldEntityName)) {
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5206\u7247\u914d\u7f6e%s\uff0c\u987b\u5220\u9664\u8be5\u914d\u7f6e\u540e\u624d\u5141\u8bb8\u4fee\u6539\u8be5\u8868\u5355\u6807\u8bc6\u3002", (String)"ShardingUtil_3", (String)BOS_METADATA, (Object[])new Object[0]), oldEntityName));
                }
                boolean useSharding = configEntity != null && configEntity.getConfigstatus() == ShardConfigStatusEnum.ENABLE;
                return useSharding;
            }
        }
        return false;
    }

    public static boolean isUseSharding(EntityMetadata meta) {
        if (DB.isXDBEnable()) {
            String entityName = meta.getKey();
            if (formSet.contains(entityName)) {
                return false;
            }
            try {
                ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entityName);
                boolean useSharding = configEntity != null && configEntity.getConfigstatus() != ShardConfigStatusEnum.DISABLE;
                return useSharding;
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
        return false;
    }

    public static void ensureAdd2CurrentRuntimeShardingConfig(EntityMetadata em, Entity<?, ?> entity, String tableName, String trackParentTableName) {
        ShardingConfigProvider scp = XDBConfig.getShardingConfigProvider();
        if (scp.getConfig(tableName) == null) {
            String parentTableName = em.getRootEntity().getTableName();
            ShardingConfig parentShardingConfig = scp.getConfig(parentTableName);
            if (parentShardingConfig != null) {
                if (entity instanceof BillEntity) {
                    StringBuilder childName = new StringBuilder(parentShardingConfig.getName());
                    String pkField = ((BillEntity)entity).getPkFieldName();
                    ShardingConfig config = ShardingConfig.childrenTable((String)childName.toString(), (String)tableName, (String)pkField, (String)pkField, (ShardingConfig)parentShardingConfig);
                    config.setEnabled(parentShardingConfig.isEnabled());
                    DBShardingRuntime.get().setTableRWAtCurrentNode(true, true, tableName);
                    scp.addConfig(config);
                } else if (trackParentTableName != null && entity instanceof EntryEntity) {
                    if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"wbsnapentity", (CharSequence)entity.getKey())) {
                        String childName = parentShardingConfig.getName().split("\\.")[0] + ".wb";
                        String pkField = "fid";
                        ShardingConfig config = ShardingConfig.childrenTable((String)childName, (String)tableName, (String)pkField, (String)pkField, (ShardingConfig)parentShardingConfig);
                        config.setEnabled(parentShardingConfig.isEnabled());
                        ((ChildrenTableConfig)config).setWbTableConfig();
                        DBShardingRuntime.get().setTableRWAtCurrentNode(true, true, tableName);
                        scp.addConfig(config);
                    }
                } else {
                    String linkKey = entity.getKey().toLowerCase();
                    List<Entity<?, ?>> entitys = em.getEntitys();
                    Entity e = null;
                    for (Entity<?, ?> lkEntity : entitys) {
                        if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)linkKey, (CharSequence)(lkEntity.getKey() + "_lk"))) continue;
                        e = lkEntity;
                        break;
                    }
                    if (e == null && entity instanceof LinkEntryEntity) {
                        e = em.getRootEntity();
                    }
                    if (e == null) {
                        e = entity;
                    }
                    if (e != null && !(e instanceof TreeEntryEntity)) {
                        String pkField = e.getClass().isAssignableFrom(BillEntity.class) ? ((BillEntity)e).getPkFieldName() : (e.getClass().isAssignableFrom(EntryEntity.class) ? ((EntryEntity)e).getEntryPkFieldName() : (e.getClass().isAssignableFrom(SubEntryEntity.class) ? ((SubEntryEntity)e).getEntryPkFieldName() : "fid"));
                        parentShardingConfig = scp.getConfig(e.getTableName());
                        StringBuilder childName = new StringBuilder();
                        if (parentShardingConfig == null) {
                            parentShardingConfig = ShardingUtil.findParentShardingConfig(em, e);
                            childName.append(parentShardingConfig.getName()).append(".").append(e.getKey());
                        } else {
                            childName.append(parentShardingConfig.getName());
                        }
                        if (entity instanceof LinkEntryEntity) {
                            childName.append(".").append(linkKey);
                        }
                        ShardingConfig config = ShardingConfig.childrenTable((String)childName.toString(), (String)tableName, (String)pkField, (String)pkField, (ShardingConfig)parentShardingConfig);
                        config.setEnabled(parentShardingConfig.isEnabled());
                        DBShardingRuntime.get().setTableRWAtCurrentNode(true, true, tableName);
                        if (entity instanceof LinkEntryEntity) {
                            ((ChildrenTableConfig)config).setLkTableConfig();
                        }
                        scp.addConfig(config);
                    }
                }
            } else if (trackParentTableName != null && (parentShardingConfig = scp.getConfig(trackParentTableName)) != null) {
                StringBuffer childName = new StringBuffer(parentShardingConfig.getName());
                if (entity instanceof BillEntity) {
                    String pkField = ((BillEntity)entity).getPkFieldName();
                    childName.append(".").append("track");
                    ShardingConfig config = ShardingConfig.childrenTable((String)childName.toString(), (String)tableName, (String)"FTBillId", (String)pkField, (ShardingConfig)parentShardingConfig);
                    config.setEnabled(parentShardingConfig.isEnabled());
                    ((ChildrenTableConfig)config).setTcTableConfig();
                    DBShardingRuntime.get().setTableRWAtCurrentNode(true, true, tableName);
                    scp.addConfig(config);
                }
            }
        }
    }

    private static ShardingConfig findParentShardingConfig(EntityMetadata em, Entity e) {
        MainEntity rootEntity = em.getRootEntity();
        List<EntityItem<?>> items = rootEntity.getItems();
        String parentName = ShardingUtil.collectExplicitlyParentTableName(items, e, rootEntity.getTableName());
        if (parentName == null) {
            parentName = rootEntity.getTableName();
        }
        return XDBConfig.getShardingConfigProvider().getConfig(parentName);
    }

    private static String collectExplicitlyParentTableName(List<EntityItem<?>> items, Entity e, String tableName) {
        for (EntityItem<?> item : items) {
            if (!(item instanceof EntryEntity)) continue;
            if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)item.getKey())) {
                return tableName;
            }
            String explicitlyName = ShardingUtil.collectExplicitlyParentTableName(((EntryEntity)item).getItems(), e, ((EntryEntity)item).getTableName());
            if (explicitlyName == null) continue;
            return explicitlyName;
        }
        return null;
    }

    public static List<ShardingConfig> getGroupTableShardingConfigsInEntityByNumber(String entityName, List<ShardingConfig> collectedShardingConfigs, boolean isMock) {
        EntityMetadata meta;
        MainEntity rootEntity;
        String mainTable;
        ShardingConfig mainConfig;
        ArrayList<ShardingConfig> ret = new ArrayList<ShardingConfig>(8);
        if (collectedShardingConfigs != null && !collectedShardingConfigs.isEmpty() && (mainConfig = ShardingUtil.getExplicitlyShardingConfig(mainTable = (rootEntity = (meta = (EntityMetadata)MetadataDao.readRuntimeMeta(MetadataDao.getIdByNumber(entityName, MetaCategory.Entity), MetaCategory.Entity)).getRootEntity()).getTableName(), collectedShardingConfigs)) != null) {
            List<SplitTable> splitTables = rootEntity.getSplitTables();
            if (!splitTables.isEmpty()) {
                for (SplitTable splitTable : splitTables) {
                    StringBuilder childName = new StringBuilder(mainConfig.getName());
                    String pkField = ((BillEntity)rootEntity).getPkFieldName();
                    ShardingConfig config = ShardingConfig.childrenTable((String)childName.toString(), (String)(mainConfig.getTable() + "_" + splitTable.getSuffix()), (String)pkField, (String)pkField, (ShardingConfig)mainConfig, (boolean)isMock);
                    ((ChildrenTableConfig)config).setGroupTableConfig();
                    config.setEnabled(mainConfig.isEnabled());
                    ret.add(config);
                }
            }
            List<EntityItem<?>> items = meta.getItems();
            for (EntityItem<?> item : items) {
                ShardingConfig parentShardingConfig;
                List<SplitTable> entrySplitTables;
                if (!(item instanceof EntryEntity) || (entrySplitTables = ((EntryEntity)item).getSplitTables()).isEmpty() || (parentShardingConfig = ShardingUtil.getExplicitlyShardingConfig(((EntryEntity)item).getTableName(), collectedShardingConfigs)) == null) continue;
                for (SplitTable entrySplitTable : entrySplitTables) {
                    StringBuilder childName = new StringBuilder(parentShardingConfig.getName());
                    String pkField = ((EntryEntity)item).getEntryPkFieldName();
                    ShardingConfig config = ShardingConfig.childrenTable((String)childName.toString(), (String)(parentShardingConfig.getTable() + "_" + entrySplitTable.getSuffix()), (String)pkField, (String)pkField, (ShardingConfig)parentShardingConfig, (boolean)isMock);
                    ((ChildrenTableConfig)config).setGroupTableConfig();
                    config.setEnabled(parentShardingConfig.isEnabled());
                    ret.add(config);
                }
            }
        }
        return ret;
    }

    private static ShardingConfig getExplicitlyShardingConfig(String tableName, List<ShardingConfig> collectedShardingConfigs) {
        for (ShardingConfig collectedShardingConfig : collectedShardingConfigs) {
            if (!collectedShardingConfig.getTable().equals(tableName)) continue;
            return collectedShardingConfig;
        }
        return null;
    }

    public static void fireReloadShardingConfig(final AbstractMetadata ... metadatas) {
        for (AbstractMetadata metadata : metadatas) {
            if (!(metadata instanceof EntityMetadata)) continue;
            EntityMetadata em = (EntityMetadata)metadata;
            String mainTableName = em.getRootEntity().getTableName();
            ShardingConfigProvider scp = XDBConfig.getShardingConfigProvider();
            MainTableConfig mainConfig = (MainTableConfig)scp.getConfig(mainTableName);
            HashMap<String, ShardingConfig> childrenConfigMap = new HashMap<String, ShardingConfig>();
            for (ShardingConfig shardingConfig : new HashSet(scp.getConfigs())) {
                if (!(shardingConfig instanceof ChildrenTableConfig) || ((ChildrenTableConfig)shardingConfig).getParent() != mainConfig) continue;
                childrenConfigMap.put(shardingConfig.getTable(), shardingConfig);
            }
            for (Entity entity : em.getEntitys()) {
                if (entity.getTableName() == null) continue;
                childrenConfigMap.remove(entity.getTableName().toLowerCase());
            }
            if (childrenConfigMap.isEmpty()) continue;
            for (String string : childrenConfigMap.keySet()) {
                scp.removeConfig(string);
            }
        }
        try (TXHandle th = TX.required();){
            TX.addCommitListener((CommitListener)new CommitListener(){

                public void onEnded(boolean rollbacked) {
                    for (AbstractMetadata metadata : metadatas) {
                        if (!(metadata instanceof FormMetadata)) continue;
                        String entityName = ((FormMetadata)metadata).getRootAp().getKey();
                        DBShardingConfigNotifier.fireReloadShardingConfig((String)entityName);
                    }
                }
            });
        }
    }

    static {
        formSet.addAll(Arrays.asList("bos_cbs_shard_config", "bos_cbs_add_config", "bos_cbs_shard_fields", "bos_cbs_shard_params", "bos_cbs_shard_strategy", "bos_cbs_shard_task", "bos_cbs_shard_log", "bos_cbs_shard_name_map", "bos_cbs_shard_cluster"));
    }
}

