/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.deploy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployFileUtils;
import kd.bos.metadata.deploy.DeployParameter;
import kd.bos.metadata.deploy.MetaDeploy;
import kd.bos.util.FileUtils;

public class CustomMetaDeploy {
    private static final Log LOGGER = LogFactory.getLog(CustomMetaDeploy.class);
    private static final String KEY_ERROR = "error";
    private static final String KEY_ERROR_MSGS = "err_msgs";
    private static final String KEY_SUCCESS_FILES = "success_files";
    private static final String SUBPATH_METADATA = "metadata";
    private static final String BOS_METADATA = "bos-metadata";
    private static final String ERROR_STR_SQL = "Error:%s. sql:%s";
    private String custFileType;
    private IDataEntityType custDesignMetaType = null;
    private IDataEntityType custDesignMetaType_Lang = null;

    public CustomMetaDeploy(String custFileType) {
        this.custFileType = custFileType;
    }

    public CustomMetaDeploy(IDataEntityType custDesignMetaType, IDataEntityType custDesignMetaType_Lang, String custFileType) {
        this.custDesignMetaType = custDesignMetaType;
        this.custDesignMetaType_Lang = custDesignMetaType_Lang;
        this.custFileType = custFileType;
    }

    public String exportUrlFile(String[] ids, Map<String, Object> exportResult) {
        String zipFullFileName;
        String property = System.getProperty("user.home");
        String tempPath = String.valueOf(DB.genGlobalLongId());
        String localPath = FileUtils.cleanString((String)(property + File.separator + "KINGDEEDOWNLOAD" + File.separator + tempPath));
        File file = new File(FileUtils.cleanString((String)localPath));
        if (!file.exists()) {
            file.mkdirs();
        }
        if (StringUtils.isBlank((CharSequence)(zipFullFileName = this.exportZipFile(localPath, ids, exportResult)))) {
            return null;
        }
        String checkFilePath = FileUtils.cleanString((String)zipFullFileName);
        Path zipPath = Paths.get(checkFilePath, new String[0]);
        String zipFileName = zipPath.getName(zipPath.getNameCount() - 1).toString();
        String fileUrl = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
            fileUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFileName, (InputStream)in, 5000);
        }
        catch (IOException e1) {
            LOGGER.error(e1.getMessage());
        }
        DeployFileUtils.deleteKd(file);
        return fileUrl;
    }

    public String exportZipFile(String exportPath, String[] ids, Map<String, Object> exportResult) {
        ArrayList<String> exportFullFiles = new ArrayList<String>(ids.length * 4);
        ArrayList<String> exportFiles = new ArrayList<String>(ids.length * 4);
        for (String id : ids) {
            this.exportFile(exportPath, id, exportFullFiles, exportFiles, exportResult);
        }
        if (exportResult.get(KEY_ERROR) != null) {
            return "";
        }
        String zipFileName = ids[0];
        if (!exportFiles.isEmpty() && StringUtils.isNotBlank((CharSequence)((CharSequence)exportFiles.get(0)))) {
            zipFileName = (String)exportFiles.get(0);
            String[] strs = zipFileName.split("\\.");
            zipFileName = strs[0];
        }
        DeployFileUtils.zipFiles(zipFileName, exportPath);
        DeployFileUtils.deleteFiles(exportPath);
        exportResult.put("success", true);
        File zipFile = new File(FileUtils.cleanString((String)(exportPath + File.separator + zipFileName + ".zip")));
        if (zipFile.exists()) {
            return zipFile.getPath();
        }
        return "";
    }

    private void exportFile(String exportPath, String id, List<String> exportFullFiles, List<String> exportFiles, Map<String, Object> checkInMsg) {
        List<DeployFile> list = null;
        list = MetadataDao.getCustMetadataDeployFile(id, this.custDesignMetaType, this.custDesignMetaType_Lang, this.custFileType);
        for (DeployFile deployFile : list) {
            String exportFile;
            String fileName = deployFile.getFileName();
            String fileContent = deployFile.getFileContent();
            if (!fileName.endsWith("x") || fileName.indexOf("zh_CN") < 0) {
                // empty if block
            }
            if (!StringUtils.isNotBlank((CharSequence)(exportFile = DeployFileUtils.saveMetaXmlFile(exportPath, fileName, fileContent, checkInMsg)))) continue;
            exportFullFiles.add(exportFile);
            exportFiles.add(fileName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importUrlFile(String fileUrl, Map<String, Object> importResult) {
        String xmlFileSuffix = "." + this.custFileType;
        String langFileSuffix = "." + this.custFileType + "x";
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content zipContent = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            zipContent = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        }
        catch (MalformedURLException exp) {
            importResult.put(KEY_ERROR, true);
            List errMsgs = (List)importResult.computeIfAbsent(KEY_ERROR_MSGS, s -> new ArrayList(10));
            String errMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u89e3\u6790\u538b\u7f29\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u59cb\u4ee3\u7801\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"CustomMetaDeploy_0", (String)BOS_METADATA, (Object[])new Object[0]), exp.getMessage());
            errMsgs.add(errMsg);
            return false;
        }
        int limitsiz = 0x500000;
        DeployParameter deployParam = new DeployParameter();
        MetaDeploy metaDeploy = new MetaDeploy(deployParam);
        try (InputStream inStream = zipContent.getInputStream();
             ZipInputStream zipIn = new ZipInputStream(inStream);){
            ZipEntry zipEntry = null;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String metaName = zipEntry.getName();
                if (!metaName.startsWith(SUBPATH_METADATA)) {
                    importResult.put(KEY_ERROR, true);
                    List errMsgs = (List)importResult.computeIfAbsent(KEY_ERROR_MSGS, s -> new ArrayList(10));
                    String errMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u3010%s\u3011\u6587\u4ef6\u76ee\u5f55\u7ed3\u6784\u548c\u5bfc\u51fa\u751f\u6210\u7684\u76ee\u5f55\u7ed3\u6784\u4e0d\u4e00\u81f4\uff0c\u8bf7\u53c2\u8003\u5bfc\u51fa\u751f\u6210\u7684\u6587\u4ef6\u76ee\u5f55\u7ed3\u6784\u3002", (String)"CustomMetaDeploy_1", (String)BOS_METADATA, (Object[])new Object[0]), metaName);
                    errMsgs.add(errMsg);
                    boolean bl = false;
                    return bl;
                }
                if (!metaName.endsWith(xmlFileSuffix) && !metaName.endsWith(langFileSuffix)) continue;
                int readLength = 0;
                int len = 0;
                byte[] buf = new byte[limitsiz];
                while ((readLength = zipIn.read()) != -1) {
                    buf[len] = (byte)readLength;
                    ++len;
                }
                String xmlContent = new String(buf, 0, len);
                metaDeploy.deployMetadata(xmlContent);
                List successFiles = (List)importResult.computeIfAbsent(KEY_SUCCESS_FILES, s -> new ArrayList(10));
                successFiles.add(metaName);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            importResult.put(KEY_ERROR, true);
            List errMsgs = (List)importResult.computeIfAbsent(KEY_ERROR_MSGS, s -> new ArrayList(10));
            String errMsg = null;
            errMsg = zipContent != null ? String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u89e3\u6790\u538b\u7f29\u6587\u4ef6\u3010%1$s\u3011\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u59cb\u4ee3\u7801\u5f02\u5e38\u4fe1\u606f\uff1a%2$s", (String)"CustomMetaDeploy_2", (String)BOS_METADATA, (Object[])new Object[0]), zipContent.getFilename(), e.getMessage()) : String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u89e3\u6790\u538b\u7f29\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u59cb\u4ee3\u7801\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"CustomMetaDeploy_0", (String)BOS_METADATA, (Object[])new Object[0]), e.getMessage());
            errMsgs.add(errMsg);
            return false;
        }
    }
}

