/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;

class DeployFileUtils {
    private static final Log LOGGER = LogFactory.getLog(FileUtils.class);
    private static final String IS_DELETE = "is delete";
    private static final String KEY_ERROR = "error";
    private static final String SUBPATH_METADATA = "metadata";
    private static final String BOS_METADATA = "bos-metadata";

    DeployFileUtils() {
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public static void deleteFiles(String deletePath) {
        String checkPath = DeployFileUtils.checkFilePath(deletePath);
        DeployFileUtils.deleteKd(new File(checkPath + File.separator + "dbschema"));
        DeployFileUtils.deleteKd(new File(checkPath + File.separator + SUBPATH_METADATA));
        DeployFileUtils.deleteKd(new File(checkPath + File.separator + "preinsdata"));
    }

    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            boolean fileDelete = file.delete();
            if (fileDelete) {
                LOGGER.info(file + IS_DELETE);
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    boolean isDelFile = delfile.delete();
                    if (!isDelFile) continue;
                    LOGGER.info(delfile + IS_DELETE);
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                DeployFileUtils.deleteKd(fileList[i]);
            }
            boolean fileDelete = file.delete();
            if (fileDelete) {
                LOGGER.info(file + IS_DELETE);
            }
        }
    }

    public static void deleteFile(String deletePath) {
        String checkPath = DeployFileUtils.checkFilePath(deletePath);
        File file = new File(checkPath);
        DeployFileUtils.deleteKd(file);
    }

    public static String unZipSingleFile(String zipFileName, Map<String, Object> unZipResult) {
        File file = new File(zipFileName);
        if (!file.exists()) {
            unZipResult.put(KEY_ERROR, String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6\u9700\u5bfc\u5165\u7684\u6587\u4ef6 %s\u3002", (String)"DeployFileUtils_0", (String)BOS_METADATA, (Object[])new Object[0]), zipFileName));
            return "";
        }
        if (!zipFileName.endsWith(".zip")) {
            unZipResult.put(KEY_ERROR, ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6587\u4ef6\u5e94\u8be5\u662fzip\u6587\u4ef6\u3002", (String)"DeployFileUtils_1", (String)BOS_METADATA, (Object[])new Object[0]));
            return "";
        }
        String filePath = file.getParent();
        Path path = Paths.get(DeployFileUtils.checkFilePath(zipFileName), new String[0]);
        try (ZipInputStream in = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));){
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    String name = entry.getName();
                    name = name.substring(0, name.length() - 1);
                    File entryFile = new File(FileUtils.cleanString((String)(filePath + File.separator + name)));
                    entryFile.mkdirs();
                    continue;
                }
                String childFilePath = FileUtils.cleanString((String)(filePath + File.separator + entry.getName()));
                File child = new File(childFilePath);
                String childPath = child.getCanonicalPath();
                if (childPath.contains("\\")) {
                    childPath = childPath.replace('\\', '/');
                    child = new File(FileUtils.cleanString((String)childPath));
                }
                if (!child.getParentFile().exists()) {
                    child.getParentFile().mkdirs();
                }
                String checkChildFilePath = FileUtils.cleanString((String)childFilePath);
                Path customZipPath = Paths.get(DeployFileUtils.checkFilePath(checkChildFilePath), new String[0]);
                OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    BufferedOutputStream out = new BufferedOutputStream(outputStream);
                    Throwable throwable2 = null;
                    try {
                        int n = 0;
                        byte[] buf = new byte[1024];
                        while ((n = in.read(buf)) != -1) {
                            out.write(buf, 0, n);
                        }
                        in.closeEntry();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            unZipResult.put(KEY_ERROR, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u51fa\u9519: %s", (String)"DeployFileUtils_2", (String)BOS_METADATA, (Object[])new Object[0]), e.getMessage()));
            return "";
        }
        return filePath;
    }

    /*
     * Exception decompiling
     */
    public static String saveMetaXmlFile(String exportPath, String fileName, String fileContext, Map<String, Object> checkInMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getMetaXmlPath(String exportPath, String filename) {
        String fullPath = String.format("%s/%s/%s", exportPath, SUBPATH_METADATA, filename);
        return fullPath;
    }

    public static void zipFiles(String zipName, String zipPath) {
        ArrayList<String> files = new ArrayList<String>(10);
        String zipCheckPath = FileUtils.cleanString((String)zipPath);
        File file = new File(zipCheckPath);
        if (file.exists()) {
            files.add(zipCheckPath);
        }
        String zipFilePath = FileUtils.cleanString((String)(zipCheckPath + File.separator + zipName + ".zip"));
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DeployFileUtils.zipFile(files, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void zipFile(List<String> files, ZipOutputStream out) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File(DeployFileUtils.checkFilePath(files.get(i)));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                ArrayList<String> tempFiles = new ArrayList<String>(10);
                for (File tempFile : listFiles) {
                    try {
                        tempFiles.add(tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        LOGGER.error((Throwable)e);
                    }
                }
                DeployFileUtils.zipFile(tempFiles, out);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
            Path zipPath = null;
            if (path != null) {
                zipPath = Paths.get(DeployFileUtils.checkFilePath(path), new String[0]);
            }
            int t = -1;
            if (path != null && path.contains(SUBPATH_METADATA)) {
                t = path.indexOf(SUBPATH_METADATA);
            }
            if (path == null || t == -1) continue;
            if ((path = path.substring(t, path.length())) != null && path.contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

