/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.deploy;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadataBinder;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DeployMetadata {
    private static final DeployMetadataBinder DEPLOY_METADATA_BINDER = new DeployMetadataBinder();
    private List<AbstractDesignMeta> designMetas = new ArrayList<AbstractDesignMeta>();
    private String BOSVersion;
    private long version;
    private String id;
    private String bizunitId;
    private String bizappId;
    private String masterId;
    private boolean multilanguage = true;

    @SimplePropertyAttribute
    public String getBOSVersion() {
        if (this.BOSVersion == null) {
            this.BOSVersion = "1.0";
        }
        return this.BOSVersion;
    }

    public void setBOSVersion(String bOSVersion) {
        this.BOSVersion = bOSVersion;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=AbstractDesignMeta.class)
    public List<AbstractDesignMeta> getDesignMetas() {
        return this.designMetas;
    }

    public static DcBinder getDCBinder() {
        return DEPLOY_METADATA_BINDER;
    }

    public DeployFile toDeployFile(String fileName) {
        DcxmlSerializer serializer = new DcxmlSerializer((DcBinder)new DeployMetadataBinder());
        serializer.setIndent(true);
        serializer.setNewlines(true);
        String fileContent = serializer.serializeToString((Object)this, null);
        if (!fileContent.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") && !(fileContent = serializer.serializeToString((Object)this, null)).startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            throw new KDException(BosErrorCode.jSONParsing, new Object[]{ResManager.loadKDString((String)"\u5143\u6570\u636e\u5e8f\u5217\u5316\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01", (String)"DeployMetadata_0", (String)"bos-metadata", (Object[])new Object[0])});
        }
        return new DeployFile(fileName, fileContent);
    }

    @SimplePropertyAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @SimplePropertyAttribute
    public String getBizunitId() {
        return this.bizunitId;
    }

    public void setBizunitId(String bizunitId) {
        this.bizunitId = bizunitId;
    }

    @SimplePropertyAttribute
    public String getBizappId() {
        return this.bizappId;
    }

    public void setBizappId(String bizappId) {
        this.bizappId = bizappId;
    }

    @SimplePropertyAttribute(name="Multilanguage")
    @DefaultValueAttribute(value="true")
    public boolean isMultilanguage() {
        return this.multilanguage;
    }

    public void setMultilanguage(boolean multilanguage) {
        this.multilanguage = multilanguage;
    }

    @SimplePropertyAttribute
    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String masterId) {
        this.masterId = masterId;
    }

    @SimplePropertyAttribute
    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }
}

