/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.deploy;

import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.archive.tablemanager.meta.Imeta;
import kd.bos.archive.tablemanager.meta.MetaFactory;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.deploy.DeployCard;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.deploy.DeployParameter;
import kd.bos.metadata.deploy.DeploySchema;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.metadata.deploy.gray.GrayDeployMetadataWriter;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta;
import kd.bos.metadata.dynplugin.DynamicPluginDesignMeta;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.util.SAXReaderUtil;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.PkInfo;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class MetaDeploy {
    private static final String ERROR_STR_SQL = "Error:%s. sql:%s";
    private DeployParameter deployParam;
    private static Log log = LogFactory.getLog(MetaDeploy.class);
    public static final String BOS_METADATA = "bos-metadata";

    public MetaDeploy(DeployParameter deployParam) {
        this.deployParam = deployParam;
    }

    public void deployScript(String content) {
        DeployScript deployNew = DeployScript.create(content);
        List<DynamicObject> designDatas = deployNew.getScripts();
        if (designDatas.isEmpty()) {
            return;
        }
        IDataEntityType dt = this.getDataEntityType(designDatas.get(0).getDataEntityType());
        try (TXHandle h = TX.requiresNew();){
            try {
                Object[] pks = new Object[designDatas.size()];
                int i = 0;
                for (DynamicObject o : designDatas) {
                    pks[i] = o.get("id");
                    o.getDataEntityState().setDirty(true);
                    ++i;
                }
                BusinessDataWriter.delete((IDataEntityType)dt, (Object[])pks);
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])designDatas.toArray());
            }
            catch (Throwable e) {
                h.markRollback();
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deployScript")});
            }
        }
        for (DynamicObject o : designDatas) {
            MetaCacheUtils.removeDistributeCache(o.getString("number"));
        }
    }

    public void deployCard(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployCard.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployCard deployNew = (DeployCard)serializer.deserializeFromString(content, null);
        List<DynamicObject> designDatas = deployNew.getCards();
        if (designDatas.isEmpty()) {
            return;
        }
        IDataEntityType dt = this.getDataEntityType(designDatas.get(0).getDataEntityType());
        try (TXHandle h = TX.requiresNew();){
            try {
                Object[] pks = new Object[designDatas.size()];
                int i = 0;
                for (DynamicObject o : designDatas) {
                    pks[i] = o.get("id");
                    o.getDataEntityState().setDirty(true);
                    DynamicObjectCollection multilangCols = o.getDynamicObjectCollection("multilanguagetext");
                    if (multilangCols != null) {
                        for (DynamicObject multilang : multilangCols) {
                            multilang.getDataEntityState().setDirty(true);
                        }
                    }
                    ++i;
                }
                BusinessDataWriter.delete((IDataEntityType)dt, (Object[])pks);
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])designDatas.toArray());
            }
            catch (Throwable e) {
                h.markRollback();
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deployCard")});
            }
        }
    }

    public void deploySchema(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeploySchema.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeploySchema deployNew = (DeploySchema)serializer.deserializeFromString(content, null);
        List<DynamicObject> designDatas = deployNew.getSchemas();
        if (designDatas.isEmpty()) {
            return;
        }
        IDataEntityType dt = this.getDataEntityType(designDatas.get(0).getDataEntityType());
        try (TXHandle h = TX.requiresNew();){
            try {
                Object[] pks = new Object[designDatas.size()];
                int i = 0;
                for (DynamicObject o : designDatas) {
                    pks[i] = o.get("id");
                    o.getDataEntityState().setDirty(true);
                    DynamicObjectCollection multilangCols = o.getDynamicObjectCollection("multilanguagetext");
                    if (multilangCols != null) {
                        for (DynamicObject multilang : multilangCols) {
                            multilang.getDataEntityState().setDirty(true);
                        }
                    }
                    ++i;
                }
                BusinessDataWriter.delete((IDataEntityType)dt, (Object[])pks);
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])designDatas.toArray());
            }
            catch (Throwable e) {
                h.markRollback();
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deploySchema")});
            }
        }
    }

    public String deployMetadata(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
        return this.deployMetadata(deployNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deployMetadata(DeployMetadata deployNew) {
        block37: {
            String formId = deployNew.getId();
            try (DLock lock = DLock.create((String)("/GrayMetaDeploy/deployMetadata/" + RequestContext.get().getAccountId() + "/" + formId.replace("/", "aaaaaa"))).fastMode();){
                try {
                    if (lock.tryLock()) {
                        List<AbstractDesignMeta> designDatas = deployNew.getDesignMetas();
                        try (TXHandle h = TX.requiresNew();){
                            try {
                                if (!deployNew.isMultilanguage()) {
                                    Iterator<AbstractDesignMeta> bizUnitid = deployNew.getBizunitId();
                                    String bizAppid = deployNew.getBizappId();
                                    if (StringUtils.isNotEmpty((CharSequence)((Object)bizUnitid)) && StringUtils.isNotEmpty((CharSequence)bizAppid)) {
                                        MetaDeploy.insertPageIntoDevportal(formId, bizUnitid, bizAppid);
                                        for (AbstractDesignMeta dmeta : designDatas) {
                                            if (!(dmeta instanceof DesignFormMeta) && !(dmeta instanceof DesignEntityMeta)) continue;
                                            ((DesignMeta)dmeta).setBizappId(bizAppid);
                                        }
                                    }
                                }
                                for (AbstractDesignMeta dmeta : designDatas) {
                                    dmeta.deployMetadata();
                                    this.deleteDesignMeta(dmeta);
                                }
                                for (AbstractDesignMeta dmeta : designDatas) {
                                    this.saveDesignMeta(dmeta);
                                }
                                break block37;
                            }
                            catch (Throwable e) {
                                h.markRollback();
                                if (e instanceof KDException) {
                                    throw (KDException)e;
                                }
                                if (e instanceof OrmException) {
                                    throw (OrmException)e;
                                }
                                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deployMetadata")});
                            }
                        }
                    }
                    lock.lock();
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return deployNew.getMasterId() == null ? deployNew.getId() : deployNew.getMasterId();
    }

    public void deploySuperMetas(String tableName, Object[] ids) {
        if (ids.length == 0) {
            return;
        }
        Imeta meta = MetaFactory.getMeta((DBRoute)DBRoute.meta);
        List columnList = meta.queryColumns(DBRoute.meta, tableName);
        PkInfo pkInfo = meta.queryPkInfo(DBRoute.meta, tableName);
        SqlBuilder sql = new SqlBuilder();
        sql.append("insert into ", new Object[0]).append(this.getGrayTableName(tableName), new Object[0]).append(" select ", new Object[0]);
        sql.append("A.", new Object[0]).append(((Column)columnList.get(0)).getColumnName(), new Object[0]);
        for (int i = 1; i < columnList.size(); ++i) {
            sql.append(",A.", new Object[0]).append(((Column)columnList.get(i)).getColumnName(), new Object[0]);
        }
        sql.append(" from ", new Object[0]).append(tableName, new Object[0]).append(" A where ", new Object[0]).appendIn("FID", ids).append(" and not exists (select 1 from ", new Object[0]).append(this.getGrayTableName(tableName), new Object[0]).append(" WHERE ", new Object[0]);
        List icsList = pkInfo.getColumnNameList();
        IndexColumnString indexColumnString = (IndexColumnString)icsList.get(0);
        sql.append(indexColumnString.getColumn(), new Object[0]).append(" = A.", new Object[0]).append(indexColumnString.getColumn(), new Object[0]);
        for (int i = 1; i < icsList.size(); ++i) {
            sql.append(" AND ", new Object[0]).append(((IndexColumnString)icsList.get(i)).getColumn(), new Object[0]).append(" = A.", new Object[0]).append(((IndexColumnString)icsList.get(i)).getColumn(), new Object[0]);
        }
        sql.append(")", new Object[0]);
        DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)sql);
    }

    public List<String> deployAppMetadata(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployAppMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployAppMetadata deployNew = (DeployAppMetadata)serializer.deserializeFromString(content, null);
        List<AbstractDesignMeta> designDatas = deployNew.getDesignMetas();
        try (TXHandle h = TX.requiresNew();){
            try {
                for (AbstractDesignMeta dmeta : designDatas) {
                    this.deleteDesignMeta(dmeta);
                }
                for (AbstractDesignMeta dmeta : designDatas) {
                    DesignAppMeta desianAppMeta;
                    if (dmeta instanceof DesignAppMeta && (desianAppMeta = (DesignAppMeta)dmeta).getIndustryId() == null) {
                        desianAppMeta.setIndustryId(0L);
                    }
                    this.saveDesignMeta(dmeta);
                }
            }
            catch (OrmException e) {
                h.markRollback();
                throw e;
            }
            catch (Throwable e) {
                h.markRollback();
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deployAppMetadata")});
            }
        }
        String id = deployNew.getMasterId() == null ? deployNew.getId() : deployNew.getMasterId();
        MetaRebuilder mr = new MetaRebuilder(this.getAppGroup());
        mr.clearAppCache(deployNew.getId(), id);
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(id);
        return appIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployCloud(String content) {
        block36: {
            if (content.contains("DeployCloudMetadata")) {
                SAXReader reader = SAXReaderUtil.getSAXReader();
                StringReader strReader = new StringReader(content);
                try {
                    Document doc = reader.read((Reader)strReader);
                    String rooElementName = doc.getDocument().getRootElement().getName();
                    if ("DeployCloudMetadata".equals(rooElementName)) {
                        return;
                    }
                }
                catch (DocumentException ex) {
                    throw new OrmException("Deserialize.DocumentException", ex.getMessage(), (Throwable)ex);
                }
            }
            DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
            List<AbstractDesignMeta> designDatas = deployNew.getDesignMetas();
            String cloudId = deployNew.getId();
            try (DLock lock = DLock.create((String)("MetaDeploy.deployCloud" + RequestContext.get().getAccountId() + "_" + cloudId)).fastMode();){
                if (lock.tryLock()) {
                    try (TXHandle h = TX.requiresNew();){
                        try {
                            for (AbstractDesignMeta dmeta : designDatas) {
                                this.deleteDesignMeta(dmeta);
                                this.saveDesignMeta(dmeta);
                            }
                            break block36;
                        }
                        catch (KDException e) {
                            h.markRollback();
                            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "deployCloud")});
                        }
                        catch (OrmException e) {
                            h.markRollback();
                            throw e;
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
                log.warn(String.format("\u4e91\uff1a%s\u5e76\u53d1\u6267\u884c\uff0c\u5df2\u6709\u5176\u4ed6\u6267\u884c\u4e91\u5143\u6570\u636e\u7ebf\u7a0b\u83b7\u5f97\u9501\uff0c\u5f53\u524d\u7ebf\u7a0b\u5ffd\u7565\u6267\u884c\u3002", cloudId));
            }
        }
        MetadataDao.cleanPreinsdataCache();
        MetadataDao.cleanAllPortalAppCache();
    }

    public void deployDynPlugin(String fileName, String content) {
        StringBuilder stringBuilder = new StringBuilder();
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
        if (deployNew != null) {
            stringBuilder.append(ResManager.loadKDString((String)"\u90e8\u7f72\u524d...", (String)"MetaDeploy_0", (String)BOS_METADATA, (Object[])new Object[0]));
            this.deployMetadata(deployNew);
            stringBuilder.append(ResManager.loadKDString((String)"\u90e8\u7f72\u540e...", (String)"MetaDeploy_1", (String)BOS_METADATA, (Object[])new Object[0]));
            try {
                List<AbstractDesignMeta> designDatas = deployNew.getDesignMetas();
                if (designDatas != null) {
                    ArrayList<Object> dynPluginIds = new ArrayList<Object>(10);
                    for (AbstractDesignMeta dmeta : designDatas) {
                        dynPluginIds.add(Long.parseLong(dmeta.getId()));
                    }
                    stringBuilder.append(ResManager.loadKDString((String)"\u6e05\u9664\u7f13\u5b58\u524d...", (String)"MetaDeploy_2", (String)BOS_METADATA, (Object[])new Object[0]));
                    if (dynPluginIds.size() > 0) {
                        if (fileName.endsWith(".dynplug")) {
                            DynamicPluginDesignMeta.clearCacheByIds(dynPluginIds);
                        } else if (fileName.endsWith(".dynplugbind")) {
                            DynamicPluginBindDesignMeta.clearCacheByBindIds(dynPluginIds);
                        }
                        stringBuilder.append(String.format(ResManager.loadKDString((String)"\u6e05\u9664\u7f13\u5b58\u540e....\u6570\u91cf\u4e3a\uff1a%1$s,id\u4e3a\uff1a%2$s", (String)"MetaDeploy_3", (String)BOS_METADATA, (Object[])new Object[0]), dynPluginIds.size(), dynPluginIds.get(0)));
                    }
                }
            }
            catch (Exception e) {
                log.error("\u90e8\u7f72\u52a8\u6001\u63d2\u4ef6\u5143\u6570\u636e\u6e05\u9664\u7f13\u5b58\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        log.info("\u90e8\u7f72\u52a8\u6001\u63d2\u4ef6\u5143\u6570\u636e:{}", (Object)stringBuilder.toString());
    }

    private void saveDesignMeta(AbstractDesignMeta dmeta) {
        GrayDeployMetadataWriter writer = new GrayDeployMetadataWriter(this.getAppGroup());
        if (StringUtils.isNotBlank((CharSequence)this.getAppGroup())) {
            log.info("MetaDeploy.saveDesignMeta -- getAppGroup():{}, meta_number:{}", (Object)this.getAppGroup(), (Object)dmeta.getNumber());
        }
        writer.saveDesignMeta(dmeta);
    }

    private void deleteDesignMeta(AbstractDesignMeta dmeta) {
        GrayDeployMetadataWriter writer = new GrayDeployMetadataWriter(this.getAppGroup());
        if (StringUtils.isNotBlank((CharSequence)this.getAppGroup())) {
            log.info("MetaDeploy.deleteDesignMeta -- getAppGroup():{}, meta_number:{}", (Object)this.getAppGroup(), (Object)dmeta.getNumber());
        }
        writer.deleteDesignMeta(dmeta);
    }

    private void delFormLang(DesignMetaL metaL) {
        IDataEntityType metadataType = this.getDataEntityType(metaL);
        String delSql = String.format("delete from %s where fid = ? and FLOCALEID=? ", metadataType.getAlias());
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)metaL.getId()), new SqlParameter(":FLOCALEID", 12, (Object)metaL.getLocaleId())};
        DBRoute route = StringUtils.isBlank((CharSequence)metadataType.getDBRouteKey()) ? DBRoute.meta : DBRoute.of((String)metadataType.getDBRouteKey());
        DB.execute((DBRoute)route, (String)delSql, (Object[])params);
    }

    private static void insertPageIntoDevportal(String formid, String bizUnitId, String bizAppId) {
        ArrayList<SqlObject> list = new ArrayList<SqlObject>();
        String delSql = String.format("delete from T_META_BIZUNITRELFORM where FFORMID = '%s';", formid);
        list.add(new SqlObject(delSql, null));
        String insertSql = String.format("insert into T_META_BIZUNITRELFORM (FID,FBIZAPPID,FBIZUNITID,FFORMID) values ('%s','%s','%s','%s');", DB.genStringId((String)"T_META_BIZUNITRELFORM"), bizAppId, bizUnitId, formid);
        list.add(new SqlObject(insertSql, null));
        if (list.size() > 0) {
            try {
                for (SqlObject sqlObject : list) {
                    DB.execute((DBRoute)DBRoute.meta, (String)sqlObject.getSql(), null);
                }
            }
            catch (Throwable e) {
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_SQL, e.getMessage(), "DeployMetadata")});
            }
        }
    }

    private IDataEntityType getDataEntityType(AbstractDesignMeta dmeta) {
        return this.getDataEntityType(OrmUtils.getDataEntityType(dmeta.getClass()));
    }

    private IDataEntityType getDataEntityType(IDataEntityType dataEntityType) {
        IDataEntityType det;
        try {
            det = (IDataEntityType)dataEntityType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.bOS, new Object[]{ex.getMessage(), "getDataEntityType"});
        }
        det.setAlias(this.getGrayTableName(det.getAlias()));
        return det;
    }

    private static List<String> queryRelateMetaIds(SqlBuilder sqlBuilder) {
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FID"));
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }

    private String getGrayTableName(String tabName) {
        if (StringUtils.isBlank((CharSequence)this.getAppGroup()) || "defaultGroup".equals(this.getAppGroup())) {
            return tabName;
        }
        return String.format("%s_%s", tabName, this.getAppGroup());
    }

    private String getAppGroup() {
        return this.deployParam.getAppGroup();
    }
}

