/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.mservice.runmode.RunModeService;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;

public class AppDesignMetaReader {
    private static final String APP_ID_BY_NUMBER = "AppIdByNumber";
    private static final String APP_METADATA = "AppMetadata";
    private static final String GET_APPID_BYNUMBER_CACHE = "GetAppIdByNumberCache";
    private static final String GET_NUMBER_BYID_CACHE = "GetAppNumberByIdCache";
    private static final String MASTER_APPINFO_BY_ID = "MasterAppInfoByIdCache";
    private static final String APP_NUMBER_BY_ID = "AppNumberById";
    private static final String T_META_BIZAPP = "T_META_BIZAPP";
    private static final String RUNTIME_APP_META_DATA_ = "Runtime-AppMetadata-";
    private static final String DESIGN_APP_META_DATA_ = "Design-AppMetadata-";
    private String appGroup = "defaultGroup";

    private DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APP_METADATA, new DistributeCacheHAPolicy());
    }

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    public AppMetadata loadMeta(String id, boolean runtime) {
        return this.loadMeta(id, runtime, false);
    }

    public AppMetadata loadMeta(String id, boolean runtime, boolean isBaseMeta) {
        String realId;
        if (StringUtils.isNotBlank((CharSequence)id) && id.length() <= 10) {
            String realId2 = this.getAppIdByNumber(id);
            if (StringUtils.isNotBlank((CharSequence)realId2)) {
                id = realId2;
            }
            return this.loadMetaById(id, runtime, isBaseMeta);
        }
        AppMetadata appMetadata = this.loadMetaById(id, runtime, isBaseMeta);
        if (appMetadata == null && StringUtils.isNotBlank((CharSequence)(realId = this.getAppIdByNumber(id)))) {
            id = realId;
            appMetadata = this.loadMetaById(id, runtime, isBaseMeta);
        }
        return appMetadata;
    }

    private AppMetadata loadMetaById(String id, boolean runtime, boolean isBaseMeta) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignAppMeta.class);
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(this.appGroup);
        AbstractMetadata meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        if (meta == null && this.isGrayGroup()) {
            reader.setAppGroup("defaultGroup");
            meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        }
        if (meta == null) {
            return null;
        }
        AppMetadata appMeta = (AppMetadata)meta;
        List<AppMenuElement> menuElements = appMeta.getAppMenus();
        Collections.sort(menuElements, new Comparator<AppMenuElement>(){

            @Override
            public int compare(AppMenuElement o1, AppMenuElement o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        return appMeta;
    }

    public Set<String> getExistAppMetas(Collection<String> appIds) {
        if (appIds.isEmpty()) {
            return new HashSet<String>();
        }
        Object[] params = appIds.toArray();
        String bizAppTabName = AppGroupUtils.getAppGroupTableName((String)this.appGroup, (String)T_META_BIZAPP);
        SqlBuilder sqlInherit = new SqlBuilder();
        sqlInherit.append("select FID from ", new Object[0]).append(bizAppTabName, new Object[0]).append(" where ", new Object[0]).appendIn("FID", params);
        ResultSetHandler<Set<String>> action = new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> ids = new HashSet<String>();
                while (rs.next()) {
                    String id = rs.getString(1);
                    if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                    ids.add(id.trim());
                }
                return ids;
            }
        };
        return (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlInherit, (ResultSetHandler)action);
    }

    public String getAppIdByNumber(String number) {
        String key = this.getCacheKey(APP_ID_BY_NUMBER, number);
        LocalMemoryCache localCache = AppDesignMetaReader.getLocalCache();
        String id = (String)localCache.get(key);
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)(id = this.getCacheAppIdByNumber(number)))) {
            localCache.put(key, (Object)id);
        }
        return id;
    }

    private String getCacheAppIdByNumber(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        DistributeSessionlessCache cache = this.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = this.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
        String id = (String)cache.get(key, number);
        if (StringUtils.isBlank((CharSequence)id)) {
            ResultSetHandler<String> action;
            Object[] params;
            String sql = String.format("select FID from %s where FNUMBER = ? ", AppGroupUtils.getAppGroupTableName((String)this.appGroup, (String)T_META_BIZAPP));
            id = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])(params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)}), (ResultSetHandler)(action = new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        return rs.getString("FID");
                    }
                    return null;
                }
            }));
            if (StringUtils.isBlank((CharSequence)id) && this.isGrayGroup()) {
                sql = String.format("select FID from %s where FNUMBER = ? ", T_META_BIZAPP);
                id = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
            }
            if (StringUtils.isNotBlank((CharSequence)id)) {
                String key_numberbyid = this.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
                cache.put(key, number, (Object)id);
                cache.put(key_numberbyid, id, (Object)number);
            }
        }
        return id;
    }

    public String getAppNumberById(String id) {
        String key = this.getCacheKey(APP_NUMBER_BY_ID, id);
        LocalMemoryCache localCache = AppDesignMetaReader.getLocalCache();
        String number = (String)localCache.get(key);
        if (StringUtils.isBlank((CharSequence)number) && StringUtils.isNotBlank((CharSequence)(number = this.getCacheAppNumberById(id)))) {
            localCache.put(key, (Object)number);
        }
        return number;
    }

    private String getCacheAppNumberById(String id) {
        DistributeSessionlessCache cache = this.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = this.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
        String number = (String)cache.get(key, id);
        if (StringUtils.isBlank((CharSequence)number)) {
            number = this.queryAppNumberById(id);
            if (StringUtils.isBlank((CharSequence)number)) {
                if (this.isGrayGroup()) {
                    number = this.queryAppNumberById(id);
                }
            } else {
                cache.put(key, id, (Object)number);
                String key_idbynumber = this.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
                cache.put(key_idbynumber, number, (Object)id);
            }
        }
        return number;
    }

    public Map<String, String> getAllOriAppNumbers() {
        String tableName = AppGroupUtils.getAppGroupTableName((String)this.appGroup, (String)T_META_BIZAPP);
        String sql = String.format("SELECT Fnumber,FID from %s WHERE FType != '2' ", tableName);
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> list = new HashMap<String, String>(16);
                while (rs.next()) {
                    list.put(rs.getString("FID"), rs.getString("Fnumber"));
                }
                return list;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
    }

    public void removeAppNumberAndIdCache(String id, String number) {
        DistributeSessionlessCache cache = this.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key_numberbyid = this.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
        String key_idbynumber = this.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
        String masterAppInfoById = this.getCacheKey("AppMetadata-" + accountId, MASTER_APPINFO_BY_ID);
        if (StringUtils.isBlank((CharSequence)number) && StringUtils.isNotBlank((CharSequence)id)) {
            number = this.getAppNumberById(id);
        } else if (StringUtils.isNotBlank((CharSequence)number) && StringUtils.isBlank((CharSequence)id)) {
            id = this.getAppIdByNumber(number);
        }
        LocalMemoryCache localCache = AppDesignMetaReader.getLocalCache();
        String key1 = this.getCacheKey(APP_ID_BY_NUMBER, number);
        String key2 = this.getCacheKey(APP_NUMBER_BY_ID, id);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            cache.remove(key_numberbyid, id);
            cache.remove(masterAppInfoById, id);
            localCache.remove(new String[]{key2});
        }
        if (StringUtils.isNotBlank((CharSequence)number)) {
            cache.remove(key_idbynumber, number);
            localCache.remove(new String[]{key1});
        }
    }

    public void cleanAllAppNumberAndIdCache() {
        DistributeSessionlessCache cache = this.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key_numberbyid = this.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
        String key_idbynumber = this.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
        String masterAppInfoById = this.getCacheKey("AppMetadata-" + accountId, MASTER_APPINFO_BY_ID);
        cache.remove(key_numberbyid);
        cache.remove(key_idbynumber);
        cache.remove(masterAppInfoById);
        LocalMemoryCache localCache = AppDesignMetaReader.getLocalCache();
        localCache.clear();
    }

    public void updateAppNumberAndIdCache(String id, String number) {
        DistributeSessionlessCache cache = this.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key_numberbyid = this.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
        String key_idbynumber = this.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
        cache.put(key_numberbyid, id, (Object)number);
        cache.put(key_idbynumber, number, (Object)id);
        LocalMemoryCache localCache = AppDesignMetaReader.getLocalCache();
        String key1 = this.getCacheKey(APP_ID_BY_NUMBER, number);
        String key2 = this.getCacheKey(APP_NUMBER_BY_ID, id);
        localCache.put(key1, (Object)id);
        localCache.put(key2, (Object)number);
    }

    public void cleanAppCache(String appId, String appMasterId, String appNumber) {
        String accountId = CacheKeyUtil.getAcctId();
        String prefixRuntime = RUNTIME_APP_META_DATA_ + accountId + "-";
        String prefixDesign = DESIGN_APP_META_DATA_ + accountId + "-";
        DistributeSessionlessCache cache = this.getCache();
        String portalAllAppkey = RUNTIME_APP_META_DATA_ + accountId + "-portalapp";
        DataEntityCacheManager appCacheManager = new DataEntityCacheManager(T_META_BIZAPP);
        appCacheManager.removeByDt();
        cache.remove(this.getCacheKey(APP_METADATA, accountId), prefixDesign + appId);
        cache.remove(this.getCacheKey(APP_METADATA, accountId), portalAllAppkey);
        if (StringUtils.isNotEmpty((CharSequence)appMasterId)) {
            cache.remove(this.getCacheKey(APP_METADATA, accountId), prefixRuntime + appMasterId);
        } else {
            cache.remove(this.getCacheKey(APP_METADATA, accountId), prefixRuntime + appId);
        }
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        permService.clearAllUserAppCache();
        if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
            MetaCacheUtils.removeAppmetaDistributeCache(appNumber);
            AppMetadataCache.removeAppmetaLocalCache((String)appNumber);
            RunModeService runModeService = (RunModeService)ServiceFactory.getService(RunModeService.class);
            runModeService.removeCache("all");
        }
        AppMetadataCache.removeCache();
        this.removeAppNumberAndIdCache(appId, appNumber);
    }

    public void cleanAppCache(String appId, String appMasterId, String ... appNumbers) {
        String accountId = CacheKeyUtil.getAcctId();
        String prefixRuntime = RUNTIME_APP_META_DATA_ + accountId + "-";
        String prefixDesign = DESIGN_APP_META_DATA_ + accountId + "-";
        DistributeSessionlessCache cache = this.getCache();
        String portalAllAppkey = RUNTIME_APP_META_DATA_ + accountId + "-portalapp";
        DataEntityCacheManager appCacheManager = new DataEntityCacheManager(T_META_BIZAPP);
        appCacheManager.removeByDt();
        cache.remove(this.getCacheKey(APP_METADATA, accountId), prefixDesign + appId);
        cache.remove(this.getCacheKey(APP_METADATA, accountId), portalAllAppkey);
        if (StringUtils.isNotEmpty((CharSequence)appMasterId)) {
            cache.remove(this.getCacheKey(APP_METADATA, accountId), prefixRuntime + appMasterId);
        } else {
            cache.remove(this.getCacheKey(APP_METADATA, accountId), prefixRuntime + appId);
        }
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        permService.clearAllUserAppCache();
        if (appNumbers != null && appNumbers.length > 0) {
            MetaCacheUtils.removeAppMetaDistributeCache(appNumbers);
            AppMetadataCache.removeAppmetaLocalCache((String[])appNumbers);
            RunModeService runModeService = (RunModeService)ServiceFactory.getService(RunModeService.class);
            runModeService.removeCache("all");
        }
        AppMetadataCache.removeCache();
        this.cleanAllAppNumberAndIdCache();
    }

    private String queryAppNumberById(String id) {
        String sql = String.format("select FNUMBER from %s where FID = ? ", AppGroupUtils.getAppGroupTableName((String)this.appGroup, (String)T_META_BIZAPP));
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString("FNUMBER");
                }
                return null;
            }
        };
        String number = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        return number;
    }

    private String getCacheKey(String key, String number) {
        return String.format("%s_%s_%s", key, this.appGroup, number);
    }

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "AppReader", info);
    }

    private boolean isGrayGroup() {
        return StringUtils.isNotBlank((CharSequence)this.appGroup) && !"defaultGroup".equals(this.appGroup);
    }
}

