/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.devportal.AppElement;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppLangItemBuilder;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.devportal.DesignAppMetaL;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AppMetadata
extends AbstractMetadata {
    private AppElement appElement;
    private List<AppMenuElement> appMenus;
    private List<AppFunctionPacketElement> appFunctionPackets;
    private Map<String, AppMenuElement> mapMenus;
    private Map<String, AppFunctionPacketElement> mapFunctionPackets;
    private String bizCloudID;
    private Long industryId;
    private String number;
    private boolean _isInitialize;

    @SimplePropertyAttribute
    public String getNumber() {
        if (StringUtils.isBlank((CharSequence)this.number)) {
            this.getAppElement().getNumber();
        }
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @SimplePropertyAttribute
    public String getBizCloudID() {
        return this.bizCloudID;
    }

    public void setBizCloudID(String bizCloudID) {
        this.bizCloudID = bizCloudID;
    }

    @SimplePropertyAttribute
    public Long getIndustryId() {
        return this.appElement.getIndustryId();
    }

    public void setIndustryId(Long industryId) {
        this.appElement.setIndustryId(industryId);
    }

    public Map<String, AppMenuElement> getMapMenus() {
        this.setMapMenus();
        return this.mapMenus;
    }

    public Map<String, AppFunctionPacketElement> getMapFuncs() {
        this.setMapFuncs();
        return this.mapFunctionPackets;
    }

    public AppMetadata() {
        this.setModelType("AppModel");
        this.appElement = new AppElement();
        this.appMenus = new ArrayList<AppMenuElement>();
        this.appFunctionPackets = new ArrayList<AppFunctionPacketElement>();
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=AppMenuElement.class)
    public List<AppMenuElement> getAppMenus() {
        return this.appMenus;
    }

    public void setAppMenus(List<AppMenuElement> appMenus) {
        this.appMenus = appMenus;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=AppFunctionPacketElement.class)
    public List<AppFunctionPacketElement> getAppFunctionPackets() {
        return this.appFunctionPackets;
    }

    public void setAppFunctionPackets(List<AppFunctionPacketElement> appFunctionPackets) {
        this.appFunctionPackets = appFunctionPackets;
    }

    private void setMapMenus() {
        if (!this._isInitialize) {
            this.mapMenus = new HashMap<String, AppMenuElement>(16);
            for (AppMenuElement menu : this.getAppMenus()) {
                this.mapMenus.put(menu.getId(), menu);
            }
        }
    }

    private void setMapFuncs() {
        if (!this._isInitialize) {
            this.mapFunctionPackets = new HashMap<String, AppFunctionPacketElement>(16);
            for (AppFunctionPacketElement func : this.getAppFunctionPackets()) {
                this.mapFunctionPackets.put(func.getId(), func);
            }
        }
    }

    @Override
    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getId() {
        return this.appElement.getId();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.appElement.setId(id);
    }

    public LocaleString getName() {
        return this.appElement.getName();
    }

    public void setName(LocaleString name) {
        this.appElement.setName(name);
    }

    @Override
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="AppModel")
    public String getModelType() {
        return super.getModelType();
    }

    @Override
    public String getBizappId() {
        return this.getId();
    }

    @ComplexPropertyAttribute
    public AppElement getAppElement() {
        return this.appElement;
    }

    public void setAppElement(AppElement appElement) {
        this.appElement = appElement;
    }

    @Override
    public void beginInit() {
        this._isInitialize = true;
    }

    @Override
    public void endInit() {
        this._isInitialize = false;
    }

    @Override
    public boolean isInitialized() {
        return this._isInitialize;
    }

    @Override
    public IDataEntityType getDesingerMetaType() {
        return OrmUtils.getDataEntityType(DesignAppMeta.class);
    }

    @Override
    public IDataEntityType getDesingerMetaLType() {
        return OrmUtils.getDataEntityType(DesignAppMetaL.class);
    }

    public Object getLocaleItems() {
        DomainModelType domainModel = DomainModelType.getDomainModelType(this.getModelType(), false);
        AppLangItemBuilder builder = new AppLangItemBuilder(new DomainModelBinder(domainModel));
        HashMap ret = new HashMap();
        builder.builderResouces(this, null);
        List<Map<String, ILocaleValue<?>>> localVaules = builder.getLocaleItemValues();
        HashMap appMap = new HashMap();
        HashMap appMenuMap = new HashMap();
        HashMap appFuncMap = new HashMap();
        for (Map<String, ILocaleValue<?>> localVal : localVaules) {
            for (String key : localVal.keySet()) {
                if (key.startsWith("AppMetadata.AppElement.")) {
                    appMap.putAll(localVal);
                    continue;
                }
                if (key.startsWith("AppMetadata.AppMenus.")) {
                    appMenuMap.putAll(localVal);
                    continue;
                }
                if (!key.startsWith("AppMetadata.AppFunctionPackets.")) continue;
                appFuncMap.putAll(localVal);
            }
        }
        ret.put("app", appMap);
        ret.put("appmenus", appMenuMap);
        ret.put("appfuncs", appFuncMap);
        return ret;
    }

    @Override
    public void convertFromDesignMeta(DesignMeta designMeta) {
        String homeURL;
        String mainFormType;
        String key;
        super.convertFromDesignMeta(designMeta);
        DesignAppMeta designAppMeta = (DesignAppMeta)designMeta;
        this.setBizCloudID(designAppMeta.getBizCloudID());
        if (this.getAppElement().getIndustryId() != null && this.getAppElement().getIndustryId() == 0L) {
            this.setIndustryId(null);
        }
        this.setNumber(designAppMeta.getNumber());
        String formId = this.getAppElement().getMainFormID();
        if (StringUtils.isBlank((CharSequence)this.getAppElement().getMainFormNumber()) && StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)(key = MetadataDao.getNumberById(formId)))) {
            this.getAppElement().setMainFormNumber(key);
        }
        if (StringUtils.isBlank((CharSequence)(mainFormType = this.getAppElement().getMainFormType()))) {
            this.getAppElement().setMainFormType("0");
        }
        if (StringUtils.isBlank((CharSequence)(homeURL = this.getAppElement().getHomeURL()))) {
            this.getAppElement().setHomeURL("");
        }
        if (StringUtils.isBlank((Object)this.getAppElement().getDescription()) && StringUtils.isNotBlank((CharSequence)designAppMeta.getDescription())) {
            this.getAppElement().getDescription().put("zh_CN", (Object)designAppMeta.getDescription());
        }
    }

    @Override
    protected void setDesignMeta(DesignMeta designMeta) {
        super.setDesignMeta(designMeta);
        AppElement appElement = this.getAppElement();
        DesignAppMeta designAppMeta = (DesignAppMeta)designMeta;
        designAppMeta.setNumber(this.getNumber());
        designAppMeta.setAllUserApp(appElement.getAllUserApp());
        designAppMeta.setBackImage(appElement.getBackImage());
        designAppMeta.setBizCloudID(this.getBizCloudID());
        designAppMeta.setDbRoute(appElement.getDbRoute());
        designAppMeta.setDependency(appElement.getDependency());
        designAppMeta.setDependencyID(appElement.getDependencyID());
        if (this.getIndustryId() != null) {
            designAppMeta.setIndustryId(this.getIndustryId());
            designAppMeta.setRefAppId(appElement.getRefAppId());
        } else {
            designAppMeta.setIndustryId(0L);
        }
        designAppMeta.setDeployStatus(appElement.getDeployStatus());
        designAppMeta.setHelpURL(appElement.getHelpURL());
        designAppMeta.setImage(appElement.getImage());
        designAppMeta.setLabel(appElement.getLabel());
        designAppMeta.setMainFormID(appElement.getMainFormID());
        designAppMeta.setMainFormName(appElement.getMainFormName());
        designAppMeta.setOpenType(appElement.getOpenType());
        designAppMeta.setSeq(appElement.getSeq());
        designAppMeta.setSimpleNumber(appElement.getSimpleNumber());
        designAppMeta.setUserType(appElement.getUserType());
        designAppMeta.setOrgFunc(appElement.getOrgFunc());
        designAppMeta.setVisible(appElement.getVisible());
        designAppMeta.setMainFormType(appElement.getMainFormType());
        designAppMeta.setHomeURL(appElement.getHomeURL());
        DesignAppMeta designDbMeta = null;
        try {
            IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignAppMeta.class);
            designDbMeta = (DesignAppMeta)BusinessDataReader.read((Object)designMeta.getId(), (IDataEntityType)designerMetaType, (Boolean)false);
        }
        catch (Exception designerMetaType) {
            // empty catch block
        }
        TimeService timeService = new TimeService();
        Date curTime = timeService.getCurrentSystemTime();
        long curUserId = Long.parseLong(RequestContext.get().getUserId());
        designAppMeta.setModifier(curUserId);
        if (designDbMeta != null) {
            designAppMeta.setModifyDate(curTime);
            designAppMeta.setCreateDate(designDbMeta.getCreateDate());
            designAppMeta.setCreater(designDbMeta.getCreater());
        } else {
            designAppMeta.setCreateDate(curTime);
            designAppMeta.setCreater(curUserId);
        }
        designAppMeta.setAppVersion(appElement.getVersion());
    }

    @Override
    protected void setDesignMetaL(String localeId, DesignMetaL designMetaL) {
        super.setDesignMetaL(localeId, designMetaL);
        DesignAppMetaL designAppMetaL = (DesignAppMetaL)designMetaL;
        designAppMetaL.setName((String)this.getName().getItem(localeId));
        designAppMetaL.setDescription((String)this.getAppElement().getDescription().getItem(localeId));
    }

    @Override
    protected void fillTermRes() {
        super.fillTermRes();
    }

    @Override
    public void fillTermRes(Map<String, Map<String, Object>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        HashMap<String, Object> res = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Map<String, Object>> item : map.entrySet()) {
            res.put(item.getKey(), item.getValue());
        }
        DomainModelType domainModel = DomainModelType.getDomainModelType(this.getModelType(), false);
        AppTermItemBuilder builder = new AppTermItemBuilder(new DomainModelBinder(domainModel));
        builder.rebuilderResouces(this, null, res);
    }

    static class AppTermItemBuilder
    extends AppLangItemBuilder {
        private DcBinder binder;

        public AppTermItemBuilder(DcBinder binder) {
            super(binder);
            this.binder = binder;
        }

        @Override
        public void rebuildRes(Object currentEntity, String parentId, IDataEntityType currentEntityType, Map<String, Object> localeItems) {
            if (currentEntityType == null) {
                return;
            }
            for (IDataEntityProperty p : currentEntityType.getProperties()) {
                String Id = parentId + "." + p.getName();
                Object val = p.getValue(currentEntity);
                if (p instanceof ISimpleProperty) {
                    if (!(val instanceof ILocaleValue) || ((ILocaleValue)val).size() <= 0) continue;
                    Map value = (Map)localeItems.get(Id);
                    Map oldLocale = (Map)val;
                    if (localeItems.get(Id) == null) continue;
                    oldLocale.putAll(value);
                    p.setValue(currentEntity, (Object)LocaleString.fromMap((Map)oldLocale));
                    continue;
                }
                if (p instanceof IComplexProperty) {
                    this.rebuilderResouces(val, Id, null, localeItems);
                    continue;
                }
                List listValue = (List)val;
                if (listValue == null) continue;
                String objId = null;
                for (Object objVal : listValue) {
                    if ("AppFunctionPackets".equals(p.getName())) {
                        AppFunctionPacketElement func = (AppFunctionPacketElement)objVal;
                        objId = func.getId();
                    } else if ("AppMenus".equals(p.getName())) {
                        AppMenuElement menu = (AppMenuElement)objVal;
                        objId = menu.getId();
                    }
                    if (!StringUtils.isNotBlank((CharSequence)objId) || objVal == null) continue;
                    this.rebuilderResouces(objVal, parentId + "." + p.getName() + "." + objId, null, localeItems);
                }
            }
        }

        @Override
        protected void rebuilderResouces(Object currentEntity, String parentId, Object baseEntity, Map<String, Object> localeItems) {
            if (currentEntity == null) {
                return;
            }
            IDataEntityType currentEntityType = this.binder.getDataEntityType(currentEntity);
            if (this.shouldCompare(currentEntityType, baseEntity)) {
                this.rebuildRes(currentEntity, parentId, baseEntity, currentEntityType, localeItems);
            } else {
                this.rebuildRes(currentEntity, parentId, currentEntityType, localeItems);
            }
        }

        @Override
        public void rebuilderResouces(Object currentEntity, Object baseEntity, Map<String, Object> localeItems) {
            if (currentEntity != null) {
                this.rebuilderResouces(currentEntity, currentEntity.getClass().getSimpleName(), baseEntity, localeItems);
            }
        }
    }
}

