/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EnvTypeHelper {
    private static final Log LOG = LogFactory.getLog(EnvTypeHelper.class);
    private static final String UPGRADE_LOGIN_API = "/api/upgradeLogin.do";
    private static final String ENVIRONMENT_STATUS_API = "/kapi/app/mc/getEnvironmentStatus";
    private static int CONNECTION_TIMEOUT = 1000;
    private static int READ_TIMEOUT = 1000;

    public static EnvType getCurrentEnvType() {
        String envType = System.getProperty("env.type");
        if (StringUtils.isBlank((CharSequence)envType)) {
            return EnvType.Develop;
        }
        return EnvType.getEnvType(envType.trim());
    }

    public static boolean isProductEnv() {
        String talentCode = RequestContext.get().getTenantCode();
        String talentEnvType = System.getProperty(talentCode + "_env.type");
        if (StringUtils.isNotBlank((CharSequence)talentEnvType)) {
            EnvType currentEnv = EnvType.getEnvType(talentEnvType.trim());
            return EnvType.Product == currentEnv;
        }
        return false;
    }

    public static boolean isDeploying() {
        if (Boolean.parseBoolean(System.getProperty("enable.deploying.develop", "false"))) {
            LOG.debug("\u5347\u7ea7\u4e0d\u5141\u8bb8\u7f16\u8f91\u5f00\u53d1\u5e73\u53f0\u53c2\u6570\u672a\u5f00\u542f");
            return false;
        }
        String isv = ISVService.getISVInfo().getId();
        if ("kingdee".equals(isv) || "kdtest".equals(isv)) {
            LOG.debug("\u91d1\u8776\u5f00\u53d1\u5546\u5141\u8bb8\u7f16\u8f91\u5f00\u53d1\u5e73\u53f0");
            return false;
        }
        String server = System.getProperty("mc.server.url");
        if (StringUtils.isBlank((CharSequence)server)) {
            LOG.debug("\u672a\u914d\u7f6eMC\u670d\u52a1\u5668\u5730\u5740\uff0c\u8bf7\u5148\u5728MC\u516c\u5171\u914d\u7f6e\u9879\u4e2d\u914d\u7f6e\u3002");
            return false;
        }
        String accessToken = EnvTypeHelper.getAccessToken(server);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            accessToken = EnvTypeHelper.getAccessToken(server);
        }
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return false;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("api", "true");
        header.put("accessToken", accessToken);
        header.put("Content-Type", "application/json");
        HashMap<String, String> postData = new HashMap<String, String>(3);
        postData.put("dcId", RequestContext.get().getAccountId());
        try {
            String resultStr = MCApiUtil.callMcApiService((String)ENVIRONMENT_STATUS_API, (String)"text/json", header, postData);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                LOG.warn("\u8bf7\u6c42\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5347\u7ea7\u72b6\u6001 \u5931\u8d25\uff0c\u8fde\u63a5\u8d85\u65f6,\u5c1d\u8bd5\u91cd\u65b0\u8bf7\u6c42");
                resultStr = MCApiUtil.callMcApiService((String)ENVIRONMENT_STATUS_API, (String)"text/json", header, postData);
            }
            if (StringUtils.isNotBlank((CharSequence)resultStr)) {
                Integer errCode;
                LOG.debug("\u8bf7\u6c42\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5347\u7ea7\u72b6\u6001 \u6210\u529f, \u5185\u5bb9\u5982\u4e0b\uff1a" + resultStr);
                Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
                boolean success = result.get("success") == null ? false : (Boolean)result.get("success");
                Integer n = errCode = result.get("errorcode") == null ? Integer.valueOf(500) : (Integer)result.get("errorcode");
                if (success && errCode == 100) {
                    Map data = result.get("data") == null ? null : (Map)result.get("data");
                    boolean isUpdating = data == null || data.get("isUpdating") == null ? false : (Boolean)data.get("isUpdating");
                    return isUpdating;
                }
                String errMsg = result.get("description") == null ? "" : (String)result.get("description");
                LOG.info("\u8bf7\u6c42mc\u63a5\u53e3 \u6210\u529f\uff0c\u4f46\u8bf7\u6c42\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5347\u7ea7\u72b6\u6001\u5931\u8d25\uff0cerrCode:" + errCode + "MSG:" + errMsg);
                return false;
            }
            LOG.warn("\u8bf7\u6c42\u8bf7\u6c42\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5347\u7ea7\u72b6\u6001 \u5931\u8d25\uff0c\u8fde\u63a5\u8d85\u65f6,\u9000\u51fa.");
            return false;
        }
        catch (Exception e) {
            LOG.error("\u8bbf\u95eemc\u670d\u52a1\u6545\u969c", (Throwable)e);
            return false;
        }
    }

    private static String getAccessToken(String server) {
        String url = server + UPGRADE_LOGIN_API;
        HashMap<String, String> postData = new HashMap<String, String>(2);
        postData.put("accountId", "");
        postData.put("tenantid", "");
        String postStr = SerializationUtils.toJsonString(postData);
        HashMap headers = new HashMap();
        try {
            String state;
            String resultStr = MCApiUtil.callMcApiService((String)UPGRADE_LOGIN_API, (String)"text/json", headers, postData);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                LOG.warn(String.format("\u83b7\u53d6MC token\u5931\u8d25:\u8bf7\u6c42\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff01(url=%s;params=%s)", url, postStr));
                return "";
            }
            Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
            String string = state = result.get("state") == null ? "" : (String)result.get("state");
            if ("success".equals(state)) {
                Map data = result.get("data") == null ? null : (Map)result.get("data");
                String accessToken = data == null || data.get("access_token") == null ? "" : (String)data.get("access_token");
                return accessToken;
            }
            String errMsg = result.get("error_desc") == null ? "" : (String)result.get("error_desc");
            LOG.debug("\u83b7\u53d6MC token\u54cd\u5e94 \u6210\u529f\uff0c\u4f46\u83b7\u53d6token\u5931\u8d25\uff0cMSG:" + errMsg);
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6MC token\u5931\u8d25,err:" + e.getMessage());
        }
        return "";
    }

    public static enum EnvType {
        Product("prod"),
        Test("test"),
        Develop("dev");

        private String value;

        private EnvType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static EnvType getEnvType(String value) {
            return Arrays.stream(EnvType.values()).filter(t -> StringUtils.equalsIgnoreCase((CharSequence)t.getValue(), (CharSequence)value)).findFirst().orElse(Test);
        }
    }
}

