/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.domainmodel;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.IIsvFlag;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.IInheritFlag;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Element;

@SdkPublic
public class DomainModelBinder
extends DcBinder {
    private DomainModelType type;
    private boolean isInherit;
    private boolean writeInheritFlag;
    private boolean isExt;
    private boolean inheritFix;
    private String isv = null;

    public DomainModelBinder(DomainModelType type) {
        this.type = type;
    }

    public void setIsv(String isv) {
        this.isv = isv;
    }

    public IDataEntityType tryBindToType(String elementName, Map<String, String> attributes) {
        ElementType elementType = this.type.getElementType(elementName);
        if (elementType != null) {
            return elementType.getDataEntityType();
        }
        return null;
    }

    public Object createInstance(IDataEntityType dt) {
        Object o = super.createInstance(dt);
        if (this.isInherit && o instanceof IInheritFlag) {
            ((IInheritFlag)o).setInherit(true);
        }
        if (this.isExt && o instanceof AbstractElement) {
            ((AbstractElement)o).setExt(true);
        }
        if (StringUtils.isNotBlank((CharSequence)this.isv) && o instanceof IIsvFlag) {
            ((IIsvFlag)o).setIsv(this.isv);
        }
        return o;
    }

    public void afterWriteJsonObject(Object currentEntity, Object baseEntity, Map<String, Object> serObj) {
        if (this.isWriteInheritFlag() && currentEntity instanceof IInheritFlag && ((IInheritFlag)currentEntity).isInherit()) {
            serObj.put("Inherit", true);
        }
        if (currentEntity instanceof IIsvFlag) {
            serObj.put("IsvFlag", ((IIsvFlag)currentEntity).getIsv());
        }
        super.afterWriteJsonObject(currentEntity, baseEntity, serObj);
    }

    public boolean isInherit() {
        return this.isInherit;
    }

    public void setInherit(boolean isInherit) {
        this.isInherit = isInherit;
    }

    public boolean isExt() {
        return this.isExt;
    }

    public void setExt(boolean isExt) {
        this.isExt = isExt;
    }

    public boolean isWriteInheritFlag() {
        return this.writeInheritFlag;
    }

    public void setWriteInheritFlag(boolean writeInheritFlag) {
        this.writeInheritFlag = writeInheritFlag;
    }

    public void setInheritFix(boolean inheritFix) {
        this.inheritFix = inheritFix;
    }

    public void readCustomJsonProperty(Map.Entry<String, Object> kv, Object entity) {
        if ("Inherit".equals(kv.getKey())) {
            if (this.inheritFix && entity instanceof IInheritFlag) {
                ((IInheritFlag)entity).setInherit((Boolean)kv.getValue());
            }
        } else if ("IsvFlag".equals(kv.getKey())) {
            if (entity instanceof IIsvFlag && kv.getValue() instanceof String) {
                ((IIsvFlag)entity).setIsv(kv.getValue().toString());
            }
        } else if (entity instanceof AbstractElement) {
            ((AbstractElement)entity).getCustomProperties().put(kv.getKey(), kv.getValue());
        }
    }

    public void writeCustomJsonProperties(Map<String, Object> serObj, Object current, Object base) {
        super.writeCustomJsonProperties(serObj, current, base);
        if (current instanceof AbstractElement) {
            serObj.putAll(((AbstractElement)current).getCustomProperties());
        }
    }

    public void readCustomXmlProperty(Element kv, Object entity) {
        super.readCustomXmlProperty(kv, entity);
        if (entity instanceof AbstractElement && !StringUtils.isBlank((CharSequence)kv.getStringValue())) {
            String s = kv.getStringValue();
            if (this.isJsonObject(s)) {
                Object value = SerializationUtils.fromJsonString((String)s, Object.class);
                ((AbstractElement)entity).getCustomProperties().put(kv.getName(), value);
            } else if ("false".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s)) {
                ((AbstractElement)entity).getCustomProperties().put(kv.getName(), Boolean.valueOf(s));
            } else {
                ((AbstractElement)entity).getCustomProperties().put(kv.getName(), s);
            }
        }
    }

    private boolean isJsonObject(String value) {
        return value.startsWith("\"") && value.endsWith("\"") || value.startsWith("[") && value.endsWith("]");
    }

    public void writeCustomXmlProperties(Element serObj, Object current, Object base) {
        super.writeCustomXmlProperties(serObj, current, base);
        if (current instanceof AbstractElement) {
            AbstractElement currentElement = (AbstractElement)current;
            AbstractElement baseElement = (AbstractElement)base;
            Map<String, Object> map = currentElement.getCustomProperties();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object baseValue;
                if (baseElement != null && this.isEqual(baseValue = baseElement.getCustomProperties().get(entry.getKey()), entry.getValue())) continue;
                this.addElementValue(serObj, entry.getKey(), entry.getValue());
            }
            if (baseElement != null) {
                Map<String, Object> mapBase = baseElement.getCustomProperties();
                for (Map.Entry<String, Object> baseEntry : mapBase.entrySet()) {
                    Object defValue;
                    String key = baseEntry.getKey();
                    if (map.containsKey(key) || (defValue = this.getDefaultValue(baseElement, key)) == null || defValue.equals(baseEntry.getValue())) continue;
                    this.addElementValue(serObj, key, defValue);
                }
            }
        }
    }

    private void addElementValue(Element serObj, String key, Object value) {
        if (value != null) {
            Element element = serObj.addElement(key);
            if (value instanceof String) {
                element.setText((String)value);
            } else {
                element.setText(SerializationUtils.toJsonString((Object)value));
            }
        }
    }

    private Object getDefaultValue(AbstractElement element, String propertyName) {
        String elementTypeName = element.getClass().getSimpleName();
        ElementType elementType = this.type.getElementType(elementTypeName);
        if (elementType != null) {
            List<Property> properties = elementType.getProperties();
            if (properties.isEmpty()) {
                DomainModelType domainModelType = DomainModelTypeFactory.getDomainModelType(this.type.getId(), true);
                ElementType elementType1 = domainModelType.getElementType(elementTypeName);
                properties = elementType1.getProperties();
            }
            for (Property property : properties) {
                Map<String, Object> map;
                if (!propertyName.equals(property.getPropertyName()) || (map = property.getEditor()) == null) continue;
                return map.get("default");
            }
        }
        return null;
    }

    private boolean isEqual(Object currentValue, Object baseValue) {
        if (currentValue == null && baseValue == null) {
            return true;
        }
        if (currentValue == null || baseValue == null) {
            return false;
        }
        return currentValue.equals(baseValue);
    }
}

