/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.domainmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.lang.Lang;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.CategoryCollection;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.PageType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.PropertyGroup;
import kd.bos.metadata.domainmodel.PropertyGroupCollection;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DomainModelType
implements ISupportInitialize {
    private List<Category> categories;
    private List<PropertyGroup> propertyGroups;
    private transient Boolean isInit = false;
    private transient Map<String, ElementType> dctElements = new HashMap<String, ElementType>();
    private boolean _isEntity = false;
    public static final String FORMMODEL_DYNAMICFORM = "DynamicFormModel";
    public static final String CardModel = "CardModel";
    public static final String FORMMODEL_BILL = "BillFormModel";
    public static final String FORMMODEL_MOBILEBILL = "MobileBillFormModel";
    public static final String FORMMODEL_DESIGNMOBILEBILL = "DesignMobileBillFormModel";
    public static final String FORMMODEL_MOBILE = "MobileFormModel";
    public static final String FORMMODEL_BASE = "BaseFormModel";
    public static final String FORMMODEL_KM = "KMModel";
    public static final String FORMMODEL_WIDGET = "WidgetFormModel";
    public static final String FORMMODEL_MOBILELIST = "MobileListModel";
    public static final String FORMMODEL_QUERYLIST = "QueryListModel";
    public static final String FORMMODEL_PARAMETER = "ParameterFormModel";
    public static final String FORMMODEL_PUBLICPARAMETER = "ParameterFormModel_public";
    public static final String FORMMODEL_APPLICATIONPARAMETER = "ParameterFormModel_application";
    public static final String FORMMODEL_BILLPARAMETER = "ParameterFormModel_bill";
    public static final String FORMMODEL_USERGUIDE = "UserGuideFormModel";
    public static final String FORMMODEL_MOBUSERGUIDE = "MobUserGuideFormModel";
    public static final String FORMMODEL_REPORT = "ReportFormModel";
    public static final String BillListCardViewModel = "BillListCardViewModel";
    public static final String CarEntryMenuModel = "CarEntryMenuModel";
    public static final String PERMISSOMMODEL = "PermissomModel";
    public static final String FORMMODEL_PRINT = "PrintModel";
    public static final String ConvertRuleModel = "ConvertRuleModel";
    public static final String CtConvertRuleModel = "CtConvertRuleModel";
    public static final String WriteBackRuleModel = "WriteBackRuleModel";
    public static final String APPMODEL = "AppModel";
    public static final String QUERYSOURCEMODEL = "QuerySourceModel";
    public static final String WORKFLOW_PLUGIN_MODEL = "WORKFLOW_PLUGIN_MODEL";
    public static final String NoCodeModel = "NoCodeModel";
    public static final String BALANCEMODEL = "BalanceModel";
    public static final String BALANCEUPDATEMODEL = "BalanceUpdateModel";
    public static final String FORMMODEL_REPORTLIST = "ReportQueryListModel";
    public static final String EARLY_WARN_MODEL = "EarlyWarnModel";
    public static final String WARN_SCHEDULE_MODEL = "WarnScheduleModel";
    public static final String LOGBILLMODEL = "LogBillFormModel";
    public static final String PHYSICAL_DATAMODEL = "PhysicalDataModel";
    private static long extendsVersion;
    private Map<String, Object> customData = new HashMap<String, Object>();
    private String id;
    private boolean fillLocale = false;
    private LocaleString name;

    public boolean isEntity() {
        return this._isEntity;
    }

    public DomainModelType() {
        this.categories = new CategoryCollection();
        this.propertyGroups = new PropertyGroupCollection();
    }

    public static DomainModelType getDomainModelType(String domainModelTypeId) {
        String locale = Lang.get().toString();
        return DomainModelType.getDomainModelType(domainModelTypeId, locale);
    }

    public static DomainModelType getDomainModelType(String domainModelTypeId, String locale) {
        return DomainModelType.getDomainModelType(domainModelTypeId, true, locale);
    }

    public static DomainModelType getDomainModelType(String domainModelTypeId, boolean includeProperties) {
        String locale = Lang.get().toString();
        return DomainModelType.getDomainModelType(domainModelTypeId, includeProperties, locale);
    }

    public static DomainModelType getDomainModelType(String domainModelTypeId, boolean includeProperties, String locale) {
        return DomainModelTypeFactory.getDomainModelType(domainModelTypeId, includeProperties, locale);
    }

    public static List<IDataEntityType> getDomainModelTypeEntityTypes() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(DomainModelType.class));
        dts.add(OrmUtils.getDataEntityType(Category.class));
        dts.add(OrmUtils.getDataEntityType(ElementType.class));
        dts.add(OrmUtils.getDataEntityType(Property.class));
        dts.add(OrmUtils.getDataEntityType(PropertyGroup.class));
        return dts;
    }

    public static PageType getPageTypeByModelType(String modelType) {
        PageType pageType = PageType.Page;
        switch (modelType) {
            case "BillFormModel": 
            case "BaseFormModel": 
            case "LogBillFormModel": 
            case "KMModel": {
                pageType = PageType.EntityObject;
                break;
            }
            case "ReportFormModel": 
            case "ReportQueryListModel": {
                pageType = PageType.Report;
                break;
            }
            case "ParameterFormModel": 
            case "ParameterFormModel_public": 
            case "ParameterFormModel_application": 
            case "ParameterFormModel_bill": {
                pageType = PageType.Parameter;
                break;
            }
            default: {
                pageType = PageType.Page;
            }
        }
        return pageType;
    }

    @SimplePropertyAttribute(name="Id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isFillLocale() {
        return this.fillLocale;
    }

    public void setFillLocale(boolean fillLocale) {
        this.fillLocale = fillLocale;
    }

    @SimplePropertyAttribute(name="Name")
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Category.class, name="Categories")
    public List<Category> getCategories() {
        return this.categories;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=PropertyGroup.class, name="PropertyGroups")
    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public void endInit() {
        for (Category ct : this.categories) {
            for (ElementType el : ct.getElementTypes()) {
                this.dctElements.put(el.getId(), el);
            }
        }
        this.sortItems();
        this.isInit = false;
    }

    public void beginInit() {
        this.isInit = true;
    }

    public boolean isInitialized() {
        return this.isInit;
    }

    public ElementType getElementType(String id) {
        return this.dctElements.get(id);
    }

    public Map<String, ElementType> getElementTypes() {
        return this.dctElements;
    }

    public static String getVersion() {
        return new StringBuffer("1.23.233").append(extendsVersion).toString();
    }

    private void sortItems() {
        Collections.sort(this.categories, (o1, o2) -> Integer.compare(o1.getSeq(), o2.getSeq()));
    }

    public static long getExtendsVersion() {
        return extendsVersion;
    }

    public static void setExtendsVersion(long extendsVersion) {
        DomainModelType.extendsVersion = extendsVersion;
    }

    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    public void setCustomData(Map<String, Object> customData) {
        this.customData = customData;
    }
}

