/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.domainmodel;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.CollectionProperty;
import kd.bos.dataentity.metadata.clr.ComplexProperty;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.metadata.clr.SimpleProperty;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.PropertyCollection;
import kd.bos.script.annotations.KSMethod;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ElementType
implements ISupportInitialize {
    private String id;
    private LocaleString name;
    private String packageName;
    private List<Property> properties = new PropertyCollection();
    private boolean isContainer;
    private Map<String, Object> accept;
    private Map<String, Object> notAccept;
    private Map<String, Object> acceptParent;
    private boolean inside;
    private boolean _isInitialize;
    private String extendClassName;
    private int createType;
    private boolean isUnique;
    private String ownerTypeId;
    private int seq;
    private Map<String, String> apType;
    private String baseType;
    private String extendFontClass;

    @KSMethod
    @SimplePropertyAttribute
    public Map<String, String> getApType() {
        return this.apType;
    }

    public void setApType(Map<String, String> apType) {
        this.apType = apType;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getBaseType() {
        return this.baseType;
    }

    @KSMethod
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @SimplePropertyAttribute(name="ExtendFontClass")
    public String getExtendFontClass() {
        return this.extendFontClass;
    }

    public void setExtendFontClass(String extendFontClass) {
        this.extendFontClass = extendFontClass;
    }

    @SimplePropertyAttribute
    public int getCreateType() {
        return this.createType;
    }

    public void setCreateType(int createType) {
        this.createType = createType;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @SimplePropertyAttribute
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    @SimplePropertyAttribute
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @SimplePropertyAttribute(name="isContainer")
    public boolean isContainer() {
        return this.isContainer;
    }

    public void setContainer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    @SimplePropertyAttribute(name="Inside")
    public boolean isInside() {
        return this.inside;
    }

    public void setInside(boolean inside) {
        this.inside = inside;
    }

    @SimplePropertyAttribute
    public Map<String, Object> getAccept() {
        return this.accept;
    }

    public void setAccept(Map<String, Object> accept) {
        this.accept = accept;
    }

    @SimplePropertyAttribute
    public Map<String, Object> getNotAccept() {
        return this.notAccept;
    }

    public void setNotAccept(Map<String, Object> notAccept) {
        this.notAccept = notAccept;
    }

    @SimplePropertyAttribute
    public Map<String, Object> getAcceptParent() {
        return this.acceptParent;
    }

    public void setAcceptParent(Map<String, Object> accept) {
        this.acceptParent = accept;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Property.class)
    public List<Property> getProperties() {
        return this.properties;
    }

    public String getClassName() {
        if (StringUtils.isNotEmpty((String)this.extendClassName)) {
            return this.extendClassName;
        }
        return this.packageName + "." + this.id;
    }

    public IDataEntityType getDataEntityType() {
        Class type = TypesContainer.getOrRegister((String)this.getClassName());
        IDataEntityType dt = OrmUtils.getDataEntityType((Class)type);
        if (dt instanceof DataEntityType) {
            ((DataEntityType)dt).setDisplayName(this.getName());
        }
        if (this.getProperties() != null && !this.getProperties().isEmpty()) {
            for (Property property : this.getProperties()) {
                IDataEntityProperty dtProp = (IDataEntityProperty)dt.getProperties().get((Object)property.getPropertyName());
                if (dtProp instanceof SimpleProperty) {
                    ((SimpleProperty)dtProp).setDisplayName(property.getName());
                    continue;
                }
                if (dtProp instanceof ComplexProperty) {
                    ((ComplexProperty)dtProp).setDisplayName(property.getName());
                    continue;
                }
                if (!(dtProp instanceof CollectionProperty)) continue;
                ((CollectionProperty)dtProp).setDisplayName(property.getName());
            }
        }
        return dt;
    }

    public void beginInit() {
        this._isInitialize = true;
    }

    public void endInit() {
        this.sortItems();
        this._isInitialize = false;
    }

    private void sortItems() {
        Collections.sort(this.properties, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return Integer.compare(o1.getSeq(), o2.getSeq());
            }
        });
    }

    public boolean isInitialized() {
        return this._isInitialize;
    }

    public String toString() {
        return this.name == null ? "" : this.name.toString();
    }

    @SimplePropertyAttribute
    public String getExtendClassName() {
        return this.extendClassName;
    }

    public void setExtendClassName(String extendClassName) {
        this.extendClassName = extendClassName;
    }

    @SimplePropertyAttribute(name="isUnique")
    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    @SimplePropertyAttribute(name="OwnerTypeId")
    public String getOwnerTypeId() {
        return this.ownerTypeId;
    }

    public void setOwnerTypeId(String ownerTypeId) {
        this.ownerTypeId = ownerTypeId;
    }

    @SimplePropertyAttribute(name="Seq")
    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public void addProperty(Property newProperty) {
        boolean exists = false;
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!newProperty.getPropertyName().equals(this.properties.get(i).getPropertyName())) continue;
            this.properties.set(i, newProperty);
            exists = true;
            break;
        }
        if (!exists) {
            this.properties.add(newProperty);
        }
    }
}

