/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.domainmodel.define;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.devportal.api.IDevService;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.DomainModelTypeBinder;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.PropertyGroup;
import kd.bos.metadata.domainmodel.define.DomainModelTypeDefiner;
import kd.bos.metadata.domainmodel.define.DomainModelTypeDefiners;
import kd.bos.metadata.domainmodel.define.Resource;
import kd.bos.metadata.domainmodel.define.ServiceImpl;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.bos.metadata.entity.validation.ValidationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationTypes;
import kd.bos.service.ServiceFactory;
import kd.bos.utils.LocaleBuildUtils;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

@SdkPublic
public class DomainModelTypeFactory {
    private static final String DM = "DM_";
    private static final String DM_Category = "DM_Category_";
    private static final String DM_PropertyGroup = "DM_PropertyGroup_";
    private static final String DM_ElementType = "DM_ElementType_";
    private static final String DM_ElementType_Property = "DM_ElementType_Property_";
    private static final String DM_ElementType_Property_Desc = "DM_ElementType_Property_Desc_";
    private static final String DM_ElementType_Property_Group = "DM_ElementType_Property_Group_";
    private static final String DM_ElementType_Property_Editor = "DM_ElementType_Property_Editor_";
    public static final String DM_NAME = "DM_Name_";
    public static final String DM_DESC = "DM_Desc_";
    public static final String VALIDATION_TYPE = "ValidationType";
    private static final String OPBIZRULE_TYPE = "OpBizRuleType";
    private static final String DOMAIN_MODEL_PRODUCT_PATH = "domainmodel/product/";
    private static final String DOMAIN_MODEL_INDUSTRY_PATH = "domainmodel/industry/";
    private static final String DOMAIN_MODEL_CUSTOM_PATH = "domainmodel/custom/";
    private static final String MODEL = ".model";
    private static final String TYPE = "type";
    private static final String COMBO = "combo";
    private static final String ITEMS = "items";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String MCOMBO = "mcombo";
    private static final String TABSELECT = "tabselect";
    private static final String EDITCOMBO = "editcombo";
    private static final String FONTBOLD = "fontbold";
    private static final String BTNEDIT = "btnedit";
    private static final String BTN_NAME = "btnName";
    private static final String DIMENSION = "dimension";
    private static final String UNITS = "units";
    private static Map<String, List<DomainModelTypeDefiner>> typeDefiners = new HashMap<String, List<DomainModelTypeDefiner>>();
    private static List<String> extendModels = new ArrayList<String>();
    private static List<String> oemSkipModels = new ArrayList<String>(3);
    private static Log log = LogFactory.getLog((String)"DomainModelTypeFactory");

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(Instance.getClusterName(), "domainmodeltype", info);
    }

    private static DomainModelType getCacheDomainModelType(String accountId, String key) {
        LocalMemoryCache cache = DomainModelTypeFactory.getLocalCache();
        Object data = cache.get("domainmodeltype." + accountId + "." + key);
        if (data instanceof DomainModelType) {
            return (DomainModelType)data;
        }
        return null;
    }

    private static void putCacheDomainModelType(String accountId, String key, DomainModelType domainModelType) {
        LocalMemoryCache cache = DomainModelTypeFactory.getLocalCache();
        cache.put("domainmodeltype." + accountId + "." + key, (Object)domainModelType);
    }

    private static void clearCacheDomainModelType(String accountId, String key) {
        LocalMemoryCache cache = DomainModelTypeFactory.getLocalCache();
        cache.remove(new String[]{"domainmodeltype." + accountId + "." + key});
    }

    public static Set<String> getParentDomainType(String modelTypeId) {
        LinkedHashSet<String> parentModels = new LinkedHashSet<String>();
        List<DomainModelTypeDefiner> mds = typeDefiners.get(modelTypeId);
        if (mds != null) {
            for (DomainModelTypeDefiner md : mds) {
                if (!StringUtils.isNotBlank((CharSequence)md.getParentTypeName())) continue;
                String parentModel = md.getParentTypeName();
                Set<String> grandModels = DomainModelTypeFactory.getParentDomainType(parentModel);
                parentModels.addAll(grandModels);
                parentModels.add(parentModel);
            }
        }
        return parentModels;
    }

    public static DomainModelType getDomainModelType(String domainModelTypeId, boolean includeProperties) {
        String locale = Lang.get().toString();
        return DomainModelTypeFactory.getDomainModelType(domainModelTypeId, includeProperties, locale);
    }

    public static DomainModelType getDomainModelType(String domainModelTypeId, boolean includeProperties, String locale) {
        String modelTypeId = domainModelTypeId.equals("ParameterFormModel_public") || !domainModelTypeId.startsWith("ParameterFormModel") ? domainModelTypeId : "ParameterFormModel";
        String key = domainModelTypeId + includeProperties + locale;
        DomainModelType modelType = DomainModelTypeFactory.getCacheDomainModelType(RequestContext.get().getAccountId(), key);
        if (modelType == null) {
            DomainModelType commonDomainModelType = DomainModelTypeFactory.getCacheDomainModelType("", key);
            if (commonDomainModelType == null) {
                commonDomainModelType = DomainModelTypeFactory.getDomainModelTypeSys(modelTypeId, includeProperties, Lang.from((String)locale));
                DomainModelTypeFactory.putCacheDomainModelType("", key, commonDomainModelType);
            }
            String xmlDomain = DomainModelTypeFactory.getDomainModelTypeXml(modelTypeId, commonDomainModelType);
            DomainModelType modelTypeLocale = new DomainModelType();
            DomainModelTypeFactory.fromXML(DomainModelType.getDomainModelTypeEntityTypes(), xmlDomain, modelTypeLocale);
            DomainModelTypeFactory.fillModelTypeLoacle(modelTypeLocale, locale);
            modelType = DomainModelTypeFactory.MergeFromDB(modelTypeLocale, modelTypeId, locale);
            DomainModelTypeFactory.putCacheDomainModelType(RequestContext.get().getAccountId(), key, modelType);
        }
        return modelType;
    }

    @Deprecated
    public static void fillModelTypeLoacle(DomainModelType modelType, String locale) {
        if (Boolean.getBoolean("sys.domainmodel.oldlocale.disable")) {
            return;
        }
        if (modelType == null || modelType.getName() == null || modelType.isFillLocale() || locale.equals(Lang.zh_CN.name())) {
            return;
        }
        Lang defaultLang = Lang.zh_CN;
        Lang targetLang = Lang.from((String)locale);
        DomainModelTypeFactory.applyOldLocaleRes(modelType.getName(), defaultLang, targetLang, DM + modelType.getId(), modelType.getId());
        for (Category category : modelType.getCategories()) {
            DomainModelTypeFactory.applyOldLocaleRes(category.getName(), defaultLang, targetLang, DM_Category + category.getId(), modelType.getId());
            for (ElementType entry : category.getElementTypes()) {
                DomainModelTypeFactory.applyOldLocaleRes(entry.getName(), defaultLang, targetLang, DM_ElementType + entry.getId(), modelType.getId());
                for (Property property : entry.getProperties()) {
                    DomainModelTypeFactory.applyOldLocaleRes(property.getName(), defaultLang, targetLang, DM_ElementType_Property + entry.getId() + "_" + property.getPropertyName(), modelType.getId());
                    DomainModelTypeFactory.applyOldLocaleRes(property.getDescription(), defaultLang, targetLang, DM_ElementType_Property_Desc + entry.getId() + "_" + property.getPropertyName(), modelType.getId());
                    DomainModelTypeFactory.fillModelTypeLoacleEditor(modelType, locale, entry, property);
                }
            }
        }
        for (PropertyGroup propertyGroup : modelType.getPropertyGroups()) {
            DomainModelTypeFactory.applyOldLocaleRes(propertyGroup.getName(), defaultLang, targetLang, DM_PropertyGroup + propertyGroup.getKey(), modelType.getId());
        }
    }

    @Deprecated
    private static void fillModelTypeLoacleEditor(DomainModelType modelType, String locale, ElementType entry, Property property) {
        block8: {
            Object units;
            Object type;
            Map<String, Object> editorMap;
            block10: {
                block9: {
                    if (property.getEditor() == null) break block8;
                    editorMap = property.getEditor();
                    type = editorMap.get(TYPE);
                    if (!COMBO.equals(type) && !MCOMBO.equals(type) && !EDITCOMBO.equals(type) && !FONTBOLD.equals(type) && !TABSELECT.equals(type)) break block9;
                    Object itemsObj = editorMap.get(ITEMS);
                    if (!(itemsObj instanceof List)) break block8;
                    for (Object itemObj : (List)itemsObj) {
                        Map item;
                        if (!(itemObj instanceof Map) || !LocaleBuildUtils.hasChineseCharacters((String)(item = (Map)itemObj).getOrDefault(NAME, "").toString())) continue;
                        Object itemId = item.get(ID);
                        String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + itemId;
                        LocaleString res = ResManager.getLocaleString((String)"", (String)resKey, (String)modelType.getId());
                        String itemName = (String)res.getItem(locale);
                        if (StringUtils.isBlank((CharSequence)itemName)) {
                            itemName = (String)res.getItem(Lang.zh_CN.name());
                        }
                        if (!StringUtils.isNotBlank((CharSequence)itemName)) continue;
                        item.put(NAME, itemName);
                    }
                    break block8;
                }
                if (!BTNEDIT.equals(type)) break block10;
                if (!LocaleBuildUtils.hasChineseCharacters((String)editorMap.getOrDefault(BTN_NAME, "").toString())) break block8;
                String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + BTN_NAME;
                if (editorMap.get(BTN_NAME) != null) {
                    LocaleString res = ResManager.getLocaleString((String)"", (String)resKey, (String)modelType.getId());
                    String str = (String)res.getItem(locale);
                    if (StringUtils.isBlank((CharSequence)str)) {
                        str = (String)res.getItem(Lang.zh_CN.name());
                    }
                    if (StringUtils.isNotBlank((CharSequence)str)) {
                        editorMap.put(BTN_NAME, str);
                    }
                }
                break block8;
            }
            if (DIMENSION.equals(type) && (units = editorMap.get(UNITS)) instanceof List) {
                List uintsList = (List)units;
                for (int i = 0; i < uintsList.size(); ++i) {
                    if (!LocaleBuildUtils.hasChineseCharacters(uintsList.get(i) == null ? null : uintsList.get(i).toString())) continue;
                    String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + DIMENSION + "_" + i;
                    LocaleString res = ResManager.getLocaleString((String)"", (String)resKey, (String)modelType.getId());
                    String str = (String)res.getItem(locale);
                    if (StringUtils.isBlank((CharSequence)str)) {
                        str = (String)res.getItem(Lang.zh_CN.name());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                    uintsList.set(i, str);
                }
            }
        }
    }

    private static boolean isTranslated(LocaleString value, String defaultLocale, String targetLocale) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        String originValue = (String)value.get((Object)targetLocale);
        if (StringUtils.isBlank((CharSequence)originValue)) {
            return true;
        }
        return !LocaleBuildUtils.hasChineseCharacters((String)originValue);
    }

    private static void applyOldLocaleRes(LocaleString v, Lang defaultLang, Lang targetLang, String resourceID, String systemType) {
        if (v == null || DomainModelTypeFactory.isTranslated(v, defaultLang.toString(), targetLang.toString())) {
            return;
        }
        String oldTrans = ResManager.loadKDString((Lang)targetLang, (String)" ", (String)resourceID, (String)systemType, (Object[])new Object[0]);
        if (!StringUtils.isBlank((CharSequence)oldTrans)) {
            v.setItem(targetLang.toString(), (Object)oldTrans);
        }
    }

    private static DomainModelType MergeFromDB(DomainModelType modelType, String modelTypeId, String locale) {
        try {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select t1.fid, t1.fnumber,t1.fxml_tag,t1.fcategory as fcategorynumber,t1.fcategoryxml as fcategoryxml,t1.fissys,t2.fname as fname,t2.fcategoryname as fcategoryname from t_dm_elementtype t1 left join t_dm_elementtype_l t2 on t1.fid=t2.fid and t2.flocaleid = ? ", new Object[]{new SqlParameter(":flocaleid", 12, (Object)locale)}).append(" where ((t1.fapplynumber like ?  and t1.fissys = '0') or (t1.fmodeltype = ? and t1.fissys = '1'))and t1.fenable = '1' ", new Object[]{new SqlParameter(":fapplynumber", 12, (Object)("%" + modelTypeId + "%")), new SqlParameter(":fmodeltype", 12, (Object)modelTypeId)});
            HashMap list = new HashMap(16);
            DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("number", rs.getString("fnumber"));
                    map.put("xml_tag", rs.getString("fxml_tag"));
                    map.put("category_number", rs.getString("fcategorynumber"));
                    map.put("category_xml", rs.getString("fcategoryxml"));
                    map.put("issys", rs.getString("fissys"));
                    map.put("element_name", rs.getString("fname"));
                    map.put("category_name", rs.getString("fcategoryname"));
                    list.put(rs.getString("fid"), map);
                }
                return list;
            });
            SqlBuilder sqlentry = new SqlBuilder();
            sqlentry.append("select t1.fid,t1.fpropertynumber as fnumber from t_dm_elementtypeentry t1", new Object[0]).append("inner join t_dm_elementtype t3 on t1.fid = t3.fid ", new Object[0]).append(" where t3.fmodeltype = ? and t3.fissys = '1' and t3.fenable = '1' and t1.fexpand = '0' ", new Object[]{new SqlParameter(":modeltype", 12, (Object)modelTypeId)});
            DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlentry, rs -> {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    if (!list.containsKey(id)) continue;
                    HashSet<String> entryList = (HashSet<String>)((Map)list.get(id)).get("entry");
                    if (entryList == null) {
                        entryList = new HashSet<String>(16);
                        ((Map)list.get(id)).put("entry", entryList);
                    }
                    entryList.add(rs.getString("fnumber"));
                }
                return list;
            });
            if (list.isEmpty()) {
                return modelType;
            }
            String xmlDomain = DomainModelTypeFactory.getDomainModelTypeXml(modelTypeId, modelType);
            modelType = new DomainModelType();
            DomainModelTypeFactory.fromXML(DomainModelType.getDomainModelTypeEntityTypes(), xmlDomain, modelType);
            SqlBuilder propertyNameSql = new SqlBuilder();
            propertyNameSql.append("select t2.fnumber as fnumber,t1.fname as fname,t1.fdesc as fdesc from t_dm_property_l t1 inner join t_dm_property t2 on t1.fid=t2.fid and t1.flocaleid = ? ", new Object[]{new SqlParameter(":flocaleid", 12, (Object)locale)});
            Map cusPropLocaleInfos = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)propertyNameSql, rs -> {
                HashMap<String, String[]> pNameMap = new HashMap<String, String[]>(10);
                while (rs.next()) {
                    String propertyNmae = rs.getString("fname");
                    String propertyDesc = rs.getString("fdesc");
                    String propNumber = rs.getString("fnumber");
                    if (StringUtils.isBlank((CharSequence)propNumber)) continue;
                    String[] data = new String[]{propertyNmae, propertyDesc};
                    pNameMap.put(propNumber, data);
                }
                return pNameMap;
            });
            block2: for (Map rs2 : list.values()) {
                String xml = (String)rs2.get("xml_tag");
                if (StringUtils.isBlank((CharSequence)xml)) continue;
                ElementType elementType = new ElementType();
                DomainModelTypeFactory.fromXML(xml, elementType);
                if (StringUtils.isNotBlank(rs2.get("element_name"))) {
                    Object elementName = elementType.getName();
                    if (elementName == null) {
                        elementName = new LocaleString(rs2.get("element_name").toString());
                    } else {
                        elementName.put(locale, (Object)rs2.get("element_name").toString());
                    }
                    elementType.setName((LocaleString)elementName);
                }
                if (!cusPropLocaleInfos.isEmpty()) {
                    for (Property prop : elementType.getProperties()) {
                        LocaleString propDesc;
                        String[] localeInfos = (String[])cusPropLocaleInfos.get(prop.getPropertyName());
                        if (localeInfos == null) continue;
                        LocaleString propName = prop.getName();
                        if (propName == null) {
                            propName = new LocaleString();
                            prop.setName(propName);
                        }
                        if ((propDesc = prop.getDescription()) == null) {
                            propDesc = new LocaleString();
                            prop.setDescription(propDesc);
                        }
                        if (StringUtils.isNotBlank((CharSequence)localeInfos[0])) {
                            prop.getName().setItem(locale, (Object)localeInfos[0]);
                        }
                        if (!StringUtils.isNotBlank((CharSequence)localeInfos[1])) continue;
                        prop.getDescription().setItem(locale, (Object)localeInfos[0]);
                    }
                }
                boolean found = false;
                Category newCategory = null;
                if ("0".equals(rs2.get("issys"))) {
                    for (Category category : modelType.getCategories()) {
                        if (!category.getId().equals(rs2.get("category_number"))) continue;
                        newCategory = category;
                        break;
                    }
                    if (newCategory == null) {
                        newCategory = new Category();
                        String categoryXml = (String)rs2.get("category_xml");
                        DomainModelTypeFactory.fromXML(categoryXml, newCategory);
                        if (StringUtils.isNotBlank(rs2.get("category_name"))) {
                            LocaleString categoryName = newCategory.getName();
                            if (categoryName == null) {
                                categoryName = new LocaleString(rs2.get("category_name").toString());
                            } else {
                                categoryName.put(locale, (Object)rs2.get("category_name").toString());
                            }
                            newCategory.setName(categoryName);
                        }
                        modelType.getCategories().add(newCategory);
                    }
                    newCategory.getElementTypes().add(elementType);
                    continue;
                }
                for (Category category : modelType.getCategories()) {
                    if (category.getId().equals(rs2.get("category_number"))) {
                        List<ElementType> elementTypes = category.getElementTypes();
                        for (ElementType type : elementTypes) {
                            if (!type.getId().equals(elementType.getId())) continue;
                            Set entryList = (Set)rs2.get("entry");
                            if (entryList != null) {
                                for (Property property : elementType.getProperties()) {
                                    if (!entryList.contains(property.getPropertyName())) continue;
                                    type.addProperty(property);
                                }
                                type.endInit();
                            }
                            found = true;
                            break;
                        }
                    }
                    if (!found) continue;
                    continue block2;
                }
            }
            modelType.endInit();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        return modelType;
    }

    public static DomainModelType getDomainModelTypeSys(String modelTypeId, boolean includeProperties) {
        List<DomainModelTypeDefiner> mds = DomainModelTypeFactory.getModelDefiners(modelTypeId);
        List<IDataEntityType> dts = DomainModelType.getDomainModelTypeEntityTypes();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new DomainModelTypeBinder(dts));
        DomainModelTypeFactory.addTemplates(includeProperties, mds, ser);
        DomainModelType modelType = (DomainModelType)ser.deserializeFromString("<DomainModelType style=\"" + modelTypeId + "\"/>", null);
        return modelType;
    }

    private static DomainModelType getDomainModelTypeSys(String modelTypeId, boolean includeProperties, Lang lang) {
        List<DomainModelTypeDefiner> mds = DomainModelTypeFactory.getModelDefiners(modelTypeId);
        List<IDataEntityType> dts = DomainModelType.getDomainModelTypeEntityTypes();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new DomainModelTypeBinder(dts));
        DomainModelTypeFactory.addTemplates(includeProperties, mds, ser, lang);
        DomainModelType modelType = (DomainModelType)ser.deserializeFromString("<DomainModelType style=\"" + modelTypeId + "\"/>", null);
        return modelType;
    }

    private static String getDomainModelTypeXml(String modelTypeId, DomainModelType domainModelType) {
        List<IDataEntityType> dts = DomainModelType.getDomainModelTypeEntityTypes();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new DomainModelTypeBinder(dts));
        ser.setIsLocaleValueFull(true);
        return ser.serializeToString((Object)domainModelType, null);
    }

    public static String getRedisCacheKey(String locale) {
        return Instance.getClusterName() + "_" + RequestContext.get().getAccountId() + "_DomainModelType" + DomainModelType.getVersion() + RequestContext.get().getLang();
    }

    public static String getEntityRedisCacheKey(String locale) {
        return Instance.getClusterName() + "_" + RequestContext.get().getAccountId() + "_DomainModelTypeOnlyEntity_" + DomainModelType.getVersion() + locale;
    }

    public static void removeCache(String modelTypeId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
        String key = DomainModelTypeFactory.getRedisCacheKey(RequestContext.get().getLang().toString());
        cache.remove(key, modelTypeId);
        key = DomainModelTypeFactory.getEntityRedisCacheKey(RequestContext.get().getLang().toString());
        cache.remove(key, modelTypeId);
        key = modelTypeId + "true" + RequestContext.get().getLang().toString();
        DomainModelTypeFactory.clearCacheDomainModelType(RequestContext.get().getAccountId(), key);
        key = modelTypeId + "false" + RequestContext.get().getLang().toString();
        DomainModelTypeFactory.clearCacheDomainModelType(RequestContext.get().getAccountId(), key);
    }

    private static <T> T fromXML(String xml, T t) {
        ArrayList dts = new ArrayList();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(true, dts));
        return (T)ser.deserializeFromString(xml, t);
    }

    private static <T> T fromXML(List<IDataEntityType> dts, String xml, T t) {
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(true, dts));
        ser.setIsLocaleValueFull(true);
        return (T)ser.deserializeFromString(xml, t);
    }

    private static List<DomainModelTypeDefiner> getModelDefiners(String domainModelTypeId) {
        List<DomainModelTypeDefiner> mds = typeDefiners.get(domainModelTypeId);
        if (mds == null && (mds = DomainModelTypeFactory.loadDomainModelTypeDefiner(domainModelTypeId)) == null) {
            List<DomainModelTypeDefiner> definers = DomainModelTypeFactory.loadDomainModelTypeDefiner();
            for (DomainModelTypeDefiner md : definers) {
                if (!StringUtils.equals((CharSequence)md.getTypeName(), (CharSequence)domainModelTypeId)) continue;
                List<DomainModelTypeDefiner> list = typeDefiners.get(md.getTypeName());
                if (list == null) {
                    list = new ArrayList<DomainModelTypeDefiner>();
                    typeDefiners.put(md.getTypeName(), list);
                }
                list.add(md);
            }
            mds = typeDefiners.get(domainModelTypeId);
            if (mds == null) {
                throw new KDException(BosErrorCode.variableNameNotFound, new Object[]{String.format("DomainModelType %s not found!", domainModelTypeId)});
            }
        }
        return mds;
    }

    private static void addTemplates(boolean includeProperties, List<DomainModelTypeDefiner> mds, DcxmlSerializer ser) {
        for (DomainModelTypeDefiner md : mds) {
            DomainModelTypeFactory.addTemplate(includeProperties, ser, md);
        }
    }

    private static void addTemplate(boolean includeProperties, DcxmlSerializer ser, DomainModelTypeDefiner md) {
        DomainModelTypeFactory.addTemplate(includeProperties, ser, md, Lang.defaultLang());
    }

    private static void addTemplates(boolean includeProperties, List<DomainModelTypeDefiner> mds, DcxmlSerializer ser, Lang mainLang) {
        for (DomainModelTypeDefiner md : mds) {
            DomainModelTypeFactory.addTemplate(includeProperties, ser, md, mainLang);
        }
    }

    private static void addTemplate(boolean includeProperties, DcxmlSerializer ser, DomainModelTypeDefiner md, Lang mainLang) {
        if (StringUtils.isNotBlank((CharSequence)md.getParentTypeName())) {
            DomainModelTypeFactory.addTemplates(includeProperties, DomainModelTypeFactory.getModelDefiners(md.getParentTypeName()), ser, mainLang);
        }
        String defaultLocale = mainLang.toString();
        String locale = Lang.get().toString();
        try {
            Document document;
            SAXReader xmlReader;
            URL url;
            for (Resource res : md.getElementResources()) {
                try {
                    if (DomainModelTypeFactory.isOemSkipModel(res.getFileName())) {
                        log.info(String.format("OEM ENV DomainModel-skip-LoadRes,file is %s", res.getFileName()));
                        continue;
                    }
                    url = DomainModelTypeFactory.getResourceURL(md, res);
                    xmlReader = DomainModelTypeFactory.getReader();
                    document = xmlReader.read(url);
                    LocaleBuildUtils.replaceLocaleVars((String)res.getFileName(), (Document)document, (String)defaultLocale);
                    ser.addTemplateFromString(defaultLocale, document.asXML());
                }
                catch (Exception e) {
                    throw new KDException(new ErrorCode("DomainModel-LoadRes", "load localeResource error,origin file is " + res.getFileName()), new Object[]{e});
                }
            }
            if (!StringUtils.equals((CharSequence)locale, (CharSequence)defaultLocale)) {
                for (Resource res : md.getElementResources()) {
                    if (DomainModelTypeFactory.isOemSkipModel(res.getFileName())) {
                        log.info(String.format("OEM ENV DomainModel-skip-LoadRes,file is %s", res.getFileName()));
                        continue;
                    }
                    url = DomainModelTypeFactory.getResourceURL(md, res);
                    if (null == (url = DomainModelTypeFactory.getResourceLangURL(url, locale))) continue;
                    ser.addTemplate(locale, url);
                }
            }
            if (includeProperties) {
                for (Resource res : md.getPropertyResources()) {
                    if (DomainModelTypeFactory.isOemSkipModel(res.getFileName())) {
                        log.info(String.format("OEM ENV DomainModel-skip-LoadRes,file is %s", res.getFileName()));
                        continue;
                    }
                    url = DomainModelTypeFactory.getResourceURL(md, res);
                    try {
                        xmlReader = DomainModelTypeFactory.getReader();
                        document = xmlReader.read(url);
                        LocaleBuildUtils.replaceLocaleVars((String)res.getFileName(), (Document)document, (String)defaultLocale);
                        ser.addTemplateFromString(defaultLocale, document.asXML());
                    }
                    catch (Exception e) {
                        throw new KDException(new ErrorCode("DomainModel-LoadRes", "load localeResource error,origin file is " + res.getFileName()), new Object[]{e});
                    }
                }
                if (!StringUtils.equals((CharSequence)locale, (CharSequence)defaultLocale)) {
                    for (Resource res : md.getPropertyResources()) {
                        if (DomainModelTypeFactory.isOemSkipModel(res.getFileName())) {
                            log.info(String.format("OEM ENV DomainModel-skip-LoadRes,file is %s", res.getFileName()));
                            continue;
                        }
                        URL origin = url = DomainModelTypeFactory.getResourceURL(md, res);
                        if (null == (url = DomainModelTypeFactory.getResourceLangURL(url, locale))) continue;
                        ser.addTemplate(locale, url);
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static URL getResourceURL(DomainModelTypeDefiner md, Resource res) throws MalformedURLException {
        URL url = null;
        if (md.isInnerModel()) {
            url = Property.class.getResource("/" + res.getFileName());
        } else {
            String path = md.getAppLocation();
            int index = path.lastIndexOf("/");
            if (index > -1) {
                path = path.substring(0, index) + "/" + res.getFileName();
            }
            url = new URL(path);
        }
        return url;
    }

    private static SAXReader getReader() throws SAXException {
        SAXReader saxReader = new SAXReader();
        saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return saxReader;
    }

    private static URL getResourceLangURL(URL url, String locale) {
        if (null == url) {
            return null;
        }
        String path = url.toExternalForm();
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        if (!path.endsWith(".xml")) {
            return null;
        }
        String tmp = path.substring(0, path.length() - 4);
        tmp = tmp + "." + locale + ".xml";
        SAXReader reader = new SAXReader();
        try {
            URL tmpUrl = new URL(tmp);
            Document doc = reader.read(tmpUrl);
            return doc == null ? null : tmpUrl;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<DomainModelTypeDefiner> loadDomainModelTypeDefiner(String domainModelType) {
        List<IDataEntityType> dts = DomainModelTypeFactory.getDomainModelDefinerEntityTypes();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        URL url = DomainModelTypeFactory.getExtendsModelFile(domainModelType);
        if (url == null) {
            return null;
        }
        DomainModelTypeDefiner ret = (DomainModelTypeDefiner)ser.deserialize(url, null);
        ret.setAppLocation(url.getProtocol() + ":" + url.getPath());
        ret.setInnerModel(false);
        List<DomainModelTypeDefiner> mds = typeDefiners.get(ret.getTypeName());
        if (mds == null) {
            mds = new ArrayList<DomainModelTypeDefiner>();
            mds.add(ret);
            typeDefiners.put(ret.getTypeName(), mds);
        }
        return mds;
    }

    private static URL getExtendsModelFile(String domainModelType) {
        URL url = null;
        url = DomainModelTypeDefiner.class.getResource("/domainmodel/product/" + domainModelType + MODEL);
        if (url != null) {
            return url;
        }
        url = DomainModelTypeDefiner.class.getResource("/domainmodel/industry/" + domainModelType + MODEL);
        if (url != null) {
            return url;
        }
        url = DomainModelTypeDefiner.class.getResource("/domainmodel/custom/" + domainModelType + MODEL);
        if (url != null) {
            return url;
        }
        return null;
    }

    private static List<DomainModelTypeDefiner> loadDomainModelTypeDefiner() {
        List<IDataEntityType> dts = DomainModelTypeFactory.getDomainModelDefinerEntityTypes();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        URL url = Property.class.getResource("/DomainModelTypeDefiners.xml");
        DomainModelTypeDefiners mds = (DomainModelTypeDefiners)ser.deserialize(url, null);
        List<DomainModelTypeDefiner> ret = mds.getDefiners();
        List<URL> files = DomainModelTypeFactory.getExtendsModelFiles();
        DomainModelTypeDefiner md = null;
        for (URL typeNameFile : files) {
            md = (DomainModelTypeDefiner)ser.deserialize(typeNameFile, null);
            md.setAppLocation(typeNameFile.getProtocol() + ":" + typeNameFile.getPath());
            md.setInnerModel(false);
            ret.add(md);
        }
        return ret;
    }

    public static List<DomainModelTypeDefiner> loadDomainModelTypeDefiner_LY() {
        List<IDataEntityType> dts = DomainModelTypeFactory.getDomainModelDefinerEntityTypes();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        URL url = Property.class.getResource("/DomainModelTypeDefiners.xml");
        DomainModelTypeDefiners mds = (DomainModelTypeDefiners)ser.deserialize(url, null);
        List<DomainModelTypeDefiner> ret = mds.getDefiners();
        List<URL> files = DomainModelTypeFactory.getExtendsModelFiles();
        DomainModelTypeDefiner md = null;
        for (URL typeNameFile : files) {
            md = (DomainModelTypeDefiner)ser.deserialize(typeNameFile, null);
            md.setAppLocation(typeNameFile.getProtocol() + ":" + typeNameFile.getPath());
            md.setInnerModel(false);
            ret.add(md);
        }
        return ret;
    }

    private static List<URL> getExtendsModelFiles() {
        ArrayList<URL> files = new ArrayList<URL>();
        for (String extmodel : extendModels) {
            URL url = DomainModelTypeDefiner.class.getResource("/domainmodel/product/" + extmodel);
            if (url == null) continue;
            files.add(url);
        }
        return files;
    }

    private static List<IDataEntityType> getDomainModelDefinerEntityTypes() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(DomainModelTypeDefiners.class));
        dts.add(OrmUtils.getDataEntityType(DomainModelTypeDefiner.class));
        dts.add(OrmUtils.getDataEntityType(Resource.class));
        return dts;
    }

    public static String genAllDomainTypeLocale() throws IOException {
        List<DomainModelTypeDefiner> list = DomainModelTypeFactory.loadDomainModelTypeDefiner_LY();
        ArrayList<String> result = new ArrayList<String>();
        for (DomainModelTypeDefiner definer : list) {
            try {
                DomainModelType dm = DomainModelTypeFactory.getDomainModelTypeSys(definer.getTypeName(), true);
                DomainModelTypeFactory.genModelTypeLocaleFileAndInsertDb(result, dm);
            }
            catch (Exception e) {
                log.error("metadata export locale=====" + definer.getTypeName() + " " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            DomainModelTypeFactory.genValidationTypeLocaleFileAndInsertDb(result);
        }
        catch (Exception e) {
            log.error("metadata export locale ValidationType=====", (Throwable)e);
            throw e;
        }
        try {
            DomainModelTypeFactory.genOpBizRuleTypeLocaleFileAndInsertDb(result);
        }
        catch (Exception e) {
            log.error("metadata export locale OpBizRuleType=====", (Throwable)e);
            throw e;
        }
        String path = DomainModelTypeFactory.getExportFilePath("exportlocale.zip");
        File dest = new File(System.getProperty("java.io.tmpdir") + "exportlocale.zip");
        try (FileOutputStream fos = new FileOutputStream(dest);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            DomainModelTypeFactory.compressFileToZip(System.getProperty("java.io.tmpdir"), result, zos);
        }
        catch (Exception e) {
            log.error("compress is fiall=====", (Throwable)e);
            throw e;
        }
        String url = "";
        try (FileInputStream inStream = new FileInputStream(dest);){
            FileService service = FileServiceFactory.getAttachmentFileService();
            url = service.upload(new FileItem("exportlocale.zip", path, (InputStream)inStream));
        }
        catch (Exception e) {
            log.error("upload is fail=====", (Throwable)e);
            throw e;
        }
        return url;
    }

    private static String getExportFilePath(String fileName) {
        RequestContext ctx = RequestContext.getOrCreate();
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String uuid = UUID.randomUUID().toString();
        return String.format("/%s/%s/%s/%s/%s/%s", ctx.getTenantId(), ctx.getAccountId(), dateStr, "bos", uuid, fileName);
    }

    private static void compressFileToZip(String parentFilePath, List<String> filePaths, ZipOutputStream zos) {
        for (String filePath : filePaths) {
            File sourceFile = new File(parentFilePath + filePath);
            if (!sourceFile.exists()) {
                return;
            }
            String zipEntryName = parentFilePath + sourceFile.getName();
            if (parentFilePath.isEmpty()) {
                zipEntryName = sourceFile.getName();
            }
            if (sourceFile.isDirectory()) {
                File[] childFiles = sourceFile.listFiles();
                if (!Objects.isNull(childFiles)) continue;
                return;
            }
            int len = -1;
            byte[] buf = new byte[1024];
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(sourceFile));
                Throwable throwable = null;
                try {
                    zos.putNextEntry(new ZipEntry(zipEntryName));
                    while ((len = ((InputStream)in).read(buf)) != -1) {
                        zos.write(buf, 0, len);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private static void genValidationTypeLocaleFileAndInsertDb(List<String> result) {
        LinkedHashMap<String, String> localeZH_CNMap = new LinkedHashMap<String, String>(50);
        ValidationTypes types = ValidationTypeLoader.loadFromXmlOri();
        for (ValidationType validationType : types.getTypes()) {
            localeZH_CNMap.put(DM_NAME + validationType.getId(), DomainModelTypeFactory.getResString((ILocaleString)validationType.getName()));
            localeZH_CNMap.put(DM_DESC + validationType.getId(), DomainModelTypeFactory.getResString((ILocaleString)validationType.getDesc()));
        }
        DomainModelTypeFactory.buildFile(result, VALIDATION_TYPE, localeZH_CNMap);
    }

    private static void genOpBizRuleTypeLocaleFileAndInsertDb(List<String> result) {
        LinkedHashMap<String, String> localeZH_CNMap = new LinkedHashMap<String, String>(50);
        OpBizRuleTypes types = OpBizRuleTypeLoader.loadFromXmlOri();
        for (OpBizRuleType type : types.getRuleTypes()) {
            localeZH_CNMap.put(DM_NAME + type.getId(), DomainModelTypeFactory.getResString((ILocaleString)type.getName()));
            localeZH_CNMap.put(DM_DESC + type.getId(), DomainModelTypeFactory.getResString((ILocaleString)type.getDesc()));
        }
        DomainModelTypeFactory.buildFile(result, OPBIZRULE_TYPE, localeZH_CNMap);
    }

    private static String getResString(ILocaleString localeString) {
        return localeString == null || localeString.get((Object)"zh_CN") == null ? " " : (String)localeString.get((Object)"zh_CN");
    }

    private static void genModelTypeLocaleFileAndInsertDb(List<String> result, DomainModelType dm) {
        if (dm.getName() == null) {
            return;
        }
        LinkedHashMap<String, String> localeEN_USMap = new LinkedHashMap<String, String>(50);
        LinkedHashMap<String, String> localeZH_CNMap = new LinkedHashMap<String, String>(50);
        localeEN_USMap.put(DM + dm.getId(), dm.getId());
        localeZH_CNMap.put(DM + dm.getId(), dm.getName() == null || dm.getName().get((Object)"zh_CN") == null ? " " : (String)dm.getName().get((Object)"zh_CN"));
        for (Category category : dm.getCategories()) {
            localeEN_USMap.put(DM_Category + category.getId(), category.getId());
            localeZH_CNMap.put(DM_Category + category.getId(), category.getName() == null || category.getName().get((Object)"zh_CN") == null ? " " : (String)category.getName().get((Object)"zh_CN"));
            for (ElementType entry : category.getElementTypes()) {
                localeEN_USMap.put(DM_ElementType + entry.getId(), entry.getId());
                localeZH_CNMap.put(DM_ElementType + entry.getId(), entry.getName() == null || entry.getName().get((Object)"zh_CN") == null ? " " : (String)entry.getName().get((Object)"zh_CN"));
                for (Property property : entry.getProperties()) {
                    Object units;
                    if (property.getDescription() != null) {
                        localeEN_USMap.put(DM_ElementType_Property_Desc + entry.getId() + "_" + property.getPropertyName(), property.getPropertyName());
                        localeZH_CNMap.put(DM_ElementType_Property_Desc + entry.getId() + "_" + property.getPropertyName(), DomainModelTypeFactory.saveConvert(StringUtils.isEmpty((CharSequence)((CharSequence)property.getDescription().get((Object)"zh_CN"))) || ((String)property.getDescription().get((Object)"zh_CN")).equals(" ") ? " " : (String)property.getDescription().get((Object)"zh_CN")));
                    }
                    if (property.getGroup() != null) {
                        localeEN_USMap.put(DM_ElementType_Property_Group + entry.getId() + "_" + property.getPropertyName(), property.getPropertyName());
                        localeZH_CNMap.put(DM_ElementType_Property_Group + entry.getId() + "_" + property.getPropertyName(), DomainModelTypeFactory.saveConvert(StringUtils.isEmpty((CharSequence)((CharSequence)property.getGroup().get((Object)"zh_CN"))) ? " " : (String)property.getGroup().get((Object)"zh_CN")));
                    }
                    if (property.getName() != null) {
                        localeEN_USMap.put(DM_ElementType_Property + entry.getId() + "_" + property.getPropertyName(), property.getPropertyName());
                        localeZH_CNMap.put(DM_ElementType_Property + entry.getId() + "_" + property.getPropertyName(), DomainModelTypeFactory.saveConvert(StringUtils.isEmpty((CharSequence)((CharSequence)property.getName().get((Object)"zh_CN"))) || ((String)property.getName().get((Object)"zh_CN")).equals(" ") ? " " : (String)property.getName().get((Object)"zh_CN")));
                    }
                    if (property.getEditor() == null) continue;
                    Map<String, Object> editorMap = property.getEditor();
                    Object type = editorMap.get(TYPE);
                    if (COMBO.equals(type) || MCOMBO.equals(type) || EDITCOMBO.equals(type) || FONTBOLD.equals(type) || TABSELECT.equals(type)) {
                        Object itemsObj = editorMap.get(ITEMS);
                        if (!(itemsObj instanceof List)) continue;
                        for (Object itemObj : (List)itemsObj) {
                            if (!(itemObj instanceof Map)) continue;
                            Map item = (Map)itemObj;
                            Object itemId = item.get(ID);
                            String key = itemId instanceof String ? DomainModelTypeFactory.saveConvert((String)itemId) : String.valueOf(itemId);
                            String itemNameObj = (String)item.get(NAME);
                            String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + key;
                            localeEN_USMap.put(resKey, itemNameObj + "_en");
                            localeZH_CNMap.put(resKey, itemNameObj);
                        }
                        continue;
                    }
                    if (BTNEDIT.equals(type)) {
                        String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + BTN_NAME;
                        if (editorMap.get(BTN_NAME) == null) continue;
                        String itemNameObj = (String)editorMap.get(BTN_NAME);
                        localeEN_USMap.put(resKey, itemNameObj + "_en");
                        localeZH_CNMap.put(resKey, itemNameObj);
                        continue;
                    }
                    if (!DIMENSION.equals(type) || !((units = editorMap.get(UNITS)) instanceof List)) continue;
                    List uintsList = (List)units;
                    for (int i = 0; i < uintsList.size(); ++i) {
                        String resKey = DM_ElementType_Property_Editor + entry.getId() + "_" + property.getPropertyName() + "_" + DIMENSION + "_" + i;
                        String itemNameObj = String.valueOf(uintsList.get(i));
                        localeEN_USMap.put(resKey, itemNameObj + "_en");
                        localeZH_CNMap.put(resKey, itemNameObj);
                    }
                }
            }
        }
        for (PropertyGroup propertyGroup : dm.getPropertyGroups()) {
            localeEN_USMap.put(DM_PropertyGroup + propertyGroup.getKey(), propertyGroup.getKey());
            localeZH_CNMap.put(DM_PropertyGroup + propertyGroup.getKey(), propertyGroup.getName() == null || propertyGroup.getName().get((Object)"zh_CN") == null ? " " : (String)propertyGroup.getName().get((Object)"zh_CN"));
        }
        DomainModelTypeFactory.buildFile(result, dm.getId(), localeZH_CNMap);
    }

    private static void buildFile(List<String> result, String modelId, HashMap<String, String> localeMap) {
        DomainModelTypeFactory.writeProperties(result, modelId, localeMap);
    }

    private static void writeProperties(List<String> result, String modelId, HashMap<String, String> localeMap) {
        Properties props = new Properties();
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            String filePath = tmpDir + modelId + "_zh_CN.properties";
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
                 BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                 FileOutputStream fos = new FileOutputStream(filePath);){
                props.load(bf);
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, String> entry : localeMap.entrySet()) {
                    sb.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
                }
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = DomainModelTypeFactory.saveConvert(String.valueOf(entry.getKey()));
                    String value = DomainModelTypeFactory.saveConvert(String.valueOf(entry.getValue()));
                    if (localeMap.containsKey(key)) continue;
                    sb.append(key).append("=").append(value).append("\n");
                }
                ((OutputStream)fos).write(sb.toString().getBytes("UTF-8"));
                if (!result.contains(modelId + "_zh_CN.properties")) {
                    result.add(modelId + "_zh_CN.properties");
                }
            }
        }
        catch (IOException e) {
            log.error("Visit " + modelId + " for updating  value error", (Throwable)e);
        }
    }

    private static String saveConvert(String theString) {
        return DomainModelTypeFactory.saveConvert(theString, true);
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static boolean isOemSkipModel(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return false;
        }
        IDevService devService = (IDevService)ServiceFactory.getService(IDevService.class);
        return devService.isOEMEnv() && oemSkipModels.contains(fileName);
    }

    static {
        extendModels.add("ExtendBillForm.model");
        extendModels.add("ExtendDynamicForm.model");
        extendModels.add("ExtendMobileBill.model");
        extendModels.add("ExtendMobileDynamicForm.model");
        extendModels.add("DataModel.model");
        extendModels.add("PhysicalDataModel.model");
        oemSkipModels.add("BalanceModelTemplate.xml");
        oemSkipModels.add("BalanceModelProperty.xml");
        oemSkipModels.add("BalanceUpdateModelTemplate.xml");
        ArrayList<String> ets = new ArrayList<String>(20);
        ets.add("KFLOW");
        ets.add("FI");
        ets.add("HR");
        ets.add("BD");
        ets.add("SCM");
        ets.add("DRP");
        ets.add("SVC");
        ets.add("GPTAS");
        ets.add("NOCODE");
        ets.add("MMC");
        try {
            String exts = System.getProperty("bos.extend.domains");
            if (exts != null) {
                String[] extendDomains = exts.split(",");
                ets.addAll(Arrays.asList(extendDomains));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        for (String extendDomain : ets) {
            extendModels.add(extendDomain + "_ExtendBillForm.model");
            extendModels.add(extendDomain + "_ExtendDynamicForm.model");
            extendModels.add(extendDomain + "_ExtendMobileBillForm.model");
            extendModels.add(extendDomain + "_ExtendMobileDynamicForm.model");
        }
        long version = 0L;
        List<DomainModelTypeDefiner> definers = DomainModelTypeFactory.loadDomainModelTypeDefiner();
        for (DomainModelTypeDefiner md : definers) {
            List<DomainModelTypeDefiner> mds = typeDefiners.get(md.getTypeName());
            if (mds == null) {
                mds = new ArrayList<DomainModelTypeDefiner>();
                typeDefiners.put(md.getTypeName(), mds);
            }
            mds.add(md);
            version = Long.MAX_VALUE - md.getVersion() > version ? (version += md.getVersion()) : (version + md.getVersion()) / 2L;
            List<ServiceImpl> serviceImpls = md.getServiceImpls();
            if (serviceImpls == null) continue;
            for (ServiceImpl serviceImpl : serviceImpls) {
                if (StringUtils.isBlank((CharSequence)serviceImpl.getServiceName()) || StringUtils.isBlank((CharSequence)serviceImpl.getServiceImplClassName())) continue;
                try {
                    Class.forName(serviceImpl.getServiceImplClassName());
                }
                catch (ClassNotFoundException ex) {
                    log.error((Throwable)ex);
                    continue;
                }
                ServiceFactory.putService((String)serviceImpl.getServiceName(), (String)serviceImpl.getServiceImplClassName());
            }
        }
        DomainModelType.setExtendsVersion(version);
    }
}

