/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.NameVersionEntryProp;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.NameVersionEntryEntity;
import kd.bos.metadata.entity.businessfield.CreateDateField;
import kd.bos.metadata.entity.businessfield.CreaterField;
import kd.bos.metadata.entity.businessfield.MasterIdField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.ModifyDateField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BaseEntity
extends BillEntity {
    private String numberFieldId;
    private String nameFieldId;
    private String flexFieldId;
    private String mobileList;
    private boolean enableNameVersion;
    private String customController;
    private List<Plugin> basedataControllers = new ArrayList<Plugin>();

    @SimplePropertyAttribute
    public String getMobileList() {
        return this.mobileList;
    }

    @Override
    protected MainEntityType createDataEntityType() {
        BasedataEntityType et = new BasedataEntityType();
        et.setDBRouteKey("basedata");
        return et;
    }

    @Override
    protected void registerProperties(MainEntityType mdt) {
        super.registerProperties(mdt);
        BasedataEntityType dt = (BasedataEntityType)mdt;
        Field<?> numberField = this.entityMetadata.getFieldById(this.numberFieldId);
        if (numberField != null && StringUtils.isNotBlank((CharSequence)numberField.getFieldName())) {
            dt.setBillNo(numberField.getKey());
            dt.setNumberProperty(numberField.getKey());
        } else {
            dt.setBillNo("");
            dt.setNumberProperty("");
        }
        Field<?> nameField = this.entityMetadata.getFieldById(this.nameFieldId);
        if (nameField != null && StringUtils.isNotBlank((CharSequence)nameField.getFieldName())) {
            dt.setNameProperty(nameField.getKey());
        } else {
            dt.setNameProperty("");
        }
        Field<?> flexField = this.entityMetadata.getFieldById(this.flexFieldId);
        if (flexField != null) {
            dt.setFlexProperty(flexField.getKey());
        } else {
            dt.setFlexProperty("");
        }
        dt.setEnableNameVersion(this.isEnableNameVersion());
        if (this.isEnableNameVersion()) {
            if (StringUtils.isBlank((CharSequence)this.getTableName())) {
                dt.setEnableNameVersion(false);
            } else {
                this.registerNameVersionType(dt);
            }
        }
        for (EntityItem<?> item : this.getItems()) {
            if (!(item instanceof MasterIdField)) continue;
            MasterIdField masterFld = (MasterIdField)item;
            dt.setMasteridType(masterFld.getMasterIdType());
            if (masterFld.getMasterIdType() == 0) break;
            dt.setMasteridPropName(masterFld.getKey());
            break;
        }
        if (this.getCustomController() != null) {
            dt.setCustomControllerProperty(this.getCustomController());
        }
        ArrayList<kd.bos.entity.plugin.Plugin> plugins = new ArrayList<kd.bos.entity.plugin.Plugin>();
        for (Plugin p : this.basedataControllers) {
            if (!p.isEnabled()) continue;
            kd.bos.entity.plugin.Plugin pl = new kd.bos.entity.plugin.Plugin();
            pl.setClassName(p.getClassName());
            pl.setType(p.getType());
            pl.setScriptNumber(p.getScriptNumber());
            pl.setRowKey(p.getRowKey());
            plugins.add(pl);
        }
        Collections.sort(plugins, new Comparator<kd.bos.entity.plugin.Plugin>(){

            @Override
            public int compare(kd.bos.entity.plugin.Plugin o1, kd.bos.entity.plugin.Plugin o2) {
                Integer rowkey1 = o1.getRowKey();
                Integer rowkey2 = o2.getRowKey();
                return rowkey1.compareTo(rowkey2);
            }
        });
        dt.setBasedataControllersProp(plugins);
    }

    @Override
    public void addRefPropTypes(Map<String, Set<String>> refObjectProps) {
        super.addRefPropTypes(refObjectProps);
        if (this.isEnableNameVersion()) {
            refObjectProps.put("68bde9ca00000eac", new HashSet());
        }
    }

    private void registerNameVersionType(BasedataEntityType dt) {
        NameVersionEntryEntity nameVersionEntryEntity = this.createNameVersionEntryEntity();
        if (nameVersionEntryEntity != null) {
            EntryType entryType = (EntryType)nameVersionEntryEntity.buildDataEntityType();
            NameVersionEntryProp prop = new NameVersionEntryProp();
            prop.setName("name$version");
            prop.setItemType((IDataEntityType)entryType);
            prop.setDisplayName(nameVersionEntryEntity.getName());
            prop.setDefaultRows(nameVersionEntryEntity.getDefaultRows());
            dt.registerCollectionProperty((DynamicCollectionProperty)prop);
        }
    }

    public NameVersionEntryEntity createNameVersionEntryEntity() {
        if (StringUtils.isBlank((CharSequence)this.getTableName())) {
            return null;
        }
        NameVersionEntryEntity entryEntity = new NameVersionEntryEntity();
        entryEntity.setDefaultRows(0);
        entryEntity.setName(ResManager.getLocaleString((String)"\u66fe\u7528\u540d\u5217\u8868", (String)"BaseEntity_0", (String)"bos-metadata"));
        entryEntity.setKey("name$version");
        MuliLangTextField nameField = new MuliLangTextField();
        nameField.setFieldName("fname");
        nameField.setName(ResManager.getLocaleString((String)"\u540d\u79f0", (String)"BaseEntity_1", (String)"bos-metadata"));
        nameField.setKey("name$version$name");
        Field<?> mainNameField = this.entityMetadata.getFieldById(this.nameFieldId);
        if (mainNameField != null && StringUtils.isNotBlank((CharSequence)mainNameField.getFieldName())) {
            int fieldLen = mainNameField.getFieldLen();
            nameField.setMaxLength(fieldLen);
        }
        nameField.setGL(true);
        entryEntity.getItems().add(nameField);
        DateField startDateField = new DateField();
        startDateField.setFieldName("fstartdate");
        startDateField.setKey("name$version$startdate");
        startDateField.setName(ResManager.getLocaleString((String)"\u751f\u6548\u65e5\u671f", (String)"BaseEntity_2", (String)"bos-metadata"));
        startDateField.setEntityMetadata(this.entityMetadata);
        entryEntity.getItems().add(startDateField);
        DateField endDateField = new DateField();
        endDateField.setFieldName("fenddate");
        endDateField.setKey("name$version$enddate");
        endDateField.setName(ResManager.getLocaleString((String)"\u5931\u6548\u65e5\u671f", (String)"BaseEntity_3", (String)"bos-metadata"));
        endDateField.setEntityMetadata(this.entityMetadata);
        entryEntity.getItems().add(endDateField);
        CheckBoxField checkBoxField = new CheckBoxField();
        checkBoxField.setFieldName("fenable");
        checkBoxField.setName(ResManager.getLocaleString((String)"\u662f\u5426\u751f\u6548", (String)"BaseEntity_4", (String)"bos-metadata"));
        checkBoxField.setKey("name$version$enable");
        checkBoxField.setDefValue(true);
        checkBoxField.setEntityMetadata(this.entityMetadata);
        entryEntity.getItems().add(checkBoxField);
        ModifierField modifierField = new ModifierField();
        modifierField.setFieldName("fmodifierid");
        modifierField.setKey("name$version$modifier");
        modifierField.setName(ResManager.getLocaleString((String)"\u4fee\u6539\u4eba", (String)"BaseEntity_5", (String)"bos-metadata"));
        modifierField.setEntityMetadata(this.entityMetadata);
        entryEntity.getItems().add(modifierField);
        ModifyDateField modifyDateField = new ModifyDateField();
        modifyDateField.setFieldName("fmodifytime");
        modifyDateField.setKey("name$version$modifytime");
        modifyDateField.setName(ResManager.getLocaleString((String)"\u4fee\u6539\u65f6\u95f4", (String)"BaseEntity_6", (String)"bos-metadata"));
        modifyDateField.setEntityMetadata(this.entityMetadata);
        entryEntity.getItems().add(modifyDateField);
        CreaterField creatorField = new CreaterField();
        creatorField.setFieldName("fcreatorid");
        creatorField.setKey("name$version$creator");
        creatorField.setName(ResManager.getLocaleString((String)"\u521b\u5efa\u4eba", (String)"BaseEntity_7", (String)"bos-metadata"));
        creatorField.setEntityMetadata(this.entityMetadata);
        entryEntity.getItems().add(creatorField);
        CreateDateField createDateField = new CreateDateField();
        createDateField.setFieldName("fcreatetime");
        createDateField.setKey("name$version$createtime");
        createDateField.setName(ResManager.getLocaleString((String)"\u521b\u5efa\u65f6\u95f4", (String)"BaseEntity_8", (String)"bos-metadata"));
        createDateField.setEntityMetadata(this.entityMetadata);
        entryEntity.getItems().add(createDateField);
        int len = Math.min(this.getTableName().length(), 28);
        entryEntity.setTableName(this.getTableName().substring(0, len) + "nh");
        entryEntity.setEntityMetadata(this.entityMetadata);
        entryEntity.setEntryPkFieldName("FEntryId");
        for (EntityItem<?> item : entryEntity.getItems()) {
            if (!(item instanceof Field)) continue;
            Field field = (Field)item;
            field.getFeatures().setCopyable(false);
            field.getFeatures().setImportable(false);
            field.getFeatures().setExportable(false);
            field.getFeatures().setBulkEditable(false);
            field.getFeatures().setF7BatchFill(false);
        }
        return entryEntity;
    }

    @SimplePropertyAttribute
    public String getNumberFieldId() {
        return this.numberFieldId;
    }

    public void setNumberFieldId(String numberFieldId) {
        this.numberFieldId = numberFieldId;
    }

    @SimplePropertyAttribute
    public String getNameFieldId() {
        return this.nameFieldId;
    }

    public void setNameFieldId(String nameFieldId) {
        this.nameFieldId = nameFieldId;
    }

    @SimplePropertyAttribute
    public String getFlexFieldId() {
        return this.flexFieldId;
    }

    public void setFlexFieldId(String flexFieldId) {
        this.flexFieldId = flexFieldId;
    }

    @Override
    public void resetItemId(Map<String, String> idMap) {
        super.resetItemId(idMap);
        String newid = idMap.get(this.getNumberFieldId());
        if (newid != null) {
            this.setNumberFieldId(newid);
        }
        if ((newid = idMap.get(this.getNameFieldId())) != null) {
            this.setNameFieldId(newid);
        }
    }

    @SimplePropertyAttribute(name="CustomController")
    public String getCustomController() {
        return this.customController;
    }

    public void setCustomController(String customController) {
        this.customController = customController;
    }

    @CollectionPropertyAttribute(name="BasedataControllers", collectionItemPropertyType=Plugin.class)
    public List<Plugin> getBasedataControllers() {
        return this.basedataControllers;
    }

    public void setBasedataControllers(List<Plugin> basedataControllers) {
        this.basedataControllers = basedataControllers;
    }

    @SimplePropertyAttribute(name="EnableNameVersion")
    public boolean isEnableNameVersion() {
        return this.enableNameVersion;
    }

    public void setEnableNameVersion(boolean enableNameVersion) {
        this.enableNameVersion = enableNameVersion;
    }
}

