/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.rule.BizRule;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class Entity<T extends DynamicProperty, DT extends EntityType>
extends EntityItem<DynamicProperty> {
    private List<EntityItem<?>> items = new ArrayList();
    private List<SplitTable> splitTables = new ArrayList<SplitTable>();
    private String tableName;
    private List<BizRule> rules = new ArrayList<BizRule>();
    public String srcEntityDisaKey;
    private String dbRoute;

    public List<EntityItem<?>> getItems() {
        return this.items;
    }

    @SimplePropertyAttribute
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @SimplePropertyAttribute
    public String getdbRoute() {
        return this.dbRoute;
    }

    public void setdbRoute(String dbRoute) {
        this.dbRoute = dbRoute;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=SplitTable.class)
    public List<SplitTable> getSplitTables() {
        return this.splitTables;
    }

    public void setSplitTables(List<SplitTable> value) {
        this.splitTables = value;
    }

    @SimplePropertyAttribute
    public String getSrcEntityDisaKey() {
        return this.srcEntityDisaKey;
    }

    public void setSrcEntityDisaKey(String srcEntityDisaKey) {
        this.srcEntityDisaKey = srcEntityDisaKey;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=BizRule.class)
    public List<BizRule> getRules() {
        return this.rules;
    }

    @Override
    public Map<String, Object> createTreeNode() {
        Map<String, Object> node = super.createTreeNode();
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(10);
        for (EntityItem<?> item : this.items) {
            nodes.add(item.createTreeNode());
        }
        node.put("Items", nodes);
        return node;
    }

    @Override
    public Map<String, Object> createTreeNodeByKey() {
        Map<String, Object> node = super.createTreeNodeByKey();
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(10);
        for (EntityItem<?> item : this.items) {
            nodes.add(item.createTreeNodeByKey());
        }
        node.put("Items", nodes);
        return node;
    }

    public DT buildDataEntityType() {
        DT dt = this.createDataEntityType();
        this.registerProperties(dt);
        return dt;
    }

    protected abstract DT createDataEntityType();

    protected void registerProperties(DT dt) {
        dt.setName(this.getKey());
        dt.setDisplayName(this.getName());
        dt.setDBRouteKey(this.entityMetadata.getDBRouteKey());
        HashMap map = new HashMap(this.items.size());
        HashMap keymap = new HashMap(this.items.size());
        for (EntityItem<?> item : this.items) {
            if (item instanceof Field) {
                String key = ((Field)item).getFieldName();
                if (StringUtils.isNotBlank((CharSequence)key) && map.containsKey(key)) {
                    Field field = (Field)map.get(key);
                    String msg = String.format(ResManager.loadKDString((String)"\u91cd\u590d\u7684\u5b57\u6bb5\u540d\uff1a\uff08%1$s\uff09%2$s\uff0c%3$s", (String)"Entity_1", (String)"bos-metadata", (Object[])new Object[0]), this.getName(), item.getName().toString(), field.getName().toString());
                    this.addBuildError(2, item.getKey(), msg);
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)item.getKey()) && keymap.containsKey(item.getKey())) {
                    String msg = String.format(ResManager.loadKDString((String)"\u91cd\u590d\u7684\u5b57\u6bb5\u6807\u8bc6\uff1a\uff08%1$s\uff09%2$s\uff0c%3$s", (String)"Entity_2", (String)"bos-metadata", (Object[])new Object[0]), this.getName(), item.getName(), item.getName());
                    this.addBuildError(1, item.getKey(), msg);
                } else {
                    map.put(key, item);
                    keymap.put(item.getKey(), item);
                }
            }
            item.registerProperty((DynamicObjectType)dt);
        }
    }
}

