/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.LinkSetItem;
import kd.bos.metadata.exception.ErrorInfo;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class LinkSet {
    private String trackerTable;
    private String wbSnapTable;
    private List<LinkSetItem> items = new ArrayList<LinkSetItem>();
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private List<Plugin> convRulePlugIns = new ArrayList<Plugin>();

    @SimplePropertyAttribute
    public String getTrackerTable() {
        return this.trackerTable;
    }

    public void setTrackerTable(String trackerTable) {
        this.trackerTable = trackerTable;
    }

    @SimplePropertyAttribute
    public String getWbSnapTable() {
        return this.wbSnapTable;
    }

    public void setWbSnapTable(String wbSnapTable) {
        this.wbSnapTable = wbSnapTable;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=LinkSetItem.class)
    public List<LinkSetItem> getItems() {
        return this.items;
    }

    public void setItems(List<LinkSetItem> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getPlugIns() {
        return this.plugins;
    }

    public void setPlugIns(List<Plugin> plugins) {
        this.plugins.clear();
        if (plugins != null) {
            this.plugins.addAll(plugins);
        }
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getConvRulePlugIns() {
        return this.convRulePlugIns;
    }

    public void setConvRulePlugIns(List<Plugin> convRulePlugIns) {
        this.convRulePlugIns.clear();
        if (convRulePlugIns != null) {
            this.convRulePlugIns.addAll(convRulePlugIns);
        }
    }

    public LinkSetElement buildRuntimeListSet(EntityMetadata entityMetadata) {
        CRPlugin runtimePlugin;
        LinkSetElement runtimeMeta = new LinkSetElement();
        runtimeMeta.setTrackerTable(this.trackerTable);
        runtimeMeta.setWbSnapTable(this.wbSnapTable);
        for (Plugin plugin : this.plugins) {
            if (!plugin.isEnabled()) continue;
            runtimePlugin = new CRPlugin();
            runtimePlugin.setEnabled(true);
            runtimePlugin.setType(plugin.getType());
            runtimePlugin.setClassName(plugin.getClassName());
            runtimePlugin.setScriptId(plugin.getFpk());
            runtimeMeta.getPlugIns().add(runtimePlugin);
        }
        for (Plugin plugin : this.convRulePlugIns) {
            if (!plugin.isEnabled()) continue;
            runtimePlugin = new CRPlugin();
            runtimePlugin.setEnabled(true);
            runtimePlugin.setType(plugin.getType());
            runtimePlugin.setClassName(plugin.getClassName());
            runtimePlugin.setScriptId(plugin.getFpk());
            runtimeMeta.getConvRulePlugIns().add(runtimePlugin);
        }
        for (LinkSetItem item : this.items) {
            String[] fldIds;
            LinkSetItemElement runtimeItem = new LinkSetItemElement();
            runtimeItem.setLinkEntityKey(item.getLinkEntityKey());
            runtimeItem.setTableName(item.getTableName());
            EntityItem<?> parent = item.getParentEntity(entityMetadata);
            if (parent == null) {
                ErrorInfo info = new ErrorInfo();
                info.setItemId(entityMetadata.getId());
                info.setPropertyName("LinkSet");
                info.setType("linkset");
                info.setLevel(1);
                info.setError(String.format(ResManager.loadKDString((String)"\u5173\u8054\u914d\u7f6e\u4e2d\u7684\u5173\u8054\u5b9e\u4f53\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u8be5\u6761\u8bb0\u5f55\u3002", (String)"LinkSet_0", (String)"bos-metadata", (Object[])new Object[0]), item.getLinkEntityKey()));
                entityMetadata.addError(info);
                entityMetadata.addError(new ErrorInfo());
                continue;
            }
            runtimeItem.setParentEntityKey(parent.getKey());
            ArrayList<String> ctlFldKeys = new ArrayList<String>();
            for (String fldId : fldIds = item.getCtrlFldIds().split(",")) {
                if (StringUtils.isBlank((CharSequence)fldId)) continue;
                EntityItem<?> field = entityMetadata.getItemById(fldId);
                if (field == null) {
                    ErrorInfo info = new ErrorInfo();
                    info.setItemId(entityMetadata.getId());
                    info.setPropertyName("LinkSet");
                    info.setType("linkset");
                    info.setLevel(1);
                    info.setError(ResManager.loadKDString((String)"\u5173\u8054\u5b50\u5b9e\u4f53\u4e0a\u8bbe\u7f6e\u7684\u63a7\u5236\u5b57\u6bb5\uff0c\u5728\u5355\u636e\u4e2d\u4e0d\u5b58\u5728\u4e86", (String)"LinkSet_1", (String)"bos-metadata", (Object[])new Object[0]));
                    entityMetadata.addError(info);
                    entityMetadata.addError(new ErrorInfo());
                    continue;
                }
                ctlFldKeys.add(field.getKey());
            }
            runtimeItem.setCtrlFldKeys(StringUtils.join((Object[])ctlFldKeys.toArray(), (String)","));
            runtimeMeta.getItems().add(runtimeItem);
        }
        return runtimeMeta;
    }

    public EntityMetadata createTrackerMetadata() {
        if (this.items.size() == 0) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.trackerTable) || StringUtils.isBlank((CharSequence)this.wbSnapTable)) {
            return null;
        }
        String entityId = MetadataDao.getIdByNumber("botp_snapshot", MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta(entityId, MetaCategory.Entity);
        entityMetadata.getRootEntity().setTableName(this.trackerTable);
        for (Entity<?, ?> entity : entityMetadata.getEntitys()) {
            if (!"wbsnapentity".equalsIgnoreCase(entity.getKey())) continue;
            entity.setTableName(this.wbSnapTable);
        }
        return entityMetadata;
    }
}

