/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.LinkEntryEntity;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.exception.ErrorInfo;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class LinkSetItem {
    private String linkEntityKey;
    private String parentEntityId;
    private String tableName;
    private String ctrlFldIds;
    public static final String Key_BillHead = "billhead";

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getParentEntityId() {
        return this.parentEntityId;
    }

    public void setParentEntityId(String parentEntityId) {
        this.parentEntityId = parentEntityId;
    }

    @SimplePropertyAttribute
    public String getLinkEntityKey() {
        return this.linkEntityKey;
    }

    public void setLinkEntityKey(String linkEntityKey) {
        this.linkEntityKey = linkEntityKey;
    }

    @SimplePropertyAttribute
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @SimplePropertyAttribute
    public String getCtrlFldIds() {
        return this.ctrlFldIds;
    }

    public void setCtrlFldIds(String ctrlFldIds) {
        this.ctrlFldIds = ctrlFldIds;
    }

    public void registLinkEntryProp(EntityMetadata entityMetadata, BillEntityType mainType) {
        if (StringUtils.isBlank((CharSequence)this.parentEntityId) || StringUtils.isBlank((CharSequence)this.linkEntityKey)) {
            return;
        }
        EntityItem<?> parentEntity = this.getParentEntity(entityMetadata);
        if (parentEntity == null) {
            return;
        }
        EntityType parentEntityType = (EntityType)mainType.getAllEntities().get(parentEntity.getKey());
        if (parentEntityType == null) {
            return;
        }
        LinkEntryEntity linkEntryEntity = this.createLinkEntryEntity(entityMetadata);
        if (linkEntryEntity != null) {
            linkEntryEntity.registerProperty((DynamicObjectType)parentEntityType);
        }
    }

    public LinkEntryEntity createLinkEntryEntity(EntityMetadata entityMetadata) {
        EntityItem<?> parentEntity = this.getParentEntity(entityMetadata);
        if (parentEntity == null) {
            return null;
        }
        LinkEntryEntity linkEntryEntity = new LinkEntryEntity();
        linkEntryEntity.setEntityMetadata(entityMetadata);
        ArrayList<String> langs = new ArrayList<String>(10);
        for (Map.Entry item : parentEntity.getName().entrySet()) {
            langs.add((String)item.getKey());
        }
        linkEntryEntity.setKey(this.linkEntityKey);
        linkEntryEntity.setDefaultRows(0);
        LocaleString localeString = ResManager.getLocaleString((String)"\u5173\u8054\u5b50\u5b9e\u4f53", (String)"LinkSetItem_8", (String)"bos-metadata");
        LocaleString linkEntityName = new LocaleString();
        for (String lang : langs) {
            linkEntityName.setItem(lang, localeString.get((Object)lang));
        }
        linkEntryEntity.setName(linkEntityName);
        linkEntryEntity.setParentId(parentEntity.getId());
        linkEntryEntity.setTableName(this.tableName);
        linkEntryEntity.setEntryPkFieldName("FPKId");
        this.createSTableIdField(linkEntryEntity, langs);
        this.createSBillIdField(linkEntryEntity, langs);
        this.createSIdField(linkEntryEntity, langs);
        if (StringUtils.isNotBlank((CharSequence)this.getCtrlFldIds())) {
            String[] ctrlFieldIds;
            for (String ctrlFieldId : ctrlFieldIds = StringUtils.split((String)this.getCtrlFldIds(), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)ctrlFieldId)) continue;
                this.createCtrlField(entityMetadata, linkEntryEntity, ctrlFieldId, langs);
            }
        }
        return linkEntryEntity;
    }

    private void createSTableIdField(LinkEntryEntity linkEntryEntity, List<String> langs) {
        String fieldKey = this.linkEntityKey + "_stableid";
        String fieldName = "FSTableId";
        LocaleString localeString = ResManager.getLocaleString((String)"\u6e90\u5355\u4e3b\u5b9e\u4f53\u7f16\u7801", (String)"LinkSetItem_9", (String)"bos-metadata");
        LocaleString fieldCaption = new LocaleString();
        for (String lang : langs) {
            fieldCaption.setItem(lang, localeString.get((Object)lang));
        }
        BigIntField field = new BigIntField();
        field.setKey(fieldKey);
        field.setFieldName(fieldName);
        field.setName(fieldCaption);
        linkEntryEntity.getItems().add(field);
    }

    private void createSBillIdField(LinkEntryEntity linkEntryEntity, List<String> langs) {
        String longFieldKey = this.linkEntityKey + "_sbillid";
        String longFieldName = "FSBillId";
        LocaleString localeString = ResManager.getLocaleString((String)"\u6e90\u5355\u5185\u7801", (String)"LinkSetItem_10", (String)"bos-metadata");
        LocaleString longFieldCaption = new LocaleString();
        for (String lang : langs) {
            longFieldCaption.setItem(lang, localeString.get((Object)lang));
        }
        BigIntField longField = new BigIntField();
        longField.setKey(longFieldKey);
        longField.setFieldName(longFieldName);
        longField.setName(longFieldCaption);
        linkEntryEntity.getItems().add(longField);
    }

    private void createSIdField(LinkEntryEntity linkEntryEntity, List<String> langs) {
        String longFieldKey = this.linkEntityKey + "_sid";
        String longFieldName = "FSId";
        LocaleString localeString = ResManager.getLocaleString((String)"\u6e90\u5355\u4e3b\u5b9e\u4f53\u5185\u7801", (String)"LinkSetItem_11", (String)"bos-metadata");
        LocaleString longFieldCaption = new LocaleString();
        for (String lang : langs) {
            longFieldCaption.setItem(lang, localeString.get((Object)lang));
        }
        BigIntField longField = new BigIntField();
        longField.setKey(longFieldKey);
        longField.setFieldName(longFieldName);
        longField.setName(longFieldCaption);
        linkEntryEntity.getItems().add(longField);
    }

    private void createCtrlField(EntityMetadata entityMetadata, LinkEntryEntity linkEntryEntity, String ctrlFieldId, List<String> langs) {
        EntityItem<?> oriCtrlItem = entityMetadata.getItemById(ctrlFieldId);
        if (oriCtrlItem == null) {
            this.addBuildError(entityMetadata, 0, ResManager.loadKDString((String)"\u63a7\u5236\u5b57\u6bb5", (String)"LinkSetItem_4", (String)"bos-metadata", (Object[])new Object[0]), ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u63a7\u5236\u5b57\u6bb5", (String)"LinkSetItem_5", (String)"bos-metadata", (Object[])new Object[0]));
            return;
        }
        if (!(oriCtrlItem instanceof DecimalField)) {
            this.addBuildError(entityMetadata, 0, ResManager.loadKDString((String)"\u63a7\u5236\u5b57\u6bb5", (String)"LinkSetItem_4", (String)"bos-metadata", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u7528\u6570\u503c\u7c7b\u578b\u5b57\u6bb5\uff0c\u4f5c\u4e3a\u63a7\u5236\u5b57\u6bb5", (String)"LinkSetItem_6", (String)"bos-metadata", (Object[])new Object[0]));
            return;
        }
        DecimalField oriCtrlField = (DecimalField)oriCtrlItem;
        if (StringUtils.isBlank((CharSequence)oriCtrlField.getFieldName())) {
            this.addBuildError(entityMetadata, 0, ResManager.loadKDString((String)"\u63a7\u5236\u5b57\u6bb5", (String)"LinkSetItem_4", (String)"bos-metadata", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u7269\u7406\u5b57\u6bb5\u540d", (String)"LinkSetItem_7", (String)"bos-metadata", (Object[])new Object[0]));
            return;
        }
        String ctrlFldName = oriCtrlField.getName().toString();
        String oldFieldKey = this.linkEntityKey + "_" + oriCtrlField.getKey() + "_old";
        String oldFieldName = oriCtrlField.getFieldName() + "_old";
        LocaleString oldFieldCaption = new LocaleString();
        LocaleString localeOldCaptions = ResManager.getLocaleString((String)"_\u539f\u59cb\u643a\u5e26\u503c", (String)"LinkSetItem_12", (String)"bos-metadata");
        for (Map.Entry item : oriCtrlField.getName().entrySet()) {
            ctrlFldName = (String)item.getValue();
            oldFieldCaption.setItem((String)item.getKey(), (Object)(ctrlFldName + (String)localeOldCaptions.getItem((String)item.getKey())));
        }
        DecimalField oldCtrlField = new DecimalField();
        oldCtrlField.setKey(oldFieldKey);
        oldCtrlField.setFieldName(oldFieldName);
        oldCtrlField.setName(oldFieldCaption);
        linkEntryEntity.getItems().add(oldCtrlField);
        String newFieldKey = this.linkEntityKey + "_" + oriCtrlField.getKey();
        String newFieldName = oriCtrlField.getFieldName();
        LocaleString newFieldCaption = new LocaleString();
        LocaleString localeNewCaptions = ResManager.getLocaleString((String)"_\u786e\u8ba4\u643a\u5e26\u503c", (String)"LinkSetItem_13", (String)"bos-metadata");
        for (Map.Entry item : oriCtrlField.getName().entrySet()) {
            ctrlFldName = (String)item.getValue();
            newFieldCaption.setItem((String)item.getKey(), (Object)(ctrlFldName + (String)localeNewCaptions.getItem((String)item.getKey())));
        }
        DecimalField newCtrlField = new DecimalField();
        newCtrlField.setKey(newFieldKey);
        newCtrlField.setFieldName(newFieldName);
        newCtrlField.setName(newFieldCaption);
        linkEntryEntity.getItems().add(newCtrlField);
    }

    private void addBuildError(EntityMetadata entityMetadata, int level, String propertyName, String error) {
        ErrorInfo info = new ErrorInfo();
        info.setItemId(this.linkEntityKey);
        info.setPropertyName(propertyName);
        info.setType("linkset");
        info.setLevel(level);
        info.setError(error);
        entityMetadata.addError(info);
    }

    public EntityItem<?> getParentEntity(EntityMetadata entityMetadata) {
        EntityItem parentEntity = null;
        if (StringUtils.isBlank((CharSequence)this.parentEntityId)) {
            return null;
        }
        parentEntity = this.parentEntityId.equalsIgnoreCase(Key_BillHead) ? entityMetadata.getRootEntity() : entityMetadata.getItemById(this.parentEntityId);
        return parentEntity;
    }
}

