/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.list.SeqColumnType;
import kd.bos.metadata.PermissionMeta;
import kd.bos.metadata.PublishAppMeta;
import kd.bos.metadata.entity.BusinessControl;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.IChildElement;
import kd.bos.metadata.entity.RuntimeEntityMeta;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.businessfield.IRefBillField;
import kd.bos.metadata.entity.operation.NetCtrlOperation;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.perm.PermissionControl;
import kd.bos.metadata.perm.PermissionDimension;
import kd.bos.metadata.perm.PermissionItem;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MainEntity
extends Entity<DynamicProperty, MainEntityType> {
    private static final String CREATR_TYPE = "CreateType";
    private static final String BOS_METADATA = "bos-metadata";
    private static final String COMPARE_GROUPID = "compareGroupId";
    private static final String IS_MULTI = "IsMulti";
    private static final String CUSTOM = "Custom";
    private static final String SEQ_TYPE = "SeqType";
    private static final String ITEMS = "Items";
    private List<Operation> operations = new ArrayList<Operation>();
    private String pkId;
    private int pkType = 1;
    private List<PermissionItem> permissionItems = new ArrayList<PermissionItem>();
    private List<NetCtrlOperation> networkControl = new ArrayList<NetCtrlOperation>();
    private BusinessControl businessControl = new BusinessControl();
    private String userOption;
    private String mainOrg;
    private boolean template;
    private PermissionControl permissionControl;
    private PermissionDimension permissionDimension;

    @Override
    public MainEntityType buildDataEntityType() {
        return (MainEntityType)super.buildDataEntityType();
    }

    @ComplexPropertyAttribute
    public PermissionControl getPermissionControl() {
        return this.permissionControl;
    }

    public void setPermissionControl(PermissionControl permissionControl) {
        this.permissionControl = permissionControl;
    }

    @ComplexPropertyAttribute
    public PermissionDimension getPermissionDimension() {
        return this.permissionDimension;
    }

    public void setPermissionDimension(PermissionDimension permissionDimension) {
        this.permissionDimension = permissionDimension;
    }

    @SimplePropertyAttribute(name="Template")
    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    @ComplexPropertyAttribute
    public BusinessControl getBusinessControl() {
        return this.businessControl;
    }

    public void setBusinessControl(BusinessControl businessControl) {
        this.businessControl = businessControl;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="1")
    public int getPkType() {
        return this.pkType;
    }

    public void setPkType(int pkType) {
        this.pkType = pkType;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Operation.class)
    public List<Operation> getOperations() {
        return this.operations;
    }

    @SimplePropertyAttribute
    public String getUserOption() {
        return this.userOption;
    }

    public void setUserOption(String userOption) {
        this.userOption = userOption;
    }

    @SimplePropertyAttribute(name="MainOrg")
    public String getMainOrg() {
        return this.mainOrg;
    }

    public void setMainOrg(String mainOrg) {
        this.mainOrg = mainOrg;
    }

    @Override
    protected MainEntityType createDataEntityType() {
        return new MainEntityType();
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getPkId() {
        if (StringUtils.isBlank((CharSequence)this.pkId)) {
            this.pkId = Uuid16.create().toString();
        }
        return this.pkId;
    }

    public void setPkId(String pkId) {
        this.pkId = pkId;
    }

    @Override
    @SimplePropertyAttribute
    public String getId() {
        return super.getId();
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=PermissionItem.class)
    public List<PermissionItem> getPermissionItems() {
        return this.permissionItems;
    }

    public PermissionItem getPermissionItem(String itemId) {
        for (PermissionItem item : this.getPermissionItems()) {
            if (!item.getItemId().equals(itemId)) continue;
            return item;
        }
        return null;
    }

    @Override
    protected void registerProperties(MainEntityType dt) {
        Object versionControl;
        String mainOrgId;
        super.registerProperties(dt);
        dt.setDisplayName(this.getName());
        if (this.getUserOption() != null) {
            dt.setUserOption(this.getUserOption());
        }
        if (StringUtils.isNotBlank((CharSequence)(mainOrgId = this.getMainOrg()))) {
            for (EntityItem<?> item : this.getItems()) {
                if (!item.getId().equals(mainOrgId)) continue;
                dt.setMainOrg(item.getKey());
                break;
            }
        }
        dt.setInheritPath(this.entityMetadata.getInheritPath());
        if (this.getCustomProperties() != null && (versionControl = this.getCustomProperties().get("VersionControl")) != null) {
            for (EntityItem<?> item : this.getItems()) {
                if (!versionControl.equals(item.getId())) continue;
                dt.setVersionControl(item.getKey());
                break;
            }
        }
    }

    public void buildSubRuntimeMetadata(List<RuntimeEntityMeta> metas, String runtimeVersion) {
    }

    public List<PermissionMeta> buildPermissionMetas() {
        ArrayList<PermissionMeta> metas = new ArrayList<PermissionMeta>(this.permissionItems.size());
        String[] ids = DB.genStringIds((String)"", (int)this.permissionItems.size());
        int i = 0;
        for (PermissionItem item : this.permissionItems) {
            PermissionMeta permissionMeta = new PermissionMeta();
            permissionMeta.setPermItemId(item.getItemId());
            permissionMeta.setId(ids[i]);
            permissionMeta.setDEntityTypeId(this.getId());
            permissionMeta.setEntityTypeId(this.getKey());
            permissionMeta.setSeq(item.getIndex() == null ? Integer.valueOf(0) : Integer.valueOf(item.getIndex()));
            metas.add(permissionMeta);
            ++i;
        }
        return metas;
    }

    public List<PublishAppMeta> buildPublishAppMetas() {
        String apps;
        List<PublishAppMeta> metas = new ArrayList<PublishAppMeta>();
        if (this.permissionDimension != null && StringUtils.isNotBlank((CharSequence)(apps = this.permissionDimension.getPublishApps()))) {
            List numbers = (List)SerializationUtils.fromJsonString((String)apps, List.class);
            metas = numbers.stream().map(number -> new PublishAppMeta(this.getKey(), (String)number, DB.genStringIds((String)"", (int)1)[0])).collect(Collectors.toList());
        }
        return metas;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=NetCtrlOperation.class)
    public List<NetCtrlOperation> getNetworkControl() {
        return this.networkControl;
    }

    public void setNetworkControl(List<NetCtrlOperation> networkControl) {
        this.networkControl = networkControl;
    }

    public Map<String, Object> createEntityTree(String type, boolean isNeedSeq, boolean isAllNode, int level, boolean isIncludeEntry) {
        HashMap<String, Object> node = new HashMap<String, Object>(4);
        node.put("Id", this.getKey());
        node.put("Type", type);
        node.put("Name", this.getName().toString());
        node.put(CREATR_TYPE, 1);
        ArrayList<Map<Object, Object>> nodeItems = new ArrayList<Map<Object, Object>>();
        if (isNeedSeq) {
            HashMap<String, Object> col = new HashMap<String, Object>(5);
            col.put("Id", "fseq");
            col.put("Type", "ListColumnAp");
            col.put("Name", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"MainEntity_0", (String)BOS_METADATA, (Object[])new Object[0]));
            col.put(CREATR_TYPE, 1);
            col.put(COMPARE_GROUPID, "1");
            col.put(IS_MULTI, false);
            col.put(CUSTOM, false);
            col.put(SEQ_TYPE, SeqColumnType.EntitySeq);
            col.put("IsFieldPropAliasEmpty", true);
            nodeItems.add(col);
        }
        node.put(ITEMS, nodeItems);
        for (EntityItem<?> item : this.getItems()) {
            if (item instanceof IBasedataField) {
                nodeItems.addAll(((IBasedataField)((Object)item)).createEntityTreeNodes(isAllNode, level));
                continue;
            }
            if (item instanceof IRefBillField) {
                nodeItems.addAll(((IRefBillField)((Object)item)).createEntityTreeNodes(isAllNode, level));
                continue;
            }
            if (item instanceof IChildElement) {
                nodeItems.addAll(((IChildElement)((Object)item)).createEntityTreeNodes(isAllNode, level, isIncludeEntry));
                continue;
            }
            nodeItems.addAll(item.createEntityTreeNodes());
        }
        return node;
    }

    public Map<String, Object> createFieldsTree(String type, boolean isNeedSeq) {
        HashMap<String, Object> node = new HashMap<String, Object>(4);
        node.put("Id", this.getKey());
        node.put("Type", type);
        node.put("Name", this.getName().toString());
        node.put(CREATR_TYPE, 1);
        ArrayList<Map<Object, Object>> nodeItems = new ArrayList<Map<Object, Object>>();
        if (isNeedSeq) {
            HashMap<String, Object> col = new HashMap<String, Object>(5);
            col.put("Id", "fseq");
            col.put("Type", "ListColumnAp");
            col.put("Name", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"MainEntity_0", (String)BOS_METADATA, (Object[])new Object[0]));
            col.put(CREATR_TYPE, 1);
            col.put(COMPARE_GROUPID, "1");
            col.put(IS_MULTI, false);
            col.put(CUSTOM, false);
            col.put(SEQ_TYPE, SeqColumnType.EntitySeq);
            nodeItems.add(col);
        }
        node.put(ITEMS, nodeItems);
        for (EntityItem<?> item : this.getItems()) {
            nodeItems.addAll(item.createEntityTreeNodes());
        }
        return node;
    }

    public Map<String, Object> createFieldsTreeByKey(String type, boolean isNeedSeq) {
        HashMap<String, Object> node = new HashMap<String, Object>(4);
        node.put("Id", this.getKey());
        node.put("Type", type);
        node.put("Name", this.getName().toString());
        node.put(CREATR_TYPE, 1);
        ArrayList<Map<Object, Object>> nodeItems = new ArrayList<Map<Object, Object>>();
        if (isNeedSeq) {
            HashMap<String, Object> col = new HashMap<String, Object>(5);
            col.put("Id", "fseq");
            col.put("Type", "ListColumnAp");
            col.put("Name", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"MainEntity_0", (String)BOS_METADATA, (Object[])new Object[0]));
            col.put(CREATR_TYPE, 1);
            col.put(COMPARE_GROUPID, "1");
            col.put(IS_MULTI, false);
            col.put(CUSTOM, false);
            col.put(SEQ_TYPE, SeqColumnType.EntitySeq);
            nodeItems.add(col);
        }
        node.put(ITEMS, nodeItems);
        for (EntityItem<?> item : this.getItems()) {
            nodeItems.addAll(item.createEntityTreeNodesByKey());
        }
        return node;
    }

    public void addRefPropTypes(Map<String, Set<String>> refObjectProps) {
    }
}

