/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QueryPlugInField;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySortField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.list.SeqColumnType;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QueryEntity
extends MainEntity {
    private static final String ITEMS = "Items";
    String editEntityAliasName;
    private String entityName;
    private String entityAlias;
    private List<JoinEntity> joinEntitys = new ArrayList<JoinEntity>();
    List<QuerySourceJoinRelation> queryRelations = new ArrayList<QuerySourceJoinRelation>();
    private String includeFieldNames = null;
    List<QuerySelectField> selectFields = new ArrayList<QuerySelectField>();
    List<QSConditionRow> whereConditions = new ArrayList<QSConditionRow>();
    List<QuerySortField> querySortFields = new ArrayList<QuerySortField>();
    List<QueryPlugInField> queryPlugInFields = new ArrayList<QueryPlugInField>();

    @SimplePropertyAttribute
    public String getEditEntityAliasName() {
        return this.editEntityAliasName;
    }

    public void setEditEntityAliasName(String editEntityAliasName) {
        this.editEntityAliasName = editEntityAliasName;
    }

    @SimplePropertyAttribute
    public String getIncludeFieldNames() {
        return this.includeFieldNames;
    }

    public void setIncludeFieldNames(String includeFieldNames) {
        this.includeFieldNames = includeFieldNames;
    }

    @SimplePropertyAttribute
    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=JoinEntity.class)
    public List<JoinEntity> getJoinEntitys() {
        return this.joinEntitys;
    }

    public void setJoinEntitys(List<JoinEntity> joinEntitys) {
        this.joinEntitys = joinEntitys;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QuerySourceJoinRelation.class)
    public List<QuerySourceJoinRelation> getJoinRelations() {
        return this.queryRelations;
    }

    public void addQuerySourceJoinRelation(QuerySourceJoinRelation rel) {
        this.queryRelations.add(rel);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QuerySelectField.class)
    public List<QuerySelectField> getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(List<QuerySelectField> selectFields) {
        this.selectFields = selectFields;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QSConditionRow.class)
    public List<QSConditionRow> getWhereConditions() {
        return this.whereConditions;
    }

    public void addWhereCondition(QSConditionRow qsConditionRow) {
        this.whereConditions.add(qsConditionRow);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QuerySortField.class)
    public List<QuerySortField> getQuerySortFields() {
        return this.querySortFields;
    }

    public void setQuerySortFields(List<QuerySortField> querySortFields) {
        this.querySortFields = querySortFields;
    }

    @SimplePropertyAttribute
    public String getEntityAlias() {
        return this.entityAlias;
    }

    public void setEntityAlias(String entityAlias) {
        this.entityAlias = entityAlias;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QueryPlugInField.class)
    public List<QueryPlugInField> getQueryPlugInFields() {
        return this.queryPlugInFields;
    }

    public void setQueryPlugInFields(List<QueryPlugInField> queryPlugInFields) {
        this.queryPlugInFields = queryPlugInFields;
    }

    @Override
    protected MainEntityType createDataEntityType() {
        return new QueryEntityType();
    }

    @Override
    protected void registerProperties(MainEntityType dt) {
        super.registerProperties(dt);
        String mainOrgId = this.getMainOrg();
        QueryEntityType qdt = (QueryEntityType)dt;
        qdt.setEntityName(this.entityName);
        qdt.setEditEntityAliasName(this.editEntityAliasName);
        qdt.setJoinEntitys(this.joinEntitys);
        qdt.setEntityAlias(this.getEntityAlias());
        for (QuerySourceJoinRelation rel : this.queryRelations) {
            qdt.addQuerySourceJoinRelation(rel);
        }
        for (QuerySelectField querySelectField : this.selectFields) {
            qdt.addSelectField(querySelectField);
        }
        for (QuerySortField querySortField : this.querySortFields) {
            qdt.addSelectField(querySortField);
        }
        for (QSConditionRow conditionRow : this.whereConditions) {
            qdt.addWhereCondition(conditionRow);
        }
        for (QueryPlugInField queryPlugInField : this.queryPlugInFields) {
            qdt.addQueryPlugInFields(queryPlugInField);
        }
        if (!StringUtils.isBlank((String)mainOrgId)) {
            qdt.setMainOrg(mainOrgId);
        }
    }

    @Override
    public Map<String, Object> createEntityTree(String type, boolean isNeedSeq, boolean isAllNode, int level, boolean isIncludeEntry) {
        HashMap<String, Object> node = new HashMap<String, Object>(4);
        node.put("Id", this.getKey());
        node.put("Type", type);
        node.put("Name", this.getName().toString());
        node.put("CreateType", 1);
        ArrayList<Map<String, Object>> nodeItems = new ArrayList<Map<String, Object>>();
        if (isNeedSeq) {
            HashMap<String, Object> col = new HashMap<String, Object>(5);
            col.put("Id", "fseq");
            col.put("Type", "ListColumnAp");
            col.put("Name", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"QueryEntity_0", (String)"bos-metadata", (Object[])new Object[0]));
            col.put("CreateType", 1);
            col.put("compareGroupId", "1");
            col.put("IsMulti", false);
            col.put("Custom", false);
            col.put("SeqType", SeqColumnType.EntitySeq);
            nodeItems.add(col);
        }
        node.put(ITEMS, nodeItems);
        MetadataReader reader = new MetadataReader(false);
        String entityId = reader.loadIdByNumber(this.getEntityName(), MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
        Map<String, Object> entityNodeItems = entityMetadata.getRootEntity().createEntityTree("billList", false, true, level, true);
        List itemMapList = (List)entityNodeItems.get(ITEMS);
        ArrayList<Map<String, Object>> itemMapListDelDup = new ArrayList<Map<String, Object>>();
        HashSet<String> idSet = new HashSet<String>(16);
        for (Map itemMap : itemMapList) {
            if (!idSet.add((String)itemMap.get("Id"))) continue;
            itemMapListDelDup.add(itemMap);
        }
        List<Map<String, Object>> displayItemMapList = this.getDisplayItemMapList(itemMapListDelDup);
        nodeItems.addAll(displayItemMapList);
        this.addJoinEntityFieldsToNodeItems(level, nodeItems);
        return node;
    }

    private List<Map<String, Object>> getDisplayItemMapList(List<Map<String, Object>> itemMapList) {
        List<QuerySelectField> querySelectFields = this.getSelectFields();
        ArrayList<Map<String, Object>> displayItemMapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> itemMap : itemMapList) {
            String propName = (String)itemMap.get("Id");
            String propAlias = (String)itemMap.get("Name");
            if (itemMap.get(ITEMS) != null) {
                List subMapList = (List)itemMap.get(ITEMS);
                for (Map subItemMap : subMapList) {
                    String subPropName = propName + "." + subItemMap.get("Id");
                    String subPropAlias = propAlias + "." + subItemMap.get("Name");
                    if (querySelectFields == null || !this.isSelectField(querySelectFields, subPropName, subPropAlias)) continue;
                    subItemMap.put("Id", subPropName);
                    subItemMap.put("Name", this.getSelectFieldDisplayName(querySelectFields, subPropName));
                    displayItemMapList.add(subItemMap);
                }
                continue;
            }
            if (querySelectFields == null || !this.isSelectField(querySelectFields, propName, propAlias)) continue;
            itemMap.put("Name", this.getSelectFieldDisplayName(querySelectFields, propName));
            displayItemMapList.add(itemMap);
        }
        return displayItemMapList;
    }

    private String getSelectFieldDisplayName(List<QuerySelectField> querySelectFields, String propName) {
        for (QuerySelectField querySelectField : querySelectFields) {
            if (!propName.equals(querySelectField.getAlias())) continue;
            return querySelectField.getDisplayName();
        }
        return null;
    }

    private boolean isSelectField(List<QuerySelectField> querySelectFields, String propName, String propAlias) {
        for (QuerySelectField querySelectField : querySelectFields) {
            if (!propName.equals(querySelectField.getAlias())) continue;
            return true;
        }
        return false;
    }

    private void addJoinEntityFieldsToNodeItems(int level, List<Map<String, Object>> nodeItems) {
        for (JoinEntity joinEntity : this.getJoinEntitys()) {
            MetadataReader reader = new MetadataReader(false);
            String entityId = reader.loadIdByNumber(joinEntity.getEntityName(), MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
            Map<String, Object> entityNodeItems = entityMetadata.getRootEntity().createEntityTree("billList", false, true, level - 1, true);
            List itemMapList = (List)entityNodeItems.get(ITEMS);
            List<Map<String, Object>> displayItemMapList = this.getDisplayItemMapList(joinEntity, itemMapList);
            nodeItems.addAll(displayItemMapList);
        }
    }

    private List<Map<String, Object>> getDisplayItemMapList(JoinEntity joinEntity, List<Map<String, Object>> itemMapList) {
        List<QuerySelectField> querySelectFields = this.getSelectFields();
        ArrayList<Map<String, Object>> displayItemMapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> itemMap : itemMapList) {
            String propName = joinEntity.getAlias() + "." + itemMap.get("Id");
            String propAlias = joinEntity.getDisplayName() + "." + itemMap.get("Name");
            if (itemMap.get(ITEMS) != null) {
                List subMapList = (List)itemMap.get(ITEMS);
                for (Map subItemMap : subMapList) {
                    String subPropName = null;
                    String subPropAlias = null;
                    String filterName = null;
                    if (subItemMap.get("SeqType") != null && "EntryEntitySeq".equals(subItemMap.get("SeqType").toString())) {
                        subPropName = joinEntity.getAlias() + "." + subItemMap.get("Id");
                        subPropAlias = joinEntity.getDisplayName() + "." + subItemMap.get("Name");
                    } else {
                        subPropName = propName + "." + subItemMap.get("Id");
                        subPropAlias = propAlias + "." + subItemMap.get("Name");
                        Object filterNameObj = subItemMap.get("FilterName");
                        if (filterNameObj != null) {
                            filterName = joinEntity.getAlias() + "." + filterNameObj;
                        }
                    }
                    if (filterName != null) {
                        subItemMap.put("FilterName", filterName);
                    }
                    if (querySelectFields == null || !this.isSelectField(querySelectFields, subPropName, subPropAlias)) continue;
                    subItemMap.put("Id", subPropName);
                    subItemMap.put("Name", this.getSelectFieldDisplayName(querySelectFields, subPropName));
                    displayItemMapList.add(subItemMap);
                }
                continue;
            }
            if (querySelectFields == null || !this.isSelectField(querySelectFields, propName, propAlias)) continue;
            itemMap.put("Id", propName);
            itemMap.put("Name", this.getSelectFieldDisplayName(querySelectFields, propName));
            String filterName = null;
            Object filterNameObj = itemMap.get("FilterName");
            if (filterNameObj != null) {
                filterName = joinEntity.getAlias() + "." + filterNameObj;
            }
            if (filterName != null) {
                itemMap.put("FilterName", filterName);
            }
            displayItemMapList.add(itemMap);
        }
        return displayItemMapList;
    }

    private String getEntityIdByNumber(String entityNumber) {
        String sql = "select fid from t_meta_entity where FNUMBER='" + entityNumber + "' and ftype=" + RuntimeMetaType.Entity.getValue();
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return "";
            }
        });
    }
}

