/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataTypeEnum;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.RefProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.field.RefBillEdit;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.RuntimeEntityMeta;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.IRefBillField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractRefBillField<T extends DynamicProperty>
extends Field<T>
implements IRefBillField {
    private static final String NUMBER = "billno";
    private static final String BOS_METADATA = "bos-metadata";
    private LocaleString emptyText;
    private String billEntityId;
    private String numberProp = "billno";
    private String editSearchProp = "billno";
    private String displayProp = "billno";
    private int displayStyle;
    private List<RefProp> refProps = new ArrayList<RefProp>();
    private String mobileList;
    private FilterCondition filter;
    private String orgFieldId;
    private String layoutId;
    private boolean showOnlyAudited = true;
    private boolean openFuzzyQuery = true;
    private boolean showFrequent;
    private int basedataEditStyle;
    private String basedataBtnIcon;
    private boolean editRefProp = false;
    private EntityMetadata refBillEntityMeta;

    @Override
    public BasedataTypeEnum getBasedataTypeEnum() {
        return BasedataTypeEnum.BaseData;
    }

    @SimplePropertyAttribute(name="RefLayout")
    public String getLayoutId() {
        return this.layoutId;
    }

    public void setLayoutId(String layoutId) {
        this.layoutId = layoutId;
    }

    private boolean hasLayout() {
        return StringUtils.isNotEmpty((CharSequence)this.layoutId);
    }

    @SimplePropertyAttribute(name="ShowUsed")
    @DefaultValueAttribute(value="true")
    public boolean isShowOnlyAudited() {
        return this.showOnlyAudited;
    }

    public void setShowOnlyAudited(boolean showOnlyAudited) {
        this.showOnlyAudited = showOnlyAudited;
    }

    @SimplePropertyAttribute
    public String getOrgFieldId() {
        return this.orgFieldId;
    }

    public void setOrgFieldId(String orgFieldId) {
        this.orgFieldId = orgFieldId;
    }

    @SimplePropertyAttribute
    public String getMobileList() {
        return this.mobileList;
    }

    public void setMobileList(String mobileList) {
        this.mobileList = mobileList;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString emptyText) {
        this.emptyText = emptyText;
    }

    @Override
    @SimplePropertyAttribute
    public String getBillEntityId() {
        return this.billEntityId;
    }

    public void setBillEntityId(String billEntityId) {
        this.billEntityId = billEntityId;
    }

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=RefProp.class)
    public List<RefProp> getRefProps() {
        return this.refProps;
    }

    @Override
    @ComplexPropertyAttribute
    public FilterCondition getFilter() {
        return this.filter;
    }

    public void setFilter(FilterCondition filter) {
        this.filter = filter;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="billno")
    public String getEditSearchProp() {
        return this.editSearchProp;
    }

    public void setEditSearchProp(String editSearchProp) {
        this.editSearchProp = editSearchProp;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="billno")
    public String getDisplayProp() {
        return this.displayProp;
    }

    public void setDisplayProp(String displayProp) {
        this.displayProp = displayProp;
    }

    @SimplePropertyAttribute
    public int getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(int displayStyle) {
        this.displayStyle = displayStyle;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="billno")
    public String getNumberProp() {
        return this.numberProp;
    }

    public void setNumberProp(String numberProp) {
        this.numberProp = numberProp;
    }

    @SimplePropertyAttribute(name="EditRefProp")
    public boolean isEditRefProp() {
        return this.editRefProp;
    }

    public void setEditRefProp(boolean editRefProp) {
        this.editRefProp = editRefProp;
    }

    @SimplePropertyAttribute(name="OpenFuzzyQuery")
    @DefaultValueAttribute(value="true")
    public boolean isOpenFuzzyQuery() {
        return this.openFuzzyQuery;
    }

    public void setOpenFuzzyQuery(boolean isOpenFuzzyQuery) {
        this.openFuzzyQuery = isOpenFuzzyQuery;
    }

    @SimplePropertyAttribute(name="ShowFrequent")
    public boolean isShowFrequent() {
        return this.showFrequent;
    }

    public void setShowFrequent(boolean isShowFrequent) {
        this.showFrequent = isShowFrequent;
    }

    @SimplePropertyAttribute(name="BasedataEditStyle")
    public int getBasedataEditStyle() {
        return this.basedataEditStyle;
    }

    public void setBasedataEditStyle(int basedataEditStyle) {
        this.basedataEditStyle = basedataEditStyle;
    }

    @SimplePropertyAttribute(name="BasedataBtnIcon")
    public String getBasedataBtnIcon() {
        return this.basedataBtnIcon;
    }

    public void setBasedataBtnIcon(String basedataBtnIcon) {
        this.basedataBtnIcon = basedataBtnIcon;
    }

    public EntityMetadata getRefBillEntityMeta() {
        if (StringUtils.isBlank((CharSequence)this.getBillEntityId())) {
            return null;
        }
        if (this.entityMetadata.getId() != null && this.entityMetadata.getId().equals(this.getBillEntityId())) {
            return this.entityMetadata;
        }
        if (this.refBillEntityMeta == null) {
            MetadataReader reader = new MetadataReader();
            MetaBuildContext ctx = this.entityMetadata.getBuildContext();
            if (ctx != null) {
                reader.setAppGroup(ctx.getRebuildAppGroup());
            }
            try {
                this.refBillEntityMeta = (EntityMetadata)reader.readEntityMetaByFormId(this.getBillEntityId());
                if (this.refBillEntityMeta == null && ctx != null && ctx.isGray()) {
                    reader = new MetadataReader();
                    this.refBillEntityMeta = (EntityMetadata)reader.readEntityMetaByFormId(this.getBillEntityId());
                }
            }
            catch (KDException e) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u5c5e\u6027\uff1a\u201c%2$s\u201d\u5173\u8054\u7684\u201c\u5355\u636e\u7c7b\u578b\u201d\u5931\u8d25\uff1a%3$s", (String)"AbstractRefBillField_3", (String)BOS_METADATA, (Object[])new Object[0]), this.entityMetadata.getName().toString(), this.getName().toString(), e.getMessage()), e);
            }
            catch (Throwable e) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u5c5e\u6027\uff1a\u201c%2$s\u201d\u5173\u8054\u7684\u201d\u5355\u636e\u7c7b\u578b\u201c\u5931\u8d25\uff1a%3$s", (String)"AbstractRefBillField_4", (String)BOS_METADATA, (Object[])new Object[0]), this.entityMetadata.getName().toString(), this.getName().toString(), e.getMessage()), e);
            }
        }
        return this.refBillEntityMeta;
    }

    protected void setRefBillProp(RefBillProp prop) {
        String name = (String)prop.getDisplayName().getDefaultItem();
        if (this.getBillEntityId() != null) {
            Field<?> field;
            MetadataReader reader = new MetadataReader();
            MetaBuildContext ctx = this.entityMetadata.getBuildContext();
            String number = "";
            if (ctx != null && ctx.isGray()) {
                reader.setAppGroup(ctx.getRebuildAppGroup());
                number = reader.getEntityNumberById(this.getBillEntityId());
            }
            if (StringUtils.isBlank((CharSequence)number) && StringUtils.isBlank((CharSequence)(number = (reader = new MetadataReader()).getEntityNumberById(this.getBillEntityId())))) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u5b57\u6bb5\uff1a\u201c%2$s\u201d\u5173\u8054\u7684\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e0d\u5b58\u5728\u3002", (String)"AbstractRefBillField_5", (String)BOS_METADATA, (Object[])new Object[0]), this.entityMetadata.getName().toString(), name));
                this.setBillEntityId(null);
            }
            prop.setBillEntityId(number);
            prop.setDisplayProp(this.getDisplayProp());
            prop.setNumberProp(this.getNumberProp());
            prop.setEditSearchProp(this.getEditSearchProp());
            if (!StringUtils.isBlank((CharSequence)this.orgFieldId) && (field = this.entityMetadata.getFieldById(this.orgFieldId)) != null) {
                prop.setOrgProp(field.getKey().toLowerCase());
            }
        } else {
            this.addBuildError(2, "BillEntityId", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u5b57\u6bb5\uff1a\u201c%2$s\u201d\u5173\u8054\u7684\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractRefBillField_6", (String)BOS_METADATA, (Object[])new Object[0]), this.entityMetadata.getName().toString(), name));
        }
        if (this.hasLayout()) {
            prop.setLayoutId(this.layoutId);
        }
        prop.setDbIgnore(!this.isEditRefProp());
        prop.setShowOnlyAudited(this.isShowOnlyAudited());
        prop.setCompareTypeConfig(this.getCompareTypeConfig());
    }

    protected void setClientRefBillEditor(Map<String, Object> ctlRet) {
        ctlRet.put("type", "basedata");
        AbstractRefBillField.setDisplayPropCtl(ctlRet, this.getDisplayProp(), "dsp", "con");
        AbstractRefBillField.setDisplayPropCtl(ctlRet, this.getEditSearchProp(), "ep", "epcon");
        ctlRet.put("dst", this.displayStyle);
        if (this.entityMetadata != null) {
            for (EntityItem<?> item : this.entityMetadata.getItems()) {
                Field<?> field;
                if (!(item instanceof FlexField) || (field = ((FlexField)item).getControlField()) == null || !field.getId().equals(this.getId())) continue;
                ctlRet.put("flexKey", item.getKey());
                break;
            }
        }
        if (StringUtils.isNotBlank((Object)this.emptyText)) {
            ctlRet.put("emptytip", this.emptyText);
        }
        if (!this.openFuzzyQuery) {
            ctlRet.put("ofq", this.isOpenFuzzyQuery());
        }
        if (this.showFrequent) {
            ctlRet.put("sft", this.isShowFrequent());
        }
        if (this.basedataEditStyle != 0) {
            ctlRet.put("editStyle", this.getBasedataEditStyle());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBasedataBtnIcon())) {
            ctlRet.put("fontClass", this.getBasedataBtnIcon());
        }
    }

    protected void setServerRefBillEditor(RefBillEdit editor) {
        editor.setDisplayProp(this.getDisplayProp());
        editor.setEditSearchProp(this.getEditSearchProp());
        editor.setF7BatchFill(this.getFeatures().isF7BatchFill());
        editor.setShowOnlyAudited(this.isShowOnlyAudited());
        editor.setDisplayStyle(this.getDisplayStyle());
        editor.setLayoutId(this.getLayoutId());
        editor.setShowFrequent(this.isShowFrequent());
    }

    @Override
    public RuntimeEntityMeta createRuntimeEntityMeta() {
        return this.entityMetadata.createRuntimeEntityMeta();
    }

    protected List<Map<String, Object>> createRefBillTreeNodes(boolean isAllNode, int level) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        if (this.getBillEntityId() == null || !isAllNode && StringUtils.isBlank((CharSequence)this.getFieldName())) {
            return cols;
        }
        MetadataReader reader = new MetadataReader();
        MetaBuildContext ctx = this.entityMetadata.getBuildContext();
        String number = "";
        if (ctx != null && ctx.isGray()) {
            reader.setAppGroup(ctx.getRebuildAppGroup());
            number = reader.getEntityNumberById(this.getBillEntityId());
        }
        if (StringUtils.isBlank((CharSequence)number)) {
            reader = new MetadataReader();
            number = reader.getEntityNumberById(this.getBillEntityId());
        }
        if (StringUtils.isBlank((CharSequence)number)) {
            return cols;
        }
        BillEntityType dt = null;
        List subRefProps = this.getRuntimeRefProps();
        if (ctx != null && ctx.isGray()) {
            MainEntityType met = this.loadEntityMeta(number, ctx.getRebuildAppGroup());
            dt = (BillEntityType)met.getSubEntityType((Collection)subRefProps);
        }
        if (dt == null) {
            dt = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)number, (Collection)subRefProps);
        }
        EntityItem<?> entityItem = this.entityMetadata.getItemById(this.getParentId());
        EntityTreeNode entityTreeNode = new EntityTreeNode(this.getKey(), this.getName().toString(), entityItem instanceof EntryEntity, true, BasedataTypeEnum.BaseData, level, this.getBillEntityId());
        entityTreeNode.setFieldPropAliasEmpty(StringUtils.isBlank((CharSequence)this.getFieldName()));
        return dt.createEntityTreeNodes(entityTreeNode, false, isAllNode);
    }

    public static void setDisplayPropCtl(Map<String, Object> ctlRet, String displayProp, String type, String con) {
        if (displayProp != null) {
            String connector = displayProp.replace(NUMBER, "").replace("name", "");
            if (!"".equals(connector)) {
                String displayField = "()".equals(connector) ? displayProp.replaceAll("[( )]", ",").substring(0, displayProp.length() - 1) : displayProp.replace(connector, ",");
                ctlRet.put(type, displayField);
                ctlRet.put(con, connector);
            } else {
                ctlRet.put(type, displayProp);
            }
        }
    }

    private MainEntityType loadEntityMeta(String number, String appGroup) {
        String entityMeta = this.queryEntityMetaData(number, appGroup);
        if (StringUtils.isBlank((CharSequence)entityMeta)) {
            MetaRebuilder mr = new MetaRebuilder(appGroup);
            mr.rebuildRuntimeMetaByNumber(number);
            entityMeta = this.queryEntityMetaData(number, appGroup);
        }
        if (entityMeta == null || entityMeta.length() == 0) {
            throw new KDException(BosErrorCode.entityMetaDataNotExist, new Object[]{number});
        }
        return (MainEntityType)EntityItemTypes.fromJsonString((String)entityMeta);
    }

    private String queryEntityMetaData(String number, String appGroup) {
        ResultSetHandler callBackHanlder;
        Object[] params;
        String sql;
        String sRet;
        String tabName = "T_META_ENTITY";
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            tabName = String.format("%s_%s", tabName, appGroup);
        }
        if (StringUtils.isBlank((CharSequence)(sRet = (String)DB.query((DBRoute)DBRoute.meta, (String)(sql = String.format("select FDATA from %s where FNUMBER = ? and FKEY = ? and FTYPE = ?", tabName)), (Object[])(params = new Object[]{number, number, RuntimeMetaType.Entity.getValue()}), (ResultSetHandler)(callBackHanlder = rs -> {
            String sFdata = null;
            try {
                if (rs.next()) {
                    sFdata = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return sFdata;
        }))))) {
            sRet = "";
        }
        return sRet;
    }
}

